import pygame
from twisted.internet import task, reactor

from fibre import mainloop
from fibre.ui import events
from fibre.ui.ui import window

TICK_INTERVAL = 0.02

Tick = events.EventKind()

def wait_for_next_frame():
    yield events.queue.next(kinds=[Tick])

class run_application(mainloop.run_application):
    init_logging = True

    def initialise(self):
        super(run_application, self).initialise()

        pygame.init()
        task.LoopingCall(tick).start(TICK_INTERVAL)
        events.queue.subscribe(window.handle_event)

    def finalise(self):
        pygame.display.quit()
        pygame.quit()

class entry_point(mainloop.entry_point):
    '''
    If the module in which entry_point() is called is being executed rather than
    imported (i.e. __name__ == '__main__'), a call to this function will
    initialise pygame and start the core sending events, call the fn parameter,
    then run the reactor until the call is complete.
    '''
    main_function = staticmethod(run_application)

def tick():
    for pygame_event in pygame.event.get():
        event = events.event_from_pygame(pygame_event)
        preprocess_event(event)
        if not events.queue.push(event):
            perform_default_handling(event)
    window.tick()
    events.queue.push(events.Event(Tick))

def perform_default_handling(event):
    if event.kind == events.QuitRequest:
        reactor.stop()

def preprocess_event(event):
    if event.kind == events.KeyDown:
        events.keyboard_status[event.key] = True
    elif event.kind == events.KeyUp:
        events.keyboard_status[event.key] = False

