from fibre.ui import (Screen, Box, Button, Text, entry_point, Canvas,
        wait_for_next_frame, window, DefaultTheme)

class BallBounceTheme(DefaultTheme):
    class Colours(DefaultTheme.Colours):
        title = DefaultTheme.Colours.yellow
        menu_background = DefaultTheme.Colours.blue
        game_background = DefaultTheme.Colours.white

        text = DefaultTheme.Colours.black
        button_highlight = DefaultTheme.Colours.gray85
        button_shadow = DefaultTheme.Colours.gray25
        button_fill = DefaultTheme.Colours.gray50

    class Fonts(DefaultTheme.Fonts):
        title = ('sans', 48)
        message = ('sans', 30)

class ThemedScreen(Screen):
    theme = BallBounceTheme
    caption = 'Bounce Demo'

class MainMenu(ThemedScreen):
    Box(
        top_left = window.top_left,
        bottom_right = window.bottom_right,
        fill = 'menu_background',
    )

    Text(
        'Bounce Demo',
        mid_top = window.mid_top,
        colour = 'title',
        font = 'title',
    )

    begin_button = Button(
        'Begin',
        centre_x = window.x_position(0.33),
        centre_y = window.y_position(0.75),
        background_colour = 'button_fill',
        action = 'begin',
    )

    quit_button = Button(
        'Quit',
        centre_x = window.x_position(0.67),
        centre_y = window.y_position(0.75),
        background_colour = 'button_fill',
        action = 'quit',
    )

class BallBounce(ThemedScreen):
    Box(
        top_left = window.top_left,
        bottom_right = window.bottom_right,
        fill = 'game_background',
    )
    canvas = Canvas(
        top_left = window.top_left,
        bottom_right = window.bottom_right,
    )
    Text(
        'Press Escape to Exit',
        centre_x = window.centre_x,
        top = window.y_position(0.1),
        colour = 'text',
        font = 'message',
    )

def main():
    while True:
        menu = MainMenu.show()
        action = yield menu.wait_for_action()

        if action == 'quit':
            break

        yield run_ball_bounce()

def run_ball_bounce():
    game = BallBounce.show()

    x = 0
    y = 0
    x_vel = 1 / 50.
    y_vel = 1 / 70.
    while True:
        if game.get_keyboard_status('ESCAPE'):
            break
        game.canvas.clear()
        game.canvas.draw_circle(
            colour=BallBounceTheme.Colours.blue,
            pos=(int(x), int(y)),
            radius=5,
        )
        yield wait_for_next_frame()

        x += x_vel * game.width
        y += y_vel * game.width
        if x >= game.width:
            x_vel *= -1
        elif x <= 0:
            x_vel *= -1
        if y >= game.height:
            y_vel *= -1
        elif y <= 0:
            y_vel *= -1


import logging
entry_point(main, logging_args=dict(level=logging.DEBUG))
