import unittest
import os
from file_checksum import Checksum

file = 'test.txt'

def setup_module(module):
    with open(file, 'w') as test_file:
        print("test", file=test_file)

def teardown_module(module):
    os.remove(file)

class TestChecksum(unittest.TestCase):

    def test_md5sum_method_returns_correct_hash(self):
        md5sum = Checksum(file).md5sum()
        hash = 'd8e8fca2dc0f896fd7cb4cb0031ba249'
        self.assertEqual(md5sum, hash)

    def test_sha1sum_method_returns_correct_hash(self):
        sha1sum = Checksum(file).sha1sum()
        hash = '4e1243bd22c66e76c2ba9eddc1f91394e57f9f83'
        self.assertEqual(sha1sum, hash)

    def test_sha256sum_method_returns_correct_hash(self):
        sha256sum = Checksum(file).sha256sum()
        hash = 'f2ca1bb6c7e907d06dafe4687e579fce76b37e4e93b7605022da52e6ccc26fd2'
        self.assertEqual(sha256sum, hash)
        
