import unittest
import os
import file_checksum

file = 'test.txt'

def setup_module(module):
    with open(file, 'w') as afile:
        print("test", file=afile)

def teardown_module(module):
    os.remove(file)

class TestChecksum(unittest.TestCase):

    def test_md5sum_method_returns_correct_hash(self):
        test_file = open(file)
        md5sum = file_checksum.md5sum(test_file)
        hash = 'd8e8fca2dc0f896fd7cb4cb0031ba249'
        self.assertEqual(md5sum, hash)

    def test_sha1sum_method_returns_correct_hash(self):
        test_file = open(file)
        sha1sum = file_checksum.sha1sum(test_file)
        hash = '4e1243bd22c66e76c2ba9eddc1f91394e57f9f83'
        self.assertEqual(sha1sum, hash)

    def test_sha256sum_method_returns_correct_hash(self):
        test_file = open(file)
        sha256sum = file_checksum.sha256sum(test_file)
        hash = 'f2ca1bb6c7e907d06dafe4687e579fce76b37e4e93b7605022da52e6ccc26fd2'
        self.assertEqual(sha256sum, hash)    
