#Part of FileOperations Package
#Creator : Hassaan Ali Wattoo
#Python Version : 2.7

import os

class FileException(Exception):
    #Create an empty exception so a message can be chosen later
    pass








def WordbyWord(file):
    #Reads a File Word By Word and returns a list of the words
    listofwords = []
    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
        Target = open(file,'r')
        lines = Target.readlines()
        for i in lines:
          thisline = i.split()
          for a in thisline:
              listofwords.append(a)

    return listofwords

def LineByLine(file):
    #Reads a File Line By Line and returns a list of the lines
    listoflines = []

    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
     Target = open(file,'r')

     for line in Target:
        listoflines.append(line.replace('\n',''))

    return listoflines

def LetterByLetter(file):

    listofletters = []
    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
        Target = open(file,'r')
        lines = Target.readlines()
        for i in lines:
          thisline = i
          for a in thisline:
              if a != ' ' and a != '\n':
                  listofletters.append(a)

    return listofletters


def FirstLetter(file):
    #Returns First Letter
    return WordbyWord(file)[0][:1]

def FirstWord(file):
    #Returnd FirstWord
    return WordbyWord(file)[0]

def NthLetter(file,number):

    if number < 1:
        return LetterByLetter(file)[0]

    elif number > len(LetterByLetter(file)):
        raise FileException("Not enough letters in file")

    else:
        return LetterByLetter(file)[number - 1]


def NthWord(file,number):

    if number < 1:

        return WordbyWord(file)[0]

    elif number > len(WordbyWord(file)):
        raise FileException("Not enough Words in file")

    else:
        return WordbyWord(file)[number - 1]