#Part of FileOperations Package
#Creator : Hassaan Ali Wattoo
#Python Version : 2.7

import os

class FileException(Exception):
    #Create an empty exception so a message can be chosen later
    pass



def CreateFile(filename):
    #CreateFile("Created.txt") Creates the file Created.txt in the folder where it is run
    if filename == '': #No name
        raise FileException("No Filename Given")

    else:
        file = open(filename,'wb').close() #Normal


def CreateFileInDirectory(filename,directory):
    # For Example :
    #     CreateFileInDirectory("Test.json","C:/Users/MyName/FileOperations/TestDirectory")

    # This creates the Test Directory and Test.json file which did not exist beforehand.

    if directory[-1:] != '/':
        directory += '/'

    if not os.path.exists(directory):
         os.makedirs(directory)

    CreateFile(directory+filename)




def DeleteFile(file):

    #DeleteFile('C:/Users/MyName/Desktop/AboutToBeDeleted.txt') Deletes the file if it exists

    if not os.path.exists(file):
        raise FileException("Invalid Path")

    else: os.remove(file)








def CopyFile(startdest,enddest,newfile):
    #Startdest Requires name of file to be copied e.g C:/Users/Me/Text.xml

   if enddest[-1:] != '/':
        enddest += '/'


   if not os.path.exists(startdest):
        raise FileException("Invalid Path")

   if not os.path.exists(enddest):
         os.makedirs(enddest)

   Copee = open(startdest,'r').read()
   Target = open(enddest+newfile,'wb')
   Target.write(Copee)
   Target.close()