#Part of FileOperations Package
#Creator : Hassaan Ali Wattoo
#Python Version : 2.7

import os

class FileException(Exception):
    #Create an empty exception so a message can be chosen later
    pass


def WordbyWord(file):
    #Reads a File Word By Word and returns a list of the words
    listofwords = []
    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
        Target = open(file,'r')
        lines = Target.readlines()
        for i in lines:
          thisline = i.split()
          for a in thisline:
              listofwords.append(a)

    return listofwords

def LineByLine(file):
    #Reads a File Line By Line and returns a list of the lines
    listoflines = []

    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
     Target = open(file,'r')

     for line in Target:
        listoflines.append(line.replace('\n',''))

    return listoflines

def LetterByLetter(file):

    listofletters = []
    if not os.path.isfile(file):
        raise FileException("No such File")

    else:
        Target = open(file,'r')
        lines = Target.readlines()
        for i in lines:
          thisline = i
          for a in thisline:
              if a != ' ' and a != '\n':
                  listofletters.append(a)

    return listofletters




def NthLetter(file,number):

    if number < 1:
        return LetterByLetter(file)[0]

    elif number > len(LetterByLetter(file)):
        raise FileException("Not enough letters in file")

    else:
        return LetterByLetter(file)[number - 1]


def NthWord(file,number):

    if number < 1:

        return WordbyWord(file)[0]

    elif number > len(WordbyWord(file)):
        raise FileException("Not enough Words in file")

    else:
        return WordbyWord(file)[number - 1]

def SearchFile(File,String):


     if not os.path.isfile(File):
        raise FileException("No such File")


     else:
         Target = open(File,'r')

         for line in Target:
             line = line.replace('\n','')

             if String in line:
                 print("String Found in Line :",line)
             else:
                pass

def ReplaceWord(file,string,newstring):
    string = " "+string+" "
    newstring = " "+newstring+" "

    if not os.path.isfile(file):
        raise FileException("No such File")


    else:
        Target = open(file,'r+')
        Targetext = Target.read()
        if string in Targetext:
            Targetext = Targetext.replace(string,newstring)
        else:
            pass

    Target.close()
    Target = open(file,'wb')


    Target.write(Targetext)
    Target.close()
    print("Finished. Ignore NONE message.")

def WordCount(file):
    return len(WordbyWord(file))

def LetterCount(file):
    return len(LetterByLetter(file))

