# -*- coding: utf-8; -*-
#   / group
#   |
#   |    / extension (without dot)
#   |    |
#   |    |                / common (0=no/1=yes)
#   |    |                | 
#   |    |                |   / description
#   |    |                |   |
filetypes = {
    'audio': {
        "4mp":           [0, "4-MP3 Database File"],
        "669":           [0, "UNIS Composer 669 Module"],
        "6cm":           [0, "Six Channel Module"],
        "8cm":           [0, "Eight Channel Module"],
        "8med":          [0, "Amiga OctaMed Music File"],
        "8svx":          [0, "Amiga 8-Bit Sound File"],
        "aa3":           [0, "ATRAC Audio File"],
        "aac":           [1, "Advanced Audio Coding File"],
        "abc":           [0, "ABC Music Notation"],
        "ac3":           [0, "Audio Codec 3 File"],
        "acd":           [0, "ACID Project File"],
        "act":           [0, "ADPCM Compressed Audio File"],
        "ahx":           [0, "WinAHX Tracker Module"],
        "aif":           [1, "Audio Interchange File Format"],
        "aifc":          [0, "Compressed Audio Interchange File"],
        "aiff":          [0, "Audio Interchange File Format"],
        "ais":           [0, "Velvet Studio Instrument"],
        "akp":           [0, "Akai Sampler File"],
        "al":            [0, "A-Law Compressed Sound Format"],
        "alaw":          [0, "A-Law Compressed Sound Format"],
        "all":           [0, "Cubase Song File"],
        "amr":           [0, "Adaptive Multi-Rate Codec File"],
        "ams":           [0, "Extreme Tracker Module"],
        "ams":           [0, "Velvet Studio Module"],
        "ape":           [0, "Monkey's Audio Lossless Audio File"],
        "ase":           [0, "Velvet Studio Sample"],
        "au":            [0, "Audio File"],
        "aud":           [0, "Video Game Compressed Audio File"],
        "aup":           [0, "Audacity Project File"],
        "avr":           [0, "Audio Visual Research File"],
        "band":          [0, "GarageBand Project File"],
        "bap":           [0, "Blaze Audio Wave Information File"],
        "bdd":           [0, "CARA Sound Radiation Data File"],
        "box":           [0, "CARA Loudspeaker Design File"],
        "bwf":           [0, "Broadcast Wave File"],
        "c01":           [0, "Typhoon Wave Audio File"],
        "caf":           [0, "Core Audio File"],
        "cda":           [0, "CD Audio Track Shortcut"],
        "cdr":           [0, "Raw Audio CD Data"],
        "cel":           [0, "Audition Loop"],
        "cmf":           [0, "Creative Music Format"],
        "copy":          [0, "Sony Ericsson Protected Content File"],
        "cpr":           [0, "Cubase Project"],
        "csh":           [0, "Cubase Waveform File"],
        "cwp":           [0, "Cakewalk SONAR Project"],
        "d00":           [0, "OPL2 FM Audio File"],
        "d01":           [0, "OPL2 FM Audio File"],
        "dcf":           [0, "DRM Content Format File"],
        "dcm":           [0, "DCM Audio Module"],
        "dct":           [0, "Dictation Audio File"],
        "dewf":          [0, "SoundEdit Recorded Instrument"],
        "df2":           [0, "Defractor 2 Instrument"],
        "dfc":           [0, "Defractor Instrument"],
        "dig":           [0, "Digilink Audio File"],
        "dig":           [0, "Sound Designer Audio File"],
        "dls":           [0, "Downloadable Sounds File"],
        "dm":            [0, "DRM Delivery Message"],
        "dmf":           [0, "Delusion Digital Music File"],
        "dsf":           [0, "Delusion Digital Sound File"],
        "dsm":           [0, "Digital Sound Module"],
        "dsp":           [0, "Dynamic Studio Professional Module"],
        "dss":           [0, "Digital Speech Standard File"],
        "dtm":           [0, "DigiTrakker Module"],
        "dvf":           [0, "Sony Digital Voice File"],
        "DWD":           [0, "DiamondWare Digital Audio File"],
        "ear":           [0, "Eyemail Audio Recording"],
        "efa":           [0, "Ensoniq ASR File"],
        "efe":           [0, "Ensoniq EPS File"],
        "efk":           [0, "Ensoniq KT File"],
        "efq":           [0, "Ensoniq SQ1/SQ2/KS-32 File"],
        "efs":           [0, "Ensoniq SQ-80 File"],
        "efv":           [0, "Ensoniq VFX-SD File"],
        "emd":           [0, "ABT Extended Module"],
        "esps":          [0, "ESPS Sampled Data File"],
        "f2r":           [0, "Farandoyle Linear Module File"],
        "f32":           [0, "Raw 32-Bit Audio File"],
        "f3r":           [0, "Farandoyle Blocked Module File"],
        "f64":           [0, "Raw 64-Bit Audio File"],
        "far":           [0, "Farandole Composer Module"],
        "fff":           [0, "Gravis UltraSound Sound Bank"],
        "flac":          [0, "Free Lossless Audio Codec"],
        "flp":           [0, "FruityLoops Project"],
        "fsm":           [0, "Farandole Composer WaveSample File"],
        "fzb":           [0, "Casio FZ-1 Bank Dump"],
        "fzf":           [0, "Casio FZ-1 Full Dump"],
        "fzv":           [0, "Casio FZ-1 Voice Dump"],
        "g721":          [0, "G.721 Audio File"],
        "g723":          [0, "G.723 Audio File"],
        "g726":          [0, "G.726 Audio File"],
        "gig":           [0, "Tascam GigaSampler File"],
        "gp5":           [0, "Guitar Pro 5 Tablature File"],
        "gsm":           [0, "Global System for Mobile Audio File"],
        "gsm":           [0, "US Robotics GSM Audio File"],
        "ics":           [0, "IC Recorder Sound File"],
        "iff":           [1, "Interchange File Format"],
        "ins":           [0, "Ensoniq Instrument"],
        "ins":           [0, "Sample Cell II Instrument Definition File"],
        "it":            [0, "Impulse Tracker Module"],
        "iti":           [0, "Impulse Tracker Instrument"],
        "its":           [0, "Impulse Tracker Sample"],
        "jam":           [0, "JAM Music Score"],
        "k25":           [0, "Kurzweil K2500 File"],
        "k26":           [0, "Kurzweil K2600 File"],
        "kar":           [0, "Karaoke MIDI File"],
        "kin":           [0, "Kinetic Music Project"],
        "kmp":           [0, "Korg Trinity/Triton Keymap File"],
        "koz":           [0, "Audiokoz Music File"],
        "koz":           [0, "Bell Music File"],
        "krz":           [0, "Kurzweil K2000 File"],
        "ksc":           [0, "Korg Trinity/Triton Script File"],
        "ksf":           [0, "Korg Trinity/Triton Sample File"],
        "ktp":           [0, "Kinetic Project Template"],
        "l":             [0, "Left Audio Channel File"],
        "lso":           [0, "Logic Audio Project"],
        "lvp":           [0, "Avaya Voice Player Audio File"],
        "m3u":           [1, "Media Playlist File"],
        "m4a":           [0, "MPEG-4 Audio File"],
        "m4b":           [0, "MPEG-4 Audio Book File"],
        "m4p":           [0, "iTunes Music Store Audio File"],
        "m4r":           [0, "iPhone Ringtone File"],
        "ma1":           [0, "Monarch Audio File"],
        "mdl":           [0, "DigiTrakker Module"],
        "med":           [0, "Amiga MED Sound File"],
        "mid":           [1, "MIDI File"],
        "midi":          [1, "MIDI File"],
        "miniusf":       [0, "Nintendo 64 Song File"],
        "mka":           [0, "Matroska Audio File"],
        "mmf":           [0, "Synthetic Music Mobile Application Format"],
        "mod":           [0, "Amiga Music Module File"],
        "mp1":           [0, "MPEG-1 Layer 1 Audio File"],
        "mp2":           [0, "MPEG Layer II Compressed Audio File"],
        "mp3":           [1, "MP3 Audio File"],
        "mpa":           [1, "MPEG Audio File"],
        "mpc":           [0, "Musepack Audio File"],
        "mpd":           [0, "File List Creator Playlist"],
        "mpga":          [0, "MPEG-1 Layer 3 Audio File"],
        "mpu":           [0, "MPEG Layer 3 Audio File"],
        "mp_":           [0, "Mobile Phone Sound File"],
        "msv":           [0, "Memory Stick Voice File"],
        "mt2":           [0, "MadTracker 2 Module"],
        "mte":           [0, "MadTracker 2 Envelope"],
        "mti":           [0, "MadTracker Instrument"],
        "mtm":           [0, "MultiTracker Module"],
        "mtp":           [0, "MadTracker 2 Pattern"],
        "mts":           [0, "MadTracker 2 Sample"],
        "mus":           [0, "Finale Notation File Format"],
        "mws":           [0, "MWave DSP Synth Instrument Extract"],
        "nap":           [0, "Napster Secured Music File"],
        "nrt":           [0, "Nokia Ringtone"],
        "nsa":           [0, "Nullsoft Streaming Audio File"],
        "nsf":           [0, "NES Sound Format File"],
        "nst":           [0, "NoiseTracker Module"],
        "ntn":           [0, "NOTION Song File"],
        "nwc":           [0, "NoteWorthy Composer File"],
        "odm":           [0, "OverDrive Media File"],
        "ogg":           [0, "Ogg Vorbis Compressed Audio File"],
        "okt":           [0, "Oktalyzer Module"],
        "omf":           [0, "Open Media Framework File"],
        "omg":           [0, "OpenMG Audio File"],
        "pac":           [0, "SBStudio II Song File"],
        "pat":           [0, "Gravis UltraSound GF1 Patch File"],
        "pbf":           [0, "Pinnacle Sample Bank"],
        "pca":           [0, "Perfect Clarity Audio"],
        "pcm":           [0, "Pulse Code Modulation"],
        "phy":           [0, "PhyMod Physical Modeling Data"],
        "pla":           [0, "Sansa Playlist File"],
        "pls":           [0, "Audio Playlist"],
        "pna":           [0, "PhatNoise Audio File"],
        "prg":           [0, "WAVmaker Program File"],
        "prg":           [0, "Akai MPC2000 Program File"],
        "psm":           [0, "Protracker Studio Module"],
        "ptm":           [0, "PolyTracker Module"],
        "pts":           [0, "Pro Tools Project"],
        "pvc":           [0, "Panasonic VM1 Voice File"],
        "qcp":           [0, "PureVoice Audio File"],
        "r":             [0, "Right Audio Channel File"],
        "ra":            [1, "Real Audio File"],
        "ram":           [1, "Real Audio Media"],
        "raw":           [0, "Raw Audio Data"],
        "rbs":           [0, "Rebirth Song File"],
        "rfl":           [0, "Reason ReFill Sound Bank"],
        "rmf":           [0, "Rich Music Format"],
        "rmi":           [0, "RMID MIDI File"],
        "rmx":           [0, "RealJukebox Format"],
        "rng":           [0, "Nokia Composer Ringtone"],
        "rol":           [0, "Ad Lib Synthesized Instrument"],
        "rsn":           [0, "Reason Project File"],
        "rti":           [0, "Real Tracker Instrument"],
        "rtm":           [0, "Real Tracker Module"],
        "rts":           [0, "Real Tracker Sample"],
        "s3i":           [0, "Scream Tracker 3 Instrument"],
        "s3m":           [0, "ScreamTracker 3 Module"],
        "saf":           [0, "Secure Audio File"],
        "sam":           [0, "MOD Edit Sample File"],
        "sb":            [0, "Signed Byte Audio File"],
        "sbi":           [0, "Sound Blaster Instrument"],
        "sbk":           [0, "E-MU SoundFont Sound Bank"],
        "sc2":           [0, "Sample Cell II Instrument Definition"],
        "sd":            [0, "Sound Designer Audio File"],
        "sd":            [0, "ESPS Sampled Data File"],
        "sd2":           [0, "Sound Designer II File"],
        "sds":           [0, "MIDI Sample Dump Standard File"],
        "sdx":           [0, "Sample MIDI Dump Exchange"],
        "sf":            [0, "IRCAM Sound File"],
        "sf2":           [0, "SoundFont 2 Sound Bank"],
        "sfk":           [0, "Sound Forge Audio Peak File"],
        "sfl":           [0, "Sound Forge Sound Data File"],
        "shn":           [0, "Shorten Compressed Audio File"],
        "sib":           [0, "Sibelius Score"],
        "sid":           [0, "Commodore 64 Music File"],
        "smf":           [0, "Standard MIDI File"],
        "smp":           [0, "SampleVision Audio Sample Format"],
        "snd":           [0, "Sound File"],
        "snd":           [0, "Macintosh Sound Resource"],
        "snd":           [0, "Akai MPC Sample"],
        "sng":           [0, "MIDI Song File"],
        "sou":           [0, "SBStudio II Sound File"],
        "sppack":        [0, "SPPack Sound Sample"],
        "sprg":          [0, "Synclavier Program File"],
        "sseq":          [0, "Synclavier Sequence File"],
        "ssnd":          [0, "Synclavier Sound File"],
        "stm":           [0, "Scream Tracker 2 Module"],
        "stx":           [0, "Scream Tracker Music Interface Kit File"],
        "svx":           [0, "8SVX Sound File"],
        "sw":            [0, "Signed Word Audio File"],
        "swa":           [0, "ShockWave Audio"],
        "syh":           [0, "Synchomatic Instrument"],
        "syw":           [0, "Yamaha SY99/SY85 Audio File"],
        "syx":           [0, "MIDI System Exclusive Message"],
        "td0":           [0, "Akai Teledisk Sound Library"],
        "tfmx":          [0, "Final Music System Tracker Module"],
        "thx":           [0, "Amiga THX Tracker Music File"],
        "toc":           [0, "PSP Audio File"],
        "tsp":           [0, "TrueSpeech Audio File"],
        "txw":           [0, "Yamaha TX16W Audio File"],
        "u":             [0, "AU Audio File"],
        "ub":            [0, "Unsigned Byte Audio File"],
        "ulaw":          [0, "Raw µ-Law Audio File"],
        "ult":           [0, "UltraTracker Module"],
        "ulw":           [0, "Raw µ-Law Audio File"],
        "uni":           [0, "MikMod UniMOD Module"],
        "usf":           [0, "Nintendo 64 Music File"],
        "usflib":        [0, "Nintendo 64 Song Library"],
        "uw":            [0, "Unsigned Word Audio File"],
        "uwf":           [0, "UltraTracker Wave File"],
        "vag":           [0, "PlayStation Compressed Sound File"],
        "val":           [0, "Olympus Voice Recording"],
        "vmd":           [0, "Covox Raw Sample"],
        "vmf":           [0, "Vocaltec Media File"],
        "vmf":           [0, "Covox Speech Thing Sample"],
        "voc":           [0, "Creative Labs Audio File"],
        "voi":           [0, "Voyetra Voice File"],
        "vox":           [0, "VoxWare Dialogic Audio File"],
        "vqf":           [0, "TwinVQ Audio File"],
        "vrf":           [0, "Ventrilo Audio Recording"],
        "w01":           [0, "Yamaha SY Series Wave File"],
        "wav":           [1, "Windows WAVE Sound File"],
        "wave":          [0, "WAVE Sound File"],
        "wax":           [0, "Windows Media Audio Redirect"],
        "wfb":           [0, "WaveFront Sound Bank"],
        "wfd":           [0, "WaveFront Drum Kit File"],
        "wfp":           [0, "WaveFront Program File"],
        "wma":           [1, "Windows Media Audio File"],
        "wow":           [0, "Grave Composer Music Module"],
        "wpk":           [0, "Nero Wave Editor File"],
        "wproj":         [0, "Wwise Project"],
        "wrk":           [0, "Cakewalk Music Project"],
        "wus":           [0, "WUTG Tagged Audio File"],
        "wut":           [0, "WUTG Tag File"],
        "wv":            [0, "WavPack Audio File"],
        "wvc":           [0, "WavPack Correction File"],
        "wwu":           [0, "Wwise Work Unit"],
        "xfs":           [0, "eRacer Sound File"],
        "xi":            [0, "Fasttracker 2 Extended Instrument File"],
        "xm":            [0, "Fasttracker 2 Extended Module"],
        "xmf":           [0, "Extensible Music File"],
        "xmi":           [0, "Extended MIDI File"],
        "xp":            [0, "Fastracker 2 Pattern"],
        "xt":            [0, "Fastracker 2 Track"],
        "zvd":           [0, "ZyXEL Voice File"],
    },
    'backup': {
        "$$$":           [0, "Temporary File"],
        "$db":           [0, "dBASE Temporary File"],
        "001":           [0, "Norton Ghost Disk Backup"],
        "001":           [0, "HJSplit Split Archive"],
        "113":           [0, "Iomega Backup File"],
        "abbu":          [0, "Address Book Backup"],
        "abk":           [0, "Automatic Backup"],
        "bac":           [0, "Backup File"],
        "bak":           [1, "Backup File"],
        "bak":           [0, "Firefox Bookmarks Backup"],
        "bck":           [0, "VMX Backup File"],
        "bcm":           [0, "Microsoft Works Communications Script Backup"],
        "bdb":           [0, "Microsoft Works Database Backup File"],
        "bkc":           [0, "Backup4all Backup Catalog"],
        "bkf":           [0, "Windows Backup Utility File"],
        "bkp":           [0, "Backup File"],
        "bks":           [0, "Microsoft Works Spreadsheet Backup File"],
        "bps":           [0, "Microsoft Works Document Backup"],
        "bup":           [0, "Backup File"],
        "bup":           [0, "DVD IFO Backup File"],
        "cbk":           [0, "Backup Configuration File"],
        "da0":           [0, "Windows Registry Backup"],
        "dbk":           [0, "dBASE Database Backup"],
        "dov":           [0, "Temp File"],
        "fbf":           [0, "Free Backup Fix Backup File"],
        "gb1":           [0, "Game Maker Backup File"],
        "gho":           [1, "Norton Ghost Backup File"],
        "iv2i":          [0, "Norton Ghost Incremental Virtual Volume Image"],
        "jbk":           [0, "Juno Backup File"],
        "llx":           [0, "LabVIEW VI Library Backup File"],
        "mem":           [0, "FoxPro Variable File"],
        "nb7":           [0, "NovaBACKUP Output File"],
        "nbk":           [0, "NovaBACKUP Backup Script"],
        "nco":           [0, "Nero BackItUp File"],
        "nrs":           [0, "NovaBACKUP Restore Script"],
        "oeb":           [0, "Outlook Express Backup Wizard File"],
        "old":           [1, "Backup File"],
        "ori":           [1, "Original File"],
        "oyx":           [0, "Approach Alternate Database Index"],
        "qbb":           [0, "QuickBooks Backup File"],
        "qbx":           [0, "QuickBooks Accountant Transfer File"],
        "qic":           [0, "Windows Backup File"],
        "rbc":           [0, "Retrospect Backup Catalog File"],
        "rbf":           [0, "Retrospect Backup File"],
        "rbk":           [0, "Windows 95 Registry Backup File"],
        "rdb":           [0, "Retrospect Backup Set"],
        "rrr":           [0, "Registry Mechanic Backup File"],
        "skb":           [0, "SketchUp Backup Document"],
        "tbk":           [0, "FoxPro Memo Backup"],
        "tmp":           [1, "Temporary File"],
        "v2i":           [0, "Norton Ghost Virtual Volume Image"],
        "win":           [0, "Windows Backup File"],
        "win":           [0, "FoxPro Window Settings"],
        "xlk":           [0, "Excel Backup File"],
    },
    'compressed': {
        "000":           [0, "DoubleSpace Compressed File"],
        "7z":            [0, "7-Zip Compressed File"],
        "ace":           [0, "WinAce Compressed File"],
        "ain":           [0, "AIN Compressed File Archive"],
        "alz":           [0, "ALZip Archive"],
        "ar":            [0, "Unix Static Library"],
        "arc":           [0, "Compressed File Archive"],
        "ari":           [0, "ARI Compressed File Archive"],
        "arj":           [0, "ARJ Compressed File Archive"],
        "axx":           [0, "AxCrypt Encrypted File"],
        "bh":            [0, "BlakHole Archive"],
        "bhx":           [0, "BinHex Encoded File"],
        "boo":           [0, "Booasm Compressed Archive"],
        "bz":            [0, "Bzip Compressed File"],
        "bz2":           [0, "Bzip2 Compressed File"],
        "c00":           [0, "WinAce Split Archive File"],
        "c01":           [0, "WinAce Split Archive Part 1 File"],
        "c02":           [0, "WinAce Split Archive Part 1 File"],
        "car":           [0, "CAR Archive"],
        "cbr":           [0, "Comic Book Archive"],
        "cbz":           [0, "Comic Book Zipped Archive"],
        "cp9":           [0, "ChoicePoint Encrypted File"],
        "cpgz":          [0, "Compressed CPIO Archive"],
        "cpt":           [0, "Compact Pro Archive"],
        "dar":           [0, "DAR Disk Archive"],
        "dd":            [0, "DiskDouber Archive"],
        "deb":           [0, "Debian Software Package"],
        "dgc":           [0, "DGCA File Archive"],
        "dist":          [0, "Mac OS X Distribution Script"],
        "ecs":           [0, "Sony Ericsson Phone Backup File"],
        "efw":           [0, "Renamed Zip or Executable File"],
        "enc":           [0, "UUEncoded File"],
        "f":             [0, "Freeze Compressed File"],
        "fdp":           [0, "MySafe Encrypted Data"],
        "gca":           [0, "GCA File Archive"],
        "gz":            [1, "Gnu Zipped File"],
        "gzip":          [0, "Gnu Zipped File"],
        "ha":            [0, "HA Compressed Archive"],
        "hki":           [0, "WinHKI Archive"],
        "hki1":          [0, "WinHKI HKI1 Archive"],
        "hki2":          [0, "WinHKI HKI2 Archive"],
        "hki3":          [0, "WinHKI HKI3 Archive"],
        "hpk":           [0, "HPack Compressed Archive"],
        "hyp":           [0, "HYPER Compressed Archive"],
        "ice":           [0, "ICE File Archive"],
        "ipg":           [0, "iPod Game File"],
        "ipk":           [0, "Itsy Package"],
        "ish":           [0, "ISH Compressed Archive"],
        "j":             [0, "JAR Archive"],
        "jic":           [0, "Java Icon File"],
        "kgb":           [0, "KGB Archive"],
        "lbr":           [0, "LU Library Archive"],
        "lha":           [0, "Compressed Archive"],
        "lnx":           [0, "Commodore 64 Lynx Archive"],
        "lqr":           [0, "SQ Compressed LBR Archive"],
        "lzh":           [0, "Compressed File"],
        "lzma":          [0, "LZMA Compressed File"],
        "lzo":           [0, "LZO Compressed File"],
        "lzx":           [0, "Amiga LZX Compressed File"],
        "md":            [0, "MDCD Compressed Archive"],
        "mint":          [0, "Linux Mint Installer File"],
        "mpkg":          [0, "Meta Package File"],
        "p7m":           [0, "Digitally Encrypted Message"],
        "package":       [0, "Linux Autopackage File"],
        "pae":           [0, "PowerArchiver Encrypted Archive"],
        "pak":           [0, "PAK (Packed) File"],
        "paq6":          [0, "PAQ6 Data Archive"],
        "paq7":          [0, "PAQ7 Data Archive"],
        "paq8":          [0, "PAQ8 Data Archive"],
        "par":           [0, "Parchive Index File"],
        "par2":          [0, "Parchive 2 Index File"],
        "pbi":           [0, "PC BSD Installer Package"],
        "pcv":           [0, "Mozilla Profile Backup"],
        "pf":            [0, "Private File"],
        "pim":           [0, "PIM Archive"],
        "pit":           [0, "PackIt Compressed Archive"],
        "piz":           [0, "Zipped File"],
        "pkg":           [1, "Mac OS X Installer Package"],
        "pup":           [0, "PlayStation 3 Update File"],
        "pup":           [0, "Puppy Linux DotPup Installer Package"],
        "puz":           [0, "Packed Publisher File"],
        "pwa":           [0, "Password Agent File"],
        "qda":           [0, "Quadruple D Archive"],
        "r00":           [0, "WinRAR Compressed Archive"],
        "r01":           [0, "WinRAR Split Archive Part 1"],
        "r02":           [0, "WinRAR Split Archive Part 2"],
        "r03":           [0, "WinRAR Split Archive Part 3"],
        "rar":           [1, "WinRAR Compressed Archive"],
        "rk":            [0, "WinRK File Archive"],
        "rpm":           [0, "Red Hat Package Manager File"],
        "rte":           [0, "RTE Encoded File"],
        "rz":            [0, "Rzip Compressed File"],
        "s00":           [0, "ZipSplitter Part 1 Archive"],
        "s01":           [0, "ZipSplitter Part 2 Archive"],
        "s02":           [0, "ZipSplitter Part 3 Archive"],
        "s7z":           [0, "Mac OS X 7-Zip File"],
        "sdn":           [0, "Shareware Distributors Network File"],
        "sea":           [1, "Self-Extracting Archive"],
        "sfs":           [0, "SquashFS File Archive"],
        "sfx":           [0, "Windows Self-Extracting Archive"],
        "sh":            [0, "Unix Shell Archive"],
        "shar":          [0, "Unix Shar Archive"],
        "shk":           [0, "ShrinkIt Archive"],
        "shr":           [0, "Unix Shell Archive File"],
        "sit":           [1, "Stuffit Archive"],
        "sitx":          [1, "Stuffit X Archive"],
        "sqx":           [0, "SQX Archive"],
        "sqz":           [0, "Squeezed Video File"],
        "tar":           [0, "Consolidated File Archive (Unix)"],
        "tbz2":          [0, "Tar BZip 2 Compressed File"],
        "tgz":           [0, "Gzipped Tar File"],
        "tlz":           [0, "Tar LZMA Compressed File"],
        "uc2":           [0, "UltraCompressor 2 Archive"],
        "uha":           [0, "UHarc Compressed Archive"],
        "vsi":           [0, "Visual Studio Content Installer File"],
        "wad":           [0, "Compressed Game Data"],
        "war":           [0, "Java Web Archive"],
        "wot":           [0, "Web Of Trust File"],
        "xef":           [0, "WinAce Encrypted File"],
        "xez":           [0, "eManager Template Package"],
        "xpi":           [0, "Mozilla Installer Package"],
        "xx":            [0, "XXEncoded File"],
        "y":             [0, "Amiga Yabba Compressed File"],
        "yz":            [0, "YAC Compressed File"],
        "z":             [0, "Unix Compressed File"],
        "zap":           [0, "FileWrangler Archive"],
        "zfsendtotarget": [0, "Compressed Folder"],
        "zip":           [1, "Zipped File"],
        "zix":           [0, "WinZix Compressed File"],
        "zoo":           [0, "Zoo Compressed File"],
        "zz":            [0, "Zzip Compressed Archive"],
    },
    'data': {
        "$er":           [0, "GroupWise Database"],
        "123":           [1, "Lotus 1-2-3 Spreadsheet"],
        "1pe":           [0, "TurboTax Form File"],
        "1ph":           [0, "TurboTax File"],
        "3dt":           [0, "3D Topicscape File"],
        "a3l":           [0, "Authorware 3 Library"],
        "a3m":           [0, "Authorware 3 Macintosh File"],
        "a3w":           [0, "Authorware 3 Windows File"],
        "a4l":           [0, "Authorware 4 Library"],
        "a4m":           [0, "Authorware 4 Macintosh File"],
        "a4w":           [0, "Authorware 4 Windows File"],
        "a5l":           [0, "Authorware 5 Library"],
        "a5w":           [0, "Authorware 5 Windows File"],
        "a65":           [0, "Authorware 6.5 File"],
        "ab":            [0, "DNA Sequence File"],
        "ab1":           [0, "DNA Electropherogram File"],
        "ab3":           [0, "PhotoImpact 3 Album File"],
        "abcd":          [0, "AudioVisual Book Data File"],
        "abi":           [0, "DNA Chromatogram File"],
        "ade":           [0, "Access Project Extension"],
        "adp":           [0, "Access Project"],
        "adx":           [0, "Approach Index File"],
        "aft":           [0, "Ancestry.com Family Tree Database"],
        "ask":           [0, "askSam Database"],
        "asm":           [0, "Solid Edge Assembly Document"],
        "awg":           [0, "Activeworlds Object Group File"],
        "bci":           [0, "Belarc Advisor Report File"],
        "bcm":           [0, "Business Contact Manager File"],
        "bdf":           [0, "Binary Data File"],
        "bin":           [0, "Generic Binary File"],
        "bk":            [0, "FrameMaker Book File"],
        "bkk":           [0, "BookBuddi eBook File"],
        "bok":           [0, "TestGen Testbank File"],
        "box":           [0, "E-mail Mailbox"],
        "brd":           [0, "EAGLE Circuit Board File"],
        "btm":           [0, "BizTalk Map File"],
        "cat":           [0, "Advanced Disk Catalog Database"],
        "cbg":           [0, "CyberGauge Data File"],
        "ccr":           [0, "ASTM Continuity of Care Record"],
        "cdf":           [0, "Common Data Format"],
        "chg":           [0, "Quicken Online Data File"],
        "chn":           [0, "Ethnograph Data"],
        "ckt":           [0, "CircuitMaker File"],
        "clp":           [0, "Windows Clipboard File"],
        "crd":           [0, "Windows Cardfile"],
        "csa":           [0, "PNA Code Calset File"],
        "csv":           [1, "Comma Separated Values File"],
        "ctf":           [0, "WhereIsIt Catalog"],
        "ctt":           [0, "Messenger Contact List"],
        "cwk":           [0, "ClarisWorks Document"],
        "cws":           [0, "Claris Works Template"],
        "cyo":           [0, "Clustify Output File"],
        "cys":           [0, "Clustify Summary File"],
        "daf":           [0, "Digital Anchor File"],
        "dam":           [0, "DeltaMaster Analysis Model"],
        "das":           [0, "DeltaMaster Analysis Session"],
        "dat":           [1, "Data File"],
        "db":            [1, "Database File"],
        "db2":           [0, "dBASE II Database"],
        "dbc":           [0, "FoxPro Database"],
        "dbf":           [0, "Database File"],
        "dbf":           [0, "FoxPro Table"],
        "dbx":           [0, "Visual FoxPro Table"],
        "dcl":           [0, "DumpSec Report File"],
        "ddc":           [0, "DivX Descriptor File"],
        "ddcx":          [0, "DivX Descriptor 2 File"],
        "dem":           [0, "Digital Elevation Model"],
        "des":           [0, "QuickBooks Forms Template"],
        "dex":           [0, "DEXIS Digital X-ray File"],
        "dex":           [0, "Excel Spreadsheet"],
        "dft":           [0, "Solid Edge Draft Document"],
        "dgb":           [0, "FlashCAD Drawing Database"],
        "dif":           [0, "Data Interchange Format"],
        "dii":           [0, "Summation Batch Load File"],
        "dlg":           [0, "Digital Line Graph"],
        "dll":           [1, "Dynamic Link Library"],
        "dm2":           [0, "Toad Data Modeler 2 File"],
        "dmo":           [0, "Derive Demo"],
        "dp1":           [0, "DataPower Database File"],
        "dsk":           [0, "Simple IDs Database"],
        "e00":           [0, "ArcInfo Coverage Export File"],
        "eap":           [0, "Enterprise Architect Project"],
        "ebuild":        [0, "Portage eBuild Script"],
        "edb":           [0, "Exchange Information Store Database"],
        "emb":           [0, "Embroidery Design File"],
        "emb":           [0, "Everest Embedded Bank File"],
        "emd":           [0, "ChessBase Tablebase"],
        "emlxpart":      [0, "Mail Message Attachment"],
        "epp":           [0, "TalaPhoto Project"],
        "esp":           [0, "ACD/Labs Dataset"],
        "ess":           [0, "EasySpreadsheet Spreadsheet"],
        "ev":            [0, "Echoview File"],
        "evy":           [0, "Envoy File"],
        "exp":           [0, "Export File"],
        "exp":           [0, "Aurora Expert Trace File"],
        "fa":            [0, "FASTA Formatted Sequence File"],
        "fasta":         [0, "FASTA Sequence File"],
        "fcd":           [0, "First Choice Database"],
        "fcs":           [0, "First Choice Spreadsheet"],
        "fdb":           [0, "Portfolio Catalog"],
        "fdb":           [0, "Art Explosion Catalog"],
        "ffd":           [0, "Flat File Description"],
        "flame":         [0, "Fractal Flame File"],
        "fll":           [0, "FoxPro Dynamic-Link Library"],
        "flo":           [0, "iGrafx FlowCharter File"],
        "flp":           [0, "Activprimary Flipchart File"],
        "flt":           [0, "Flight Simulator Saved Flight"],
        "fm":            [0, "FileMaker Spreadsheet"],
        "fm5":           [0, "FileMaker 5 Database"],
        "fmp":           [0, "FileMaker Pro Database"],
        "fo":            [0, "XSL-FO Form"],
        "fop":           [0, "InfoZoom Protected Data File"],
        "fox":           [0, "InfoZoom Data File"],
        "fp":            [0, "FileMaker Pro Spreadsheet"],
        "fp3":           [0, "FileMaker Pro 3 Database"],
        "fp4":           [0, "FileMaker Pro 4 Database"],
        "fp5":           [0, "FileMaker Pro 5 Database"],
        "fp7":           [0, "FileMaker Pro 7+ Database"],
        "frl":           [0, "Electronic Form Loader"],
        "frm":           [0, "ADL Form"],
        "fro":           [0, "dBASE IV Compiled Report"],
        "frx":           [0, "FoxPro Report"],
        "fsc":           [0, "Practical Scriptwriter File"],
        "ftw":           [0, "Family Tree File"],
        "gc":            [0, "GraphClick File"],
        "gcx":           [0, "Grapher Graph File"],
        "gdb":           [0, "InterBase Database"],
        "ged":           [0, "GEDCOM Genealogy Data File"],
        "gms":           [0, "Gesture and Motion Signal File"],
        "gnp":           [0, "GNPeak Output File"],
        "gpx":           [0, "GPS Exchange File"],
        "gra":           [0, "Microsoft Graph File"],
        "grf":           [0, "Generic Graph File"],
        "grf":           [0, "DPlot Graph File"],
        "grib":          [0, "Gridded Binary File"],
        "gst":           [0, "MapInfo Geoset File"],
        "gxl":           [0, "Graph Exchange Language File"],
        "hdf":           [0, "Hierarchical Data Format File"],
        "hdl":           [0, "HotDocs Library"],
        "hif":           [0, "Quicken Online File"],
        "ib":            [0, "InterBase Database"],
        "ics":           [0, "iCalendar File"],
        "idx":           [0, "HMI Historical Log Index File"],
        "igc":           [0, "Anime List Builder Input File"],
        "iif":           [0, "Intuit Interchange Format File"],
        "ink":           [0, "Mimio Ink Data File"],
        "inp":           [0, "ABAQUS Input File"],
        "irock":         [0, "intelliRock Sensor Data File"],
        "isf":           [0, "Inspiration Flowchart Document"],
        "itl":           [0, "iTunes Library File"],
        "itn":           [0, "TomTom Navigator Itinerary File"],
        "itw":           [0, "InTouch With Database File"],
        "ivt":           [0, "Beyond 20/20 Table"],
        "jef":           [0, "Janome Embroidery Format"],
        "jude":          [0, "JUDE Project File"],
        "kdb":           [0, "Keypass Database File"],
        "kid":           [0, "Kidspiration Document"],
        "kmz":           [0, "Google Earth Placemark File"],
        "kpr":           [0, "KPresenter Presentation"],
        "lbx":           [0, "FoxPro Label Definition File"],
        "lcd":           [0, "ABBYY Language File"],
        "lcf":           [0, "ArchiCAD Library Container File"],
        "lcm":           [0, "Lipikar Custom Map File"],
        "lgh":           [0, "HMI Historical Log File"],
        "lgi":           [0, "Multimedia Logic File"],
        "lib":           [0, "Generic Data Library"],
        "lif":           [0, "TurboTax Information Archive"],
        "lix":           [0, "Logos Library System File"],
        "llb":           [0, "LabVIEW Library File"],
        "lnt":           [0, "LiveNote Case File"],
        "lp7":           [0, "LP7 Digitally Signed File"],
        "lsf":           [0, "Logos Library System File"],
        "lsp":           [0, "LANsurveyor Poll List"],
        "lsr":           [0, "LANsurveyor Report"],
        "lsu":           [0, "LANsurveyor Map"],
        "m":             [0, "Mathematica Input File"],
        "mai":           [0, "Microsoft Mail File"],
        "mat":           [0, "MATLAB Variables Binary File"],
        "mbg":           [0, "Mailbag Assistant Mailbox File"],
        "mbg":           [0, "Microsoft Mailbag"],
        "mbl":           [0, "Logger Pro Data"],
        "mbx":           [0, "Outlook Express Mailbox"],
        "mc1":           [0, "MedCalc Data File"],
        "mc9":           [0, "Mastercam 9 Geometry File"],
        "mcd":           [0, "Mathcad Document"],
        "md":            [0, "Moneydance Financial Data File"],
        "mdb":           [1, "Microsoft Access Database"],
        "mdc":           [0, "Multi Dimension Cube File"],
        "mdf":           [0, "Measurement Data Format File"],
        "mdl":           [0, "Simulink Model File"],
        "mdl":           [0, "Rational Rose Model File"],
        "mdn":           [0, "Blank Access Database Template"],
        "mdt":           [0, "Access Database Template"],
        "mdx":           [0, "Multiple Index File"],
        "mdx":           [0, "Rational XDE Model File"],
        "mdz":           [0, "Access Wizard Template"],
        "mfo":           [0, "Perl ModInfo Descriptor File"],
        "mfp":           [0, "Macromedia FlashPaper Document"],
        "mgc":           [0, "MGCSoft Equation Illustrator File"],
        "mls":           [0, "Milestones Simplicity File"],
        "mm":            [0, "FreeMind Mind Map"],
        "mmap":          [0, "MindManager Map File"],
        "mmp":           [0, "MindManager Mind Map"],
        "mmp":           [0, "Master Album Maker Project"],
        "mnc":           [0, "My Notes Center Notebook"],
        "mnk":           [0, "My Notes Keeper Notebook"],
        "mny":           [0, "Microsoft Money File"],
        "mp":            [0, "Maya Project File"],
        "mpx":           [0, "Microsoft Project Exchange File"],
        "mth":           [0, "Derive Math File"],
        "nb":            [0, "Mathematica Notebook"],
        "ndx":           [0, "dBASE Index File"],
        "net":           [0, "netViz Project File"],
        "neta":          [0, "Netica Binary File"],
        "nitf":          [0, "National Imagery Transmission Format File"],
        "nmind":         [0, "NovaMind Mind Map File"],
        "notebook":      [0, "SMART Notebook File"],
        "np":            [0, "Portfolio NetPublish File"],
        "npt":           [0, "Portfolio NetPublish Template"],
        "ns2":           [0, "Lotus Notes 2 Database"],
        "ns3":           [0, "Lotus Notes 3 Database"],
        "ns4":           [0, "Lotus Notes 4 Database"],
        "nsf":           [0, "Lotus Notes Database"],
        "nsf":           [0, "Lotus Domino Database"],
        "nvl":           [0, "UniChem Results File"],
        "nyf":           [0, "myBase Database File"],
        "oab":           [0, "Offline Address Book"],
        "obj":           [0, "Relocatable Object Code"],
        "odb":           [0, "ABAQUS Database"],
        "odf":           [0, "Open Document File"],
        "odp":           [0, "OpenDocument Presentation"],
        "ods":           [0, "OpenDocument Spreadsheet"],
        "odx":           [0, "BizTalk Server Orchestration File"],
        "ofm":           [0, "OmniForm Form"],
        "oo3":           [0, "OmniOutliner 3 File"],
        "opf":           [0, "FlipViewer FlipBook File"],
        "opx":           [0, "OrgPlus Org Chart"],
        "opx":           [0, "FlipAlbum Photo Album File"],
        "or4":           [0, "Lotus Organizer 4 File"],
        "org":           [0, "Lotus Organizer File"],
        "otln":          [0, "Opal Outline File"],
        "ots":           [0, "OpenDocument Spreadsheet Template"],
        "ov2":           [0, "TomTom Points of Interest Database"],
        "ova":           [0, "Octava Musical Score"],
        "ovl":           [0, "Rollercoaster Tycoon 3 Sprites File"],
        "p96":           [0, "Win96 Database File"],
        "p97":           [0, "Win97 Database File"],
        "pab":           [0, "Personal Address Book"],
        "pan":           [0, "Panorama Database File"],
        "pcap":          [0, "Packet Capture"],
        "pdas":          [0, "PDAStore Data Store File"],
        "pdb":           [0, "Program Database"],
        "pdd":           [0, "Medtronic Programmer Data File"],
        "pds":           [0, "Planetary Data System File"],
        "pex":           [0, "Merak Peep Data File"],
        "pfc":           [0, "AOL Personal File Cabinet"],
        "pfl":           [0, "Family Lawyer Document"],
        "pi":            [0, "Pi Calculation Data File"],
        "pjx":           [0, "FoxPro Project"],
        "pmd":           [0, "PageMaker Document"],
        "pmr":           [0, "Performance Monitor Report"],
        "postal":        [0, "TomTom Postal Code File"],
        "pot":           [0, "PowerPoint Template"],
        "potx":          [0, "PowerPoint Open XML Presentation Template"],
        "pp2":           [0, "PingPlotter Data File"],
        "pps":           [1, "PowerPoint Slide Show"],
        "ppsx":          [0, "PowerPoint Open XML Slide Show"],
        "ppt":           [1, "PowerPoint Presentation"],
        "pptx":          [0, "Microsoft PowerPoint Open XML Document"],
        "psa":           [0, "Photoshop Album Catalog"],
        "psf":           [0, "SPI Proxy Output File"],
        "pst":           [0, "Personal Folder File"],
        "ptb":           [0, "Power Tab File"],
        "ptk":           [0, "Quicken Online Data File"],
        "pub":           [0, "Publisher Document"],
        "pvl":           [0, "Instalit Library"],
        "pwd":           [0, "Solid Edge Weldment Document"],
        "qbw":           [0, "QuickBooks Data File"],
        "qdf":           [0, "Snapform File"],
        "qdf":           [0, "Quicken Data File"],
        "qdfm":          [0, "Quicken Data File (Macintosh)"],
        "qfx":           [0, "Quicken Financial Exchange File"],
        "qif":           [0, "Quicken Interchange Format File"],
        "qpb":           [0, "Quicken Payroll File"],
        "qpm":           [0, "Quick Pallet Maker Input Data"],
        "qpw":           [0, "Quattro Pro Spreadsheet"],
        "rcd":           [0, "Arcade File"],
        "rdb":           [0, "N64 ROM Database"],
        "rdf":           [0, "Report Definition"],
        "rf1":           [0, "Retirement Forecast File"],
        "rge":           [0, "Entourage File Archive"],
        "rgo":           [0, "RepliGo File"],
        "rnq":           [0, "Renque Model File"],
        "rog":           [0, "Roger 2 Input Data File"],
        "roi":           [0, "Report Object Instance"],
        "rpt":           [0, "Crystal Reports File"],
        "rrr":           [0, "Rhapzodé Resource Repository"],
        "rsw":           [0, "R&R SQL Report Writer Report File"],
        "rte":           [0, "Navigation Route"],
        "s85":           [0, "Sabre Airline Solutions Chart"],
        "sar":           [0, "Sibelius Arrange Style"],
        "sav":           [0, "SPSS Data File"],
        "sbf":           [0, "SmartBroker Data"],
        "sca":           [0, "Norton AntiVirus Scan File"],
        "scf":           [0, "DNA Sequence Chromatogram File"],
        "sch":           [0, "EAGLE Schematics File"],
        "sdb":           [0, "OpenOffice.org Base Database File"],
        "sdb":           [0, "ServerBoss Database File"],
        "sdb":           [0, "MonKey Office SQLite Database File"],
        "sdc":           [0, "OpenOffice.org Calc Spreadsheet"],
        "sdf":           [0, "Standard Data File"],
        "sdq":           [0, "SAS Data File"],
        "sds":           [0, "OpenOffice.org Chart"],
        "seq":           [0, "DNA Sequence Text File"],
        "sgml":          [0, "Standard Generalized Markup Language File"],
        "shp":           [0, "ESRI Shapefile"],
        "shx":           [0, "Shapefile Index File"],
        "skv":           [0, "Semicolon Separated Values File"],
        "skv":           [0, "XLANG Schedule Drawing File"],
        "skx":           [0, "XLANG Schedule File"],
        "spo":           [0, "SPSS Statistical Data Output File"],
        "sps":           [0, "SPSS Program File"],
        "spub":          [0, "Disc Cover File"],
        "sq":            [0, "Sysquake Program"],
        "sqd":           [0, "SQ Data File"],
        "sql":           [1, "Structured Query Language Data"],
        "sqr":           [0, "SQL Program File"],
        "sta":           [0, "ABAQUS Status File"],
        "stc":           [0, "StarOffice Calc Spreadsheet Template"],
        "stk":           [0, "Stickfigure Animator File"],
        "stl":           [0, "Fireworks Style Library"],
        "stm":           [0, "Exchange Streaming Media File"],
        "str":           [0, "dBASE Structure List Object File"],
        "stw":           [0, "STATISTICA Workbook"],
        "swk":           [0, "StudyWorks Save File"],
        "sxc":           [0, "StarOffice Calc Spreadsheet"],
        "sxi":           [0, "StarOffice Impress Presentation"],
        "t01":           [0, "TaxCut 2001 File"],
        "t02":           [0, "TaxCut 2002 File"],
        "t03":           [0, "TaxCut 2003 File"],
        "t04":           [0, "TaxCut 2004 File"],
        "tab":           [0, "Tab Separated Data"],
        "tbk":           [0, "ToolBook File"],
        "tdl":           [0, "Tab Delineated Format File"],
        "tef":           [0, "TablEdit Tablature"],
        "tfa":           [0, "TreeSoft CashFlow Analysis Data File"],
        "tfd":           [0, "Tape Format Requirements Document"],
        "tfrd":          [0, "Tape Image Format Requirements Document"],
        "tjp":           [0, "TaskJuggler Project File"],
        "tkfl":          [0, "TKLinks Saver Favorite Links File"],
        "topc":          [0, "TopicCrunch Project File"],
        "tps":           [0, "Multi Channel Measurement File"],
        "trd":           [0, "TrID Definitions Package"],
        "trs":           [0, "Rosetta Stone Language Data"],
        "tst":           [0, "TestPoint Test File"],
        "tsv":           [0, "Tab Separated Values File"],
        "txf":           [0, "Tax Exchange Format"],
        "ulz":           [0, "USBlyzer Data Capture File"],
        "uvf":           [0, "Uncertain Value Format"],
        "val":           [0, "Values List"],
        "vcf":           [0, "vCard File"],
        "voi":           [0, "VOI Group File"],
        "vok":           [0, "PocketVok Vocabulary File"],
        "vscontent":     [0, "Visual Studio Content File"],
        "wab":           [0, "Windows Address Book"],
        "wdb":           [0, "Microsoft Works Database"],
        "wfm":           [0, "dBASE Form"],
        "wgt":           [0, "XNBC Synaptic Weights File"],
        "wgt":           [0, "IMPS Data File"],
        "wk1":           [0, "Lotus Worksheet"],
        "wk2":           [0, "Lotus 2 Worksheet"],
        "wk3":           [0, "Lotus 3 Worksheet"],
        "wk4":           [0, "Lotus 4 Worksheet"],
        "wk5":           [0, "Lotus 5 Worksheet"],
        "wki":           [0, "Lotus 2 Worksheet"],
        "wks":           [1, "Microsoft Works Spreadsheet"],
        "wks":           [0, "Lotus 1-2-3 Spreadsheet"],
        "wku":           [0, "Lotus 1-2-3 Spreadsheet"],
        "wmdb":          [0, "Windows Media Database File"],
        "wor":           [0, "MapInfo Workspace File"],
        "wpf":           [0, "WordPerfect Form"],
        "wtr":           [0, "Encarta File"],
        "xdp":           [0, "XML Data Package"],
        "xef":           [0, "eManager Form Data"],
        "xfo":           [0, "XSL-FO Formatted Form"],
        "xft":           [0, "Adobe Form Designer 5.0 File"],
        "xl":            [0, "Excel Spreadsheet"],
        "xlc":           [0, "Excel Chart"],
        "xlr":           [0, "Microsoft Works Spreadsheet"],
        "xls":           [1, "Microsoft Excel Spreadsheet"],
        "xlsb":          [0, "Excel Binary Workbook"],
        "xlsm":          [0, "Excel 2007 Macro-Enabled Spreadsheet"],
        "xlsx":          [0, "Microsoft Excel Open XML Document"],
        "xlt":           [0, "Microsoft Excel Template"],
        "xltm":          [0, "Excel 2007 Macro-Enabled Spreadsheet Template"],
        "xltx":          [0, "Excel 2007 Spreadsheet Template"],
        "xlw":           [0, "Microsoft Excel Workbook"],
        "xml":           [1, "XML File"],
        "xmlper":        [0, "LeCroy Binary Waveform File"],
        "xpj":           [0, "Micro Planner X-Pert Project File"],
        "xpm":           [0, "Micro Planner Manager File"],
        "xpt":           [0, "SAS Transport File"],
        "xsl":           [0, "XML Stylesheet"],
        "xslt":          [0, "XSL Transformation"],
        "xsn":           [0, "InfoPath Form Template File"],
        "xtp":           [0, "XTree Data File"],
        "yam":           [0, "Yahoo! Auctions Data"],
        "zap":           [0, "Zone Alarm Pro Data File"],
        "zdb":           [0, "Quicken Online File"],
        "zdb":           [0, "EPSQ Database"],
        "zix":           [0, "Quicken Online File"],
        "^^^":           [0, "Pervasive SQL Database File"],
    },
    'development': {
        "$01":           [0, "DOS Pipe File"],
        "a":             [0, "Static Library"],
        "ab":            [0, "Applix Builder File"],
        "abc":           [0, "ABC Source File"],
        "acd":           [0, "RSLogix 5000 Program"],
        "ada":           [0, "Ada Source Code"],
        "adb":           [0, "Ada Body File"],
        "ads":           [0, "Ada Specification File"],
        "aep":           [0, "Activ E-Book Project"],
        "agi":           [0, "Asterisk Gateway Interface File"],
        "as":            [0, "ActionScript File"],
        "asm":           [0, "Assembly Language Source Code"],
        "au3":           [0, "AutoIt v3 Script"],
        "bas":           [0, "BASIC Source Code File"],
        "bb":            [0, "Blitz Source Code File"],
        "bbc":           [0, "BBC BASIC Data File"],
        "bcp":           [0, "Borland C++ Makefile"],
        "bpg":           [0, "Borland Project Group"],
        "bpl":           [0, "Borland Package Library"],
        "bs2":           [0, "BASIC Stamp 2 Code File"],
        "c":             [1, "C/C++ Source Code File"],
        "cbl":           [0, "COBOL Program"],
        "cc":            [0, "C++ Source Code File"],
        "class":         [0, "Java Class File"],
        "cls":           [0, "Program Class File"],
        "cob":           [0, "COBOL Source Code File"],
        "cod":           [0, "Compiled Source Code"],
        "config":        [0, "Configuration File"],
        "cp":            [0, "Captivate Source File"],
        "cpp":           [1, "C++ Source Code File"],
        "cs":            [0, "C Sharp Source Code File"],
        "csi":           [0, "ContentServ Include File"],
        "cst":           [0, "ContentServ Template"],
        "ctl":           [0, "Visual Basic UserControl Object File"],
        "ctx":           [0, "Visual Basic Control Binary File"],
        "d":             [0, "D Source Code File"],
        "dcp":           [0, "Delphi Compiled Package"],
        "dcu":           [0, "Delphi Compiled Unit"],
        "dec":           [0, "Declaration File"],
        "def":           [0, "Module-Definition File"],
        "def":           [0, "SmartWare II Data File"],
        "dev":           [0, "Dev-C++ Project File"],
        "df1":           [0, "Omnis Native Datafile"],
        "dfm":           [0, "Delphi Form"],
        "dob":           [0, "Visual Basic UserDocument"],
        "dox":           [0, "Visual Basic Binary UserDocument"],
        "dpk":           [0, "Delphi Package"],
        "dpl":           [0, "Delphi Package Library"],
        "dpr":           [0, "Delphi Project"],
        "dsk":           [0, "Borland Project Desktop File"],
        "dsp":           [0, "Developer Studio Project"],
        "dsw":           [0, "Visual C++ Workspace"],
        "dtd":           [0, "Document Type Definition"],
        "dylib":         [0, "Dynamic Library"],
        "ent":           [0, "External Entity"],
        "eql":           [0, "Embedded SQL File"],
        "ex":            [0, "Euphoria Source Code"],
        "f":             [0, "Fortran Source Code"],
        "f90":           [0, "Fortran 90 Source File"],
        "fgl":           [0, "Fifth Generation Language Source File"],
        "fic":           [0, "WINDEV Hyper File Database"],
        "fla":           [0, "Adobe Flash Animation"],
        "for":           [0, "Fortran 77 Source File"],
        "fpa":           [0, "Front Panel Encrypted Order File"],
        "fpd":           [0, "Front Panel Order File"],
        "fpm":           [0, "FPS Creator Map File"],
        "fpp":           [0, "Fortran Source Code"],
        "fpp":           [0, "Front Panel Project"],
        "framework":     [0, "Mac OS X Application Framework"],
        "frm":           [0, "Visual Basic Text Form"],
        "frx":           [0, "Visual Basic Binary Form"],
        "fsproj":        [0, "FireStarter Project File"],
        "ged":           [0, "Game Editor Project File"],
        "global":        [0, "Global Makefile"],
        "gm6":           [0, "Game Maker 6 Project File"],
        "gmd":           [0, "Game Maker Program Code"],
        "gmk":           [0, "Game Maker 7 File"],
        "gorm":          [0, "Gorm Interface Resource File"],
        "h":             [0, "C++ or Java Header File"],
        "has":           [0, "Haskell Script"],
        "hh":            [0, "C++ Header File"],
        "hhh":           [0, "Power C Precompiled Header File"],
        "hpp":           [0, "C++Builder Header File"],
        "hs":            [0, "Haskell Script"],
        "i":             [0, "INTERCAL Source File"],
        "inc":           [0, "Include File"],
        "isc":           [0, "Xilinx Device Configuration File"],
        "iss":           [0, "InstallShield Silent Response"],
        "j":             [0, "Java Source File"],
        "jav":           [0, "Java Source File"],
        "java":          [1, "Java Source Code File"],
        "jed":           [0, "Xilinx JEDEC Programming File"],
        "jic":           [0, "JTAG Indirect Configuration File"],
        "jpd":           [0, "Java Process Definition"],
        "jpr":           [0, "JBuilder Project"],
        "jpx":           [0, "JBuilder Project"],
        "kb":            [0, "C++ Keyboard Script"],
        "kdevdlg":       [0, "KDevelop Dialog Box File"],
        "kdevelop":      [0, "KDevelop Project Data File"],
        "kdevprj":       [0, "KDevelop Project File"],
        "lbi":           [0, "Dreamweaver Library Item"],
        "lbs":           [0, "Omnis Library"],
        "lds":           [0, "Linux Compile Time Header File"],
        "lgo":           [0, "Logo Instructions File"],
        "lhs":           [0, "Literate Haskell Script"],
        "lis":           [0, "VAX Program Listing"],
        "lit":           [0, "Literate Haskell Script"],
        "lnt":           [0, "PC-lint/FlexeLint Configuration File"],
        "lproj":         [0, "Localized Project Folder"],
        "lsp":           [0, "Lisp Program Source Code"],
        "lua":           [0, "Lua Source File"],
        "m":             [0, "Objective-C Implementation File"],
        "m4":            [0, "Macro Processor Library"],
        "mak":           [0, "Makefile"],
        "md":            [0, "Machine Description"],
        "mk":            [0, "Makefile"],
        "mod":           [0, "Fortran Module File"],
        "mpr":           [0, "FoxPro Generated Menu Program"],
        "nib":           [0, "Interface Resources"],
        "o":             [0, "Compiled Object File"],
        "oca":           [0, "Custom Control Library Type File"],
        "ocx":           [0, "ActiveX Control"],
        "omo":           [0, "OMake Object File"],
        "p":             [0, "Pascal Source Code"],
        "p":             [0, "Python Pickle File"],
        "pas":           [0, "Pascal Source File"],
        "pbproj":        [0, "Project Builder Project"],
        "pch":           [0, "Precompiled Header"],
        "pdm":           [0, "VB Project Information File"],
        "pl":            [1, "Perl Script"],
        "pl":            [0, "Prolog Source Code File"],
        "plc":           [0, "PL/B Source File"],
        "pm":            [0, "Perl Module"],
        "pod":           [0, "Perl POD File"],
        "ptl":           [0, "Rational Rose Petal File"],
        "pyd":           [0, "Python Dynamic Module"],
        "qpr":           [0, "FoxPro Generated Query Program"],
        "qx":            [0, "Quexal Source Code"],
        "rb":            [0, "REALbasic Project"],
        "rb":            [0, "Ruby Source Code"],
        "rbc":           [0, "Rembo-C Script"],
        "rbp":           [0, "REALbasic Project"],
        "rc":            [0, "Resource Script"],
        "res":           [0, "Windows Resource File"],
        "res":           [0, "C++ Complied Resource File"],
        "rnc":           [0, "RELAX NG Compact Syntax File"],
        "rsrc":          [0, "Macintosh Resource File"],
        "ru":            [0, "JavaSoft JRE 1.3 Library"],
        "rul":           [0, "InstallShield Rules"],
        "s":             [0, "Source Code File"],
        "s19":           [0, "Motorola S19 File Record"],
        "sas":           [0, "SAS Program File"],
        "sc":            [0, "SuperCollider Source Code File"],
        "sh":            [0, "Bash Shell Script"],
        "sln":           [0, "Visual Studio Solution File"],
        "snippet":       [0, "Visual Studio IntelliSense Code Snippet"],
        "so":            [0, "Shared Library"],
        "spt":           [0, "ESPL Programming File"],
        "src":           [0, "Source Code"],
        "ssc":           [0, "SourceSafe Status File"],
        "sud":           [0, "Super Project Analyzer File"],
        "sup":           [0, "Super Project Definition File"],
        "targets":       [0, "MSBuild Targets File"],
        "tcl":           [0, "Tcl Script"],
        "tk":            [0, "Tk Script"],
        "tpu":           [0, "Turbo Pascal Unit"],
        "tpx":           [0, "Turbo Pascal 7 Unit"],
        "ui":            [0, "User Interface File"],
        "vac":           [0, "Oc2.316s Cakit File"],
        "var":           [0, "Variable Data"],
        "vbg":           [0, "Visual Basic Project Group File"],
        "vbp":           [0, "Visual Basic Project File"],
        "vbx":           [0, "Visual Basic Custom Control"],
        "vbz":           [0, "Visual Basic Project Template"],
        "vc4":           [0, "Visual C++ 4 File"],
        "vcproj":        [0, "Visual C++ Project File"],
        "vcx":           [0, "Visual Fox Pro Class Library"],
        "vdm":           [0, "VDM Specification"],
        "vdproj":        [0, "Visual Studio Deployment Project File"],
        "vgc":           [0, "ViziGen Code Generation Template"],
        "vic":           [0, "ViziGen Code Import Mappings File"],
        "vpc":           [0, "ViziGen Configuration File"],
        "x":             [0, "Lex Source Code File"],
        "xaml":          [0, "XAML File"],
        "xcode":         [0, "Xcode Project"],
        "xcodeproj":     [0, "Xcode Project"],
        "xsd":           [0, "XML Schema Definition"],
        "yab":           [0, "Yabasic Source Code"],
        "ymp":           [0, "YaST Metapackage File"],
    },
    'disk image': {
        "000":           [0, "Virtual CD ISO File"],
        "aa":            [0, "Generic CD Image"],
        "adf":           [0, "Amiga Disk File"],
        "adz":           [0, "Compressed Amiga Disk File"],
        "b5i":           [0, "BlindWrite 5 Disk Image"],
        "b5t":           [0, "BlindWrite 5 Disk Track Information"],
        "bdf":           [0, "MIDAS BDF Disk Image File"],
        "bin":           [0, "CDRWin CD Image"],
        "bwa":           [0, "BlindWrite Disk Information File"],
        "bwi":           [0, "BlindWrite CD/DVD Disc Image"],
        "bws":           [0, "BlindWrite Sub Code File"],
        "bwt":           [0, "BlindWrite 4 Disk Image"],
        "c2d":           [0, "WinOnCD Disc Image"],
        "ccd":           [0, "CloneCD Disk Image"],
        "cd":            [0, "CD-i OptImage"],
        "cdi":           [0, "DiscJuggler Disc Image"],
        "cif":           [0, "Easy CD Creator Disk Image"],
        "cso":           [0, "Compressed ISO Disk Image"],
        "cue":           [0, "Cue Sheet File"],
        "cue":           [0, "CDRWin Cue Sheet"],
        "d64":           [0, "Commodore 64 Disk Image"],
        "daa":           [0, "Direct-Access-Archive"],
        "dao":           [0, "Disk at Once CD/DVD Image"],
        "dmg":           [1, "Mac OS X Disk Image"],
        "dms":           [0, "Disk Masher Image"],
        "dsk":           [0, "Disk Image"],
        "dvd":           [0, "CloneCD DVD Information File"],
        "eda":           [0, "Ensoniq ASR Disk Image"],
        "ede":           [0, "Ensoniq EPS Disk Image"],
        "edk":           [0, "Ensoniq KT Disk Image"],
        "edq":           [0, "Ensoniq SQ1/SQ2/KS32 Disk Image"],
        "eds":           [0, "Ensoniq SQ-80 Disk Image"],
        "edv":           [0, "Ensoniq VFX-SD Disk Image"],
        "eui":           [0, "Ensoniq EPS Compacted Disk Image"],
        "fcd":           [0, "Virtual CD Format"],
        "fdi":           [0, "Amiga Disk Image"],
        "flp":           [0, "Floppy Disk Image"],
        "gcd":           [0, "Prassi CD Image"],
        "gi":            [0, "Global Image"],
        "gi":            [0, "RecordNow! CD Image"],
        "gkh":           [0, "Ensoniq EPS Family Disk Image"],
        "i00":           [0, "DVD Shrink File Part 1"],
        "i01":           [0, "DVD Shrink File Part 2"],
        "i02":           [0, "DVD Shrink File Part 3"],
        "ibp":           [0, "IsoBuster Managed Image Information File"],
        "ibq":           [0, "IsoBuster Managed Image File"],
        "ima":           [0, "Disk Image"],
        "image":         [0, "Apple Disk Image"],
        "img":           [0, "Macintosh Disk Image"],
        "img":           [0, "CloneCD Disk Image Data File"],
        "ipf":           [0, "Interchangeable Preservation File"],
        "iso":           [1, "Disc Image File"],
        "isz":           [0, "Zipped ISO Disk Image"],
        "ixa":           [0, "Ulead Disc Image format"],
        "lcd":           [0, "CDSpace Emulated Disk Image"],
        "lnx":           [0, "Atari Lynx ROM"],
        "md0":           [0, "Alcohol Disk Image Segment 1"],
        "md1":           [0, "GEAR CD/DVD Disc Image"],
        "md1":           [0, "Alcohol Disk Image Segment 2"],
        "md2":           [0, "Alcohol Disk Image Segment 2"],
        "mdf":           [0, "Alcohol 120% Disc Image"],
        "mds":           [0, "Media Descriptor File"],
        "mds":           [0, "Alcohol Disc Image Track Data"],
        "ncd":           [0, "NTI CD-Maker Disc Image"],
        "nrg":           [0, "Nero CD/DVD Image File"],
        "p01":           [0, "Toast CD Image"],
        "p01":           [0, "GEAR CD/DVD Disc Image"],
        "partimg":       [0, "Partimage File"],
        "pdi":           [0, "InstantCopy Disc Image"],
        "pqi":           [0, "PowerQuest Drive Image"],
        "pxi":           [0, "PlexTools Disc Image"],
        "ratdvd":        [0, "RatDVD Disk Image"],
        "simg":          [0, "Synclavier Disk Image File"],
        "smi":           [0, "Self-Mounting Disk Image"],
        "sopt":          [0, "Synclavier Optical Disk Image File"],
        "sqfs":          [0, "Squash FS Bootable File"],
        "st":            [0, "Atari ST Disk Image"],
        "t64":           [0, "Commodore 64 Tape Image File"],
        "tao":           [0, "Track at Once CD/DVD Image"],
        "tc":            [0, "TrueCrypt Volume"],
        "td0":           [0, "Teledisk Archive"],
        "tib":           [0, "Acronis True Image File"],
        "tzx":           [0, "ZX Spectrum Tape Image File"],
        "uif":           [0, "Universal Image Format"],
        "vaporcd":       [0, "Norum Vapor CD"],
        "vc4":           [0, "Virtual CD Disk Image"],
        "vcd":           [1, "Virtual CD"],
        "vcd":           [0, "FarStone Virtual Drive"],
        "vdi":           [0, "Virtuo CD Manager Disk Image"],
        "vhd":           [0, "Virtual PC Virtual Hard Disk"],
        "x64":           [0, "Commodore 64 Disk Image"],
        "xa":            [0, "GEAR CD/DVD Disc Image"],
        "xmd":           [0, "GameJack Disc Image"],
        "xmf":           [0, "GameJack Disc Image File"],
    },
    'encoded': {
        "afp":           [0, "FileProtector Encrypted File"],
        "bfa":           [0, "Blowfish Encrypted File"],
        "bin":           [1, "Macbinary II Encoded File"],
        "cpio":          [0, "Unix CIPO Archive"],
        "dc4":           [0, "ViaThinkSoft (De)Coder 4 File"],
        "dim":           [0, "Direct Internet Message Encapsulation (DIME)"],
        "dime":          [0, "Direct Internet Message Encapsulation (DIME)"],
        "efl":           [0, "Encryptafile Encrypted File"],
        "efr":           [0, "Encryptafile Private Key File"],
        "efu":           [0, "Encryptafile Public Key File"],
        "hqx":           [1, "BinHex 4.0 Encoded File"],
        "mim":           [1, "Multi-Purpose Internet Mail Message"],
        "mime":          [0, "Multi-Purpose Internet Mail Extension"],
        "mme":           [0, "Multi-Purpose Internet Mail"],
        "rzx":           [0, "File Crypt Encrypted File"],
        "sef":           [0, "Encryptafile Signature File"],
        "shy":           [0, "ShyFile Encrypted File"],
        "uu":            [0, "Uuencoded File"],
        "uud":           [0, "UUDecoded File"],
        "uue":           [1, "Uuencoded File"],
        "vlt":           [0, "WinVault File Archive"],
        "xxe":           [0, "XXEncoded File"],
    },
    'font': {
        "abf":           [0, "Adobe Binary Screen Font File"],
        "acfm":          [0, "Adobe Composite Font Metrics File"],
        "afm":           [0, "Adobe Font Metrics File"],
        "amfm":          [0, "Adobe Multiple Font Metrics File"],
        "bdf":           [0, "Glyph Bitmap Distribution Format"],
        "chr":           [0, "Borland Character Set"],
        "dfont":         [0, "Mac OS X Data Fork Font"],
        "eot":           [0, "Embedded OpenType Font"],
        "fnt":           [1, "Font File"],
        "fon":           [1, "Generic Font File"],
        "gdr":           [0, "Symbian OS Font File"],
        "lwfn":          [0, "Adobe Type 1 Mac Font File"],
        "otf":           [1, "OpenType Font"],
        "pfa":           [0, "Printer Font ASCII File"],
        "pfb":           [0, "Printer Font Binary File"],
        "pfm":           [0, "Printer Font Metrics File"],
        "suit":          [0, "Macintosh Font Suitcase"],
        "ttc":           [0, "TrueType Font Collection"],
        "ttf":           [1, "TrueType Font"],
        "xfn":           [0, "Ventura Printer Font"],
        "xft":           [0, "ChiWriter Printer Font"],
    },
    'text': {
        "1st":           [0, "Readme File"],
        "abw":           [0, "AbiWord Document"],
        "act":           [0, "FoxPro Documenting Wizard Action Diagram"],
        "ans":           [0, "ANSI Text File"],
        "applescript":   [0, "AppleScript File"],
        "asc":           [0, "ASCII Text File"],
        "asc":           [0, "Autodesk ASCII Export File"],
        "ascii":         [0, "ASCII Text File"],
        "ase":           [0, "Autodesk ASCII Scene Export File"],
        "aty":           [0, "Association Type Placeholder"],
        "bbs":           [0, "Bulletin Board System Text"],
        "bean":          [0, "Bean Rich Text Document"],
        "bib":           [0, "BibTeX Bibliography Database"],
        "bib":           [0, "Bibliography Document"],
        "boc":           [0, "EasyWord Big Document"],
        "charset":       [0, "Character Set"],
        "chord":         [0, "Song Chords File"],
        "crd":           [0, "Guitar Tabs"],
        "cyi":           [0, "Clustify Input File"],
        "dbt":           [0, "Database Text File"],
        "dct":           [0, "FoxPro Database Memo"],
        "dgs":           [0, "Dagesh Pro Document"],
        "diz":           [0, "Description in Zip File"],
        "dne":           [0, "Netica Text File"],
        "doc":           [1, "Microsoft Word Document"],
        "doc":           [0, "WordPad Document"],
        "docm":          [0, "Word 2007 Macro-Enabled Document"],
        "docx":          [0, "Microsoft Word Open XML Document"],
        "dot":           [0, "Microsoft Word Template"],
        "dotm":          [0, "Word 2007 Macro-Enabled Document Template"],
        "dotx":          [0, "Word 2007 Document Template"],
        "dvi":           [0, "Device Independent Format File"],
        "dx":            [0, "DEC WPS Plus File"],
        "email":         [0, "Outlook Express Email Message"],
        "emlx":          [0, "Mail Message"],
        "epp":           [0, "EditPad Pro Project"],
        "err":           [0, "Error Log File"],
        "err":           [0, "FoxPro Compilation Error"],
        "etf":           [0, "ENIGMA Transportable File"],
        "etx":           [0, "Structure Enhanced Text (Setext) File"],
        "euc":           [0, "Extended Unix Code"],
        "faq":           [0, "Frequently Asked Questions Document"],
        "fb2":           [0, "FictionBook 2.0 File"],
        "fbl":           [0, "CADfix Command Level Log File"],
        "fdf":           [0, "Acrobat Forms Data Format"],
        "fdr":           [0, "Final Draft Document"],
        "fds":           [0, "Final Draft Secure Copy"],
        "fes":           [0, "Fileless Occurrence Placeholder"],
        "fpt":           [0, "FileMaker Pro Database Memo File"],
        "fpt":           [0, "FoxPro Table Memo"],
        "frt":           [0, "FoxPro Report Memo"],
        "fxc":           [0, "FilePackager Configuration"],
        "gio":           [0, "Adagio Score"],
        "gio":           [0, "Nyquist MIDI File"],
        "gpn":           [0, "GlidePlan Map Document"],
        "hwp":           [0, "Hangul (Korean) Text Document"],
        "hz":            [0, "Chinese (Hanzi) Text"],
        "idx":           [0, "Outlook Express Mailbox Index File"],
        "iil":           [0, "CleanSweep Installation Log"],
        "imapmbox":      [0, "IMAP Mailbox"],
        "indt":          [0, "InDesign Template"],
        "ipf":           [0, "OS/2 Help File"],
        "jis":           [0, "Japanese Industry Standard Text"],
        "jp1":           [0, "Japanese (Romaji) Text File"],
        "klg":           [0, "Log File"],
        "klg":           [0, "KOFIA Log"],
        "kml":           [0, "Keyhole Markup Language"],
        "knt":           [0, "KeyNote Note File"],
        "kon":           [0, "Yahoo! Widget XML File"],
        "kwd":           [0, "KWord Document"],
        "latex":         [0, "LaTeX Document"],
        "lbt":           [0, "FoxPro Label Memo"],
        "lis":           [0, "SQR Output File"],
        "lit":           [0, "eBook File"],
        "log":           [1, "Log File"],
        "lp2":           [0, "iLEAP Word Processing Document"],
        "lst":           [0, "Data List"],
        "lst":           [0, "FoxPro Documenting Wizard List"],
        "ltr":           [0, "Letter File"],
        "luf":           [0, "Lipikar Uniform Format File"],
        "lwp":           [0, "Lotus Word Pro Document"],
        "lyt":           [0, "TurboTax Install Log File"],
        "lyx":           [0, "LyX Document"],
        "man":           [0, "Unix Manual"],
        "map":           [0, "Image Map"],
        "mbox":          [0, "E-mail Mailbox File"],
        "mell":          [0, "Mellel Word Processing File"],
        "mellel":        [0, "Mellel Word Processing Document"],
        "mnt":           [0, "FoxPro Menu Memo"],
        "msg":           [1, "Mail Message"],
        "mw":            [0, "MacWrite Text Document"],
        "nfo":           [0, "Warez Information File"],
        "now":           [0, "Readme File"],
        "nzb":           [0, "NewzBin File"],
        "ocr":           [0, "FAXGrapper Fax Text File"],
        "odm":           [0, "OpenDocument Master Document"],
        "odt":           [0, "OpenDocument Text Document"],
        "oft":           [0, "Outlook File Template"],
        "opml":          [0, "OPML File"],
        "ott":           [0, "OpenDocument Text Document Template"],
        "p7s":           [0, "Digitally Signed Message"],
        "pages":         [0, "Pages Document"],
        "pfx":           [0, "First Choice Word Processing Document"],
        "pjt":           [0, "FoxPro Project Memo"],
        "prt":           [0, "Printer Output File"],
        "psw":           [0, "Pocket Word Document"],
        "pwi":           [0, "Pocket Word Document"],
        "rad":           [0, "Radar ViewPoint Radar Data"],
        "readme":        [0, "Readme File"],
        "rng":           [0, "RELAX NG File"],
        "rpt":           [0, "Generic Report"],
        "rt":            [0, "RealText Streaming Text File"],
        "rtd":           [0, "RagTime Document"],
        "rtf":           [1, "Rich Text Format"],
        "rtfd":          [0, "Rich Text Format Directory File"],
        "rtx":           [0, "Rich Text Document"],
        "rzk":           [0, "File Crypt Password File"],
        "saf":           [0, "SafeText File"],
        "safetext":      [0, "SafeText File"],
        "sam":           [0, "Ami Pro Document"],
        "scc":           [0, "Scenarist Closed Caption File"],
        "scm":           [0, "Schema File"],
        "scpt":          [0, "AppleScript Script File"],
        "sct":           [0, "FoxPro Form Memo"],
        "scw":           [0, "Movie Magic Screenwriter Document"],
        "sdm":           [0, "StarOffice Mail Message"],
        "sdw":           [0, "StarOffice Writer Text Document"],
        "sgm":           [0, "SGML File"],
        "sig":           [0, "Signature File"],
        "sls":           [0, "Image Playlist"],
        "sms":           [0, "Exported SMS Text Message"],
        "ssa":           [0, "Sub Station Alpha Subtitle File"],
        "strings":       [0, "Text Strings File"],
        "stw":           [0, "StarOffice Text Document Template"],
        "sub":           [0, "Subtitle File"],
        "sxw":           [0, "StarOffice Text Document"],
        "tab":           [0, "Guitar Tablature File"],
        "tex":           [0, "LaTeX Source Document"],
        "text":          [0, "Plain Text File"],
        "thp":           [0, "TurboTax Text String"],
        "tlb":           [0, "VAX Text Library"],
        "tmx":           [0, "Translation Memory eXchange File"],
        "tpc":           [0, "Topic Connection Placeholder"],
        "txt":           [1, "Text File"],
        "unauth":        [0, "SiteMinder Unauthorized Message File"],
        "unx":           [0, "Unix Text File"],
        "upd":           [0, "Program Update Information"],
        "utf8":          [0, "Unicode UTF8-Encoded Text"],
        "utxt":          [0, "Unicode Text File"],
        "vct":           [0, "Visual Class Library Memo"],
        "vnt":           [0, "Mobile Phone vNote File"],
        "wbk":           [0, "Word Document Backup"],
        "wbk":           [0, "WordPerfect Workbook"],
        "wcf":           [0, "WebEx Saved Chat Session"],
        "wn":            [0, "WriteNow Text Document"],
        "wp":            [0, "WordPerfect Document"],
        "wp4":           [0, "WordPerfect 4 Document"],
        "wp5":           [0, "WordPerfect 5 Document"],
        "wp6":           [0, "WordPerfect 6 Document"],
        "wp7":           [0, "WordPerfect 7 Document"],
        "wpa":           [0, "ACT! Word Processing Document"],
        "wpd":           [1, "WordPerfect Document"],
        "wpd":           [0, "ACT! 2 Word Processing Document"],
        "wpl":           [0, "DEC WPS Plus Text Document"],
        "wps":           [1, "Microsoft Works Word Processor Document"],
        "wpt":           [0, "WordPerfect Template"],
        "wri":           [0, "Windows Write Document"],
        "wsc":           [0, "Windows Script Component"],
        "wsh":           [0, "Windows Script Host Settings"],
        "xdl":           [0, "XML Schema File"],
        "xdl":           [0, "Oracle Expert Definition Language File"],
        "xlf":           [0, "XLIFF Document"],
        "xps":           [0, "XML Paper Specification"],
        "xwp":           [0, "XMLwriter Project"],
        "xwp":           [0, "Xerox Writer Text Document"],
        "xwp":           [0, "Crosstalk Session File"],
        "xy":            [0, "XYWrite Document"],
        "xy3":           [0, "XYWrite III Document"],
        "xyp":           [0, "XYWrite Plus Document"],
        "xyw":           [0, "XYWrite for Windows Document"],
        "ybk":           [0, "YanCEyWare Reader eBook"],
        "yml":           [0, "YAML Document"],
    },
    'settings': {
        "ahl":           [0, "eMule Metadata File"],
        "ahs":           [0, "Adobe Halftone Screen File"],
        "ams":           [0, "Adobe Monitor Setup file"],
        "asl":           [0, "Photoshop Style"],
        "atf":           [0, "Photoshop Transfer Function File"],
        "atn":           [0, "Photoshop Actions"],
        "bcmx":          [0, "Business Contact Manager Customization"],
        "cfg":           [1, "Configuration File"],
        "cfg":           [0, "Citrix Server Connection File"],
        "cm":            [0, "Cable Modem Configuration File"],
        "cnf":           [0, "Telnet Configuration File"],
        "conf":          [0, "Unix Configuration File"],
        "csf":           [0, "Photoshop Color Settings"],
        "cwf":           [0, "CorelDraw Workspace File"],
        "dbg":           [0, "FoxPro Debugger Configuration"],
        "downloadhost":  [0, "MSN Download Settings File"],
        "drm":           [0, "Cubase Drum Map File"],
        "ds_store":      [0, "Mac OS X Folder Settings File"],
        "env":           [0, "WordPerfect Environment"],
        "eql":           [0, "MathType Settings"],
        "eqp":           [0, "MathType Preferences"],
        "exp":           [0, "SonicWALL Preference File"],
        "fcc":           [0, "Forms Credential Collector File"],
        "fmt":           [0, "FoxPro Format File"],
        "gid":           [0, "Windows Help Index File"],
        "hid":           [0, "Sony Ericsson Remote Settings File"],
        "ica":           [0, "Citrix ICA File"],
        "icc":           [0, "ICC Profile"],
        "icm":           [0, "Image Color Matching Profile"],
        "idf":           [0, "MIDI Instrument Definition File"],
        "inf":           [0, "Setup File or Installer Script"],
        "ini":           [0, "Gravis UltraSound Bank Setup File"],
        "ini":           [0, "Symbian OS Configuration File"],
        "isp":           [0, "IIS Internet Service Provider Settings"],
        "jws":           [0, "Java Workspace Settings File"],
        "key":           [0, "Keyboard Definition File"],
        "kyb":           [0, "Keyboard Layout"],
        "kys":           [0, "Adobe Photoshop CS Keyboard Shortcut File"],
        "lic":           [0, "Software License"],
        "lop":           [0, "Mastercook Layout File"],
        "m2s":           [0, "Maxthon 2 Browser Skin File"],
        "mailhost":      [0, "MSN Mailhost Settings File"],
        "mgm":           [0, "MGCSoft Equation Illustrator Macro"],
        "mlk":           [0, "Mastercook Look File"],
        "msf":           [0, "Miranda IM Skin File"],
        "msi":           [1, "Windows Installer File"],
        "mskn":          [0, "MediaMonkey Skin File"],
        "msm":           [0, "Windows Installer Merge Module"],
        "mtf":           [0, "Motorola Theme File"],
        "nvc":           [0, "Nikon Vignette Correction File"],
        "ops":           [0, "Office Profile Settings File"],
        "pen":           [0, "Paint Shop Pro Pen Preset File"],
        "ph":            [0, "AOL Phone Home Settings"],
        "plist":         [0, "Mac OS X Property List"],
        "pmc":           [0, "Performance Monitor Counter File"],
        "pref":          [0, "Macintosh Preferences File"],
        "prf":           [0, "Outlook Profile File"],
        "prf":           [0, "Director Preferences File"],
        "prf":           [0, "ClarisWorks Preference File"],
        "profimail":     [0, "ProfiMail Settings File"],
        "properties":    [0, "Java Properties File"],
        "psf":           [0, "Photoshop Proof Setup"],
        "ptf":           [0, "PSP Theme File"],
        "pvs":           [0, "Parallels Desktop Configuration File"],
        "rb":            [0, "Rosebud Profile"],
        "rdf":           [0, "Resource Description Framework File"],
        "rdo":           [0, "Xerox Rawster Document Object File"],
        "rdp":           [0, "Remote Desktop Connection"],
        "reg":           [1, "Registration Information"],
        "set":           [0, "Settings File"],
        "set":           [0, "Document Library Property Set File"],
        "sfo":           [0, "CuteFTP Search File"],
        "ski":           [0, "Motorola Phone Skin File"],
        "sl":            [0, "Software License File"],
        "sol":           [0, "Flash Local Shared Object File"],
        "srs":           [0, "Outlook Send/Receive Settings File"],
        "tsk":           [0, "Pocket PC Skin"],
        "vmtm":          [0, "VMware Team Data File"],
        "vmx":           [0, "Cubase Mixer Settings"],
        "vmx":           [0, "VMWare Configuration File"],
        "vph":           [0, "VirtualPhotographer Custom Settings"],
        "vsw":           [0, "Visio Workspace File"],
        "vue":           [0, "FoxPro 2.x View Settings"],
        "wms":           [0, "Windows Media Skin"],
        "wmz":           [0, "Compressed Windows Media Player Skin"],
        "wpp":           [0, "WordPerfect Color Palette"],
        "xem":           [0, "eManager Metered Units"],
        "xep":           [0, "eManager File Packaging Information"],
        "xes":           [0, "eManager Skins Definition"],
        "xet":           [0, "eManager Process Definition"],
        "xev":           [0, "eManager Auto-Update File"],
        "xlb":           [0, "Excel Toolbars File"],
        "xwk":           [0, "Crosstalk Keyboard Mapping File"],
        "zap":           [0, "Software Installation Settings"],
        "zon":           [0, "Collection Building Custom Zone File"],
    },
    'video': {
        "3g2":           [0, "3GPP2 Multimedia File"],
        "3gp":           [1, "3GPP Multimedia File"],
        "3gp2":          [0, "3GPP Multimedia File"],
        "3gpp":          [0, "3GPP Multimedia File"],
        "3mm":           [0, "3D Movie Maker Movie"],
        "60d":           [0, "CCTV Video Clip"],
        "aep":           [0, "After Effects Project"],
        "ajp":           [0, "CCTV Video File"],
        "amv":           [0, "Anime Music Video File"],
        "asf":           [1, "Advanced Systems Format File"],
        "asx":           [1, "Microsoft ASF Redirector File"],
        "avb":           [0, "Avid Bin File"],
        "avi":           [1, "Audio Video Interleave File"],
        "avs":           [0, "Application Visualization System Format"],
        "bik":           [0, "BINK Video File"],
        "bix":           [0, "Kodicom Video File"],
        "box":           [0, "Kodicom Video"],
        "byu":           [0, "Brigham Young University Movie"],
        "camrec":        [0, "Camtasia Studio Screen Recording"],
        "cvc":           [0, "cVideo"],
        "d2v":           [0, "DVD2AVI File"],
        "dat":           [0, "VCD Video File"],
        "dce":           [0, "DriveCam Video"],
        "dif":           [0, "Digital Interface Format"],
        "dir":           [0, "Adobe Director Movie"],
        "divx":          [0, "DivX-Encoded Movie"],
        "dmb":           [0, "Digital Multimedia Broadcasting File"],
        "dpg":           [0, "Nintendo DS Movie File"],
        "dv":            [0, "Digital Video File"],
        "dvr-ms":        [0, "Microsoft Digital Video Recording"],
        "dxr":           [0, "Protected Macromedia Director Movie"],
        "eye":           [0, "Eyemail Video Recording"],
        "fcp":           [0, "Final Cut Project"],
        "flc":           [0, "FLIC Animation"],
        "fli":           [0, "FLIC Animation"],
        "flv":           [0, "Flash Video File"],
        "flx":           [0, "FLIC Animation"],
        "gl":            [0, "GRASP Animation"],
        "grasp":         [0, "GRASP Animation"],
        "gvi":           [0, "Google Video File"],
        "gvp":           [0, "Google Video Pointer"],
        "ifo":           [0, "DVD-Video Disc Information File"],
        "imovieproj":    [0, "iMovie Project File"],
        "imovieproject": [0, "iMovie Project"],
        "ivf":           [0, "Indeo Video Format File"],
        "ivs":           [0, "Internet Streaming Video"],
        "izz":           [0, "Isadora Media Control Project"],
        "izzy":          [0, "Isadora Project"],
        "lsf":           [0, "Streaming Media Format"],
        "lsx":           [0, "Streaming Media Shortcut"],
        "m1v":           [0, "MPEG-1 Video File"],
        "m21":           [0, "MPEG-21 File"],
        "m2v":           [0, "MPEG-2 Video"],
        "m4e":           [0, "MPEG-4 Video File"],
        "m4u":           [0, "MPEG-4 Playlist"],
        "m4v":           [0, "iTunes Video File"],
        "mjp":           [0, "MJPEG Video File"],
        "mkv":           [0, "Matroska Video File"],
        "mod":           [0, "JVC Recorded Video File"],
        "moov":          [0, "Apple QuickTime Movie"],
        "mov":           [1, "Apple QuickTime Movie"],
        "movie":         [0, "QuickTime Movie File"],
        "mp21":          [0, "MPEG-21 Multimedia File"],
        "mp4":           [1, "MPEG-4 Video File"],
        "mpe":           [0, "MPEG Movie File"],
        "mpeg":          [0, "MPEG Video File"],
        "mpg":           [1, "MPEG Video File"],
        "mpv2":          [0, "MPEG-2 Video Stream"],
        "mqv":           [0, "Sony Movie Format File"],
        "msh":           [0, "Visual Communicator Project File"],
        "mswmm":         [0, "Windows Movie Maker Project"],
        "mvb":           [0, "Multimedia Viewer Book Source File"],
        "mvc":           [0, "Movie Collector Catalog"],
        "nsv":           [0, "Nullsoft Streaming Video File"],
        "nvc":           [0, "NeroVision Express Project File"],
        "ogm":           [0, "Ogg Media File"],
        "pds":           [0, "PowerDirector Project File"],
        "piv":           [0, "Pivot Stickfigure Animation"],
        "playlist":      [0, "CyberLink PowerDVD Playlist"],
        "pro":           [0, "ProPresenter Export File"],
        "prproj":        [0, "Premiere Pro Project"],
        "prx":           [0, "Windows Media Profile"],
        "qt":            [1, "Apple QuickTime Movie"],
        "qtch":          [0, "QuickTime Cache File"],
        "qtz":           [0, "Quartz Composer File"],
        "rm":            [1, "Real Media File"],
        "rmvb":          [0, "RealVideo Variable Bit Rate File"],
        "rp":            [0, "RealPix Clip"],
        "rts":           [0, "RealPlayer Streaming Media"],
        "rts":           [0, "QuickTime Real-Time Streaming Format"],
        "sbk":           [0, "SWiSH Project Backup File"],
        "scm":           [0, "ScreenCam Screen Recording"],
        "scm":           [0, "Super Chain Media File"],
        "sfvidcap":      [0, "Sonic Foundry Video Capture File"],
        "smil":          [0, "SMIL Presentation File"],
        "smv":           [0, "VideoLink Mail Video"],
        "spl":           [0, "FutureSplash Animation"],
        "srt":           [0, "Subtitle File"],
        "ssm":           [0, "Standard Streaming Metafile"],
        "str":           [0, "PlayStation Video Stream"],
        "svi":           [0, "Samsung Video File"],
        "swf":           [1, "Macromedia Flash Movie"],
        "swi":           [0, "SWiSH Project File"],
        "tda3mt":        [0, "DivX Author Template File"],
        "tivo":          [0, "TiVo Video File"],
        "ts":            [0, "Video Transport Stream File"],
        "vdo":           [0, "VDOLive Media File"],
        "veg":           [0, "Vegas Video Project"],
        "vf":            [0, "Vegas Movie Studio Project File"],
        "vfw":           [0, "Video for Windows"],
        "vid":           [0, "Generic Video File"],
        "viewlet":       [0, "Qarbon Viewlet"],
        "viv":           [0, "VivoActive Video File"],
        "vivo":          [0, "VivoActive Video File"],
        "vob":           [0, "DVD Video Object"],
        "vp6":           [0, "TrueMotion VP6 Video File"],
        "vp7":           [0, "TrueMotion VP7 Video File"],
        "vro":           [0, "DVD Video Recording Format"],
        "w32":           [0, "WinCAPs Subtitle File"],
        "wcp":           [0, "WinDVD Creator Project File"],
        "wm":            [0, "Windows Media File"],
        "wmd":           [0, "Windows Media Download Package"],
        "wmv":           [1, "Windows Media Video File"],
        "wmx":           [0, "Windows Media Redirector"],
        "wvx":           [0, "Windows Media Video Redirector"],
        "yuv":           [0, "YUV Video File"],
    },
    'web': {
        "adr":           [0, "Opera Bookmarks File"],
        "ap":            [0, "Active Page"],
        "asa":           [0, "ASP Configuration File"],
        "ascx":          [0, "Active Server Custom Control"],
        "asmx":          [0, "Active Server Method File"],
        "asp":           [1, "Active Server Page"],
        "aspx":          [0, "Active Server Page Extended"],
        "atom":          [0, "Atom Syndication Format"],
        "cdf":           [0, "Channel Definition Format"],
        "cer":           [0, "Internet Security Certificate"],
        "cfm":           [0, "ColdFusion Markup File"],
        "cha":           [0, "Online Chat Configuration File"],
        "chat":          [0, "Online Chat Configuration File"],
        "chm":           [0, "Compiled HTML Help File"],
        "cms":           [0, "Content Management System"],
        "con":           [0, "Concept Application Source File"],
        "crt":           [0, "Security Certificate"],
        "csp":           [0, "Concept Server Page"],
        "css":           [1, "Cascading Style Sheet"],
        "dbm":           [0, "ColdFusion Server File"],
        "dhtml":         [0, "Dynamic HTML file"],
        "disco":         [0, "DISCO Discovery Document"],
        "discomap":      [0, "DISCO Discovery Output File"],
        "dll":           [0, "DLL Dynamic Web Page"],
        "do":            [0, "Java Servlet"],
        "download":      [0, "Partially Downloaded File"],
        "dwt":           [0, "Dreamweaver Web Page Template"],
        "ece":           [0, "Oracle Express Dynamic Web Page"],
        "gne":           [0, "Flickr Web Page"],
        "hdml":          [0, "Handheld Markup Language"],
        "htaccess":      [0, "Apache HTACCESS File"],
        "htm":           [1, "Hypertext Markup Language File"],
        "html":          [1, "Hypertext Markup Language File"],
        "htx":           [0, "HTML Extension File"],
        "htz4":          [0, "HyperMaker Publication"],
        "hxs":           [0, "Help 2 Compiled Help File"],
        "idc":           [0, "Internet Database Connector File"],
        "iqy":           [0, "Internet Query"],
        "jcz":           [0, "Liquid Motion Animation"],
        "jhtml":         [0, "Java HTML Web Page"],
        "jnlp":          [0, "Java Web Start File"],
        "js":            [1, "JavaScript File"],
        "jsp":           [1, "Java Server Page"],
        "jspx":          [0, "XML Java Server Page"],
        "jvs":           [0, "JavaScript Proxy Autoconfig File"],
        "jws":           [0, "Java Web Services File"],
        "lasso":         [0, "Lasso Database-Driven Web Page"],
        "mht":           [0, "MIME HTML Web Page Archive"],
        "mhtml":         [0, "MIME HTML File"],
        "moz":           [0, "Mozilla Cache File"],
        "ognc":          [0, "Dynamic Web Page"],
        "oth":           [0, "OpenDocument HTML Template"],
        "p12":           [0, "Personal Information Exchange"],
        "pem":           [0, "Privacy Enhanced Mail Certificate"],
        "php":           [1, "Hypertext Preprocessor File"],
        "php3":          [0, "PHP 3 Script"],
        "php4":          [0, "PHP 4 Script"],
        "php5":          [0, "PHP 5 Script"],
        "phtm":          [0, "PHP Web Page"],
        "phtml":         [0, "PHP Web Page"],
        "qrm":           [0, "Qworum Message File"],
        "rhtml":         [0, "Ruby HTML Web Page"],
        "rjs":           [0, "Ruby Javascript File"],
        "rss":           [0, "Rich Site Summary"],
        "rwp":           [0, "RapidWeaver Package"],
        "sht":           [0, "HTML File with Server Side Includes"],
        "shtm":          [0, "HTML Server Side Include File"],
        "shtml":         [0, "Server Side Include HTML File"],
        "site":          [0, "GoLive Website Project File"],
        "stl":           [0, "Certificate Trust List"],
        "svr":           [0, "Compressed Virtual World"],
        "url":           [0, "Internet Shortcut"],
        "vrml":          [0, "VRML File"],
        "vsdisco":       [0, "DISCO Dynamic Discovery Document"],
        "wdgt":          [0, "Opera Widget"],
        "webarchive":    [0, "Safari Web Archive"],
        "webloc":        [0, "Mac OS X Website Location"],
        "wml":           [0, "Wireless Markup Language File"],
        "wrf":           [0, "WebEx Recording"],
        "wsdl":          [0, "Web Services Description Language File"],
        "xht":           [0, "XHTML File"],
        "xhtml":         [1, "Extensible Hypertext Markup Language File"],
        "xpd":           [0, "XML Pipeline Document"],
        "xul":           [0, "XML User Interface Language File"],
        "zfo":           [0, "XSL-FO Online Form"],
        "zvz":           [0, "Possible Virus File"],
    },
}

def getByExtension(extension, group=None, only_common=False):
    result = []
    if group and group in filetypes:
        if extension in filetypes[group]:
            if only_common and filetypes[group][extension][0] == 0: return None
            return filetypes[group][extension][1]
        return None
    else:
        for group in filetypes:
            if extension in filetypes[group]:
                if only_common and filetypes[group][extension][0] == 0: continue
                result.append(filetypes[group][extension][1])
    return result

def getByMimeType(mimetype, group=None, only_common=False):
    result = []
    import mimetypes
    for extension in mimetypes.guess_all_extensions(mimetype):
        result.extend(getByExtension(extension[1:]))
    return result

# this one sucks
def getByDescription(description, only_common=False):
    result = []
    description = description.lower()
    for group in filetypes:
        for extension in filetypes[group]:
            if only_common and filetypes[group][extension][0] == 0: continue
            if description in filetypes[group][extension][1].lower():
                result.append(extension)
    return result

def getGroup(extension):
    for group in filetypes:
        if extension in filetypes[group]:
            return group
    return None

if __name__ == '__main__':
    import unittest

    class TestCase(unittest.TestCase):
        def test_by_extension1(self):
            test = getByExtension('001')
            self.assertEqual(test, ['HJSplit Split Archive'])
        def test_by_extension2(self):
            test = getByExtension('wav', group='audio') 
            self.assertEqual(test, "Windows WAVE Sound File")
        def test_by_description1(self):
            test = getByDescription('PHP')
            self.assertEqual(sorted(test), sorted(['phtm', 'phtml', 'php3', 'php4', 'php5']))
        def test_by_description2(self):
            test = getByDescription('Hypertext', only_common=True)
            self.assertEqual(sorted(test), sorted(['htm', 'html', 'php', 'xhtml']))
        def test_by_mimetype(self):
            test = getByMimeType('application/x-shockwave-flash')
            self.assertEqual(test, ['Macromedia Flash Movie'])
        def test_group(self):
            test = getGroup('zip')
            self.assertEqual(test, 'compressed')

    suite = unittest.TestLoader().loadTestsFromTestCase(TestCase)
    unittest.TextTestRunner(verbosity=3).run(suite)

