
################# BEGIN AUTOMATICALLY GENERATED FIT PROFILE ##################
########################### DO NOT EDIT THIS FILE ############################
####### EXPORTED PROFILE FROM SDK VERSION 5.20 AT 2013-01-04 19:16:35 ########
########### PARSED 56 TYPES (513 VALUES), 38 MESSAGES (399 FIELDS) ###########

from fitparse.records import (
    ComponentField,
    Field,
    FieldType,
    MessageType,
    ReferenceField,
    SubField,
    BASE_TYPES,
)


FIELD_TYPES = {
    'activity': FieldType(
        name='activity',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'manual',
            1: 'auto_multi_sport',
        },
    ),
    'activity_class': FieldType(
        name='activity_class',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            100: 'level_max',
            0x7F: 'level',  # 0 to 100
            0x80: 'athlete',
        },
    ),
    'activity_subtype': FieldType(
        name='activity_subtype',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'generic',
            1: 'treadmill',  # Run
            2: 'street',  # Run
            3: 'trail',  # Run
            4: 'track',  # Run
            5: 'spin',  # Cycling
            6: 'indoor_cycling',  # Cycling
            7: 'road',  # Cycling
            8: 'mountain',  # Cycling
            9: 'downhill',  # Cycling
            10: 'recumbent',  # Cycling
            11: 'cyclocross',  # Cycling
            12: 'hand_cycling',  # Cycling
            13: 'track_cycling',  # Cycling
            14: 'indoor_rowing',  # Fitness Equipment
            15: 'elliptical',  # Fitness Equipment
            16: 'stair_climbing',  # Fitness Equipment
            17: 'lap_swimming',  # Swimming
            18: 'open_water',  # Swimming
            254: 'all',
        },
    ),
    'activity_type': FieldType(
        name='activity_type',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'generic',
            1: 'running',
            2: 'cycling',
            3: 'transition',  # Mulitsport transition
            4: 'fitness_equipment',
            5: 'swimming',
            6: 'walking',
            254: 'all',  # All is for goals only to include all sports.
        },
    ),
    'autolap_trigger': FieldType(
        name='autolap_trigger',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'time',
            1: 'distance',
            2: 'position_start',
            3: 'position_lap',
            4: 'position_waypoint',
            5: 'position_marked',
            6: 'off',
        },
    ),
    'battery_status': FieldType(
        name='battery_status',
        base_type=BASE_TYPES[0x02],  # uint8
        values={
            1: 'new',
            2: 'good',
            3: 'ok',
            4: 'low',
            5: 'critical',
        },
    ),
    'bool': FieldType(
        name='bool',
        base_type=BASE_TYPES[0x00],  # enum
    ),
    'bp_status': FieldType(
        name='bp_status',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'no_error',
            1: 'error_incomplete_data',
            2: 'error_no_measurement',
            3: 'error_data_out_of_range',
            4: 'error_irregular_heart_rate',
        },
    ),
    'checksum': FieldType(
        name='checksum',
        base_type=BASE_TYPES[0x02],  # uint8
        values={
            0: 'clear',  # Allows clear of checksum for flash memory where can only write 1 to 0 without erasing sector.
            1: 'ok',  # Set to mark checksum as valid if computes to invalid values 0 or 0xFF.  Checksum can also be set to ok to save encoding computation time.
        },
    ),
    'course_capabilities': FieldType(
        name='course_capabilities',
        base_type=BASE_TYPES[0x8C],  # uint32z
        values={
            0x00000001: 'processed',
            0x00000002: 'valid',
            0x00000004: 'time',
            0x00000008: 'distance',
            0x00000010: 'position',
            0x00000020: 'heart_rate',
            0x00000040: 'power',
            0x00000080: 'cadence',
            0x00000100: 'training',
            0x00000200: 'navigation',
        },
    ),
    'course_point': FieldType(
        name='course_point',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'generic',
            1: 'summit',
            2: 'valley',
            3: 'water',
            4: 'food',
            5: 'danger',
            6: 'left',
            7: 'right',
            8: 'straight',
            9: 'first_aid',
            10: 'fourth_category',
            11: 'third_category',
            12: 'second_category',
            13: 'first_category',
            14: 'hors_category',
            15: 'sprint',
            16: 'left_fork',
            17: 'right_fork',
            18: 'middle_fork',
        },
    ),
    'date_time': FieldType(  # seconds since UTC 00:00 Dec 31 1989
        name='date_time',
        base_type=BASE_TYPES[0x86],  # uint32
    ),
    'device_index': FieldType(
        name='device_index',
        base_type=BASE_TYPES[0x02],  # uint8
        values={
            0: 'creator',  # Creator of the file is always device index 0.
        },
    ),
    'device_type': FieldType(
        name='device_type',
        base_type=BASE_TYPES[0x02],  # uint8
        values={
            1: 'antfs',
            11: 'bike_power',
            12: 'environment_sensor_legacy',
            15: 'multi_sport_speed_distance',
            16: 'control',
            17: 'fitness_equipment',
            18: 'blood_pressure',
            19: 'geocache_node',
            20: 'light_electric_vehicle',
            25: 'env_sensor',
            119: 'weight_scale',
            120: 'heart_rate',
            121: 'bike_speed_cadence',
            122: 'bike_cadence',
            123: 'bike_speed',
            124: 'stride_speed_distance',
        },
    ),
    'display_heart': FieldType(
        name='display_heart',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'bpm',
            1: 'max',
            2: 'reserve',
        },
    ),
    'display_measure': FieldType(
        name='display_measure',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'metric',
            1: 'statute',
        },
    ),
    'display_position': FieldType(
        name='display_position',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'degree',  # dd.dddddd
            1: 'degree_minute',  # dddmm.mmm
            2: 'degree_minute_second',  # dddmmss
            3: 'austrian_grid',  # Austrian Grid (BMN)
            4: 'british_grid',  # British National Grid
            5: 'dutch_grid',  # Dutch grid system
            6: 'hungarian_grid',  # Hungarian grid system
            7: 'finnish_grid',  # Finnish grid system Zone3 KKJ27
            8: 'german_grid',  # Gausss Krueger (German)
            9: 'icelandic_grid',  # Icelandic Grid
            10: 'indonesian_equatorial',  # Indonesian Equatorial LCO
            11: 'indonesian_irian',  # Indonesian Irian LCO
            12: 'indonesian_southern',  # Indonesian Southern LCO
            13: 'india_zone_0',  # India zone 0
            14: 'india_zone_IA',  # India zone IA
            15: 'india_zone_IB',  # India zone IB
            16: 'india_zone_IIA',  # India zone IIA
            17: 'india_zone_IIB',  # India zone IIB
            18: 'india_zone_IIIA',  # India zone IIIA
            19: 'india_zone_IIIB',  # India zone IIIB
            20: 'india_zone_IVA',  # India zone IVA
            21: 'india_zone_IVB',  # India zone IVB
            22: 'irish_transverse',  # Irish Transverse Mercator
            23: 'irish_grid',  # Irish Grid
            24: 'loran',  # Loran TD
            25: 'maidenhead_grid',  # Maidenhead grid system
            26: 'mgrs_grid',  # MGRS grid system
            27: 'new_zealand_grid',  # New Zealand grid system
            28: 'new_zealand_transverse',  # New Zealand Transverse Mercator
            29: 'qatar_grid',  # Qatar National Grid
            30: 'modified_swedish_grid',  # Modified RT-90 (Sweden)
            31: 'swedish_grid',  # RT-90 (Sweden)
            32: 'south_african_grid',  # South African Grid
            33: 'swiss_grid',  # Swiss CH-1903 grid
            34: 'taiwan_grid',  # Taiwan Grid
            35: 'united_states_grid',  # United States National Grid
            36: 'utm_ups_grid',  # UTM/UPS grid system
            37: 'west_malayan',  # West Malayan RSO
            38: 'borneo_rso',  # Borneo RSO
            39: 'estonian_grid',  # Estonian grid system
            40: 'latvian_grid',  # Latvian Transverse Mercator
            41: 'swedish_ref_99_grid',  # Reference Grid 99 TM (Swedish)
        },
    ),
    'display_power': FieldType(
        name='display_power',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'watts',
            1: 'percent_ftp',
        },
    ),
    'event': FieldType(
        name='event',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'timer',  # Group 0.  Start / stop_all
            3: 'workout',  # start / stop
            4: 'workout_step',  # Start at beginning of workout.  Stop at end of each step.
            5: 'power_down',  # stop_all group 0
            6: 'power_up',  # stop_all group 0
            7: 'off_course',  # start / stop group 0
            8: 'session',  # Stop at end of each session.
            9: 'lap',  # Stop at end of each lap.
            10: 'course_point',  # marker
            11: 'battery',  # marker
            12: 'virtual_partner_pace',  # Group 1. Start at beginning of activity if VP enabled, when VP pace is changed during activity or VP enabled mid activity.  stop_disable when VP disabled.
            13: 'hr_high_alert',  # Group 0.  Start / stop when in alert condition.
            14: 'hr_low_alert',  # Group 0.  Start / stop when in alert condition.
            15: 'speed_high_alert',  # Group 0.  Start / stop when in alert condition.
            16: 'speed_low_alert',  # Group 0.  Start / stop when in alert condition.
            17: 'cad_high_alert',  # Group 0.  Start / stop when in alert condition.
            18: 'cad_low_alert',  # Group 0.  Start / stop when in alert condition.
            19: 'power_high_alert',  # Group 0.  Start / stop when in alert condition.
            20: 'power_low_alert',  # Group 0.  Start / stop when in alert condition.
            21: 'recovery_hr',  # marker
            22: 'battery_low',  # marker
            23: 'time_duration_alert',  # Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
            24: 'distance_duration_alert',  # Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
            25: 'calorie_duration_alert',  # Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
            26: 'activity',  # Group 1..  Stop at end of activity.
            27: 'fitness_equipment',  # marker
            28: 'length',  # Stop at end of each length.
        },
    ),
    'event_type': FieldType(
        name='event_type',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'start',
            1: 'stop',
            2: 'consecutive_depreciated',
            3: 'marker',
            4: 'stop_all',
            5: 'begin_depreciated',
            6: 'end_depreciated',
            7: 'end_all_depreciated',
            8: 'stop_disable',
            9: 'stop_disable_all',
        },
    ),
    'file': FieldType(
        name='file',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            1: 'device',  # Read only, single file. Must be in root directory.
            2: 'settings',  # Read/write, single file. Directory=Settings
            3: 'sport',  # Read/write, multiple files, file number = sport type. Directory=Sports
            4: 'activity',  # Read/erase, multiple files. Directory=Activities
            5: 'workout',  # Read/write/erase, multiple files. Directory=Workouts
            6: 'course',  # Read/write/erase, multiple files. Directory=Courses
            7: 'schedules',  # Read/write, single file. Directory=Schedules
            9: 'weight',  # Read only, single file. Circular buffer. All message definitions at start of file. Directory=Weight
            10: 'totals',  # Read only, single file. Directory=Totals
            11: 'goals',  # Read/write, single file. Directory=Goals
            14: 'blood_pressure',  # Read only. Directory=Blood Pressure
            15: 'monitoring',  # Read only. Directory=Monitoring
            20: 'activity_summary',  # Read/erase, multiple files. Directory=Activities
            28: 'monitoring_daily',
        },
    ),
    'file_flags': FieldType(
        name='file_flags',
        base_type=BASE_TYPES[0x0A],  # uint8z
        values={
            0x02: 'read',
            0x04: 'write',
            0x08: 'erase',
        },
    ),
    'fitness_equipment_state': FieldType(  # fitness equipment event data
        name='fitness_equipment_state',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'ready',
            1: 'in_use',
            2: 'paused',
            3: 'unknown',  # lost connection to fitness equipment
        },
    ),
    'garmin_product': FieldType(
        name='garmin_product',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            1: 'hrm1',
            2: 'axh01',  # AXH01 HRM chipset
            3: 'axb01',
            4: 'axb02',
            5: 'hrm2ss',
            6: 'dsi_alf02',
            717: 'fr405',  # Forerunner 405
            782: 'fr50',  # Forerunner 50
            988: 'fr60',  # Forerunner 60
            1011: 'dsi_alf01',
            1018: 'fr310xt',  # Forerunner 310
            1036: 'edge500',
            1124: 'fr110',  # Forerunner 110
            1169: 'edge800',
            1253: 'chirp',
            1325: 'edge200',
            1328: 'fr910xt',
            1341: 'alf04',
            1345: 'fr610',
            1436: 'fr70',
            1446: 'fr310xt_4t',
            1461: 'amx',
            10007: 'sdm4',  # SDM4 footpod
            20119: 'training_center',
            65534: 'connect',  # Garmin Connect website
        },
    ),
    'gender': FieldType(
        name='gender',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'female',
            1: 'male',
        },
    ),
    'goal': FieldType(
        name='goal',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'time',
            1: 'distance',
            2: 'calories',
            3: 'frequency',
            4: 'steps',
        },
    ),
    'goal_recurrence': FieldType(
        name='goal_recurrence',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'off',
            1: 'daily',
            2: 'weekly',
            3: 'monthly',
            4: 'yearly',
            5: 'custom',
        },
    ),
    'hr_type': FieldType(
        name='hr_type',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'normal',
            1: 'irregular',
        },
    ),
    'hr_zone_calc': FieldType(
        name='hr_zone_calc',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'custom',
            1: 'percent_max_hr',
            2: 'percent_hrr',
        },
    ),
    'intensity': FieldType(
        name='intensity',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'active',
            1: 'rest',
            2: 'warmup',
            3: 'cooldown',
        },
    ),
    'language': FieldType(
        name='language',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'english',
            1: 'french',
            2: 'italian',
            3: 'german',
            4: 'spanish',
            5: 'croatian',
            6: 'czech',
            7: 'danish',
            8: 'dutch',
            9: 'finnish',
            10: 'greek',
            11: 'hungarian',
            12: 'norwegian',
            13: 'polish',
            14: 'portuguese',
            15: 'slovakian',
            16: 'slovenian',
            17: 'swedish',
            18: 'russian',
            19: 'turkish',
            20: 'latvian',
            21: 'ukrainian',
            22: 'arabic',
            23: 'farsi',
            24: 'bulgarian',
            25: 'romanian',
            254: 'custom',
        },
    ),
    'lap_trigger': FieldType(
        name='lap_trigger',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'manual',
            1: 'time',
            2: 'distance',
            3: 'position_start',
            4: 'position_lap',
            5: 'position_waypoint',
            6: 'position_marked',
            7: 'session_end',
            8: 'fitness_equipment',
        },
    ),
    'left_right_balance': FieldType(
        name='left_right_balance',
        base_type=BASE_TYPES[0x02],  # uint8
        values={
            0x7F: 'mask',  # % contribution
            0x80: 'right',  # data corresponds to right if set, otherwise unknown
        },
    ),
    'left_right_balance_100': FieldType(
        name='left_right_balance_100',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            0x3FFF: 'mask',  # % contribution scaled by 100
            0x8000: 'right',  # data corresponds to right if set, otherwise unknown
        },
    ),
    'length_type': FieldType(
        name='length_type',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'idle',  # Rest period. Length with no strokes
            1: 'active',  # Length with strokes.
        },
    ),
    'local_date_time': FieldType(  # seconds since 00:00 Dec 31 1989 in local time zone
        name='local_date_time',
        base_type=BASE_TYPES[0x86],  # uint32
    ),
    'manufacturer': FieldType(
        name='manufacturer',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            1: 'garmin',
            2: 'garmin_fr405_antfs',  # Do not use.  Used by FR405 for ANTFS man id.
            3: 'zephyr',
            4: 'dayton',
            5: 'idt',
            6: 'srm',
            7: 'quarq',
            8: 'ibike',
            9: 'saris',
            10: 'spark_hk',
            11: 'tanita',
            12: 'echowell',
            13: 'dynastream_oem',
            14: 'nautilus',
            15: 'dynastream',
            16: 'timex',
            17: 'metrigear',
            18: 'xelic',
            19: 'beurer',
            20: 'cardiosport',
            21: 'a_and_d',
            22: 'hmm',
            23: 'suunto',
            24: 'thita_elektronik',
            25: 'gpulse',
            26: 'clean_mobile',
            27: 'pedal_brain',
            28: 'peaksware',
            29: 'saxonar',
            30: 'lemond_fitness',
            31: 'dexcom',
            32: 'wahoo_fitness',
            33: 'octane_fitness',
            34: 'archinoetics',
            35: 'the_hurt_box',
            36: 'citizen_systems',
            37: 'magellan',
            38: 'osynce',
            39: 'holux',
            40: 'concept2',
            42: 'one_giant_leap',
            43: 'ace_sensor',
            44: 'brim_brothers',
            45: 'xplova',
            46: 'perception_digital',
            47: 'bf1systems',
            48: 'pioneer',
            49: 'spantec',
            50: 'metalogics',
            51: '4iiiis',
            52: 'seiko_epson',
            53: 'seiko_epson_oem',
            54: 'ifor_powell',
            55: 'maxwell_guider',
            56: 'star_trac',
            57: 'breakaway',
            58: 'alatech_technology_ltd',
            60: 'rotor',
            61: 'geonaute',
            62: 'id_bike',
            63: 'specialized',
            64: 'wtek',
            65: 'physical_enterprises',
            66: 'north_pole_engineering',
            255: 'development',
            5759: 'actigraphcorp',
        },
    ),
    'mesg_count': FieldType(
        name='mesg_count',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'num_per_file',
            1: 'max_per_file',
            2: 'max_per_file_type',
        },
    ),
    'mesg_num': FieldType(
        name='mesg_num',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            0: 'file_id',
            1: 'capabilities',
            2: 'device_settings',
            3: 'user_profile',
            4: 'hrm_profile',
            5: 'sdm_profile',
            6: 'bike_profile',
            7: 'zones_target',
            8: 'hr_zone',
            9: 'power_zone',
            10: 'met_zone',
            12: 'sport',
            15: 'goal',
            18: 'session',
            19: 'lap',
            20: 'record',
            21: 'event',
            23: 'device_info',
            26: 'workout',
            27: 'workout_step',
            28: 'schedule',
            30: 'weight_scale',
            31: 'course',
            32: 'course_point',
            33: 'totals',
            34: 'activity',
            35: 'software',
            37: 'file_capabilities',
            38: 'mesg_capabilities',
            39: 'field_capabilities',
            49: 'file_creator',
            51: 'blood_pressure',
            53: 'speed_zone',
            55: 'monitoring',
            78: 'hrv',
            101: 'length',
            103: 'monitoring_info',
            105: 'pad',
            131: 'cadence_zone',
        },
    ),
    'message_index': FieldType(
        name='message_index',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            0x0FFF: 'mask',  # index
            0x7000: 'reserved',  # reserved (default 0)
            0x8000: 'selected',  # message is selected if set
        },
    ),
    'pwr_zone_calc': FieldType(
        name='pwr_zone_calc',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'custom',
            1: 'percent_ftp',
        },
    ),
    'schedule': FieldType(
        name='schedule',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'workout',
            1: 'course',
        },
    ),
    'session_trigger': FieldType(
        name='session_trigger',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'activity_end',
            1: 'manual',  # User changed sport.
            2: 'auto_multi_sport',  # Auto multi-sport feature is enabled and user pressed lap button to advance session.
            3: 'fitness_equipment',  # Auto sport change caused by user linking to fitness equipment.
        },
    ),
    'sport': FieldType(
        name='sport',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'generic',
            1: 'running',
            2: 'cycling',
            3: 'transition',  # Mulitsport transition
            4: 'fitness_equipment',
            5: 'swimming',
            6: 'basketball',
            7: 'soccer',
            8: 'tennis',
            9: 'american_football',
            10: 'training',
            254: 'all',  # All is for goals only to include all sports.
        },
    ),
    'sport_bits_0': FieldType(  # Bit field corresponding to sport enum type (1 << sport).
        name='sport_bits_0',
        base_type=BASE_TYPES[0x0A],  # uint8z
        values={
            0x01: 'generic',
            0x02: 'running',
            0x04: 'cycling',
            0x08: 'transition',  # Mulitsport transition
            0x10: 'fitness_equipment',
            0x20: 'swimming',
            0x40: 'basketball',
            0x80: 'soccer',
        },
    ),
    'sport_bits_1': FieldType(  # Bit field corresponding to sport enum type (1 << (sport-8)).
        name='sport_bits_1',
        base_type=BASE_TYPES[0x0A],  # uint8z
        values={
            0x01: 'tennis',
            0x02: 'american_football',
            0x04: 'training',
        },
    ),
    'sub_sport': FieldType(
        name='sub_sport',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'generic',
            1: 'treadmill',  # Run
            2: 'street',  # Run
            3: 'trail',  # Run
            4: 'track',  # Run
            5: 'spin',  # Cycling
            6: 'indoor_cycling',  # Cycling
            7: 'road',  # Cycling
            8: 'mountain',  # Cycling
            9: 'downhill',  # Cycling
            10: 'recumbent',  # Cycling
            11: 'cyclocross',  # Cycling
            12: 'hand_cycling',  # Cycling
            13: 'track_cycling',  # Cycling
            14: 'indoor_rowing',  # Fitness Equipment
            15: 'elliptical',  # Fitness Equipment
            16: 'stair_climbing',  # Fitness Equipment
            17: 'lap_swimming',  # Swimming
            18: 'open_water',  # Swimming
            19: 'flexibility_training',  # Training
            20: 'strength_training',  # Training
            254: 'all',
        },
    ),
    'swim_stroke': FieldType(
        name='swim_stroke',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'freestyle',
            1: 'backstroke',
            2: 'breaststroke',
            3: 'butterfly',
            4: 'drill',
            5: 'mixed',
        },
    ),
    'timer_trigger': FieldType(  # timer event data
        name='timer_trigger',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'manual',
            1: 'auto',
            2: 'fitness_equipment',
        },
    ),
    'user_local_id': FieldType(
        name='user_local_id',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            0x0001: 'local_min',
            0x000F: 'local_max',
            0x0010: 'stationary_min',
            0x00FF: 'stationary_max',
            0x0100: 'portable_min',
            0xFFFE: 'portable_max',
        },
    ),
    'weight': FieldType(
        name='weight',
        base_type=BASE_TYPES[0x84],  # uint16
        values={
            0xFFFE: 'calculating',
        },
    ),
    'wkt_step_duration': FieldType(
        name='wkt_step_duration',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'time',
            1: 'distance',
            2: 'hr_less_than',
            3: 'hr_greater_than',
            4: 'calories',
            5: 'open',
            6: 'repeat_until_steps_cmplt',
            7: 'repeat_until_time',
            8: 'repeat_until_distance',
            9: 'repeat_until_calories',
            10: 'repeat_until_hr_less_than',
            11: 'repeat_until_hr_greater_than',
            12: 'repeat_until_power_less_than',
            13: 'repeat_until_power_greater_than',
            14: 'power_less_than',
            15: 'power_greater_than',
        },
    ),
    'wkt_step_target': FieldType(
        name='wkt_step_target',
        base_type=BASE_TYPES[0x00],  # enum
        values={
            0: 'speed',
            1: 'heart_rate',
            2: 'open',
            3: 'cadence',
            4: 'power',
            5: 'grade',
            6: 'resistance',
        },
    ),
    'workout_capabilities': FieldType(
        name='workout_capabilities',
        base_type=BASE_TYPES[0x8C],  # uint32z
        values={
            0x00000001: 'interval',
            0x00000002: 'custom',
            0x00000004: 'fitness_equipment',
            0x00000008: 'firstbeat',
            0x00000010: 'new_leaf',
            0x00000020: 'tcx',  # For backwards compatibility.  Watch should add missing id fields then clear flag.
            0x00000080: 'speed',  # Speed source required for workout step.
            0x00000100: 'heart_rate',  # Heart rate source required for workout step.
            0x00000200: 'distance',  # Distance source required for workout step.
            0x00000400: 'cadence',  # Cadence source required for workout step.
            0x00000800: 'power',  # Power source required for workout step.
            0x00001000: 'grade',  # Grade source required for workout step.
            0x00002000: 'resistance',  # Resistance source required for workout step.
            0x00004000: 'protected',
        },
    ),
    'workout_hr': FieldType(  # 0 - 100 indicates% of maz hr; >100 indicates bpm (255 max) plus 100
        name='workout_hr',
        base_type=BASE_TYPES[0x86],  # uint32
        values={
            100: 'bpm_offset',
        },
    ),
    'workout_power': FieldType(  # 0 - 1000 indicates % of functional threshold power; >1000 indicates watts plus 1000.
        name='workout_power',
        base_type=BASE_TYPES[0x86],  # uint32
        values={
            1000: 'watts_offset',
        },
    ),
}


FIELD_TYPE_TIMESTAMP = Field(name='timestamp', type=FIELD_TYPES['date_time'], def_num=253, units='s')


MESSAGE_TYPES = {
    ############################ Common Messages #############################
    0: MessageType(  # Must be first message in file.
        name='file_id',
        mesg_num=0,
        fields={
            0: Field(
                name='type',
                type=FIELD_TYPES['file'],
                def_num=0,
            ),
            1: Field(
                name='manufacturer',
                type=FIELD_TYPES['manufacturer'],
                def_num=1,
            ),
            2: Field(
                name='product',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                subfields=(
                    SubField(
                        name='garmin_product',
                        def_num=2,
                        type=FIELD_TYPES['garmin_product'],
                        ref_fields=(
                            ReferenceField(
                                name='manufacturer',
                                def_num=1,
                                value='garmin',
                                raw_value=1,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=1,
                                value='dynastream',
                                raw_value=15,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=1,
                                value='dynastream_oem',
                                raw_value=13,
                            ),
                        ),
                    ),
                ),
            ),
            3: Field(
                name='serial_number',
                type=BASE_TYPES[0x8C],  # uint32z
                def_num=3,
            ),
            4: Field(  # Only set for files that are can be created/erased.
                name='time_created',
                type=FIELD_TYPES['date_time'],
                def_num=4,
            ),
            5: Field(  # Only set for files that are not created/erased.
                name='number',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
            ),
        },
    ),
    49: MessageType(
        name='file_creator',
        mesg_num=49,
        fields={
            0: Field(
                name='software_version',
                type=BASE_TYPES[0x84],  # uint16
                def_num=0,
            ),
            1: Field(
                name='hardware_version',
                type=BASE_TYPES[0x02],  # uint8
                def_num=1,
            ),
        },
    ),


    ######################### Activity File Messages #########################
    18: MessageType(
        name='session',
        mesg_num=18,
        fields={
            0: Field(  # session
                name='event',
                type=FIELD_TYPES['event'],
                def_num=0,
            ),
            1: Field(  # stop
                name='event_type',
                type=FIELD_TYPES['event_type'],
                def_num=1,
            ),
            2: Field(
                name='start_time',
                type=FIELD_TYPES['date_time'],
                def_num=2,
            ),
            3: Field(
                name='start_position_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=3,
                units='semicircles',
            ),
            4: Field(
                name='start_position_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=4,
                units='semicircles',
            ),
            5: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=5,
            ),
            6: Field(
                name='sub_sport',
                type=FIELD_TYPES['sub_sport'],
                def_num=6,
            ),
            7: Field(  # Time (includes pauses)
                name='total_elapsed_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=7,
                scale=1000,
                units='s',
            ),
            8: Field(  # Timer Time (excludes pauses)
                name='total_timer_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=8,
                scale=1000,
                units='s',
            ),
            9: Field(
                name='total_distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=9,
                scale=100,
                units='m',
            ),
            10: Field(
                name='total_cycles',
                type=BASE_TYPES[0x86],  # uint32
                def_num=10,
                units='cycles',
                subfields=(
                    SubField(
                        name='total_strides',
                        def_num=10,
                        type=BASE_TYPES[0x86],  # uint32
                        units='strides',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=5,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            11: Field(
                name='total_calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=11,
                units='kcal',
            ),
            13: Field(
                name='total_fat_calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=13,
                units='kcal',
            ),
            14: Field(  # total_distance / total_timer_time
                name='avg_speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=14,
                scale=1000,
                units='m/s',
            ),
            15: Field(
                name='max_speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=15,
                scale=1000,
                units='m/s',
            ),
            16: Field(  # average heart rate (excludes pause time)
                name='avg_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=16,
                units='bpm',
            ),
            17: Field(
                name='max_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=17,
                units='bpm',
            ),
            18: Field(  # total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
                name='avg_cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=18,
                units='rpm',
                subfields=(
                    SubField(
                        name='avg_running_cadence',
                        def_num=18,
                        type=BASE_TYPES[0x02],  # uint8
                        units='strides/min',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=5,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            19: Field(
                name='max_cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=19,
                units='rpm',
                subfields=(
                    SubField(
                        name='max_running_cadence',
                        def_num=19,
                        type=BASE_TYPES[0x02],  # uint8
                        units='strides/min',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=5,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            20: Field(  # total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
                name='avg_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=20,
                units='watts',
            ),
            21: Field(
                name='max_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=21,
                units='watts',
            ),
            22: Field(
                name='total_ascent',
                type=BASE_TYPES[0x84],  # uint16
                def_num=22,
                units='m',
            ),
            23: Field(
                name='total_descent',
                type=BASE_TYPES[0x84],  # uint16
                def_num=23,
                units='m',
            ),
            24: Field(
                name='total_training_effect',
                type=BASE_TYPES[0x02],  # uint8
                def_num=24,
                scale=10,
            ),
            25: Field(
                name='first_lap_index',
                type=BASE_TYPES[0x84],  # uint16
                def_num=25,
            ),
            26: Field(
                name='num_laps',
                type=BASE_TYPES[0x84],  # uint16
                def_num=26,
            ),
            27: Field(
                name='event_group',
                type=BASE_TYPES[0x02],  # uint8
                def_num=27,
            ),
            28: Field(
                name='trigger',
                type=FIELD_TYPES['session_trigger'],
                def_num=28,
            ),
            29: Field(
                name='nec_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=29,
                units='semicircles',
            ),
            30: Field(
                name='nec_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=30,
                units='semicircles',
            ),
            31: Field(
                name='swc_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=31,
                units='semicircles',
            ),
            32: Field(
                name='swc_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=32,
                units='semicircles',
            ),
            34: Field(
                name='normalized_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=34,
                units='watts',
            ),
            35: Field(
                name='training_stress_score',
                type=BASE_TYPES[0x84],  # uint16
                def_num=35,
                scale=10,
                units='tss',
            ),
            36: Field(
                name='intensity_factor',
                type=BASE_TYPES[0x84],  # uint16
                def_num=36,
                scale=1000,
                units='if',
            ),
            37: Field(
                name='left_right_balance',
                type=FIELD_TYPES['left_right_balance_100'],
                def_num=37,
            ),
            41: Field(
                name='avg_stroke_count',
                type=BASE_TYPES[0x86],  # uint32
                def_num=41,
                scale=10,
                units='strokes/lap',
            ),
            42: Field(
                name='avg_stroke_distance',
                type=BASE_TYPES[0x84],  # uint16
                def_num=42,
                scale=100,
                units='m',
            ),
            43: Field(
                name='swim_stroke',
                type=FIELD_TYPES['swim_stroke'],
                def_num=43,
                units='swim_stroke',
            ),
            44: Field(
                name='pool_length',
                type=BASE_TYPES[0x84],  # uint16
                def_num=44,
                scale=100,
                units='m',
            ),
            46: Field(
                name='pool_length_unit',
                type=FIELD_TYPES['display_measure'],
                def_num=46,
            ),
            47: Field(  # # of active lengths of swim pool
                name='num_active_lengths',
                type=BASE_TYPES[0x84],  # uint16
                def_num=47,
                units='lengths',
            ),
            48: Field(
                name='total_work',
                type=BASE_TYPES[0x86],  # uint32
                def_num=48,
                units='J',
            ),
            49: Field(
                name='avg_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=49,
                scale=5,
                offset=500,
                units='m',
            ),
            50: Field(
                name='max_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=50,
                scale=5,
                offset=500,
                units='m',
            ),
            51: Field(
                name='gps_accuracy',
                type=BASE_TYPES[0x02],  # uint8
                def_num=51,
                units='m',
            ),
            52: Field(
                name='avg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=52,
                scale=100,
                units='%',
            ),
            53: Field(
                name='avg_pos_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=53,
                scale=100,
                units='%',
            ),
            54: Field(
                name='avg_neg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=54,
                scale=100,
                units='%',
            ),
            55: Field(
                name='max_pos_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=55,
                scale=100,
                units='%',
            ),
            56: Field(
                name='max_neg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=56,
                scale=100,
                units='%',
            ),
            57: Field(
                name='avg_temperature',
                type=BASE_TYPES[0x01],  # sint8
                def_num=57,
                units='C',
            ),
            58: Field(
                name='max_temperature',
                type=BASE_TYPES[0x01],  # sint8
                def_num=58,
                units='C',
            ),
            59: Field(
                name='total_moving_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=59,
                scale=1000,
                units='s',
            ),
            60: Field(
                name='avg_pos_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=60,
                scale=1000,
                units='m/s',
            ),
            61: Field(
                name='avg_neg_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=61,
                scale=1000,
                units='m/s',
            ),
            62: Field(
                name='max_pos_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=62,
                scale=1000,
                units='m/s',
            ),
            63: Field(
                name='max_neg_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=63,
                scale=1000,
                units='m/s',
            ),
            64: Field(
                name='min_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=64,
                units='bpm',
            ),
            65: Field(
                name='time_in_hr_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=65,
                scale=1000,
                units='s',
            ),
            66: Field(
                name='time_in_speed_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=66,
                scale=1000,
                units='s',
            ),
            67: Field(
                name='time_in_cadence_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=67,
                scale=1000,
                units='s',
            ),
            68: Field(
                name='time_in_power_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=68,
                scale=1000,
                units='s',
            ),
            69: Field(
                name='avg_lap_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=69,
                scale=1000,
                units='s',
            ),
            70: Field(
                name='best_lap_index',
                type=BASE_TYPES[0x84],  # uint16
                def_num=70,
            ),
            71: Field(
                name='min_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=71,
                scale=5,
                offset=500,
                units='m',
            ),
            253: FIELD_TYPE_TIMESTAMP,  # Sesson end time.
            254: Field(  # Selected bit is set for the current session.
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    19: MessageType(
        name='lap',
        mesg_num=19,
        fields={
            0: Field(
                name='event',
                type=FIELD_TYPES['event'],
                def_num=0,
            ),
            1: Field(
                name='event_type',
                type=FIELD_TYPES['event_type'],
                def_num=1,
            ),
            2: Field(
                name='start_time',
                type=FIELD_TYPES['date_time'],
                def_num=2,
            ),
            3: Field(
                name='start_position_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=3,
                units='semicircles',
            ),
            4: Field(
                name='start_position_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=4,
                units='semicircles',
            ),
            5: Field(
                name='end_position_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=5,
                units='semicircles',
            ),
            6: Field(
                name='end_position_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=6,
                units='semicircles',
            ),
            7: Field(  # Time (includes pauses)
                name='total_elapsed_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=7,
                scale=1000,
                units='s',
            ),
            8: Field(  # Timer Time (excludes pauses)
                name='total_timer_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=8,
                scale=1000,
                units='s',
            ),
            9: Field(
                name='total_distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=9,
                scale=100,
                units='m',
            ),
            10: Field(
                name='total_cycles',
                type=BASE_TYPES[0x86],  # uint32
                def_num=10,
                units='cycles',
                subfields=(
                    SubField(
                        name='total_strides',
                        def_num=10,
                        type=BASE_TYPES[0x86],  # uint32
                        units='strides',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=25,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            11: Field(
                name='total_calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=11,
                units='kcal',
            ),
            12: Field(  # If New Leaf
                name='total_fat_calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=12,
                units='kcal',
            ),
            13: Field(
                name='avg_speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=13,
                scale=1000,
                units='m/s',
            ),
            14: Field(
                name='max_speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=14,
                scale=1000,
                units='m/s',
            ),
            15: Field(
                name='avg_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=15,
                units='bpm',
            ),
            16: Field(
                name='max_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=16,
                units='bpm',
            ),
            17: Field(  # total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
                name='avg_cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=17,
                units='rpm',
                subfields=(
                    SubField(
                        name='avg_running_cadence',
                        def_num=17,
                        type=BASE_TYPES[0x02],  # uint8
                        units='strides/min',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=25,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            18: Field(
                name='max_cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=18,
                units='rpm',
                subfields=(
                    SubField(
                        name='max_running_cadence',
                        def_num=18,
                        type=BASE_TYPES[0x02],  # uint8
                        units='strides/min',
                        ref_fields=(
                            ReferenceField(
                                name='sport',
                                def_num=25,
                                value='running',
                                raw_value=1,
                            ),
                        ),
                    ),
                ),
            ),
            19: Field(  # total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
                name='avg_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=19,
                units='watts',
            ),
            20: Field(
                name='max_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=20,
                units='watts',
            ),
            21: Field(
                name='total_ascent',
                type=BASE_TYPES[0x84],  # uint16
                def_num=21,
                units='m',
            ),
            22: Field(
                name='total_descent',
                type=BASE_TYPES[0x84],  # uint16
                def_num=22,
                units='m',
            ),
            23: Field(
                name='intensity',
                type=FIELD_TYPES['intensity'],
                def_num=23,
            ),
            24: Field(
                name='lap_trigger',
                type=FIELD_TYPES['lap_trigger'],
                def_num=24,
            ),
            25: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=25,
            ),
            26: Field(
                name='event_group',
                type=BASE_TYPES[0x02],  # uint8
                def_num=26,
            ),
            32: Field(  # # of lengths of swim pool
                name='num_lengths',
                type=BASE_TYPES[0x84],  # uint16
                def_num=32,
                units='lengths',
            ),
            33: Field(
                name='normalized_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=33,
                units='watts',
            ),
            34: Field(
                name='left_right_balance',
                type=FIELD_TYPES['left_right_balance_100'],
                def_num=34,
            ),
            35: Field(
                name='first_length_index',
                type=BASE_TYPES[0x84],  # uint16
                def_num=35,
            ),
            37: Field(
                name='avg_stroke_distance',
                type=BASE_TYPES[0x84],  # uint16
                def_num=37,
                scale=100,
                units='m',
            ),
            38: Field(
                name='swim_stroke',
                type=FIELD_TYPES['swim_stroke'],
                def_num=38,
            ),
            39: Field(
                name='sub_sport',
                type=FIELD_TYPES['sub_sport'],
                def_num=39,
            ),
            40: Field(  # # of active lengths of swim pool
                name='num_active_lengths',
                type=BASE_TYPES[0x84],  # uint16
                def_num=40,
                units='lengths',
            ),
            41: Field(
                name='total_work',
                type=BASE_TYPES[0x86],  # uint32
                def_num=41,
                units='J',
            ),
            42: Field(
                name='avg_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=42,
                scale=5,
                offset=500,
                units='m',
            ),
            43: Field(
                name='max_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=43,
                scale=5,
                offset=500,
                units='m',
            ),
            44: Field(
                name='gps_accuracy',
                type=BASE_TYPES[0x02],  # uint8
                def_num=44,
                units='m',
            ),
            45: Field(
                name='avg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=45,
                scale=100,
                units='%',
            ),
            46: Field(
                name='avg_pos_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=46,
                scale=100,
                units='%',
            ),
            47: Field(
                name='avg_neg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=47,
                scale=100,
                units='%',
            ),
            48: Field(
                name='max_pos_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=48,
                scale=100,
                units='%',
            ),
            49: Field(
                name='max_neg_grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=49,
                scale=100,
                units='%',
            ),
            50: Field(
                name='avg_temperature',
                type=BASE_TYPES[0x01],  # sint8
                def_num=50,
                units='C',
            ),
            51: Field(
                name='max_temperature',
                type=BASE_TYPES[0x01],  # sint8
                def_num=51,
                units='C',
            ),
            52: Field(
                name='total_moving_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=52,
                scale=1000,
                units='s',
            ),
            53: Field(
                name='avg_pos_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=53,
                scale=1000,
                units='m/s',
            ),
            54: Field(
                name='avg_neg_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=54,
                scale=1000,
                units='m/s',
            ),
            55: Field(
                name='max_pos_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=55,
                scale=1000,
                units='m/s',
            ),
            56: Field(
                name='max_neg_vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=56,
                scale=1000,
                units='m/s',
            ),
            57: Field(
                name='time_in_hr_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=57,
                scale=1000,
                units='s',
            ),
            58: Field(
                name='time_in_speed_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=58,
                scale=1000,
                units='s',
            ),
            59: Field(
                name='time_in_cadence_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=59,
                scale=1000,
                units='s',
            ),
            60: Field(
                name='time_in_power_zone',
                type=BASE_TYPES[0x86],  # uint32
                def_num=60,
                scale=1000,
                units='s',
            ),
            61: Field(
                name='repetition_num',
                type=BASE_TYPES[0x84],  # uint16
                def_num=61,
            ),
            62: Field(
                name='min_altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=62,
                scale=5,
                offset=500,
                units='m',
            ),
            63: Field(
                name='min_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=63,
                units='bpm',
            ),
            71: Field(
                name='wkt_step_index',
                type=FIELD_TYPES['message_index'],
                def_num=71,
            ),
            253: FIELD_TYPE_TIMESTAMP,  # Lap end time.
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    20: MessageType(
        name='record',
        mesg_num=20,
        fields={
            0: Field(
                name='position_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=0,
                units='semicircles',
            ),
            1: Field(
                name='position_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=1,
                units='semicircles',
            ),
            2: Field(
                name='altitude',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                scale=5,
                offset=500,
                units='m',
            ),
            3: Field(
                name='heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=3,
                units='bpm',
            ),
            4: Field(
                name='cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=4,
                units='rpm',
            ),
            5: Field(
                name='distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=5,
                scale=100,
                units='m',
            ),
            6: Field(
                name='speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=6,
                scale=1000,
                units='m/s',
            ),
            7: Field(
                name='power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=7,
                units='watts',
            ),
            8: Field(
                name='compressed_speed_distance',
                type=BASE_TYPES[0x0D],  # byte
                def_num=8,
                components=(
                    ComponentField(
                        name='speed',
                        def_num=6,
                        scale=100,
                        units='m/s',
                        accumulate=False,
                        bits=12,
                        bit_offset=0,
                    ),
                    ComponentField(
                        name='distance',
                        def_num=5,
                        scale=16,
                        units='m',
                        accumulate=True,
                        bits=12,
                        bit_offset=12,
                    ),
                ),
            ),
            9: Field(
                name='grade',
                type=BASE_TYPES[0x83],  # sint16
                def_num=9,
                scale=100,
                units='%',
            ),
            10: Field(  # Relative. 0 is none  254 is Max.
                name='resistance',
                type=BASE_TYPES[0x02],  # uint8
                def_num=10,
            ),
            11: Field(
                name='time_from_course',
                type=BASE_TYPES[0x85],  # sint32
                def_num=11,
                scale=1000,
                units='s',
            ),
            12: Field(
                name='cycle_length',
                type=BASE_TYPES[0x02],  # uint8
                def_num=12,
                scale=100,
                units='m',
            ),
            13: Field(
                name='temperature',
                type=BASE_TYPES[0x01],  # sint8
                def_num=13,
                units='C',
            ),
            17: Field(  # Speed at 1s intervals.  Timestamp field indicates time of last array element.
                name='speed_1s',
                type=BASE_TYPES[0x02],  # uint8
                def_num=17,
                scale=16,
                units='m/s',
            ),
            18: Field(
                name='cycles',
                type=BASE_TYPES[0x02],  # uint8
                def_num=18,
                components=(
                    ComponentField(
                        name='total_cycles',
                        def_num=19,
                        units='cycles',
                        accumulate=True,
                        bits=8,
                        bit_offset=0,
                    ),
                ),
            ),
            19: Field(
                name='total_cycles',
                type=BASE_TYPES[0x86],  # uint32
                def_num=19,
                units='cycles',
            ),
            28: Field(
                name='compressed_accumulated_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=28,
                components=(
                    ComponentField(
                        name='accumulated_power',
                        def_num=29,
                        units='watts',
                        accumulate=True,
                        bits=16,
                        bit_offset=0,
                    ),
                ),
            ),
            29: Field(
                name='accumulated_power',
                type=BASE_TYPES[0x86],  # uint32
                def_num=29,
                units='watts',
            ),
            30: Field(
                name='left_right_balance',
                type=FIELD_TYPES['left_right_balance'],
                def_num=30,
            ),
            31: Field(
                name='gps_accuracy',
                type=BASE_TYPES[0x02],  # uint8
                def_num=31,
                units='m',
            ),
            32: Field(
                name='vertical_speed',
                type=BASE_TYPES[0x83],  # sint16
                def_num=32,
                scale=1000,
                units='m/s',
            ),
            33: Field(
                name='calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=33,
                units='kcal',
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),
    21: MessageType(
        name='event',
        mesg_num=21,
        fields={
            0: Field(
                name='event',
                type=FIELD_TYPES['event'],
                def_num=0,
            ),
            1: Field(
                name='event_type',
                type=FIELD_TYPES['event_type'],
                def_num=1,
            ),
            2: Field(
                name='data16',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                components=(
                    ComponentField(
                        name='data',
                        def_num=3,
                        accumulate=False,
                        bits=16,
                        bit_offset=0,
                    ),
                ),
            ),
            3: Field(
                name='data',
                type=BASE_TYPES[0x86],  # uint32
                def_num=3,
                subfields=(
                    SubField(
                        name='battery_level',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        scale=1000,
                        units='V',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='battery',
                                raw_value=11,
                            ),
                        ),
                    ),
                    SubField(
                        name='cad_high_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        units='rpm',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='cad_high_alert',
                                raw_value=17,
                            ),
                        ),
                    ),
                    SubField(
                        name='cad_low_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        units='rpm',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='cad_low_alert',
                                raw_value=18,
                            ),
                        ),
                    ),
                    SubField(
                        name='calorie_duration_alert',
                        def_num=3,
                        type=BASE_TYPES[0x86],  # uint32
                        units='calories',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='calorie_duration_alert',
                                raw_value=25,
                            ),
                        ),
                    ),
                    SubField(
                        name='course_point_index',
                        def_num=3,
                        type=FIELD_TYPES['message_index'],
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='course_point',
                                raw_value=10,
                            ),
                        ),
                    ),
                    SubField(
                        name='distance_duration_alert',
                        def_num=3,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=100,
                        units='m',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='distance_duration_alert',
                                raw_value=24,
                            ),
                        ),
                    ),
                    SubField(
                        name='fitness_equipment_state',
                        def_num=3,
                        type=FIELD_TYPES['fitness_equipment_state'],
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='fitness_equipment',
                                raw_value=27,
                            ),
                        ),
                    ),
                    SubField(
                        name='hr_high_alert',
                        def_num=3,
                        type=BASE_TYPES[0x02],  # uint8
                        units='bpm',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='hr_high_alert',
                                raw_value=13,
                            ),
                        ),
                    ),
                    SubField(
                        name='hr_low_alert',
                        def_num=3,
                        type=BASE_TYPES[0x02],  # uint8
                        units='bpm',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='hr_low_alert',
                                raw_value=14,
                            ),
                        ),
                    ),
                    SubField(
                        name='power_high_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        units='watts',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='power_high_alert',
                                raw_value=19,
                            ),
                        ),
                    ),
                    SubField(
                        name='power_low_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        units='watts',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='power_low_alert',
                                raw_value=20,
                            ),
                        ),
                    ),
                    SubField(
                        name='speed_high_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        scale=1000,
                        units='m/s',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='speed_high_alert',
                                raw_value=15,
                            ),
                        ),
                    ),
                    SubField(
                        name='speed_low_alert',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        scale=1000,
                        units='m/s',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='speed_low_alert',
                                raw_value=16,
                            ),
                        ),
                    ),
                    SubField(
                        name='time_duration_alert',
                        def_num=3,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=1000,
                        units='s',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='time_duration_alert',
                                raw_value=23,
                            ),
                        ),
                    ),
                    SubField(
                        name='timer_trigger',
                        def_num=3,
                        type=FIELD_TYPES['timer_trigger'],
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='timer',
                                raw_value=0,
                            ),
                        ),
                    ),
                    SubField(
                        name='virtual_partner_speed',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        scale=1000,
                        units='m/s',
                        ref_fields=(
                            ReferenceField(
                                name='event',
                                def_num=0,
                                value='virtual_partner_pace',
                                raw_value=12,
                            ),
                        ),
                    ),
                ),
            ),
            4: Field(
                name='event_group',
                type=BASE_TYPES[0x02],  # uint8
                def_num=4,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),
    23: MessageType(
        name='device_info',
        mesg_num=23,
        fields={
            0: Field(
                name='device_index',
                type=FIELD_TYPES['device_index'],
                def_num=0,
            ),
            1: Field(
                name='device_type',
                type=FIELD_TYPES['device_type'],
                def_num=1,
            ),
            2: Field(
                name='manufacturer',
                type=FIELD_TYPES['manufacturer'],
                def_num=2,
            ),
            3: Field(
                name='serial_number',
                type=BASE_TYPES[0x8C],  # uint32z
                def_num=3,
            ),
            4: Field(
                name='product',
                type=BASE_TYPES[0x84],  # uint16
                def_num=4,
            ),
            5: Field(
                name='software_version',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
                scale=100,
            ),
            6: Field(
                name='hardware_version',
                type=BASE_TYPES[0x02],  # uint8
                def_num=6,
            ),
            7: Field(  # Reset by new battery or charge.
                name='cum_operating_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=7,
                units='s',
            ),
            10: Field(
                name='battery_voltage',
                type=BASE_TYPES[0x84],  # uint16
                def_num=10,
                scale=256,
                units='V',
            ),
            11: Field(
                name='battery_status',
                type=FIELD_TYPES['battery_status'],
                def_num=11,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),
    34: MessageType(
        name='activity',
        mesg_num=34,
        fields={
            0: Field(  # Exclude pauses
                name='total_timer_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=0,
                scale=1000,
                units='s',
            ),
            1: Field(
                name='num_sessions',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
            ),
            2: Field(
                name='type',
                type=FIELD_TYPES['activity'],
                def_num=2,
            ),
            3: Field(
                name='event',
                type=FIELD_TYPES['event'],
                def_num=3,
            ),
            4: Field(
                name='event_type',
                type=FIELD_TYPES['event_type'],
                def_num=4,
            ),
            5: Field(  # Use to convert activity timestamps to local time if device does not support time zone and daylight savings time correction.
                name='local_timestamp',
                type=FIELD_TYPES['local_date_time'],
                def_num=5,
            ),
            6: Field(
                name='event_group',
                type=BASE_TYPES[0x02],  # uint8
                def_num=6,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),
    78: MessageType(  # Heart rate variability
        name='hrv',
        mesg_num=78,
        fields={
            0: Field(  # Time between beats
                name='time',
                type=BASE_TYPES[0x84],  # uint16
                def_num=0,
                scale=1000,
                units='s',
            ),
        },
    ),
    101: MessageType(
        name='length',
        mesg_num=101,
        fields={
            0: Field(
                name='event',
                type=FIELD_TYPES['event'],
                def_num=0,
            ),
            1: Field(
                name='event_type',
                type=FIELD_TYPES['event_type'],
                def_num=1,
            ),
            2: Field(
                name='start_time',
                type=FIELD_TYPES['date_time'],
                def_num=2,
            ),
            3: Field(
                name='total_elapsed_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=3,
                scale=1000,
                units='s',
            ),
            4: Field(
                name='total_timer_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                scale=1000,
                units='s',
            ),
            5: Field(
                name='total_strokes',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
                units='strokes',
            ),
            6: Field(
                name='avg_speed',
                type=BASE_TYPES[0x84],  # uint16
                def_num=6,
                scale=1000,
                units='m/s',
            ),
            7: Field(
                name='swim_stroke',
                type=FIELD_TYPES['swim_stroke'],
                def_num=7,
                units='swim_stroke',
            ),
            9: Field(
                name='avg_swimming_cadence',
                type=BASE_TYPES[0x02],  # uint8
                def_num=9,
                units='strokes/min',
            ),
            10: Field(
                name='event_group',
                type=BASE_TYPES[0x02],  # uint8
                def_num=10,
            ),
            11: Field(
                name='total_calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=11,
                units='kcal',
            ),
            12: Field(
                name='length_type',
                type=FIELD_TYPES['length_type'],
                def_num=12,
            ),
            253: FIELD_TYPE_TIMESTAMP,
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ###################### Blood Pressure File Messages ######################
    51: MessageType(
        name='blood_pressure',
        mesg_num=51,
        fields={
            0: Field(
                name='systolic_pressure',
                type=BASE_TYPES[0x84],  # uint16
                def_num=0,
                units='mmHg',
            ),
            1: Field(
                name='diastolic_pressure',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                units='mmHg',
            ),
            2: Field(
                name='mean_arterial_pressure',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                units='mmHg',
            ),
            3: Field(
                name='map_3_sample_mean',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
                units='mmHg',
            ),
            4: Field(
                name='map_morning_values',
                type=BASE_TYPES[0x84],  # uint16
                def_num=4,
                units='mmHg',
            ),
            5: Field(
                name='map_evening_values',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
                units='mmHg',
            ),
            6: Field(
                name='heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=6,
                units='bpm',
            ),
            7: Field(
                name='heart_rate_type',
                type=FIELD_TYPES['hr_type'],
                def_num=7,
            ),
            8: Field(
                name='status',
                type=FIELD_TYPES['bp_status'],
                def_num=8,
            ),
            9: Field(  # Associates this blood pressure message to a user.  This corresponds to the index of the user profile message in the blood pressure file.
                name='user_profile_index',
                type=FIELD_TYPES['message_index'],
                def_num=9,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),


    ########################## Course File Messages ##########################
    31: MessageType(
        name='course',
        mesg_num=31,
        fields={
            4: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=4,
            ),
            5: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=5,
            ),
            6: Field(
                name='capabilities',
                type=FIELD_TYPES['course_capabilities'],
                def_num=6,
            ),
        },
    ),
    32: MessageType(
        name='course_point',
        mesg_num=32,
        fields={
            1: Field(
                name='timestamp',
                type=FIELD_TYPES['date_time'],
                def_num=1,
            ),
            2: Field(
                name='position_lat',
                type=BASE_TYPES[0x85],  # sint32
                def_num=2,
                units='semicircles',
            ),
            3: Field(
                name='position_long',
                type=BASE_TYPES[0x85],  # sint32
                def_num=3,
                units='semicircles',
            ),
            4: Field(
                name='distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                scale=100,
                units='m',
            ),
            5: Field(
                name='type',
                type=FIELD_TYPES['course_point'],
                def_num=5,
            ),
            6: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=6,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ########################## Device File Messages ##########################
    1: MessageType(
        name='capabilities',
        mesg_num=1,
        fields={
            0: Field(  # Use language_bits_x types where x is index of array.
                name='languages',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=0,
            ),
            1: Field(  # Use sport_bits_x types where x is index of array.
                name='sports',
                type=FIELD_TYPES['sport_bits_0'],
                def_num=1,
            ),
            21: Field(
                name='workouts_supported',
                type=FIELD_TYPES['workout_capabilities'],
                def_num=21,
            ),
        },
    ),
    35: MessageType(
        name='software',
        mesg_num=35,
        fields={
            0: Field(
                name='manufacturer',
                type=FIELD_TYPES['manufacturer'],
                def_num=0,
            ),
            1: Field(
                name='product',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                subfields=(
                    SubField(
                        name='garmin_product',
                        def_num=1,
                        type=FIELD_TYPES['garmin_product'],
                        ref_fields=(
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='garmin',
                                raw_value=1,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='dynastream',
                                raw_value=15,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='dynastream_oem',
                                raw_value=13,
                            ),
                        ),
                    ),
                ),
            ),
            3: Field(
                name='version',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
                scale=100,
            ),
            5: Field(
                name='part_number',
                type=BASE_TYPES[0x07],  # string
                def_num=5,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    37: MessageType(
        name='file_capabilities',
        mesg_num=37,
        fields={
            0: Field(
                name='type',
                type=FIELD_TYPES['file'],
                def_num=0,
            ),
            1: Field(
                name='flags',
                type=FIELD_TYPES['file_flags'],
                def_num=1,
            ),
            2: Field(
                name='directory',
                type=BASE_TYPES[0x07],  # string
                def_num=2,
            ),
            3: Field(
                name='max_count',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
            ),
            4: Field(
                name='max_size',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                units='bytes',
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    38: MessageType(
        name='mesg_capabilities',
        mesg_num=38,
        fields={
            0: Field(
                name='file',
                type=FIELD_TYPES['file'],
                def_num=0,
            ),
            1: Field(
                name='mesg_num',
                type=FIELD_TYPES['mesg_num'],
                def_num=1,
            ),
            2: Field(
                name='count_type',
                type=FIELD_TYPES['mesg_count'],
                def_num=2,
            ),
            3: Field(
                name='count',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
                subfields=(
                    SubField(
                        name='max_per_file',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        ref_fields=(
                            ReferenceField(
                                name='count_type',
                                def_num=2,
                                value='max_per_file',
                                raw_value=1,
                            ),
                        ),
                    ),
                    SubField(
                        name='max_per_file_type',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        ref_fields=(
                            ReferenceField(
                                name='count_type',
                                def_num=2,
                                value='max_per_file_type',
                                raw_value=2,
                            ),
                        ),
                    ),
                    SubField(
                        name='num_per_file',
                        def_num=3,
                        type=BASE_TYPES[0x84],  # uint16
                        ref_fields=(
                            ReferenceField(
                                name='count_type',
                                def_num=2,
                                value='num_per_file',
                                raw_value=0,
                            ),
                        ),
                    ),
                ),
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    39: MessageType(
        name='field_capabilities',
        mesg_num=39,
        fields={
            0: Field(
                name='file',
                type=FIELD_TYPES['file'],
                def_num=0,
            ),
            1: Field(
                name='mesg_num',
                type=FIELD_TYPES['mesg_num'],
                def_num=1,
            ),
            2: Field(
                name='field_num',
                type=BASE_TYPES[0x02],  # uint8
                def_num=2,
            ),
            3: Field(
                name='count',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ########################## Goals File Messages ###########################
    15: MessageType(
        name='goal',
        mesg_num=15,
        fields={
            0: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=0,
            ),
            1: Field(
                name='sub_sport',
                type=FIELD_TYPES['sub_sport'],
                def_num=1,
            ),
            2: Field(
                name='start_date',
                type=FIELD_TYPES['date_time'],
                def_num=2,
            ),
            3: Field(
                name='end_date',
                type=FIELD_TYPES['date_time'],
                def_num=3,
            ),
            4: Field(
                name='type',
                type=FIELD_TYPES['goal'],
                def_num=4,
            ),
            5: Field(
                name='value',
                type=BASE_TYPES[0x86],  # uint32
                def_num=5,
            ),
            6: Field(
                name='repeat',
                type=FIELD_TYPES['bool'],
                def_num=6,
            ),
            7: Field(
                name='target_value',
                type=BASE_TYPES[0x86],  # uint32
                def_num=7,
            ),
            8: Field(
                name='recurrence',
                type=FIELD_TYPES['goal_recurrence'],
                def_num=8,
            ),
            9: Field(
                name='recurrence_value',
                type=BASE_TYPES[0x84],  # uint16
                def_num=9,
            ),
            10: Field(
                name='enabled',
                type=FIELD_TYPES['bool'],
                def_num=10,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ######################## Monitoring File Messages ########################
    55: MessageType(
        name='monitoring',
        mesg_num=55,
        fields={
            0: Field(  # Associates this data to device_info message.  Not required for file with single device (sensor).
                name='device_index',
                type=FIELD_TYPES['device_index'],
                def_num=0,
            ),
            1: Field(
                name='calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                units='kcal',
            ),
            2: Field(
                name='distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=2,
                scale=100,
                units='m',
            ),
            3: Field(
                name='cycles',
                type=BASE_TYPES[0x86],  # uint32
                def_num=3,
                units='cycles',
            ),
            4: Field(
                name='active_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                scale=1000,
                units='s',
            ),
            5: Field(
                name='activity_type',
                type=FIELD_TYPES['activity_type'],
                def_num=5,
            ),
            6: Field(
                name='activity_subtype',
                type=FIELD_TYPES['activity_subtype'],
                def_num=6,
            ),
            8: Field(
                name='compressed_distance',
                type=BASE_TYPES[0x84],  # uint16
                def_num=8,
                components=(
                    ComponentField(
                        name='distance',
                        def_num=2,
                        scale=100,
                        units='m',
                        accumulate=True,
                        bits=16,
                        bit_offset=0,
                    ),
                ),
            ),
            9: Field(
                name='compressed_cycles',
                type=BASE_TYPES[0x84],  # uint16
                def_num=9,
                components=(
                    ComponentField(
                        name='cycles',
                        def_num=3,
                        units='cycles',
                        accumulate=True,
                        bits=16,
                        bit_offset=0,
                    ),
                ),
            ),
            10: Field(
                name='compressed_active_time',
                type=BASE_TYPES[0x84],  # uint16
                def_num=10,
                components=(
                    ComponentField(
                        name='active_time',
                        def_num=4,
                        units='s',
                        accumulate=True,
                        bits=16,
                        bit_offset=0,
                    ),
                ),
            ),
            11: Field(  # Must align to logging interval, for example, time must be 00:00:00 for daily log.
                name='local_timestamp',
                type=FIELD_TYPES['local_date_time'],
                def_num=11,
            ),
            253: FIELD_TYPE_TIMESTAMP,  # Must align to logging interval, for example, time must be 00:00:00 for daily log.
        },
    ),
    103: MessageType(
        name='monitoring_info',
        mesg_num=103,
        fields={
            0: Field(  # Use to convert activity timestamps to local time if device does not support time zone and daylight savings time correction.
                name='local_timestamp',
                type=FIELD_TYPES['local_date_time'],
                def_num=0,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),


    ######################### Schedule File Messages #########################
    28: MessageType(
        name='schedule',
        mesg_num=28,
        fields={
            0: Field(  # Corresponds to file_id of scheduled workout / course.
                name='manufacturer',
                type=FIELD_TYPES['manufacturer'],
                def_num=0,
            ),
            1: Field(  # Corresponds to file_id of scheduled workout / course.
                name='product',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                subfields=(
                    SubField(
                        name='garmin_product',
                        def_num=1,
                        type=FIELD_TYPES['garmin_product'],
                        ref_fields=(
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='garmin',
                                raw_value=1,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='dynastream',
                                raw_value=15,
                            ),
                            ReferenceField(
                                name='manufacturer',
                                def_num=0,
                                value='dynastream_oem',
                                raw_value=13,
                            ),
                        ),
                    ),
                ),
            ),
            2: Field(  # Corresponds to file_id of scheduled workout / course.
                name='serial_number',
                type=BASE_TYPES[0x8C],  # uint32z
                def_num=2,
            ),
            3: Field(  # Corresponds to file_id of scheduled workout / course.
                name='time_created',
                type=FIELD_TYPES['date_time'],
                def_num=3,
            ),
            4: Field(  # TRUE if this activity has been started
                name='completed',
                type=FIELD_TYPES['bool'],
                def_num=4,
            ),
            5: Field(
                name='type',
                type=FIELD_TYPES['schedule'],
                def_num=5,
            ),
            6: Field(
                name='scheduled_time',
                type=FIELD_TYPES['local_date_time'],
                def_num=6,
            ),
        },
    ),


    ######################### Settings File Messages #########################
    2: MessageType(
        name='device_settings',
        mesg_num=2,
        fields={
            1: Field(  # Offset from system time. Required to convert timestamp from system time to UTC.
                name='utc_offset',
                type=BASE_TYPES[0x86],  # uint32
                def_num=1,
            ),
        },
    ),
    3: MessageType(
        name='user_profile',
        mesg_num=3,
        fields={
            0: Field(
                name='friendly_name',
                type=BASE_TYPES[0x07],  # string
                def_num=0,
            ),
            1: Field(
                name='gender',
                type=FIELD_TYPES['gender'],
                def_num=1,
            ),
            2: Field(
                name='age',
                type=BASE_TYPES[0x02],  # uint8
                def_num=2,
                units='years',
            ),
            3: Field(
                name='height',
                type=BASE_TYPES[0x02],  # uint8
                def_num=3,
                scale=100,
                units='m',
            ),
            4: Field(
                name='weight',
                type=BASE_TYPES[0x84],  # uint16
                def_num=4,
                scale=10,
                units='kg',
            ),
            5: Field(
                name='language',
                type=FIELD_TYPES['language'],
                def_num=5,
            ),
            6: Field(
                name='elev_setting',
                type=FIELD_TYPES['display_measure'],
                def_num=6,
            ),
            7: Field(
                name='weight_setting',
                type=FIELD_TYPES['display_measure'],
                def_num=7,
            ),
            8: Field(
                name='resting_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=8,
                units='bpm',
            ),
            9: Field(
                name='default_max_running_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=9,
                units='bpm',
            ),
            10: Field(
                name='default_max_biking_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=10,
                units='bpm',
            ),
            11: Field(
                name='default_max_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=11,
                units='bpm',
            ),
            12: Field(
                name='hr_setting',
                type=FIELD_TYPES['display_heart'],
                def_num=12,
            ),
            13: Field(
                name='speed_setting',
                type=FIELD_TYPES['display_measure'],
                def_num=13,
            ),
            14: Field(
                name='dist_setting',
                type=FIELD_TYPES['display_measure'],
                def_num=14,
            ),
            16: Field(
                name='power_setting',
                type=FIELD_TYPES['display_power'],
                def_num=16,
            ),
            17: Field(
                name='activity_class',
                type=FIELD_TYPES['activity_class'],
                def_num=17,
            ),
            18: Field(
                name='position_setting',
                type=FIELD_TYPES['display_position'],
                def_num=18,
            ),
            21: Field(
                name='temperature_setting',
                type=FIELD_TYPES['display_measure'],
                def_num=21,
            ),
            22: Field(
                name='local_id',
                type=FIELD_TYPES['user_local_id'],
                def_num=22,
            ),
            23: Field(
                name='global_id',
                type=BASE_TYPES[0x0D],  # byte
                def_num=23,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    4: MessageType(
        name='hrm_profile',
        mesg_num=4,
        fields={
            0: Field(
                name='enabled',
                type=FIELD_TYPES['bool'],
                def_num=0,
            ),
            1: Field(
                name='hrm_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=1,
            ),
            2: Field(
                name='log_hrv',
                type=FIELD_TYPES['bool'],
                def_num=2,
            ),
            3: Field(
                name='hrm_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=3,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    5: MessageType(
        name='sdm_profile',
        mesg_num=5,
        fields={
            0: Field(
                name='enabled',
                type=FIELD_TYPES['bool'],
                def_num=0,
            ),
            1: Field(
                name='sdm_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=1,
            ),
            2: Field(
                name='sdm_cal_factor',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                scale=10,
                units='%',
            ),
            3: Field(
                name='odometer',
                type=BASE_TYPES[0x86],  # uint32
                def_num=3,
                scale=100,
                units='m',
            ),
            4: Field(  # Use footpod for speed source instead of GPS
                name='speed_source',
                type=FIELD_TYPES['bool'],
                def_num=4,
            ),
            5: Field(
                name='sdm_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=5,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    6: MessageType(
        name='bike_profile',
        mesg_num=6,
        fields={
            0: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=0,
            ),
            1: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=1,
            ),
            2: Field(
                name='sub_sport',
                type=FIELD_TYPES['sub_sport'],
                def_num=2,
            ),
            3: Field(
                name='odometer',
                type=BASE_TYPES[0x86],  # uint32
                def_num=3,
                scale=100,
                units='m',
            ),
            4: Field(
                name='bike_spd_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=4,
            ),
            5: Field(
                name='bike_cad_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=5,
            ),
            6: Field(
                name='bike_spdcad_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=6,
            ),
            7: Field(
                name='bike_power_ant_id',
                type=BASE_TYPES[0x8B],  # uint16z
                def_num=7,
            ),
            8: Field(
                name='custom_wheelsize',
                type=BASE_TYPES[0x84],  # uint16
                def_num=8,
                scale=1000,
                units='m',
            ),
            9: Field(
                name='auto_wheelsize',
                type=BASE_TYPES[0x84],  # uint16
                def_num=9,
                scale=1000,
                units='m',
            ),
            10: Field(
                name='bike_weight',
                type=BASE_TYPES[0x84],  # uint16
                def_num=10,
                scale=10,
                units='kg',
            ),
            11: Field(
                name='power_cal_factor',
                type=BASE_TYPES[0x84],  # uint16
                def_num=11,
                scale=10,
                units='%',
            ),
            12: Field(
                name='auto_wheel_cal',
                type=FIELD_TYPES['bool'],
                def_num=12,
            ),
            13: Field(
                name='auto_power_zero',
                type=FIELD_TYPES['bool'],
                def_num=13,
            ),
            14: Field(
                name='id',
                type=BASE_TYPES[0x02],  # uint8
                def_num=14,
            ),
            15: Field(
                name='spd_enabled',
                type=FIELD_TYPES['bool'],
                def_num=15,
            ),
            16: Field(
                name='cad_enabled',
                type=FIELD_TYPES['bool'],
                def_num=16,
            ),
            17: Field(
                name='spdcad_enabled',
                type=FIELD_TYPES['bool'],
                def_num=17,
            ),
            18: Field(
                name='power_enabled',
                type=FIELD_TYPES['bool'],
                def_num=18,
            ),
            19: Field(
                name='crank_length',
                type=BASE_TYPES[0x02],  # uint8
                def_num=19,
                scale=2,
                offset=-110,
                units='mm',
            ),
            20: Field(
                name='enabled',
                type=FIELD_TYPES['bool'],
                def_num=20,
            ),
            21: Field(
                name='bike_spd_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=21,
            ),
            22: Field(
                name='bike_cad_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=22,
            ),
            23: Field(
                name='bike_spdcad_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=23,
            ),
            24: Field(
                name='bike_power_ant_id_trans_type',
                type=BASE_TYPES[0x0A],  # uint8z
                def_num=24,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ###################### Sport Settings File Messages ######################
    7: MessageType(
        name='zones_target',
        mesg_num=7,
        fields={
            1: Field(
                name='max_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=1,
            ),
            2: Field(
                name='threshold_heart_rate',
                type=BASE_TYPES[0x02],  # uint8
                def_num=2,
            ),
            3: Field(
                name='functional_threshold_power',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
            ),
            5: Field(
                name='hr_calc_type',
                type=FIELD_TYPES['hr_zone_calc'],
                def_num=5,
            ),
            7: Field(
                name='pwr_calc_type',
                type=FIELD_TYPES['pwr_zone_calc'],
                def_num=7,
            ),
        },
    ),
    8: MessageType(
        name='hr_zone',
        mesg_num=8,
        fields={
            1: Field(
                name='high_bpm',
                type=BASE_TYPES[0x02],  # uint8
                def_num=1,
                units='bpm',
            ),
            2: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=2,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    9: MessageType(
        name='power_zone',
        mesg_num=9,
        fields={
            1: Field(
                name='high_value',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                units='watts',
            ),
            2: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=2,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    10: MessageType(
        name='met_zone',
        mesg_num=10,
        fields={
            1: Field(
                name='high_bpm',
                type=BASE_TYPES[0x02],  # uint8
                def_num=1,
            ),
            2: Field(
                name='calories',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                scale=10,
                units='kcal/min',
            ),
            3: Field(
                name='fat_calories',
                type=BASE_TYPES[0x02],  # uint8
                def_num=3,
                scale=10,
                units='kcal/min',
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    12: MessageType(
        name='sport',
        mesg_num=12,
        fields={
            0: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=0,
            ),
            1: Field(
                name='sub_sport',
                type=FIELD_TYPES['sub_sport'],
                def_num=1,
            ),
            3: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=3,
            ),
        },
    ),
    53: MessageType(
        name='speed_zone',
        mesg_num=53,
        fields={
            0: Field(
                name='high_value',
                type=BASE_TYPES[0x84],  # uint16
                def_num=0,
                scale=1000,
                units='m/s',
            ),
            1: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=1,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
    131: MessageType(
        name='cadence_zone',
        mesg_num=131,
        fields={
            0: Field(
                name='high_value',
                type=BASE_TYPES[0x02],  # uint8
                def_num=0,
                units='rpm',
            ),
            1: Field(
                name='name',
                type=BASE_TYPES[0x07],  # string
                def_num=1,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ########################## Totals File Messages ##########################
    33: MessageType(
        name='totals',
        mesg_num=33,
        fields={
            0: Field(  # Excludes pauses
                name='timer_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=0,
                units='s',
            ),
            1: Field(
                name='distance',
                type=BASE_TYPES[0x86],  # uint32
                def_num=1,
                units='m',
            ),
            2: Field(
                name='calories',
                type=BASE_TYPES[0x86],  # uint32
                def_num=2,
                units='kcal',
            ),
            3: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=3,
            ),
            4: Field(  # Includes pauses
                name='elapsed_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                units='s',
            ),
            5: Field(
                name='sessions',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
            ),
            6: Field(
                name='active_time',
                type=BASE_TYPES[0x86],  # uint32
                def_num=6,
                units='s',
            ),
            253: FIELD_TYPE_TIMESTAMP,
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),


    ####################### Weight Scale File Messages #######################
    30: MessageType(
        name='weight_scale',
        mesg_num=30,
        fields={
            0: Field(
                name='weight',
                type=FIELD_TYPES['weight'],
                def_num=0,
                scale=100,
                units='kg',
            ),
            1: Field(
                name='percent_fat',
                type=BASE_TYPES[0x84],  # uint16
                def_num=1,
                scale=100,
                units='%',
            ),
            2: Field(
                name='percent_hydration',
                type=BASE_TYPES[0x84],  # uint16
                def_num=2,
                scale=100,
                units='%',
            ),
            3: Field(
                name='visceral_fat_mass',
                type=BASE_TYPES[0x84],  # uint16
                def_num=3,
                scale=100,
                units='kg',
            ),
            4: Field(
                name='bone_mass',
                type=BASE_TYPES[0x84],  # uint16
                def_num=4,
                scale=100,
                units='kg',
            ),
            5: Field(
                name='muscle_mass',
                type=BASE_TYPES[0x84],  # uint16
                def_num=5,
                scale=100,
                units='kg',
            ),
            7: Field(
                name='basal_met',
                type=BASE_TYPES[0x84],  # uint16
                def_num=7,
                scale=4,
                units='kcal/day',
            ),
            8: Field(
                name='physique_rating',
                type=BASE_TYPES[0x02],  # uint8
                def_num=8,
            ),
            9: Field(  # ~4kJ per kcal, 0.25 allows max 16384 kcal
                name='active_met',
                type=BASE_TYPES[0x84],  # uint16
                def_num=9,
                scale=4,
                units='kcal/day',
            ),
            10: Field(
                name='metabolic_age',
                type=BASE_TYPES[0x02],  # uint8
                def_num=10,
                units='years',
            ),
            11: Field(
                name='visceral_fat_rating',
                type=BASE_TYPES[0x02],  # uint8
                def_num=11,
            ),
            12: Field(  # Associates this weight scale message to a user.  This corresponds to the index of the user profile message in the weight scale file.
                name='user_profile_index',
                type=FIELD_TYPES['message_index'],
                def_num=12,
            ),
            253: FIELD_TYPE_TIMESTAMP,
        },
    ),


    ######################### Workout File Messages ##########################
    26: MessageType(
        name='workout',
        mesg_num=26,
        fields={
            4: Field(
                name='sport',
                type=FIELD_TYPES['sport'],
                def_num=4,
            ),
            5: Field(
                name='capabilities',
                type=FIELD_TYPES['workout_capabilities'],
                def_num=5,
            ),
            6: Field(  # number of valid steps
                name='num_valid_steps',
                type=BASE_TYPES[0x84],  # uint16
                def_num=6,
            ),
            8: Field(
                name='wkt_name',
                type=BASE_TYPES[0x07],  # string
                def_num=8,
            ),
        },
    ),
    27: MessageType(
        name='workout_step',
        mesg_num=27,
        fields={
            0: Field(
                name='wkt_step_name',
                type=BASE_TYPES[0x07],  # string
                def_num=0,
            ),
            1: Field(
                name='duration_type',
                type=FIELD_TYPES['wkt_step_duration'],
                def_num=1,
            ),
            2: Field(
                name='duration_value',
                type=BASE_TYPES[0x86],  # uint32
                def_num=2,
                subfields=(
                    SubField(
                        name='duration_calories',
                        def_num=2,
                        type=BASE_TYPES[0x86],  # uint32
                        units='calories',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='calories',
                                raw_value=4,
                            ),
                        ),
                    ),
                    SubField(
                        name='duration_distance',
                        def_num=2,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=100,
                        units='m',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='distance',
                                raw_value=1,
                            ),
                        ),
                    ),
                    SubField(
                        name='duration_hr',
                        def_num=2,
                        type=FIELD_TYPES['workout_hr'],
                        units='% or bpm',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='hr_less_than',
                                raw_value=2,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='hr_greater_than',
                                raw_value=3,
                            ),
                        ),
                    ),
                    SubField(
                        name='duration_power',
                        def_num=2,
                        type=FIELD_TYPES['workout_power'],
                        units='% or watts',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='power_less_than',
                                raw_value=14,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='power_greater_than',
                                raw_value=15,
                            ),
                        ),
                    ),
                    SubField(  # message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.
                        name='duration_step',
                        def_num=2,
                        type=BASE_TYPES[0x86],  # uint32
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_steps_cmplt',
                                raw_value=6,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_time',
                                raw_value=7,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_distance',
                                raw_value=8,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_calories',
                                raw_value=9,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_hr_less_than',
                                raw_value=10,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_hr_greater_than',
                                raw_value=11,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_power_less_than',
                                raw_value=12,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_power_greater_than',
                                raw_value=13,
                            ),
                        ),
                    ),
                    SubField(
                        name='duration_time',
                        def_num=2,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=1000,
                        units='s',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='time',
                                raw_value=0,
                            ),
                        ),
                    ),
                ),
            ),
            3: Field(
                name='target_type',
                type=FIELD_TYPES['wkt_step_target'],
                def_num=3,
            ),
            4: Field(
                name='target_value',
                type=BASE_TYPES[0x86],  # uint32
                def_num=4,
                subfields=(
                    SubField(
                        name='repeat_calories',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        units='calories',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_calories',
                                raw_value=9,
                            ),
                        ),
                    ),
                    SubField(
                        name='repeat_distance',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=100,
                        units='m',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_distance',
                                raw_value=8,
                            ),
                        ),
                    ),
                    SubField(
                        name='repeat_hr',
                        def_num=4,
                        type=FIELD_TYPES['workout_hr'],
                        units='% or bpm',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_hr_less_than',
                                raw_value=10,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_hr_greater_than',
                                raw_value=11,
                            ),
                        ),
                    ),
                    SubField(
                        name='repeat_power',
                        def_num=4,
                        type=FIELD_TYPES['workout_power'],
                        units='% or watts',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_power_less_than',
                                raw_value=12,
                            ),
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_power_greater_than',
                                raw_value=13,
                            ),
                        ),
                    ),
                    SubField(  # # of repetitions
                        name='repeat_steps',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_steps_cmplt',
                                raw_value=6,
                            ),
                        ),
                    ),
                    SubField(
                        name='repeat_time',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=1000,
                        units='s',
                        ref_fields=(
                            ReferenceField(
                                name='duration_type',
                                def_num=1,
                                value='repeat_until_time',
                                raw_value=7,
                            ),
                        ),
                    ),
                    SubField(  # hr zone (1-5);Custom =0;
                        name='target_hr_zone',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='heart_rate',
                                raw_value=1,
                            ),
                        ),
                    ),
                    SubField(  # Power Zone ( 1-7); Custom = 0;
                        name='target_power_zone',
                        def_num=4,
                        type=BASE_TYPES[0x86],  # uint32
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='power',
                                raw_value=4,
                            ),
                        ),
                    ),
                ),
            ),
            5: Field(
                name='custom_target_value_low',
                type=BASE_TYPES[0x86],  # uint32
                def_num=5,
                subfields=(
                    SubField(
                        name='custom_target_cadence_low',
                        def_num=5,
                        type=BASE_TYPES[0x86],  # uint32
                        units='rpm',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='cadence',
                                raw_value=3,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_heart_rate_low',
                        def_num=5,
                        type=FIELD_TYPES['workout_hr'],
                        units='% or bpm',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='heart_rate',
                                raw_value=1,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_power_low',
                        def_num=5,
                        type=FIELD_TYPES['workout_power'],
                        units='% or watts',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='power',
                                raw_value=4,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_speed_low',
                        def_num=5,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=1000,
                        units='m/s',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='speed',
                                raw_value=0,
                            ),
                        ),
                    ),
                ),
            ),
            6: Field(
                name='custom_target_value_high',
                type=BASE_TYPES[0x86],  # uint32
                def_num=6,
                subfields=(
                    SubField(
                        name='custom_target_cadence_high',
                        def_num=6,
                        type=BASE_TYPES[0x86],  # uint32
                        units='rpm',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='cadence',
                                raw_value=3,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_heart_rate_high',
                        def_num=6,
                        type=FIELD_TYPES['workout_hr'],
                        units='% or bpm',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='heart_rate',
                                raw_value=1,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_power_high',
                        def_num=6,
                        type=FIELD_TYPES['workout_power'],
                        units='% or watts',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='power',
                                raw_value=4,
                            ),
                        ),
                    ),
                    SubField(
                        name='custom_target_speed_high',
                        def_num=6,
                        type=BASE_TYPES[0x86],  # uint32
                        scale=1000,
                        units='m/s',
                        ref_fields=(
                            ReferenceField(
                                name='target_type',
                                def_num=3,
                                value='speed',
                                raw_value=0,
                            ),
                        ),
                    ),
                ),
            ),
            7: Field(
                name='intensity',
                type=FIELD_TYPES['intensity'],
                def_num=7,
            ),
            254: Field(
                name='message_index',
                type=FIELD_TYPES['message_index'],
                def_num=254,
            ),
        },
    ),
}
