"""
  >>> from five.megrok.layout import ILayout
  >>> from five.megrok.layout.ftests.layout.layout import *
  >>> from zope.component import getMultiAdapter
  >>> from zope.publisher.browser import TestRequest

  >>> request = TestRequest()
  >>> mammoth = Mammoth()
  >>> mylayout = getMultiAdapter((request, mammoth), ILayout)
  >>> ILayout.providedBy(mylayout)
  True

  >>> mylayout.context
  <five.megrok.layout.ftests.layout.layout.Mammoth object at ...>

  >>> mylayout.render()
  '<div> MyLayout </div>'

  >>> elephant = Elephant()
  >>> mycontextlayout = getMultiAdapter((request, elephant), ILayout)
  >>> mycontextlayout.render()
  '<div> MyContextLayout </div>'
"""

from five import grok

from zope import interface
from five.megrok.layout import Layout


class Mammoth(grok.Context):
    pass


class Elephant(grok.Context):
    pass


class MyLayout(Layout):
    grok.context(interface.Interface)

    def render(self):
	return "<div> MyLayout </div>"


class MyContextLayout(Layout):
    grok.context(Elephant)

    def render(self):
	return "<div> MyContextLayout </div>"

