#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# Copyright 2014 Telefónica Investigación y Desarrollo, S.A.U
#
# This file is part of FI-WARE project.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
#
# You may obtain a copy of the License at:
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# For those usages not covered by the Apache version 2.0 License please
# contact with opensource@tid.es
#
__author__ = 'gjp'
import json


class information():

    def __init__(self, owner=None, windowsize=None, version=None, runningfrom=None, doc=None):
        self.owner = owner
        self.windowsize = windowsize
        self.version = version
        if runningfrom != None:
            self.runningfrom = runningfrom.strftime("%y/%m/%d %H:%M:%S")
        self.doc = doc

    def parse(self, d):
        """
        Convert from a dict to an information object.
        """
        try:
            self.windowsize = json.loads(d)['windowsize']
            return self
        except (ValueError, KeyError, TypeError):
            print ("error")
            return None

    def getVars(self):
        return vars(self)
