from flask.ext.wtf import Form


class ModelForm(Form):
    """A WTForms mongoengine model form"""

    def __init__(self, formdata=None, obj=None, prefix='', **kwargs):
        self.instance = (kwargs.pop('instance', None) or kwargs.get('obj', None))
        if self.instance and not formdata:
            obj = self.instance
        self.formdata = formdata
        super(ModelForm, self).__init__(formdata, obj, prefix, **kwargs)

    def save(self, commit=True, **kwargs):
        if self.instance:
            self.populate_obj(self.instance)
        else:
            self.instance = self.model_class(**self.data)

        if commit:
            self.instance.save(**kwargs)
        return self.instance
