from flask import Blueprint


class MarkupSet(object):
    def append(self, app, markup_set_name, templates=None):
        kwargs = {'static_folder':markup_set_name,
                  'static_url_path':app.static_url_path + '/' + markup_set_name}
        if templates:
            kwargs['template_folder']=templates

        blueprint = Blueprint(markup_set_name, __name__, **kwargs)
        app.register_blueprint(blueprint)

class AmpleMarkup(MarkupSet):
    name = 'ample'    
    def __init__(self, app, plugins=('rest',)):
        self.append(app, self.name, templates='templates')
        for plugin in plugins:
            self.append(app, plugin)
