(function(ample) {
    function restful(attrname, updaters, defaults) {
        if (_.isUndefined(defaults)){
            var defaults = {}
        }
        var ample = this
        cEvent = ample.classes.Event

        function getrefs(refs, node) {
            var noderefkeys = _.pairs(node.__proto__).map(function(nv) {
                var name = nv[0]
                var value = nv[1]
                if(_.isNull(value)) {
                    return name
                } else {
                    return null
                }
            })
            return _.extend(_.pick(node, _.without(noderefkeys, null)), refs)
        }

        function preserve_toprefs(node, refs) {
            if(_.isUndefined(refs)) {
                var refs = {}
            } else {
                _.keys(refs).map(function(name) {
                    if(_.isNull(node[name])) {
                        node[name] = refs[name]
                    }
                })
            }

            if(node.childNodes) {
                var noderefs = getrefs(refs, node)
                _.defer(function() {
                    _.map(node.childNodes, function(subnode) {
                        preserve_toprefs(subnode, noderefs)
                    })
                })
            }
        }

        function default_url_getter(node) {
            if(_.isString(node)) {
                return node
            } else {
                return node.attributes[attrname]
            }
        }

        function abort(node) {
            clearTimeout(node._rest)
            delete node._rest
            if(node._rest_ajax) {
                node._rest_ajax.abort()
                delete node._rest_ajax
            }
        }

        function RestContext(destinations, updater, settings) {
            var context = this
            if (_.isUndefined(settings)){
                var settings = {}
            }
            _.defaults(settings, defaults)

            function using(sources, getter) {
                if(_.isUndefined(getter)) {
                    var getter = default_url_getter
                }
                if(_.isString(sources)) {
                    context.urls = new Array(sources)
                    return context
                }
                if(_.has(sources, 'length')) {
                    context.urls = _.map(sources, getter).filter(function(n) {
                        return n
                    })
                    return context
                }                
                context.urls = new Array(getter(sources))
                return context
            }

            using(destinations)

            _.extend(this, {
                using: using,
                with: function(method, data, success) {

                    fns = _.functions(data)
                    if(fns.length) {
                        var data = _.clone(data)
                        try {
                            _.map(fns, function(name) {
                                data[name] = _.bind(data[name], context)()
                            })

                        } catch(err) {
                            if(err == 'cancel') {
                                return
                            }
                        }
                    }
                    _.zip(context.urls, destinations).map(function(url_dest) {
                        var url = url_dest[0]
                        var dest = url_dest[1]
                        if(dest._rest) {
                            abort(dest)
                        }
                        if(_.isUndefined(url) || _.isUndefined(dest)) {
                            return context
                        }

                        var oEvent = new cEvent;
                        oEvent.initEvent("unload", false, false);
                        dest.dispatchEvent(oEvent)
                        dest.$setPseudoClass('load', true)
                        dest._rest = _.defer(function() {
                            dest._rest_ajax = ample.ajax({
                                url: url,
                                type: method,
                                dataType: 'xml',
                                data: data || null,
                                headers: context.headers || null,
                                success: function(data, status, xhr) {
                                    var node = ample.importNode(data.documentElement, true)
                                    try {

                                        dest.$setPseudoClass('load', false)
                                        updater(node, dest)

                                    } finally {
                                        var oEvent = new cEvent;
                                        oEvent.initEvent("load", false, false);
                                        dest.dispatchEvent(oEvent)
                                        preserve_toprefs(dest)
                                        if(_.isFunction(success)) {
                                            success(context)
                                        }
                                        dest._rest = undefined
                                    }

                                }
                            })
                        })
                    })
                    return context
                }
            }, settings || {})
        }

        function rest(selection, updater, settings) {
            if(_.isUndefined(updater)) {
                var updater = updaters.DEFAULT
            }
            var items = ample.query(selection)
            return new RestContext(items, updater, settings)
        }

        function getselection(node, name) {
            if(_.isUndefined(name)) {
                name = 'selection'
            }
            var node = ample.query(node)
            if(node.length == 0) {
                return
            }
            var context = node.data(name)
            if(_.isUndefined(context)) {
                if(node[0].parentNode) {
                    return getselection(node[0].parentNode, name)
                }
            }
            return context
        }



        return _.extend(rest, {
            context: {
                set: function(store, getter, name) {
                    if(_.isUndefined(name)) {
                        name = 'selection'
                    }
                    ample.query(store).data(name, getter(ample.activeElement))
                },
                get: getselection
            },
        }, updaters)
    };

    
    var updaters = {
        APPEND: function(src, dest) {
            dest.appendChild(src)
        },
        REPLACE: function(src, dest) {
            $(dest).empty()
            _.defer(function() {
                _.keys(dest.attributes).map(function(name) {
                    delete dest.attributes[name]
                })
                _.keys(src.attributes).map(function(name) {
                    dest.attributes[name] = src.attributes[name]
                })
                while(src.firstChild) {
                    dest.appendChild(src.firstChild)
                }
            })
        },
    }
    updaters.DEFAULT = updaters.REPLACE

    ample.extend({
        restful: _.extend(_.bind(restful, ample), {UPDATERS:updaters})
    });
})(ample)