/*
rest.REPLACE
rest.INSERT
rest.APPEND
rest.DEFAULT = rest.REPLACE

rest($('#treechildren'), rest.INSERT).using([URLS]).with('GET')
rest($('#treechildren')).using([URLS]).with('PUT', {name:123})
rest($('#treechildren')).with('PUT', {name:123}) ==> rest($('#treechildren')).using($('#treechildren')).with('PUT', {name:123})
*/
describe('ample.rest', function() {
    var rest = ample.rest

    it('exists', function() {
        expect(rest).toEqual(jasmine.any(Object));
    });

    describe('.context', function() {
        it('exists', function() {
            expect(rest.context).toEqual(jasmine.any(Object));
        });

        describe('.push', function() {
            it('stores selection result to node.data["selection"]', function() {
                rest.context.push($('#menupopup'), function(activeElement) {
                    return $('#tree')
                })
                expect($('#menupopup').data('selection')).toEqual($('#tree'))
            });
        })

        describe('.pop', function() {
            it('retrieves context from parent.data["selection"]', function() {
                rest.context.push($('#menupopup'), function(activeElement) {
                    return $('#tree')
                })
                expect(rest.context.pop($('#menuitem'))).toEqual($('#tree'))
            });
        })

    });
    describe('.append()', function() {
        it('callable', function() {
            expect(rest.replace($('#label')).get).toEqual(jasmine.any(Function));
        });

        it('appends to node with new loaded xml', function() {
            runs(function(){
                $('#root-treechildren')[0].attributes.url = '/root-ajax-container-treeitem'
                rest.append($('#root-treechildren')).get()                
            })
            // waitsFor(function(){
            // }, 750);
        });

    })
    describe('.replace()', function() {
        it('callable', function() {
            expect(rest.replace($('#label')).get).toEqual(jasmine.any(Function));
        });

        it('replaces node with new loaded xml', function() {
            waitsFor(function() {
                rest.replace($('#vbox-replaced')).get()
                return $('#sublabel')[0].attributes.value == 'updated sublabel'
            }, 'loads new content', 750)
        });
        it('works with treechildren', function() {
            runs(function() {
                rest.replace($('#root-treechildren')).get()
            })
            waitsFor(function() {
                return $('#root-treechildren')[0].items[0].row.cells[0].attributes.label == 'the updated 1'
            }, 750)
            runs(function() {
                rest.replace($('#container-treechildren')).get()
            })
            waitsFor(function() {
                if($('#container-treechildren')[0].items.length) {
                    return $('#container-treechildren')[0].items[0].row.cells[0].attributes.label == 'sub updated 1'
                }
            }, 750)
        })
    })
});