describe('ample.restful', function() {
    var rest = ample.restful('url', ample.restful.UPDATERS)

    it('callable', function() {
        // expect(rest).toEqual(jasmine.any(Object));
        expect(rest).toEqual(jasmine.any(Function));
    });

    describe('.context', function() {
        it('exists', function() {
            expect(rest.context).toEqual(jasmine.any(Object));
        });

        describe('.set', function() {
            it('stores selection result to node.data["selection"]', function() {
                rest.context.set($('#menupopup'), function(activeElement) {
                    return $('#tree')
                })
                expect($('#menupopup').data('selection')).toEqual($('#tree'))
            });
        });

        describe('.get', function() {
            it('retrieves selection from parent.data["selection"]', function() {
                rest.context.set($('#menupopup'), function(activeElement) {
                    return $('#tree')
                })
                expect(rest.context.get($('#menuitem'))).toEqual($('#tree'))
            });
        });
    });

    describe('.with', function() {
        it('uses destination nodes as urls source', function() {
            expect(rest('#root-treechildren').with('PUT').urls).toEqual(['/root-treechildren', ])
        });

        // it('calls methods inside data arg', function() {
        //     spyOn(ample, 'ajax').andCallThrough();

        //     function fn() {
        //         return 'value'
        //     }
        //     var data = {
        //         name: fn
        //     }
        //     rest('#root-treechildren').with('POST', data)
        //     expect(ample.ajax.calls[0].args[0].data).toEqual({
        //         name: 'value'
        //     })
        //     expect(data.name).toEqual(fn)
        // });

        it('replaces tree node', function() {
            runs(function() {
                rest('#root-treechildren').with('GET')
            })
            waitsFor(function() {
                try{
                return $('#tree')[0].body.children
                                    .items[0]
                                    .row
                                    .cells[0]
                                    .attributes
                                    .label == 'the updated 1'
                    }catch(err){
                        console.log(err)
                    }
            }, 750);

        });
    });
    
    describe('.using', function(){
        it('sets urls list from nodelist', function(){
            expect(rest('#root-treechildren')
                    .using($('#container-treechildren'))
                    .urls)
                   .toEqual(['/container-treechildren',])
        });
        it('sets urls list from single node', function(){
            expect(rest('#root-treechildren')
                    .using($('#container-treechildren')[0])
                    .urls)
                   .toEqual(['/container-treechildren',])
        });

        it('sets urls list from strings array', function(){
            expect(rest('#root-treechildren')
                    .using(['/container-treechildren'])
                    .urls)
                   .toEqual(['/container-treechildren'])
        });

        it('sets urls list from single string', function(){
            expect(rest('#root-treechildren')
                    .using('/container-treechildren')
                    .urls)
                   .toEqual(['/container-treechildren'])
        });
        describe('.with', function(){
            it('updates tree subnode',function(){
                runs(function(){
                    rest('#container-treechildren').with('GET')
                })
                waitsFor(function(){
                    if ($('#container-treechildren')[0]
                            .items[0]){
                                                return $('#container-treechildren')[0]
                                                        .items[0]
                                                        .row
                                                        .cells[0]
                                                        .attributes
                                                        .label == 'sub updated 1'}
                }, 750)
            });
            it('inserts node by given url', function(){
                runs(function(){
                    rest('#vbox', rest.APPEND)
                        .using('/vbox-sublabel').with('GET')
                });
                waitsFor(function(){
                    if ($('#vbox')[0].firstChild){
                        return $('#vbox')[0].firstChild.attributes.value == 'updated sublabel'
                    }
                }, 750);
            });
        }); 
    });
});