import time
from unittest import TestCase
from flask import Flask, render_template, url_for
from ghost import GhostTestCase

class Config:
    SERVER_NAME = 'localhost:5000'
    DEBUG = True

app = Flask(__name__, static_folder='static', template_folder='templates')
app.config.from_object(Config)

from flask_ample import AmpleMarkup

AmpleMarkup(app)

@app.route('/')
def index():
    return render_template('test_tree.html')

@app.route('/label')
def label():
    return '<?xml version="1.0"?><xul:label id="label" url="/label" value="updated label text" xmlns:xul="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"></xul:label>'

@app.route('/vbox-sublabel')
def vbox_sublabel():
    return """<?xml version="1.0"?><xul:label xmlns:xul="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" value='updated sublabel' id='sublabel'></xul:label>"""


ROOT_TREECHILDREN = """<?xml version="1.0"?>
<xul:treechildren id='root-treechildren' url='/root-treechildren' xmlns:xul="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">
  <xul:treeitem id='container-treeitem' url='/container-treechildren' container='true' open='false'>
    <xul:treerow>
      <xul:treecell label='the updated 1' value='123'></xul:treecell>
    </xul:treerow>
    <xul:treechildren id='container-treechildren' url='/container-treechildren'/>
  </xul:treeitem>
  <xul:treeitem id='leaf-treeitem'>
    <xul:treerow>
      <xul:treecell label='the updated 2' value='123'></xul:treecell>
    </xul:treerow>

  </xul:treeitem>
</xul:treechildren>
"""
@app.route('/root-treechildren')
def root_treechildren():
    return ROOT_TREECHILDREN

CONTAINER_TREECHILDREN = """<?xml version="1.0"?>
<xul:treechildren id='container-treechildren' url='/container-treechildren' xmlns:xul="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">
  <xul:treeitem id='sub-container-treeitem'>
    <xul:treerow>
      <xul:treecell label='sub updated 1' value='123'></xul:treecell>
    </xul:treerow>        
  </xul:treeitem>
  <xul:treeitem id='cub-leaf-treeitem'>
    <xul:treerow>
      <xul:treecell label='sub updated 2' value='123'></xul:treecell>
    </xul:treerow>
  </xul:treeitem>
</xul:treechildren>
"""
@app.route('/container-treechildren')
def container_treechildren():
    return CONTAINER_TREECHILDREN

ROOT_AJAX_CONTAINER_TREEITEM = '''<?xml version="1.0"?>
<xul:treeitem onclick='_.once(function(){ample.rest(this.lastChild).with("GET")})' id='root-ajax-container-treeitem' url='/root-ajax-container-treeitem' xmlns:xul='http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul'>
  <xul:treerow>
    <xul:treecell label='root-ajax-container-treeitem'></xul:treecell>
  </xul:treerow>
  <xul:treechildren id='root-ajax-container-treeitem-treechildren' url='/root-ajax-container-treeitem-treechildren'></xul:treechildren>
</xul:treeitem>'''
@app.route('/root-ajax-container-treeitem')
def root_ajax_container_treeitem():
    return ROOT_AJAX_CONTAINER_TREEITEM

ROOT_AJAX_CONTAINER_TREEITEM_TREECHILDREN = '''<?xml version="1.0"?>
<xul:treechildren id='root-ajax-container-treeitem-treechildren' url='/root-ajax-container-treeitem-treechildren' xmlns:xul='http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul'>
<xul:treeitem >
  <xul:treerow>
    <xul:treecell label='root-ajax-container-treeitem-treechildren'></xul:treecell>
  </xul:treerow>
</xul:treeitem>
</xul:treechildren>'''
@app.route('/root-ajax-container-treeitem-treechildren')
def root_ajax_container_treeitem_treechildren():
    return ROOT_AJAX_CONTAINER_TREEITEM_TREECHILDREN

ROOT_PRERENDERED_CONTAINER_TREEITEM = '''
<?xml version="1.0"?>
<xul:treeitem id='root-prerendered-container-treeitem' url='/root-prerendered-container-treeitem' xmlns:xul='http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul'>
  <xul:treerow>
    <xul:treecell label='root-prerendered-container-treeitem'></xul:treecell>
  </xul:treerow>
  <xul:treechildren id='root-prerendered-container-treeitem-treechildren' url='/root-prerendered-container-treeitem-treechildren'>
    <xul:treeitem >
      <xul:treerow>
        <xul:treecell label='root-prerendered-container-treeitem-treechildren'></xul:treecell>
      </xul:treerow>
    </xul:treeitem>
  </xul:treechildren>
</xul:treeitem>'''

@app.route('/root-prerendered-container-treeitem')
def root_prerendered_container_treeitem():
  return ROOT_PRERENDERED_CONTAINER_TREEITEM

ROOT_LEAF_ITEM = '''<?xml version="1.0"?>
<xul:treeitem id='root-leaf-treeitem' url='/root-leaf-item' xmlns:xul='http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul'>
  <xul:treerow>
    <xul:treecell label='root-leaf-item'></xul:treecell>
  </xul:treerow>
</xul:treeitem>'''
@app.route('/root-leaf-item')
def root_leaf_item():
    return ROOT_LEAF_ITEM

if __name__ == '__main__':
    app.run()