#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os, os.path
from codecs import open
import StringIO
import logging

from flask import Flask
import flask
import jinja2
from flask.ext.login import LoginManager
from flask.ext.login import login_user , logout_user , current_user , login_required
from werkzeug.security import generate_password_hash, check_password_hash

import sphinx
from sphinx.application import Sphinx
import sphinx.util.console as sphinxc

__version__ = '0.0.1'
__author__ = 'Frederic Aoustin'

STR_DOCTREE_MISSING="toctree contains reference to nonexisting document u'"



def init(app):
    if 'SPHINX_BUILD_DIR' not in app.config:
        app.config['SPHINX_BUILD_DIR'] = '.'
    if 'SPHINX_DIR_HTML' not in app.config:
        app.config['SPHINX_DIR_HTML'] = os.path.join(app.config['SPHINX_BUILD_DIR'],'html')
    if 'SPHINX_DIR_DOCTREE' not in app.config:
        app.config['SPHINX_DIR_DOCTREE'] = os.path.join(app.config['SPHINX_BUILD_DIR'],'doctrees')
    if 'SPHINX_THEME_ACE' not in app.config:
        app.config['SPHINX_THEME_ACE'] = 'monokai'
    if 'SPHINX_BUILDERNAME' not in app.config:
        app.config['SPHINX_BUILDERNAME'] = 'html'
    if 'SPHINX_CONFOVERRIDES' not in app.config:  
        app.config['SPHINX_CONFOVERRIDES'] = {}
    if 'SPHINX_FRESHENV' not in app.config:
        app.config['SPHINX_FRESHENV'] = False
    if 'SPHINX_WARNNINGISERROR' not in app.config:
        app.config['SPHINX_WARNNINGISERROR'] = False
    if 'SPHINX_TAGS' not in app.config:
        app.config['SPHINX_TAGS'] = []
    if 'SPHINX_VERBOSITY' not in app.config:
        app.config['SPHINX_VERBOSITY'] = 0
    if 'SPHINX_PARALLEL' not in app.config:
        app.config['SPHINX_PARALLEL'] = 0
    if 'SPHINX_FORCEALL' not in app.config:
        app.config['SPHINX_FORCEALL'] = False
    if 'SPHINX_TEMPLATE' not in app.config:
        app.config['SPHINX_TEMPLATE'] = 'undefined\n=========\n'
    if 'SPHINX_CONF_DIR' in app.config:
        sys.path.insert(0, os.path.abspath(app.config['SPHINX_CONF_DIR']))
        import conf
        app.config['master_doc']= conf.master_doc
        app.config['source_suffix']= conf.source_suffix
        if 'SPHINX_SRC_DIR' not in app.config:
            app.config['SPHINX_SRC_DIR'] = app.config['SPHINX_CONF_DIR']
        try:
            app.config['SPHINX_SRC_ENCODING'] = conf.source_encoding
        except:
            app.config['SPHINX_SRC_ENCODING'] = 'utf-8-sig'
    else:
         print("Error not SPHINX_CONF_DIR in myapp.cfg")
         sys.exit(1)
    paths = []
    try:
        for i in app.jinja_loader.searchpath:
            paths.append(i)
    except:
        pass
    paths.append(os.path.join(os.path.dirname(__file__),'templates'))    
    my_loader = jinja2.ChoiceLoader([
        jinja2.FileSystemLoader(paths),
        app.jinja_loader
    ])
    app.jinja_loader = my_loader
       

    class User():
        """ class of User, for login"""

        def __init__(self, username):
            self.username = username

        def check_password(self, password):
            if self.username in [i['username']  for i in app.config['USERS']]:
                if [ i['password'] for i in app.config['USERS'] if i['username'] == self.username][0] == password:
                    return True
            return False

        def in_groups(self, group):
            if group in [ i['groups'] for i in app.config['USERS'] if i['username']  == self.username][0]:
                return True
            return False

        def is_authenticated(self):
            return True

        def is_active(self):
            return True

        def is_anonymous(self):
            return False

        def get_id(self):
            return [ i['id'] for i in app.config['USERS'] if i['username']  == self.username][0]

        def __repr__(self):
            return '<User %r>' % (self.username)     

    def run_sphinx(loaded= False):
        warning = status = StringIO.StringIO()
        apps = Sphinx(app.config['SPHINX_SRC_DIR'], 
            app.config['SPHINX_CONF_DIR'],
            app.config['SPHINX_DIR_HTML'], 
            app.config['SPHINX_DIR_DOCTREE'], 
            app.config['SPHINX_BUILDERNAME'],
            app.config['SPHINX_CONFOVERRIDES'], 
            status, 
            warning, 
            app.config['SPHINX_FRESHENV'],
            app.config['SPHINX_WARNNINGISERROR'],
            app.config['SPHINX_TAGS'],
            app.config['SPHINX_VERBOSITY'],
            app.config['SPHINX_PARALLEL'])    
        apps.build(app.config['SPHINX_FORCEALL'], [])    
        rtn = status.getvalue()
        for i in sphinxc.codes:
            rtn = rtn.replace(sphinxc.codes[i], '')
        #manage reference to nonexisting 
        missing = False    
        for i in rtn.split('\n'):
            if STR_DOCTREE_MISSING in i:
                missing = True
                page = i.split(STR_DOCTREE_MISSING)[1][0:-1]
                a = open(os.path.join(app.config['SPHINX_SRC_DIR'], '%s%s' % (page, app.config['source_suffix'])), encoding=app.config['SPHINX_SRC_ENCODING'], mode='w')
                a.write(app.config['SPHINX_TEMPLATE'])
                a.close()
        if missing and not loaded:
            return run_sphinx(missing)
        return rtn
        

    @login_required
    def login_index():
        return index()
        
    def index():
        return flask.redirect('%s.html' % app.config['master_doc'])

    @login_required
    def login_static_web(path):
        return static_web(path)
        
    def static_web(path):
        return flask.send_from_directory(app.config['SPHINX_DIR_HTML'],path)

    @login_required
    def login_edit(page):
        return edit(page)

    def edit(page):
        if flask.request.method == 'GET':
            with open(os.path.join(app.config['SPHINX_SRC_DIR'], '%s%s' % (page, app.config['source_suffix'])), encoding=app.config['SPHINX_SRC_ENCODING'], mode='r') as f:
                data = ''.join(f.readlines())
                return flask.render_template('editor.html', src=data, theme=app.config['SPHINX_THEME_ACE'])
        if flask.request.method == 'POST':
            with open(os.path.join(app.config['SPHINX_SRC_DIR'], '%s%s' % (page, app.config['source_suffix'])), encoding=app.config['SPHINX_SRC_ENCODING'], mode='w') as f:
                data = flask.request.form['val']
                f.write(data)
            return run_sphinx()

    def logout():
        logout_user()
        flask.session['next_url'] =  '%s.html' % app.config['master_doc']
        return flask.redirect(flask.url_for('login'))

    def login():
        app.logger.debug('login method: %s' % flask.request.method)
        if flask.request.method == 'GET':
            return flask.render_template('login.html', warnings=[], infos=[])
        username = flask.request.form['username']
        app.logger.debug(username)
        password = flask.request.form['password']
        registered_user = User(username)
        if registered_user.check_password(password):
            login_user(registered_user, remember = True)
            app.logger.debug('Logged in successfully')
            app.logger.debug('redirect to %s' % flask.session.get('next_url', '%s.html' % app.config['master_doc']))
            return flask.redirect(flask.session.get('next_url', '%s.html' % app.config['master_doc']))
        return flask.abort(401) 
        
    if 'USERS' in app.config:
        if 'SPHINX_LOGIN' not in app.config:
            app.config['SPHINX_LOGIN'] = 'all' #all or edit
        login_manager = LoginManager()
        login_manager.init_app(app)
        login_manager.login_view = 'login'
        if app.config['SPHINX_LOGIN'] == 'all':
            app.add_url_rule("/", view_func=login_index)
            app.add_url_rule("/<path:path>", view_func=login_static_web)
        else:    
            app.add_url_rule("/", view_func=index)
            app.add_url_rule("/<path:path>", view_func=static_web)
        app.add_url_rule("/edit/<page>", view_func=login_edit, methods = ['GET', 'POST'])
        app.add_url_rule("/logout", view_func=logout)
        app.add_url_rule("/login", view_func=login, methods = ['GET', 'POST'])
        
        @login_manager.unauthorized_handler
        def unauthorized():
            flask.session['next_url'] = flask.request.path
            return  flask.redirect('login')

        @login_manager.user_loader
        def load_user(id):
            try:
                app.logger.debug('id %s' % id)
                return User([i['username']  for i in app.config['USERS'] if i['id']== id][0])
            except:
                return  flask.redirect('logout')
                
            
    if 'USERS' not in app.config:
        app.add_url_rule("/", view_func=index)
        app.add_url_rule("/<path:path>", view_func=static_web)
        app.add_url_rule("/edit/<page>", view_func=edit, methods = ['GET', 'POST'])
        app.add_url_rule("/logout", view_func=index)