#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
from setuptools import setup, find_packages
import codecs
 
import flasksphinx


here = os.path.abspath(os.path.dirname(__file__))

def read(*parts):
    return codecs.open(os.path.join(here, *parts), 'r').read()

long_description = read('PROJECT.txt')
 
setup(
 
    name='flasksphinx',
    version=flasksphinx.__version__,
    packages=find_packages(),
    author="Frederic Aoustin",
    author_email="mydevpython@gmail.com",
    description="flask app for sphinx",
    long_description=long_description,
    install_requires= ['flask', 'flask-login'], 
    include_package_data=True, 
 
    url='https://pypi.python.org/pypi/flasksphinx/',
 
    classifiers=[
        "Programming Language :: Python",
        "Development Status :: 3 - Alpha",
        "License :: OSI Approved",
        "Natural Language :: French",
        "Operating System :: OS Independent",
        "Environment :: Console", 
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.0",
        "Programming Language :: Python :: 3.1",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4"
    ],
 
 
)
