# -*- coding: utf-8 -*-
"""
    flaskpshinx.todo
    ~~~~~~~~~~~~~~~~

    Add role :x: and :o: for check box
"""

from docutils import nodes
from docutils.parsers.rst import roles

def setup(app):
    generic = roles.GenericRole('x', nodes.inline)
    role = roles.CustomRole('x', generic, {'classes': ['xcheck']})    
    app.add_role('x',role)
    generic = roles.GenericRole('o', nodes.inline)
    role = roles.CustomRole('o', generic, {'classes': ['ocheck']})    
    app.add_role('o',role)

# vim: set expandtab shiftwidth=4 softtabstop=4 :
