# -*- coding: utf-8 -*-
"""
    flaskpshinx.todo
    ~~~~~~~~~~~~~~~~

    Add role :x: and :o: for check box
"""

from docutils import nodes
from docutils.parsers.rst import roles

ROLES_CHECK ={'x' : '\\f046',
		 'o' : '\\f096'}
ROLES = {'call' : '\\f095',
		 'mail' : '\\f0e0',
		 'warning' : '\\f071',
		 'info' : '\\f05a',
		 'meeting' : '\\f0c0'}

CSS = """
span.%(name)s:before {
    font-family: "FontAwesome";
    content: "%(unicode)s";
    padding-right: 5px;
}

span.o-%(name)s {
    font-weight: normal;
    display: block;
}

span.o-%(name)s:before {
    font-family: "FontAwesome";
    content: "%(unicode-o)s    %(unicode)s";
    padding-right: 5px;
}

span.x-%(name)s {
    font-weight: normal;
    font-style: italic;
    display: block;
}

span.x-%(name)s:before {
    font-weight: normal;
    font-family: "FontAwesome";
    content: "%(unicode-x)s    %(unicode)s";
    padding-right: 5px;
    font-style: normal;
}
"""

def setup(app):
    for i in ROLES.keys():
        generic = roles.GenericRole(i, nodes.inline)
        role = roles.CustomRole(i, generic, {'classes': [i]})    
        app.add_role(i,role)
    for i in ROLES_CHECK.keys():
        generic = roles.GenericRole(i, nodes.inline)
        role = roles.CustomRole(i, generic, {'classes': ['%scheck' % i]})    
        app.add_role(i,role)
    for i in ROLES_CHECK.keys():
        for j in ROLES.keys():
            val = '%s-%s' % (i,j)
            generic = roles.GenericRole(val, nodes.inline)
            role = roles.CustomRole(val, generic, {'classes': [val]})    
            app.add_role(val,role)


def getcss():
        for j in ROLES.keys():
        	print(CSS % {'name' : j,
        					'unicode' : ROLES[j],
        					'unicode-o' : ROLES_CHECK['o'],
        					'unicode-x' : ROLES_CHECK['x']})
# vim: set expandtab shiftwidth=4 softtabstop=4 :
