ace.define("ace/mode/rst_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var rstHighlightRules = function() {
    this.$rules =
        {
    "start": [
        {
            token : "comment",
            regex : "^\t.*$"
        },
        {
            token : "comment",
            regex : "^    .*$"
        },
        {
            token : "keyword",
            regex : "^[\\*]+$|^[#]+$|^[=]+$|^[\-]+$|^[\.]+$|^[\+]+$"
        },
        {
            token : "string",
            regex : "^\.\. [\\w\-]+::|^::$"
        },
        {
            token : "constant.numeric",
            regex : "\\*[^ $\\*]+\\*"
        },
        {
            token : "constant.numeric",
            regex : "\\*\\*[^ $\\*]+\\*\\*"
        },
        {
            token : "constant.numeric",
            regex : "\\+[\+\-]+\\+|\\+[\+=]+\\+|\\|"
        },
        {
            token : "constant.numeric",
            regex : "^=[= ]+=$|^-[- ]+-$"
        },
    ],
    "qqstring": [
    ]
}

};

oop.inherits(rstHighlightRules, TextHighlightRules);

exports.rstHighlightRules = rstHighlightRules;
});

ace.define("ace/mode/rst",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/rst_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var rstHighlightRules = require("./rst_highlight_rules").rstHighlightRules;

var Mode = function() {
    this.HighlightRules = rstHighlightRules;
};
oop.inherits(Mode, TextMode);

(function() {

    this.lineCommentStart = ";";

    this.$id = "ace/mode/rst";
}).call(Mode.prototype);

exports.Mode = Mode;
});