# -*- coding: utf-8 -*-
"""
    flaskpshinx.todo
    ~~~~~~~~~~~~~~~~

    Add role :x: and :o: for check box
"""

from docutils import nodes
from docutils.parsers.rst import roles

from sphinx.locale import _
from sphinx.environment import NoUri
from sphinx.util.nodes import set_source_info
from sphinx.util.compat import Directive, make_admonition
from docutils.parsers.rst import directives

class todo(nodes.Admonition, nodes.Element):
    pass

def visit_todo_node(self, node):
    self.visit_admonition(node)

def depart_todo_node(self, node):
    self.depart_admonition(node)

class todo_directive(Directive):

    # this enables content in the directive
    has_content = True
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = False
    option_spec = {
        'start': str,
        'end': str,
        'time': str,
        'priority': str,
        'checked': directives.flag,
    }
    
    def run(self):
        env = self.state.document.settings.env
        if 'priority' not in self.options:
            priority = 3
        else:
            priority = self.options['priority']
        if 'checked' in self.options:
            checked = 'checked'
        else:    
            checked = 'nochecked'
        if len(self.content) > 0 :
            title = self.content[0]
            self.content = self.content[1:]
        else:
            title = 'My Title'        
        if 'start' in self.options or 'end' in self.options :
            title += ' ('
            if 'start' in self.options:
                title += '%s ... ' % self.options['start']
            if 'end' in self.options:
                title += '%s' % self.options['end']
            title += ')'
        if 'time' in self.options:
            title += ', %s' % self.options['time']
                
        admonition_node = todo('\n'.join(self.content))
        textnodes, messages = self.state.inline_text(title, self.lineno)
        admonition_node += nodes.title(title, '',*textnodes)
        admonition_node += messages
        admonition_node['classes'] = ['admonition-todo', checked, 'priority-%s' % priority]
        self.state.nested_parse(self.content, self.content_offset, admonition_node)
        return [admonition_node,]
        
ROLES_CHECK ={'x' : '\\f046',
		 'o' : '\\f096'}
ROLES = {'call' : '\\f095',
		 'mail' : '\\f0e0',
		 'warning' : '\\f071',
		 'info' : '\\f05a',
		 'meeting' : '\\f0c0'}

CSS = """
span.%(name)s:before {
    font-family: "FontAwesome";
    content: "%(unicode)s";
    padding-right: 5px;
}

span.o-%(name)s {
    font-weight: normal;
    display: block;
}

span.o-%(name)s:before {
    font-family: "FontAwesome";
    content: "%(unicode-o)s    %(unicode)s";
    padding-right: 5px;
}

span.x-%(name)s {
    font-weight: normal;
    font-style: italic;
    display: block;
}

span.x-%(name)s:before {
    font-weight: normal;
    font-family: "FontAwesome";
    content: "%(unicode-x)s    %(unicode)s";
    padding-right: 5px;
    font-style: normal;
}
"""



def setup(app):
    for i in ROLES.keys():
        generic = roles.GenericRole(i, nodes.inline)
        role = roles.CustomRole(i, generic, {'classes': [i]})    
        app.add_role(i,role)
    for i in ROLES_CHECK.keys():
        generic = roles.GenericRole(i, nodes.inline)
        role = roles.CustomRole(i, generic, {'classes': ['%scheck' % i]})    
        app.add_role(i,role)
    for i in ROLES_CHECK.keys():
        for j in ROLES.keys():
            val = '%s-%s' % (i,j)
            generic = roles.GenericRole(val, nodes.inline)
            role = roles.CustomRole(val, generic, {'classes': [val]})    
            app.add_role(val,role)
    app.add_node(todo,
             html=(visit_todo_node, depart_todo_node),
             latex=(visit_todo_node, depart_todo_node),
             text=(visit_todo_node, depart_todo_node))        
    app.add_directive('todo', todo_directive)


def getcss():
        for j in ROLES.keys():
        	print(CSS % {'name' : j,
        					'unicode' : ROLES[j],
        					'unicode-o' : ROLES_CHECK['o'],
        					'unicode-x' : ROLES_CHECK['x']})
# vim: set expandtab shiftwidth=4 softtabstop=4 :
