"""
See: http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml
"""

ssl_cipher_suites = [
    {
        "id": 0x010080,
        "name": "SSL_CK_RC4_128_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": None,
        "export": False,
    },
    {
        "id": 0x020080,
        "name": "SSL_CK_RC4_128_EXPORT40_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "RSA(512)",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": None,
        "export": True,
    },
    {
        "id": 0x030080,
        "name": "SSL_CK_RC2_128_CBC_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "RC2",
        "mac": "MD5",
        "dtls": None,
        "export": False,
    },
    {
        "id": 0x040080,
        "name": "SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "RSA(512)",
        "authentication": "RSA",
        "encryption": "RC2",
        "mac": "MD5",
        "dtls": None,
        "export": True,
    },
    {
        "id": 0x050080,
        "name": "SSL_CK_IDEA_128_CBC_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "IDEA",
        "mac": "MD5",
        "dtls": None,
        "export": False,
    },
    {
        "id": 0x060040,
        "name": "SSL_CK_DES_64_CBC_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 56,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "DES",
        "mac": "MD5",
        "dtls": None,
        "export": False,
    },
    {
        "id": 0x0700C0,
        "name": "SSL_CK_DES_192_EDE3_CBC_WITH_MD5",
        "protocol": "SSLv2",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "3DES",
        "mac": "MD5",
        "dtls": None,
        "export": False,
    },
]

tls_cipher_suites = [
    {
        "id": 0x000,
        "name": "TLS_NULL_WITH_NULL_NULL",
        "protocol": "",
        "bits": 0,
        "alg_bits": 0,
        "key_exchange": "NULL",
        "encryption": "NULL",
        "mac": "NULL",
        "dtls": True,
        "export": None,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0001,
        "name": "TLS_RSA_WITH_NULL_MD5",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": 0,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "NULL",
        "mac": "MD5",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0002,
        "name": "TLS_RSA_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": 0,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "NULL",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0003,
        "name": "TLS_RSA_EXPORT_WITH_RC4_40_MD5",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "RSA(512)",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": False,
        "export": True,
        "references": ["RFC4346", "RFC6347"],
    },
    {
        "id": 0x0004,
        "name": "TLS_RSA_WITH_RC4_128_MD5",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": False,
        "export": False,
        "references": ["RFC5246", "RFC6347"],
    },
    {
        "id": 0x0005,
        "name": "TLS_RSA_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC5246", "RFC6347"],
    },
    {
        "id": 0x0006,
        "name": "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "RSA(512)",
        "authentication": "RSA",
        "encryption": "RC2",
        "mac": "MD5",
        "dtls": True,
        "export": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x0007,
        "name": "TLS_RSA_WITH_IDEA_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "IDEA",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5469"],
    },
    {
        "id": 0x0008,
        "name": "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "RSA(512)",
        "authentication": "RSA",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x0009,
        "name": "TLS_RSA_WITH_DES_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 56,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5469"],
    },
    {
        "id": 0x000A,
        "name": "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x000b,
        "name": "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA",
        "key_exchange": "DH-DSS-EXPORT",
        "encryption": "DES40-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x000c,
        "name": "TLS_DH_DSS_WITH_DES_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "DES-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5469"],
    },
    {
        "id": 0x000d,
        "name": "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x000e,
        "name": "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA",
        "key_exchange": "DH-RSA-EXPORT",
        "encryption": "DES40-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x000f,
        "name": "TLS_DH_RSA_WITH_DES_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "DES-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5469"],
    },
    {
        "id": 0x0010,
        "name": "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0011,
        "name": "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "DH(512)",
        "authentication": "DSS",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x0012,
        "name": "TLS_DHE_DSS_WITH_DES_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 56,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5469"],
    },
    {
        "id": 0x0013,
        "name": "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0014,
        "name": "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "DH(512)",
        "authentication": "RSA",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x0015,
        "name": "TLS_DHE_RSA_WITH_DES_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 56,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5469"],
    },
    {
        "id": 0x0016,
        "name": "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0017,
        "name": "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "DH(512)",
        "authentication": "None",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": False,
        "export": True,
        "references": ["RFC4346", "RFC6347"],
    },
    {
        "id": 0x0018,
        "name": "TLS_DH_anon_WITH_RC4_128_MD5",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "RC4",
        "mac": "MD5",
        "dtls": False,
        "export": False,
        "references": ["RFC5246", "RFC6347"],
    },
    {
        "id": 0x0019,
        "name": "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 40,
        "alg_bits": None,
        "key_exchange": "DH(512)",
        "authentication": "None",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": True,
        "references": ["RFC4346"],
    },
    {
        "id": 0x001A,
        "name": "TLS_DH_anon_WITH_DES_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 56,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5469"],
    },
    {
        "id": 0x001B,
        "name": "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
    },
    {
        "id": 0x001e,
        "name": "TLS_KRB5_WITH_DES_CBC_SHA",
        "key_exchange": "KRB5",
        "encryption": "DES-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x001f,
        "name": "TLS_KRB5_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "KRB5",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0020,
        "name": "TLS_KRB5_WITH_RC4_128_SHA",
        "key_exchange": "KRB5",
        "encryption": "RC4-128",
        "mac": "SHA",
        "dtls": False,
        "references": ["RFC2712", "RFC6347"],
    },
    {
        "id": 0x0021,
        "name": "TLS_KRB5_WITH_IDEA_CBC_SHA",
        "key_exchange": "KRB5",
        "encryption": "IDEA-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0022,
        "name": "TLS_KRB5_WITH_DES_CBC_MD5",
        "key_exchange": "KRB5",
        "encryption": "DES-CBC",
        "mac": "MD5",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0023,
        "name": "TLS_KRB5_WITH_3DES_EDE_CBC_MD5",
        "key_exchange": "KRB5",
        "encryption": "3DES-EDE-CBC",
        "mac": "MD5",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0024,
        "name": "TLS_KRB5_WITH_RC4_128_MD5",
        "key_exchange": "KRB5",
        "encryption": "RC4-128",
        "mac": "MD5",
        "dtls": False,
        "references": ["RFC2712", "RFC6347"],
    },
    {
        "id": 0x0025,
        "name": "TLS_KRB5_WITH_IDEA_CBC_MD5",
        "key_exchange": "KRB5",
        "encryption": "IDEA-CBC",
        "mac": "MD5",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0026,
        "name": "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "DES-CBC-40",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0027,
        "name": "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "RC2-CBC-40",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x0028,
        "name": "TLS_KRB5_EXPORT_WITH_RC4_40_SHA",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "RC4-40",
        "mac": "SHA",
        "dtls": False,
        "references": ["RFC2712", "RFC6347"],
    },
    {
        "id": 0x0029,
        "name": "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "DES-CBC-40",
        "mac": "MD5",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x002a,
        "name": "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "RC2-CBC-40",
        "mac": "MD5",
        "dtls": True,
        "references": ["RFC2712"],
    },
    {
        "id": 0x002b,
        "name": "TLS_KRB5_EXPORT_WITH_RC4_40_MD5",
        "key_exchange": "KRB5-EXPORT",
        "encryption": "RC4-40",
        "mac": "MD5",
        "dtls": False,
        "references": ["RFC2712", "RFC6347"],
    },
    {
        "id": 0x002c,
        "name": "TLS_PSK_WITH_NULL_SHA",
        "key_exchange": "PSK",
        "encryption": "NULL",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4785"],
    },
    {
        "id": 0x002d,
        "name": "TLS_DHE_PSK_WITH_NULL_SHA",
        "key_exchange": "DHE-PSK",
        "encryption": "NULL",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4785"],
    },
    {
        "id": 0x002e,
        "name": "TLS_RSA_PSK_WITH_NULL_SHA",
        "key_exchange": "RSA-PSK",
        "encryption": "NULL",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4785"],
    },
    {
        "id": 0x002F,
        "name": "TLS_RSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0030,
        "name": "TLS_DH_DSS_WITH_AES_128_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "AES-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0031,
        "name": "TLS_DH_RSA_WITH_AES_128_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "AES-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0032,
        "name": "TLS_DHE_DSS_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0033,
        "name": "TLS_DHE_RSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0034,
        "name": "TLS_DH_anon_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0035,
        "name": "TLS_RSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0036,
        "name": "TLS_DH_DSS_WITH_AES_256_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "AES-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0037,
        "name": "TLS_DH_RSA_WITH_AES_256_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "AES-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0038,
        "name": "TLS_DHE_DSS_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0039,
        "name": "TLS_DHE_RSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003A,
        "name": "TLS_DH_anon_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003B,
        "name": "TLS_RSA_WITH_NULL_SHA256",
        "protocol": "TLSv1.2",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "None",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003C,
        "name": "TLS_RSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003D,
        "name": "TLS_RSA_WITH_AES_256_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003e,
        "name": "TLS_DH_DSS_WITH_AES_128_CBC_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x003f,
        "name": "TLS_DH_RSA_WITH_AES_128_CBC_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0040,
        "name": "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0041,
        "name": "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0042,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0043,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0044,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0045,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0046,
        "name": "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0067,
        "name": "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0068,
        "name": "TLS_DH_DSS_WITH_AES_256_CBC_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "AES-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0069,
        "name": "TLS_DH_RSA_WITH_AES_256_CBC_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "AES-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 0x006A,
        "name": "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x006B,
        "name": "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x006C,
        "name": "TLS_DH_anon_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x006D,
        "name": "TLS_DH_anon_WITH_AES_256_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5246"],
    },
    {
        "id": 0x0084,
        "name": "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0085,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0086,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0087,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0088,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x0089,
        "name": "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "Camellia",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5932"],
    },
    {
        "id": 0x008A,
        "name": "TLS_PSK_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "PSK",
        "authentication": "PSK",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4279", "RFC6347"],
    },
    {
        "id": 0x008B,
        "name": "TLS_PSK_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "PSK",
        "authentication": "PSK",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4279"],
    },
    {
        "id": 0x008C,
        "name": "TLS_PSK_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "PSK",
        "authentication": "PSK",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4279"],
    },
    {
        "id": 0x008D,
        "name": "TLS_PSK_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "PSK",
        "authentication": "PSK",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4279"],
    },
    {
        "id": 0x008e,
        "name": "TLS_DHE_PSK_WITH_RC4_128_SHA",
        "key_exchange": "DHE-PSK",
        "encryption": "RC4-128",
        "mac": "SHA",
        "dtls": False,
        "references": ["RFC4279", "RFC6347"],
    },
    {
        "id": 0x008f,
        "name": "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "DHE-PSK",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0090,
        "name": "TLS_DHE_PSK_WITH_AES_128_CBC_SHA",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0091,
        "name": "TLS_DHE_PSK_WITH_AES_256_CBC_SHA",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0092,
        "name": "TLS_RSA_PSK_WITH_RC4_128_SHA",
        "key_exchange": "RSA-PSK",
        "encryption": "RC4-128",
        "mac": "SHA",
        "dtls": False,
        "references": ["RFC4279", "RFC6347"],
    },
    {
        "id": 0x0093,
        "name": "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "RSA-PSK",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0094,
        "name": "TLS_RSA_PSK_WITH_AES_128_CBC_SHA",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0095,
        "name": "TLS_RSA_PSK_WITH_AES_256_CBC_SHA",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4279"],
    },
    {
        "id": 0x0096,
        "name": "TLS_RSA_WITH_SEED_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "SEED",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4162"],
    },
    {
        "id": 0x0097,
        "name": "TLS_DH_DSS_WITH_SEED_CBC_SHA",
        "key_exchange": "DH-DSS",
        "encryption": "SEED-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4162"],
    },
    {
        "id": 0x0098,
        "name": "TLS_DH_RSA_WITH_SEED_CBC_SHA",
        "key_exchange": "DH-RSA",
        "encryption": "SEED-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC4162"],
    },
    {
        "id": 0x0099,
        "name": "TLS_DHE_DSS_WITH_SEED_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "SEED",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4162"],
    },
    {
        "id": 0x009A,
        "name": "TLS_DHE_RSA_WITH_SEED_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "SEED",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4162"],
    },
    {
        "id": 0x009B,
        "name": "TLS_DH_anon_WITH_SEED_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "SEED",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4162"],
    },
    {
        "id": 0x009C,
        "name": "TLS_RSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x009D,
        "name": "TLS_RSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "RSA",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x009E,
        "name": "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x009F,
        "name": "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00a0,
        "name": "TLS_DH_RSA_WITH_AES_128_GCM_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "AES-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00a1,
        "name": "TLS_DH_RSA_WITH_AES_256_GCM_SHA384",
        "key_exchange": "DH-RSA",
        "encryption": "AES-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00A2,
        "name": "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00A3,
        "name": "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "DSS",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00a4,
        "name": "TLS_DH_DSS_WITH_AES_128_GCM_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "AES-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00a5,
        "name": "TLS_DH_DSS_WITH_AES_256_GCM_SHA384",
        "key_exchange": "DH-DSS",
        "encryption": "AES-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00A6,
        "name": "TLS_DH_anon_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00A7,
        "name": "TLS_DH_anon_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "DH",
        "authentication": "None",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5288"],
    },
    {
        "id": 0x00a8,
        "name": "TLS_PSK_WITH_AES_128_GCM_SHA256",
        "key_exchange": "PSK",
        "encryption": "AES-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00a9,
        "name": "TLS_PSK_WITH_AES_256_GCM_SHA384",
        "key_exchange": "PSK",
        "encryption": "AES-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00aa,
        "name": "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00ab,
        "name": "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00ac,
        "name": "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00ad,
        "name": "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00ae,
        "name": "TLS_PSK_WITH_AES_128_CBC_SHA256",
        "key_exchange": "PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00af,
        "name": "TLS_PSK_WITH_AES_256_CBC_SHA384",
        "key_exchange": "PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b0,
        "name": "TLS_PSK_WITH_NULL_SHA256",
        "key_exchange": "PSK",
        "encryption": "NULL",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b1,
        "name": "TLS_PSK_WITH_NULL_SHA384",
        "key_exchange": "PSK",
        "encryption": "NULL",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b2,
        "name": "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b3,
        "name": "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b4,
        "name": "TLS_DHE_PSK_WITH_NULL_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "NULL",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b5,
        "name": "TLS_DHE_PSK_WITH_NULL_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "NULL",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b6,
        "name": "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b7,
        "name": "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b8,
        "name": "TLS_RSA_PSK_WITH_NULL_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "NULL",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00b9,
        "name": "TLS_RSA_PSK_WITH_NULL_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "NULL",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5487"],
    },
    {
        "id": 0x00ba,
        "name": "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00bb,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00bc,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00bd,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DHE-DSS",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00be,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DHE-RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00bf,
        "name": "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DH-anon",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c0,
        "name": "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c1,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c2,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c3,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "DHE-DSS",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c4,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "DHE-RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0x00c5,
        "name": "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256",
        "key_exchange": "DH-anon",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5932"],
    },
    {
        "id": 0xC001,
        "name": "TLS_ECDH_ECDSA_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "None",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC002,
        "name": "TLS_ECDH_ECDSA_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4492", "RFC6347"],
    },
    {
        "id": 0xC003,
        "name": "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC004,
        "name": "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC005,
        "name": "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC006,
        "name": "TLS_ECDHE_ECDSA_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "None",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC007,
        "name": "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4492", "RFC6347"],
    },
    {
        "id": 0xC008,
        "name": "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC009,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC00A,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC00B,
        "name": "TLS_ECDH_RSA_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "None",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC00C,
        "name": "TLS_ECDH_RSA_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4492", "RFC6347"],
    },
    {
        "id": 0xC00D,
        "name": "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC00E,
        "name": "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC00F,
        "name": "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC010,
        "name": "TLS_ECDHE_RSA_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "None",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC011,
        "name": "TLS_ECDHE_RSA_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4492", "RFC6347"],
    },
    {
        "id": 0xC012,
        "name": "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC013,
        "name": "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC014,
        "name": "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC015,
        "name": "TLS_ECDH_anon_WITH_NULL_SHA",
        "protocol": "SSLv3",
        "bits": 0,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "None",
        "encryption": "None",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC016,
        "name": "TLS_ECDH_anon_WITH_RC4_128_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "None",
        "encryption": "RC4",
        "mac": "SHA1",
        "dtls": False,
        "export": False,
        "references": ["RFC4492", "RFC6347"],
    },
    {
        "id": 0xC017,
        "name": "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "None",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC018,
        "name": "TLS_ECDH_anon_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC019,
        "name": "TLS_ECDH_anon_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "None",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC4492"],
    },
    {
        "id": 0xC01A,
        "name": "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "SRP",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC01B,
        "name": "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "RSA",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC01C,
        "name": "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 168,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "DSS",
        "encryption": "3DES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC01D,
        "name": "TLS_SRP_SHA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "SRP",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC01E,
        "name": "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC01F,
        "name": "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC020,
        "name": "TLS_SRP_SHA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "SRP",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC021,
        "name": "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC022,
        "name": "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA",
        "protocol": "SSLv3",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "SRP",
        "authentication": "DSS",
        "encryption": "AES",
        "mac": "SHA1",
        "dtls": True,
        "export": False,
        "references": ["RFC5054"],
    },
    {
        "id": 0xC023,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC024,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AES",
        "mac": "SHA384",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC025,
        "name": "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC026,
        "name": "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA384",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC027,
        "name": "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC028,
        "name": "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AES",
        "mac": "SHA384",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC029,
        "name": "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA256",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02A,
        "name": "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AES",
        "mac": "SHA384",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02B,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02C,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "ECDSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02D,
        "name": "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02E,
        "name": "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/ECDSA",
        "authentication": "ECDH",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC02F,
        "name": "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC030,
        "name": "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH",
        "authentication": "RSA",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC031,
        "name": "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256",
        "protocol": "TLSv1.2",
        "bits": 128,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xC032,
        "name": "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384",
        "protocol": "TLSv1.2",
        "bits": 256,
        "alg_bits": None,
        "key_exchange": "ECDH/RSA",
        "authentication": "ECDH",
        "encryption": "AESGCM",
        "mac": "AEAD",
        "dtls": True,
        "export": False,
        "references": ["RFC5289"],
    },
    {
        "id": 0xc033,
        "name": "TLS_ECDHE_PSK_WITH_RC4_128_SHA",
        "key_exchange": "ECDHE-PSK",
        "encryption": "RC4-128",
        "mac": "SHA",
        "dtls": False,
        "references": ["RFC5489", "RFC6347"],
    },
    {
        "id": 0xc034,
        "name": "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA",
        "key_exchange": "ECDHE-PSK",
        "encryption": "3DES-EDE-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc035,
        "name": "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA",
        "key_exchange": "ECDHE-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc036,
        "name": "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA",
        "key_exchange": "ECDHE-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc037,
        "name": "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256",
        "key_exchange": "ECDHE-PSK",
        "encryption": "AES-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc038,
        "name": "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384",
        "key_exchange": "ECDHE-PSK",
        "encryption": "AES-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc039,
        "name": "TLS_ECDHE_PSK_WITH_NULL_SHA",
        "key_exchange": "ECDHE-PSK",
        "encryption": "NULL",
        "mac": "SHA",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc03a,
        "name": "TLS_ECDHE_PSK_WITH_NULL_SHA256",
        "key_exchange": "ECDHE-PSK",
        "encryption": "NULL",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc03b,
        "name": "TLS_ECDHE_PSK_WITH_NULL_SHA384",
        "key_exchange": "ECDHE-PSK",
        "encryption": "NULL",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC5489"],
    },
    {
        "id": 0xc03c,
        "name": "TLS_RSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "RSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc03d,
        "name": "TLS_RSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "RSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc03e,
        "name": "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc03f,
        "name": "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DH-DSS",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc040,
        "name": "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc041,
        "name": "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DH-RSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc042,
        "name": "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DHE-DSS",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc043,
        "name": "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DHE-DSS",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc044,
        "name": "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DHE-RSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc045,
        "name": "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DHE-RSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc046,
        "name": "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DH-anon",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc047,
        "name": "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DH-anon",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc048,
        "name": "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc049,
        "name": "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04a,
        "name": "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04b,
        "name": "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04c,
        "name": "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-RSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04d,
        "name": "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-RSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04e,
        "name": "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "ECDH-RSA",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc04f,
        "name": "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "ECDH-RSA",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc050,
        "name": "TLS_RSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "RSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc051,
        "name": "TLS_RSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "RSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc052,
        "name": "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DHE-RSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc053,
        "name": "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DHE-RSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc054,
        "name": "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc055,
        "name": "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DH-RSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc056,
        "name": "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DHE-DSS",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc057,
        "name": "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DHE-DSS",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc058,
        "name": "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc059,
        "name": "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DH-DSS",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05a,
        "name": "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DH-anon",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05b,
        "name": "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DH-anon",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05c,
        "name": "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05d,
        "name": "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05e,
        "name": "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc05f,
        "name": "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc060,
        "name": "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "ECDHE-RSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc061,
        "name": "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "ECDHE-RSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc062,
        "name": "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "ECDH-RSA",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc063,
        "name": "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "ECDH-RSA",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc064,
        "name": "TLS_PSK_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "PSK",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc065,
        "name": "TLS_PSK_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "PSK",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc066,
        "name": "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc067,
        "name": "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc068,
        "name": "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc069,
        "name": "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06a,
        "name": "TLS_PSK_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "PSK",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06b,
        "name": "TLS_PSK_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "PSK",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06c,
        "name": "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06d,
        "name": "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06e,
        "name": "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "ARIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc06f,
        "name": "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "ARIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc070,
        "name": "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-PSK",
        "encryption": "ARIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc071,
        "name": "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-PSK",
        "encryption": "ARIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6209"],
    },
    {
        "id": 0xc072,
        "name": "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc073,
        "name": "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc074,
        "name": "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc075,
        "name": "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc076,
        "name": "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc077,
        "name": "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc078,
        "name": "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "ECDH-RSA",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc079,
        "name": "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "ECDH-RSA",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07a,
        "name": "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "RSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07b,
        "name": "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "RSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07c,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DHE-RSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07d,
        "name": "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DHE-RSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07e,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc07f,
        "name": "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DH-RSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc080,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DHE-DSS",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc081,
        "name": "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DHE-DSS",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc082,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc083,
        "name": "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DH-DSS",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc084,
        "name": "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DH-anon",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc085,
        "name": "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DH-anon",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc086,
        "name": "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc087,
        "name": "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc088,
        "name": "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc089,
        "name": "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "ECDH-ECDSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08a,
        "name": "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "ECDHE-RSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08b,
        "name": "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "ECDHE-RSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08c,
        "name": "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "ECDH-RSA",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08d,
        "name": "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "ECDH-RSA",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08e,
        "name": "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "PSK",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc08f,
        "name": "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "PSK",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc090,
        "name": "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc091,
        "name": "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc092,
        "name": "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "CAMELLIA-128-GCM",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc093,
        "name": "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "CAMELLIA-256-GCM",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc094,
        "name": "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "PSK",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc095,
        "name": "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "PSK",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc096,
        "name": "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "DHE-PSK",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc097,
        "name": "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "DHE-PSK",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc098,
        "name": "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "RSA-PSK",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc099,
        "name": "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "RSA-PSK",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc09a,
        "name": "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256",
        "key_exchange": "ECDHE-PSK",
        "encryption": "CAMELLIA-128-CBC",
        "mac": "SHA256",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc09b,
        "name": "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384",
        "key_exchange": "ECDHE-PSK",
        "encryption": "CAMELLIA-256-CBC",
        "mac": "SHA384",
        "dtls": True,
        "references": ["RFC6367"],
    },
    {
        "id": 0xc09c,
        "name": "TLS_RSA_WITH_AES_128_CCM",
        "key_exchange": "RSA",
        "encryption": "AES-128",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc09d,
        "name": "TLS_RSA_WITH_AES_256_CCM",
        "key_exchange": "RSA",
        "encryption": "AES-256",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc09e,
        "name": "TLS_DHE_RSA_WITH_AES_128_CCM",
        "key_exchange": "DHE-RSA",
        "encryption": "AES-128",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc09f,
        "name": "TLS_DHE_RSA_WITH_AES_256_CCM",
        "key_exchange": "DHE-RSA",
        "encryption": "AES-256",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a0,
        "name": "TLS_RSA_WITH_AES_128_CCM_8",
        "key_exchange": "RSA",
        "encryption": "AES-128-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a1,
        "name": "TLS_RSA_WITH_AES_256_CCM_8",
        "key_exchange": "RSA",
        "encryption": "AES-256-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a2,
        "name": "TLS_DHE_RSA_WITH_AES_128_CCM_8",
        "key_exchange": "DHE-RSA",
        "encryption": "AES-128-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a3,
        "name": "TLS_DHE_RSA_WITH_AES_256_CCM_8",
        "key_exchange": "DHE-RSA",
        "encryption": "AES-256-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a4,
        "name": "TLS_PSK_WITH_AES_128_CCM",
        "key_exchange": "PSK",
        "encryption": "AES-128",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a5,
        "name": "TLS_PSK_WITH_AES_256_CCM",
        "key_exchange": "PSK",
        "encryption": "AES-256",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a6,
        "name": "TLS_DHE_PSK_WITH_AES_128_CCM",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-128",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a7,
        "name": "TLS_DHE_PSK_WITH_AES_256_CCM",
        "key_exchange": "DHE-PSK",
        "encryption": "AES-256",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a8,
        "name": "TLS_PSK_WITH_AES_128_CCM_8",
        "key_exchange": "PSK",
        "encryption": "AES-128-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0a9,
        "name": "TLS_PSK_WITH_AES_256_CCM_8",
        "key_exchange": "PSK",
        "encryption": "AES-256-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0aa,
        "name": "TLS_PSK_DHE_WITH_AES_128_CCM_8",
        "key_exchange": "PSK-DHE",
        "encryption": "AES-128-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0ab,
        "name": "TLS_PSK_DHE_WITH_AES_256_CCM_8",
        "key_exchange": "PSK-DHE",
        "encryption": "AES-256-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC6655"],
    },
    {
        "id": 0xc0ac,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_128_CCM",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "AES-128",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC7251"],
    },
    {
        "id": 0xc0ad,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_256_CCM",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "AES-256",
        "mac": "CCM",
        "dtls": True,
        "references": ["RFC7251"],
    },
    {
        "id": 0xc0ae,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "AES-128-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC7251"],
    },
    {
        "id": 0xc0af,
        "name": "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8",
        "key_exchange": "ECDHE-ECDSA",
        "encryption": "AES-256-CCM",
        "mac": "8",
        "dtls": True,
        "references": ["RFC7251"],
    },
]

tls_compression_methods = [
    {
        "id": 0,
        "name": "none",
        "dtls": None,
        "references": ["RFC5246"],
    },
    {
        "id": 1,
        "name": "DEFLATE",
        "dtls": None,
        "references": ["RFC3749"],
    },
    {
        "id": 64,
        "name": "LZS",
        "dtls": None,
        "references": ["RFC3943"],
    },
]

tls_hash_algorithms = [
    {
        "id": 0,
        "name": "none",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 1,
        "name": "md5",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 2,
        "name": "sha1",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 3,
        "name": "sha224",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 4,
        "name": "sha256",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 5,
        "name": "sha384",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 6,
        "name": "sha512",
        "dtls": True,
        "references": ["RFC5246"],
    },
]

tls_signature_algorithms = [
    {
        "id": 0,
        "name": "anonymous",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 1,
        "name": "rsa",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 2,
        "name": "dsa",
        "dtls": True,
        "references": ["RFC5246"],
    },
    {
        "id": 3,
        "name": "ecdsa",
        "dtls": True,
        "references": ["RFC5246"],
    },
]

ec_named_curves = [
    {
        "id": 1,
        "name": "sect163k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 2,
        "name": "sect163r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 3,
        "name": "sect163r2",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 4,
        "name": "sect193r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 5,
        "name": "sect193r2",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 6,
        "name": "sect233k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 7,
        "name": "sect233r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 8,
        "name": "sect239k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 9,
        "name": "sect283k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 10,
        "name": "sect283r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 11,
        "name": "sect409k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 12,
        "name": "sect409r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 13,
        "name": "sect571k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 14,
        "name": "sect571r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 15,
        "name": "secp160k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 16,
        "name": "secp160r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 17,
        "name": "secp160r2",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 18,
        "name": "secp192k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 19,
        "name": "secp192r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 20,
        "name": "secp224k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 21,
        "name": "secp224r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 22,
        "name": "secp256k1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 23,
        "name": "secp256r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 24,
        "name": "secp384r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 25,
        "name": "secp521r1",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 26,
        "name": "brainpoolP256r1",
        "dtls": True,
        "references": ["RFC7027"],
    },
    {
        "id": 27,
        "name": "brainpoolP384r1",
        "dtls": True,
        "references": ["RFC7027"],
    },
    {
        "id": 28,
        "name": "brainpoolP512r1",
        "dtls": True,
        "references": ["RFC7027"],
    },
    {
        "id": 65281,
        "name": "arbitrary_explicit_prime_curves",
        "dtls": True,
        "references": ["RFC4492"],
    },
    {
        "id": 65282,
        "name": "arbitrary_explicit_char2_curves",
        "dtls": True,
        "references": ["RFC4492"],
    },
]
