"""
Flickr API client.
"""

__author__ = "Lawrence Oluyede (oluyede.org)"
__version__ = '0.5.0'
__copyright__ = "Copyright (c) 2007 Lawrence Oluyede"
__license__ = "BSD"


from backend import JSONBackend

class FlickrClient(object):
    """The Flickr client class."""
    def __init__(self, api_key, secret_key, backend=JSONBackend):
        self.api_key = api_key
        self.secret_key = secret_key
        self.backend = backend(self.api_key, self.secret_key)
            
    def __getattr__(self, api_method_name):
        def _method(**params):
            try:
                return getattr(self.backend, api_method_name)(**params)
            except AttributeError:
                api_name = ".".join(api_method_name.split('_'))
                flickr_method_name = "flickr.%s" % api_name
                return self.backend.call_api_method(flickr_method_name,
                    True, **params)
        return _method
