import md5
import os
import webbrowser

BASE_HOST = 'flickr.com'
REST_API_PATH = '/services/rest'
AUTH_API_PATH = '/services/auth'

REST_API_URL = 'http://%s%s/' % (BASE_HOST, REST_API_PATH)
AUTH_API_URL = 'http://%s%s/' % (BASE_HOST, AUTH_API_PATH)

UPLOAD_URL = 'http://api.flickr.com/services/upload/'

def get_api_signature(secret_key, **params):
    """API signing, see: <http://www.flickr.com/services/api/auth.spec.html>"""
    keys = params.keys()
    keys.sort()
    
    lst = []
    for key in keys:
        lst.append("%s%s" % (str(key), str(params[key])))
    lst.insert(0, secret_key)
    sig = ''.join(lst)
    return md5.new(sig).hexdigest()

def open_url_in_browser(url):
    try:
        webbrowser.open(url)
    except:
        controller = webbrowser.get('macosx')
        controller.open(url)
        

class TokenCache(object):
    """Represents the cache of the token.
    
    It stores on the file system."""
    def __init__(self, api_key, base_path=os.path.expanduser('~')):
        self._api_key = api_key
        self.base_path = base_path
        self._token = None
    
    def get(self):
        """Gets the token from the cache."""
        if not self._token:
            self._token = self._read_token_from_file()
        return self._token
        
    def put(self, token):
        """Puts a new token in the cache overwriting the old one if any."""
        self._token = token
        self._write_token_to_file(self._token)
        
    def _get_cache_path(self):
        return os.path.join(self.base_path, '.flickyou', self._api_key)
        
    def _get_cache_filename(self):
        return os.path.join(self._get_cache_path(), 'token')
    
    def _read_token_from_file(self):
        f = None
        try:
            try:
                f = open(self._get_cache_filename(), 'r')
                return f.read().strip()
            except (IOError, OSError):
                return None
        finally:
            if f:
                f.close()
                
    def _write_token_to_file(self, token):
        if not os.path.exists(self._get_cache_path()):
            os.makedirs(self._get_cache_path())
        
        f = open(self._get_cache_filename(), 'w')
        f.write(token)
        f.write("\n")
        f.close()
