import tempfile
import unittest

from flickyou.backend import utils

class UtilsTestCase(unittest.TestCase):
    def test_api_signature(self):
        self.assertEquals('d41d8cd98f00b204e9800998ecf8427e',
            utils.get_api_signature(''))
        self.assertEquals('3858f62230ac3c915f300c664312c63f',
            utils.get_api_signature('foobar'))
            
    def test_token_cache(self):
        cache = utils.TokenCache('barfoo', tempfile.mkdtemp())
        self.assertEquals(None, cache.get())
        self.assert_(cache._token is None)
        cache.put("bazbaz")
        self.assertEquals("bazbaz", cache.get())
        self.assert_(cache._token)

if __name__ == '__main__':
    unittest.main()
