import logging
import urllib2
import json
import sys
import socket
from time import sleep
from hashlib import sha1
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-s", "--shepherd", dest="host", action="store", type="string", 
                  help="hostname for task manager (shepherd)", default="http://fstm.pudo.org")
parser.add_option("-v", "--debug",
                  action="store_true", dest="debug", default=False,
                  help="enable debug output")
parser.add_option("-d", "--daemon",
                  action="store_true", dest="daemon", default=False,
                  help="daemonize after start")
parser.add_option("-x", "--skip-version",
                  action="store_true", dest="skip_version", default=False,
                  help="don't check the client version against that of the server")

SERIAL = 20101226001

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('flockscrape')

def op_noop(task):
    return {'noop': 'no operation'}

def op_sleep(task):
    sleep(task.get('seconds', 5))
    log.info("sleeping...")
    return {}
    
def op_get(task):
    #raise ValueError()
    assert 'url' in task, 'No URL specified!'
    reply = {}
    class LRequest(urllib2.Request):
        def get_method(self):
            return task.get('method', 'GET')
    req = LRequest(task.get('url'))
    log.info("%s" % task.get('url'))
    for header, value in task.get('headers', {}).items():
        req.add_header(header, value)
    if 'data' in task:
        req.data = task.get('data')
    fh = urllib2.urlopen(req)
    reply['status_code'] = fh.code
    reply['http_message'] = unicode(fh.headers)
    reply['headers'] = fh.headers.items()
    reply['body'] = fh.read() #.encode('base64')
    fh.close()
    return reply

def push_task(result, host):
    req = urllib2.Request(host)
    req.add_header("Content-type", "application/json")
    req.data = json.dumps(result) if result else None
    urlfh = urllib2.urlopen(req)
    task = json.loads(urlfh.read())
    urlfh.close()
    return task
    
def handle_task(task):
    try:
        ret = {'status': 'success'} 
        op =  {'get': op_get,
               'sleep': op_sleep
              }.get(task.get('op'), op_noop)
        ret.update(op(task))
        return ret
    except Exception, e:
        log.exception(e)
        return {'status': 'error', 'message': repr(e)}
    
def run(host):
    result = None
    while True:
        try:
            task = push_task(result, host)
            #log.info("TASK: %s" % repr(task))
            result = handle_task(task)
            host_id = sha1(socket.gethostname()).hexdigest()
            result['host'] = host_id[:10]
            if 'ref' in task:
                result['ref'] = task.get('ref')
        except Exception, e:
            log.exception(e)
            from time import sleep
            sleep(5)

def check_version(host):
    task = push_task(None, host)
    assert task.get('_serial')==SERIAL, "Your client is outdated, please update!"

def daemonize(callable=run):
    import posix 
    import os
    pid = posix.fork()
    if pid == 0:
        sys.stdout.close()
        sys.stdout = open("/dev/null", "wb")
        sys.stderr.close()
        sys.stderr = open("/dev/null", "wb")
        sys.stdin.close()
        sys.stdin = open("/dev/null", "rb")
        #os.chroot("/")
        return
    msg = """FLOCKSCRAPE DAEMON
    
    The client is now running in daemon mode. You can close the current 
    window. To abort the client, please run the following command: 
        
        $ kill %s
    
    Thanks for contributing.
    """
    print msg % pid
    sys.exit()
    


if __name__ == '__main__':
    main()

def main():
    (options, args) = parser.parse_args()
    if not options.skip_version:
        check_version(options.host)
    
    if options.daemon:
        daemonize()
    
    if options.debug:
        pass
        #logging.basicConfig(level=logging.DEBUG)
        #log = logging.getLogger('flockscrape')
        
    run(host=options.host)

