from flopy.mbase import Package

class ModflowNwt(Package):
    '''Newton solver package
    Only programmed to work with the default values; need work for option [options = SPECIFIED]'''
    def __init__(self, model, headtol = 1E-4, fluxtol = 500, maxiterout = 100, \
                 thickfact = 1E-5, linmeth = 1, iprnwt = 0, ibotav = 0, options = 'COMPLEX', \
                 extension='nwt', unitnumber = 32):
        Package.__init__(self, model, extension, 'NWT', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# NWT for MODFLOW-NWT, generated by Flopy.'
        self.url = 'nwt_newton_solver.htm'
        self.headtol = headtol
        self.fluxtol = fluxtol
        self.maxiterout = maxiterout
        self.thickfact = thickfact
        self.linmeth = linmeth
        self.iprnwt = iprnwt
        self.ibotav = ibotav
        self.options = options
        self.parent.add_package(self)
    def __repr__( self ):
        return 'Newton solver package class'
    def write_file(self):
        # Open file for writing
        f_nwt = open(self.fn_path, 'w')
        f_nwt.write('%s\n' % self.heading)
        f_nwt.write('%10.1e%10.1e%10i%10.1e%10i%10i%10i%10s\n' % (self.headtol, self.fluxtol, self.maxiterout, self.thickfact, self.linmeth, self.iprnwt, self.ibotav, self.options))
        f_nwt.close()

