from flopy.mbase import Package

class ModflowPcg(Package):
    '''Pcg Package
    Only programmed to work with the default values; may need work for other options'''
    def __init__(self, model, mxiter=50, iter1=30, npcond=1,
                 hclose=1e-5, rclose=1e-5, relax=1.0, nbpol=0, iprpcg=0, mutpcg=3,
                 damp=1.0, dampt=1.0, ihcofadd=0,
                 extension='pcg', unitnumber=27):
        Package.__init__(self, model, extension, 'PCG', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# PCG for MODFLOW, generated by Flopy.'
        self.url = 'pcg.htm'
        self.mxiter = mxiter
        self.iter1 = iter1
        self.npcond = npcond
        self.hclose = hclose
        self.rclose = rclose
        self.relax = relax
        self.nbpol = nbpol
        self.iprpcg = iprpcg
        self.mutpcg = mutpcg
        self.damp = damp
        self.dampt = dampt
        self.ihcofadd = ihcofadd
        self.parent.add_package(self)
    def __repr__( self ):
        return 'Preconditioned conjugate gradient solver package class'
    def write_file(self):
        # Open file for writing
        f_pcg = open(self.fn_path, 'w')
        f_pcg.write('%s\n' % self.heading)
        ifrfm = self.parent.get_ifrefm()
        if ifrfm:
            f_pcg.write('{0} '.format(self.mxiter))
            f_pcg.write('{0} '.format(self.iter1))
            f_pcg.write('{0} '.format(self.npcond))
            f_pcg.write('{0} '.format(self.ihcofadd))
            f_pcg.write('\n')
            f_pcg.write('{0} '.format(self.hclose))
            f_pcg.write('{0} '.format(self.rclose))
            f_pcg.write('{0} '.format(self.relax))
            f_pcg.write('{0} '.format(self.nbpol))
            f_pcg.write('{0} '.format(self.iprpcg))
            f_pcg.write('{0} '.format(self.mutpcg))
            f_pcg.write('{0} '.format(self.damp))
            if self.damp < 0:
                f_pcg.write('{0} '.format(self.dampt))
            f_pcg.write('\n')
        else:
            f_pcg.write('{0:10d}'.format(self.mxiter))
            f_pcg.write('{0:10d}'.format(self.iter1))
            f_pcg.write('{0:10d}'.format(self.npcond))
            f_pcg.write('{0:10d}'.format(self.ihcofadd))
            f_pcg.write('\n')
            f_pcg.write('{0:9.4e} '.format(self.hclose))
            f_pcg.write('{0:9.4e} '.format(self.rclose))
            f_pcg.write('{0:9.4e} '.format(self.relax))
            f_pcg.write('{0:10d}'.format(self.nbpol))
            f_pcg.write('{0:10d}'.format(self.iprpcg))
            f_pcg.write('{0:10d}'.format(self.mutpcg))
            f_pcg.write('{0:9.4e} '.format(self.damp))
            if self.damp < 0:
                f_pcg.write('{0:9.4e} '.format(self.dampt))
            f_pcg.write('\n')
        f_pcg.close()
    @staticmethod
    def load(f, model, ext_unit_dict=None):
        if type(f) is not file:
            filename = f
            f = open(filename, 'r')
        #dataset 0 -- header
        while True:
            line = f.readline()
            if line[0] != '#':
                break
        #dataset 1
        ifrfm = model.get_ifrefm()
        if model.version != 'mf2k':
            ifrfm = True
        ihcofadd = 0
        dampt = 0.
        if ifrfm:
            t = line.strip().split()
            mxiter = int(t[0])
            iter1 = int(t[1])
            npcond = int(t[2])
            try:
                ihcofadd = int(t[3])
            except:
                pass
            line = f.readline()
            t = line.strip().split()
            hclose = float(t[0])
            rclose = float(t[1])
            relax = float(t[2])
            nbpol = int(t[3])
            iprpcg = int(t[4])
            mutpcg = int(t[5])
            damp = float(t[6])
            if damp < 0.:
                dampt = float(t[7])
        else:
            mxiter = int(line[0:10].strip())
            iter1 = int(line[10:20].strip())
            npcond = int(line[20:30].strip())
            try:
                ihcofadd = int(line[30:40].strip())
            except:
                pass
            line = f.readline()
            hclose = float(line[0:10].strip())
            rclose = float(line[10:20].strip())
            relax = float(line[20:30].strip())
            nbpol = int(line[30:40].strip())
            iprpcg = int(line[40:50].strip())
            mutpcg = int(line[50:60].strip())
            damp = float(line[60:70].strip())
            if damp < 0.:
                dampt = float(line[70:80].strip())

        pcg = ModflowPcg(model, mxiter=mxiter, iter1=iter1, npcond=npcond, ihcofadd=ihcofadd,\
                         hclose=hclose, rclose=rclose, relax=relax, nbpol=nbpol,\
                         iprpcg=iprpcg, mutpcg=mutpcg, damp=damp, dampt=dampt)
        return pcg

