"""Numerical simulations (:mod:`fluiddyn.simul`)
================================================

.. _simul:
.. currentmodule:: fluiddyn.simul

The package :mod:`fluiddyn.simul` **will** provide an object-oriented
toolkit for doing numerical simulations of different equations
(incompressible Navier-Stokes, shallow-water, primitive equations,
with and without the quasi-geostrophic limit, adjoin equations, ...)
with different simple methods (pseudo-spectral, finite differences)
and geometries (1D, 2D and 3D periodic, 1 inhomogeneous direction,
...).

The package is organised in four sub-packages:

.. autosummary::
   :toctree:

   util
   base
   operators
   solvers

"""

from fluiddyn.io import FLUIDDYN_PATH_SIM as path_dir_results

from fluiddyn.simul.util.util import (
    import_module_solver_from_key,
    load_sim_for_plot, load_state_phys_file,
    modif_resolution_from_dir, modif_resolution_all_dir)


from fluiddyn.simul.base.info_solver_params import create_params
