

import numpy as np


from fluiddyn.simul.base.output import OutputBase


class Output(OutputBase):

    @staticmethod
    def _complete_info_solver(info_solver):
        """Complete the ContainerXML info_solver.

        This is a static method!
        """
        info_solver.classes.Output.set_child('classes')
        classes = info_solver.classes.Output.classes

        base_name_mod = 'fluiddyn.simul.solvers.ns2d.output'

        classes.set_child(
            'PrintStdOut',
            attribs={'module_name': base_name_mod+'.print_stdout',
                     'class_name': 'PrintStdOutNS2D'})

        classes.set_child(
            'PhysFields',
            attribs={'module_name': 'fluiddyn.simul.base.output.phys_fields',
                     'class_name': 'PhysFieldsBase'})

        classes.set_child(
            'Spectra',
            attribs={'module_name': base_name_mod+'.spectra',
                     'class_name': 'SpectraNS2D'})

        classes.set_child(
            'spatial_means',
            attribs={'module_name': 'fluiddyn.simul.base.output.spatial_means',
                     'class_name': 'SpatialMeansNS2D'})

        attribs={
            'module_name': 'fluiddyn.simul.base.output.spect_energy_budget',
            'class_name': 'SpectralEnergyBudgetNS2D'}
        classes.set_child('spect_energy_budg', attribs=attribs)

        attribs={
            'module_name': 'fluiddyn.simul.base.output.increments',
            'class_name': 'Increments'}
        classes.set_child('increments', attribs=attribs)




    @staticmethod
    def _complete_params_with_default(params):
        """This static method is used to complete the *params* container.
        """
        OutputBase._complete_params_with_default(params)

        params.output.periods_save.set_attribs({
            'spectra': 0,
            'spatial_means': 0.5,
            'spect_energy_budg': 0.5,
            'increments': 0.5})

        params.output.phys_fields.field_to_plot = 'rot'

        params.output.set_child('spectra', attribs={'has_to_plot': False})
        params.output.set_child('spatial_means',
                                attribs={'has_to_plot': False})
        params.output.set_child('spect_energy_budg',
                                attribs={'has_to_plot': False})
        params.output.set_child('increments', attribs={'has_to_plot': False})





    def compute_energy_fft(self):
        rot_fft = self.sim.state.state_fft['rot_fft']
        ux_fft, uy_fft = self.vecfft_from_rotfft(rot_fft)
        return (np.abs(ux_fft)**2+np.abs(uy_fft)**2)/2

    def compute_enstrophy_fft(self):
        rot_fft = self.sim.state.state_fft['rot_fft']
        return np.abs(rot_fft)**2/2

    def compute_energy(self):
        energy_fft = self.compute_energy_fft()
        return self.sum_wavenumbers(energy_fft)

    def compute_enstrophy(self):
        enstrophy_fft = self.compute_enstrophy_fft()
        return self.sum_wavenumbers(enstrophy_fft)
