""" """

import numpy as np


from .output_base import OutputBaseSW1l


class OutputSW1l(OutputBaseSW1l):

    def compute_energies_fft(self):
        state = self.sim.state
        eta_fft = state('eta_fft')
        energyA_fft = self.sim.params.c2 * np.abs(eta_fft)**2/2
        Jx_fft = state('Jx_fft')
        Jy_fft = state('Jy_fft')
        ux_fft = state('ux_fft')
        uy_fft = state('uy_fft')
        energyK_fft = np.real( Jx_fft.conj()*ux_fft
                               + Jy_fft.conj()*uy_fft  )/2

        ## Test:
        # energyK_fft = np.real( ux_fft.conj()*ux_fft
        #                        + uy_fft.conj()*uy_fft  )/2

        rot_fft = state('rot_fft')
        uxr_fft, uyr_fft = self.vecfft_from_rotfft(rot_fft)
        rotJ_fft = self.rotfft_from_vecfft(Jx_fft, Jy_fft)
        Jxr_fft, Jyr_fft = self.vecfft_from_rotfft(rotJ_fft)
        energyKr_fft = np.real( Jxr_fft.conj()*uxr_fft
                                + Jyr_fft.conj()*uyr_fft )/2
        return energyK_fft, energyA_fft, energyKr_fft


    def compute_energiesKA_fft(self):
        state = self.sim.state
        eta_fft = state('eta_fft')
        energyA_fft = self.sim.params.c2 * np.abs(eta_fft)**2/2
        Jx_fft = state('Jx_fft')
        Jy_fft = state('Jy_fft')
        ux_fft = state('ux_fft')
        uy_fft = state('uy_fft')
        energyK_fft = np.real( Jx_fft.conj()*ux_fft
                               + Jy_fft.conj()*uy_fft  )/2

        ## Test:
        # energyK_fft = np.real( ux_fft.conj()*ux_fft
        #                        + uy_fft.conj()*uy_fft  )/2


        return energyK_fft, energyA_fft


