'use strict';

var FxA = require('../marionette/lib/fxa'),
    FxAUser = require('../marionette/lib/fxa_user'),
    constants = require('../marionette/lib/constants'),
    assert = require('assert');

marionette('Set Find My Device to ENABLED for end-to-end test', function() {
    FxA.config.prefs["identity.fxaccounts.auth.uri"] = process.env.FXA_SERVER;
    FxA.config.settings["debugger.remote-mode"] = 'adb-only';
    FxA.config.settings["debug.gaia.enabled"] = true;
    var client = marionette.client(FxA.config);
    var selectors;
    var app;
    var fxaUser;
    var fxa_user = process.env.FXA_USER;
    var fxa_pw = process.env.FXA_PW;
    var runSettingsMenu = function() {
      //this.client.helper.wait(FxA.maxTimeInMS);
      assert.ok(this.onClick(selectors.menuItemFmd) !== -1);
      //this.client.helper.wait(FxA.maxTimeInMS);
      assert.ok(this.onClick(selectors.fmdLogin) !== -1);
      this.client.switchToFrame();
      var frame = this.client.findElement(selectors.fxaFrame);
      this.client.switchToFrame(frame);
    };

    setup(function() {
        var fxaUserObj = new FxAUser(client);
        fxaUser = fxaUserObj.user(constants.USER_EXISTING);
        app = new FxA(client, fxaUser);
        app.runSettingsMenu = runSettingsMenu;
        selectors = FxA.Selectors;
        app.launch(FxA.SETTINGS_ORIGIN);
        app.runSettingsMenu();

    });

    test('should walk flow for: Settings > Find My Device - Enable', function () {
        assert.ok(app.enterInput(selectors.emailInput, fxa_user) !== -1);
        assert.ok(app.onClick(selectors.moduleNext) !== -1);
        assert.ok(app.enterInput(selectors.pwInput, fxa_pw) !== -1);
        assert.ok(app.onClick(selectors.moduleNext) !== -1);
        assert.ok(app.onClick(selectors.moduleDone) !== -1);
        client.switchToFrame();
        console.log('NEW USER: >>>' + fxa_user + '<<<');
        console.log('>>>READY-TO-ROCK<<<');
        //app.onClick(selectors.menuItemFmd);
        client.helper.wait(10*60000);
    });

});  // end: marionette















































































