'use strict';

var assert = require('assert'),
    http = require('http'),
    https = require('https'),
    url = require('url');

//var FxAUser = require('./fxa:_user');
/**
 * Abstraction around FxA app.
 * app URL is passed in since FxA isn't a standalone app
 * (launched by Settings, Marketplace, FTU, FMD, test_apps, etc.)
 *
 * @param client
 * @param fxaUser
 * @constructor
 */
//function FxA(client, URL, fxaUser) {
function FxA(client, fxaUser) {
    //this.client = client;
    this.client = client.scope({ searchTimeout: 20000 });
    this.email = fxaUser.email;
    this.password = fxaUser.password;
    this.accountExists = false;
}

FxA.maxTimeInMS = 8000;
FxA._confirmationMessage = 'you are seconds away from verifying your Firefox Account';
FxA.mailHost = 'http://restmail.net/mail/';
FxA.SETTINGS_ORIGIN = 'app://settings.gaiamobile.org';
FxA.UITEST_ORIGIN = 'app://uitest.gaiamobile.org';
FxA.TEST_FXA_CLIENT_ORIGIN = 'app://test-fxa-client.gaiamobile.org';
FxA.FTU_ORIGIN = 'app://communications.gaiamobile.org';

var LEN_NO_MAIL = 10;

FxA.config = {
    settings: {
        // disable keyboard ftu because it blocks our display
        'keyboard.ftu.enabled': false,
        //'ftu.manifestURL': null,
        //'lockscreen.enabled': false
        'identity.fxaccounts.ui.enabled': true,
        'debug.console.enabled': true,
        'debug.gaia.enabled': true,
        'debugger.remote-mode': 'adb-only'
    },
    prefs: {
        //'dom.w3c_touch_events.enabled': 1,
        // FxA-related prefs from sam
        'dom.identity.enabled': true,
        'toolkit.identity.debug': true,
        'dom.inter-app-communication-api.enabled': true,
        'dom.identity.syntheticEventsOk': true,
        //'identity.fxaccounts.ui.enabled': true,
        // enable debugging of certified/system apps
        'devtools.debugger.forbid-certified-apps': false,

        // this enables marionette which lets you run performance tests
        // see https://developer.mozilla.org/en-US/docs/Mozilla/Firefox_OS/Platform/Testing/Gaia_performance_tests
        'marionette.defaultPrefs.enabled': true,
        // this sets the port for remote debugging your application on the device
        'devtools.debugger.remote-port': 60000,
        // this enables the remote debugger
        'devtools.debugger.remote-enabled': true,
        // this outputs debug information about the Radio Interface Layer in logcat
        'ril.debugging.enabled': true,
        //'devtools.debugger.forbid-certified-apps': false

        // pass in FxA server config when instantiating marionette
        // default:
        // dev
        //'identity.fxaccounts.auth.uri': 'https://api-accounts.dev.lcip.org/v1'
        // stage
        'identity.fxaccounts.auth.uri': 'https://api-accounts.stage.mozaws.net/v1'
        // prod
        //'identity.fxaccounts.auth.uri': 'https://api.accounts.firefox.com/v1'
    }
};

FxA.Selectors = {
    body: 'body',
    bodyReady: 'body .view-body',

    // test_apps/uitest
    apiFxaFrame: '#test-iframe',
    fxaFrame:  '#fxa-iframe',
    tabAPI: '#API',
    fxaButton: '#mozId-fxa',
    requestButton: '#request',

    // test_apps/test-fxa-client
    tabOpenFlow: '#openFlow',

    // apps/settings
    menuItemFxa: '#menuItem-fxa',
    menuItemFmd: '#menuItem-findmydevice',
    fxaLogin: '#fxa-login',
    fmdLogin: '#findmydevice-login',
    fxaCancelAccountConfirmation: '#fxa-cancel-confirmation',
    menuItemWifi: '#menuItem-wifi',
    wifiIconBack: 'span[class="icon icon-back"]',
    wifiToggleOnOff: 'span[data-l10n-id="wifi"]',

    // apps/communications/ftu
    forward: '#forward',
    createAccountOrLogin: '#fxa-create-account',

    // apps/homescreen/everything.me/modules/Results/providers?? marketplace
    // apps/findmydevice

    emailInput: '#fxa-email-input',
    pwInput: '#fxa-pw-input',
    pwInputPostCOPPA: '#fxa-pw-set-input',
    pwSetInput: '#fxa-pw-set-input',
    pwRefresh: '#fxa-pw-input-refresh',
    COPPAElementId: '#fxa-coppa',
    COPPASelectId: 'fxa-age-select',
    COPPAOptionVal: '1990 or earlier',
    COPPAOptionValToFail: '2002',
    moduleNext: '#fxa-module-next',
    moduleDone: '#fxa-module-done',
    errorOK: '#fxa-error-ok'
};

FxA.prototype = {
    /**
     * Launches FxA app and focuses on frame.
     */
    launch: function (origin) {
        var client = this.client;

        // do unless FTU
        if(origin.search("communications") === -1) {
            client.apps.launch(origin);
        }
        client.apps.switchToApp(origin);
    },

    relaunch: function (origin) {
        this.client.apps.close(origin, 'FxA');
        this.launch(origin);
    },

    clickDone: function() {
        this.client.switchToFrame();
        this.client.switchToFrame(FxA.Selectors.fxaFrame);
        this.client.helper.wait(FxA.maxTimeInMS);
        assert.ok(this.onClick(FxA.Selectors.moduleDone) !== -1);
    },

    enterInput: function (inputId, inputString) {
        this.client.helper
            .waitForElement(inputId)
            .sendKeys(inputString)
        this.client.helper.wait(FxA.maxTimeInMS);
    },

    onClick:  function(searchSelector) {
        var element = this.client.findElement(searchSelector);
        this.client.helper
            .waitForElement(element)
            .tap();
    },

    /**
     * special click function for <select> tags
     * @param elementId
     * @param selectId
     * @param optionValue
     */
    onClickSelectOption:  function(elementId, selectId, optionValue) {
        //<select name="language.current"></select>
        //'languageChangeSelect': '#languages select[name="language.current"]',
        var searchSelector = elementId + ' select[id="' + selectId + '"]';
        var select = this.client.findElement(searchSelector);
        this.client.helper.tapSelectOption(select, optionValue);

        //TODO(rpappa)
        // fails without this wait time - bundle with above
        this.client.helper.wait(FxA.maxTimeInMS);
    },

    getAccountExists: function(email) {
        var chunks = '';
        var url = FxA.mailHost + email;

        getHTTP(FxA.mailHost +email, function(chunks) {
            if (chunks.length <= LEN_NO_MAIL) {
                console.log("\n\t\tNEW USER: no confirmation email");
            } else {
                console.log("\n\t\tEXISTING USER: confirmation email exists");
            }
        });
        //getHTTP(url, getRestmail);
    }
};


//callback function
function getRestmail(chunks) {
    var resp = '';
    console.log('getRestmail....');
    if (chunks.length <= LEN_NO_MAIL) {
        message = '\n\t\tNEW USER: no confirmation email';
    } else {
        message = '\n\t\tEXISTING USER: confirmation email exists';
    }
    console.log(message);
    resp = getURLs(url, chunks);
    for(var i = 0; i < resp.length; i++) {
        if( resp[i].match('verify_email') ) {
            console.log(resp[i]);
            getHTTPS(resp[i], doNothing);

        }
    }
};


function getURLs(urlString, chunk) {
    var matchingURLs = new RegExp(
	      "(^|[ \t\r\n])((ftp|http|https|mailto|file|webcal):(([A-Za-z0-9$_.+!*(),;/?:@&~=-])|%[A-Fa-f0-9]{2}){2,}(#([a-zA-Z0-9][a-zA-Z0-9$_.+!*(),;/?:@&~=%-]*))?([A-Za-z0-9$_+!*();/?:~-]))"
	     ,"g"
	   );
    return chunk.match(matchingURLs);
}

function getHTTP(urlString, callback) {
  var chunks = '';

    console.log("\n\t\tgetHTTP - URL: " + urlString);

    var req = http.get(urlString, function (res, err) {

        res.setEncoding('utf8');
        var code = res.statusCode;

        if (res.statusCode === 200) {
            res.on('data', function (chunk) {
                chunks += chunk;
            });
            res.on('end', function () {
                callback(chunks);
            });
        } else {
            console.log("server returned no status code");
        }

    }).on('error', function (e) {
        console.log("HTTP ERROR: " + e.message);
    });

    // send request
    req.end();
}

function getHTTPS(urlString, callback) {
  var chunks = '';

  console.log("\n\t\tgetHTTPS - URL: " + urlString);
  var urlObj = url.parse(urlString);

  var options = {
      host: urlObj.hostname,
      path: urlObj.path,
      method: 'GET'
  }
      //,
//      headers: {
//        accept: '*/*'
//      }
//  }


    var req = https.get(options, function (res, err) {
      res.setEncoding('utf8');
      var code = res.statusCode;

      console.log('code:'+ code);
      if (res.statusCode === 200) {
        res.on('data', function (chunk) {
          chunks += chunk;
        });
        res.on('end', function () {
          callback(chunks);
        });
      } else {
        console.log("server returned no status code");
      }

    }).on('error', function (e) {
        console.log("HTTPS ERROR: " + e.message);
  });

  // send request
  req.end();
  console.log('--------------------------');
  console.log(req._headers)
  console.log('--------------------------');
}

function doNothing() {
    console.log('doing nuthin');
};

var email = 'kilroy_mno@restmail.net';
//var app = new FxA();

var urlString = 'http://restmail.net/mail/' + email;
var message = '';

//getHTTP(urlString, getRestmail);



module.exports = FxA;
