#!/usr/bin/env python

from distutils.core import setup

setup(
    name = 'fmd-e2e',
    version = '0.0.3',
    description = 'Python script providing an end-to-end test for Mozilla Find My Device.',
    author = 'Richard Pappalardo',
    author_email = 'rpappalax@gmail.com',
    url = 'https://github.com/rpappalax/fmd-e2e',
    install_requires = ['fxa-python-client', 'test-out', 'selenium', 'psutil' ],
    package_data = { 'fmde2e': [ 'marionette/*.js', 'marionette/lib/*.js' ]},
    packages = [ 'fmde2e' ],
    entry_points={
        'console_scripts': [
            'fmde2e = fmde2e.fmd_test:FMDTest',
        ]
    },
    keywords = ['testing', 'findmydevice', 'end-to-end', 'e2e', 'firefoxos'],
    classifiers=[
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        ]
    )
