#!/usr/bin/env python
# encoding: utf-8

import time
import os
import argparse
from subprocess import Popen, PIPE, STDOUT
from test_out import TestOut
from process_handler import ProcessManager
from fmd_web_handler import FMDWebHandler
from distutils.sysconfig import get_python_lib
print get_python_lib()

'''
FMDTest() is a standalone class for functional testing of Find My Device on Desktop B2G and findmydevice web
'''
class FMDTest(object):

    def __init__(self):

        self.test_timeout = 90
        self.wait_time = 5 # seconds
        self.servers_fxa = {
            'prod': 'https://api.accounts.firefox.com/',
            'stage': 'https://api-accounts.stage.mozaws.net/',
            'dev': 'https://api-accounts.dev.lcip.org/'
        }

        self.servers_fmd = {
            'prod': 'https://find.firefox.com',
            'stage': 'https://fmd.stage.mozaws.net',
            'dev': '???'
        }
        self.fxa_password = '123456789'
        os.putenv('FXA_PW', self.fxa_password)
        self.dir_current = os.getcwd()
        self.dir_packages = get_python_lib()
        self.set_args()
        self.proc_mgr = ProcessManager()
        self.test_reporter = TestOut()
        self.test_reporter.log_file = 'fmd_test.log'
        self.tear_down_time = False


        for i in xrange(1, self.repeat + 1):
            self.test_reporter.test_start(test_num=i, test_type='CUSTOM')
            self.emailUTF8 = "fxa-%s@restmail.net" % os.urandom(6).encode("hex")
            self.fxa_user = self.emailUTF8
            os.putenv('FXA_USER', self.fxa_user)
            self.cmd_root = 'fxa-client --email {} --password {} '.format(self.emailUTF8, self.fxa_password)
            print self.cmd_root
            self.fmd_web = FMDWebHandler(
                self.selenium_server,
                self.fmd_server,
                self.fxa_user,
                self.fxa_password
            )
            self.fmd_web.test_reporter = self.test_reporter
            self.fmd_web.proc_mgr = self.proc_mgr
            self.run_test()
        self.test_reporter.write_result_summary()

    def set_args(self):

        parser = argparse.ArgumentParser(
            description='Script to test FIND MY DEVICE'
        )

        parser.add_argument('-f','--fmd-and-fxa-servers',
                            help='Enter: dev, stage or prod',
                            default='prod',
                            required=False)
        parser.add_argument('-g','--gaia-dir',
                            help="Enter path of gaia dir (default:" + \
                                 self.dir_current + ")",
                            default=self.dir_current,
                            required=False)
        parser.add_argument('-t','--test-timeout',
                            help="Enter the test timeout (default:" +
                                 str(self.test_timeout) + " seconds)",
                            default=self.test_timeout,
                            type=int,
                            required=False)
        parser.add_argument('-r','--repeat',
                            help="Enter # of times to repeat test (default:1)",
                            default=1,
                            type=int,
                            required=False)
        parser.add_argument('-s','--selenium-server',
                            help="Enter path of selenium jar file (default:" + \
                                 self.dir_packages +
                                 "/selenium-server-standalone-2.42.2.jar)",
                            default='/selenium-server-standalone-2.42.2.jar',
                            required=False)
        args = vars(parser.parse_args())

        server_choice = args['fmd_and_fxa_servers']
        self.fxa_server = self.servers_fxa[server_choice]
        self.fmd_server = self.servers_fmd[server_choice]

        self.gaia_dir = args['gaia_dir']
        self.test_timeout = args['test_timeout']
        self.repeat = args['repeat']
        self.selenium_server = args['selenium_server']

        # set env var for fxa-python-client
        os.putenv('PUBLIC_URL', self.fxa_server)
        # set env vars Marionette JS script
        os.putenv('FXA_SERVER', self.fxa_server + 'v1')
        os.putenv('FMD_SERVER', self.fmd_server)

    @property
    def result_current(self):
        return self._result_current

    @result_current.setter
    def result_current(self, value):
        self._result_current = value

    def run_test(self):
        self.fxa_user_create()
        # server must be loaded way in advance of fmd_web
        if not self.tear_down_time:
            self.fmd_web.selenium_start()
        if not self.tear_down_time:
            self.b2g_fmd_enable()
            time.sleep(self.wait_time)
        if not self.tear_down_time:
            self.fmd_web.test_fmd()
            time.sleep(self.wait_time)
        self.proc_mgr.tear_down()
        time.sleep(self.wait_time)

    # Monitor process log for matching string
    def monitor_proc_log(self, proc):
        flag_wait = False
        for line in iter(proc.stdout.readline,''):
            print line.rstrip()
            if 'Or if you used restmail.net use the verify command' in line:
                flag_wait = True
                break
            elif 'Verified Acct' in line:
                print 'New user: {} VERIFIED!'.format(self.fxa_user)
                flag_wait = True
                break
            elif 'Max retries exceeded with url' in line:
                self.tear_down('EXCEPTION', 'FxA verify: Connection error!')
                break
            elif '>>>READY-TO-ROCK<<<' in line:
                self.test_reporter.print_log('FMD ENABLED!','BIG_STRIPE')
                break
            elif 'onerror fired: {"name":"UNVERIFIED_ACCOUNT"}' in line:
                self.tear_down('EXCEPTION', 'B2G thinks user: {} is UNVERIFIED'
                                   .format(self.fxa_user))
                break
            elif 'NoSuchElement' in line:
                self.tear_down('EXCEPTION', line)
                break
            elif 'Error:' in line:
                self.tear_down('EXCEPTION', line)
                break

        # required for fxa-python-client
        if flag_wait:
            proc.wait()
            # !!! UNVERIFIED_ACCOUNT error occurs on B2G
            #     with verified users unless some wait time
            #     is reserved
            time.sleep(self.wait_time * 3)


    """Create & verify user on FxA server"""
    def fxa_user_create(self):

        cmd = self.cmd_root + ' create'
        proc = Popen(cmd, shell=True, stdout=PIPE, stdin=PIPE, stderr=STDOUT)
        self.test_reporter.print_log('Execute: fxa-python-client - create)'
                                     .format(proc.pid))
        print cmd
        self.monitor_proc_log(proc)
        cmd = self.cmd_root + ' verify'
        proc = Popen(cmd, shell=True, stdout=PIPE, stdin=PIPE, stderr=STDOUT)
        self.test_reporter.print_log('Execute: fxa-python-client - verify'
                                     .format(proc.pid))
        print cmd
        self.monitor_proc_log(proc)

    """Login to FxA & enable FindMyDevice on B2G (using Marionette JS)"""
    def b2g_fmd_enable(self):

        marionette_js_file = '{}/{}'.format(self.dir_packages, 'fmde2e/marionette/fmd_enable_ext.js')

        #TODO: https://bugzilla.mozilla.org/show_bug.cgi?id=1036172
        make_options = 'NO_LOCK_SCREEN=1 NOFTU=1 VERBOSE=1 DEBUG=b2g '
        # VERBOSE=1          adds some extra Marionette logging
        # DEBUG=b2g-desktop  adds VERY verbose Marionette logging
        # sets VERBOSE_OPTS='--verbose'

        # create profile with $ VERBOSE=1 make test-integration
        cmd = make_options + \
            ' PROFILE_FOLDER=' + self.gaia_dir + '/profile-test ' + \
            ' TEST_FILES=' + marionette_js_file + \
            ' make -f ' + self.gaia_dir + '/Makefile test-integration-test '

        # cmd = make_options + 'TEST_FILES=' + self.gaia_dir + '/apps/system/fxa/test/services/fmd_enable_ext.js  ' + \
        #       './bin/gaia-marionette --host marionette-b2gdesktop-host ' + \
        #       '--manifest ./sharedtest/integration/local-manifest.json --debug '

        proc_b2g = Popen(
            cmd,
            shell=True,
            stdout=PIPE,
            stdin=PIPE,
            stderr=STDOUT
        )
        self.test_reporter.print_log('Starting B2G - FMD enable)'
                                     .format(proc_b2g.pid))
        print cmd
        self.proc_b2g = proc_b2g.pid
        self.proc_mgr.register_pid('B2G', proc_b2g.pid)
        self.monitor_proc_log(proc_b2g)

    def tear_down(self, result='FAIL', message='N/A'):

        self.tear_down_time = True
        if(result is 'EXCEPTION'):
            f = self.test_reporter.log_file
            os.remove(f) if os.path.exists(f) else None
            self.test_reporter.print_log('Teardown time!')
            print '{}: {}'.format(result, message)

        self.proc_mgr.tear_down()
        self.test_reporter.test_end(result, message)
        # sys.exit(0)

if __name__ == '__main__':
    fmd = FMDTest()


