import time
import urllib2
from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException
from subprocess import Popen, PIPE, STDOUT

TEAR_DOWN_TIME = True

class FMDWebHandler(object):

    def __init__(
            self,
            selenium_server,
            fmd_server,
            fxa_user,
            fxa_password,
            test_timeout=60,
            browser_name='firefox'):

        self.fmd_server = fmd_server
        self.fxa_user = fxa_user
        self.fxa_password = fxa_password
        self.user_name = self.fxa_user.split('@')[0]
        self.test_timeout = test_timeout
        self.selenium_server = selenium_server
        self.browser_name = browser_name #'chrome'
        self.tear_down_time = False
        self.wait_time = 2 #seconds
        self.test_results = {
            'device_found': False,
            'ringer_activated': False,
            'device_locked': False,
            'device_erased': False
        }
        self.selenium_actions_csv = """category,locator,locator_desc,locator_method,locator_obj_method,keys_text
SIGNIN,Sign in,Sign in,find_element_by_link_text,click,
SIGNIN,input.email,[input] email,find_element_by_css_selector,send_keys,""" + self.fxa_user + """
SIGNIN,input.password,[input] password,find_element_by_css_selector,send_keys,""" + self.fxa_password + """
SIGNIN,submit-btn,fxa-login submit,find_element_by_id,click,
HEADER,//header//h1[text() = '""" + self.user_name + """'],h1 header with user_name: '""" + self.user_name + """,find_element_by_xpath,,
RINGER,//span//a,Ring,find_elements_by_xpath,click,
RINGER,//button[@class="play-sound primary"],[button] Ring,find_element_by_xpath,click,
LOCK,//span//a,Lock,find_elements_by_xpath,click,
LOCK,//textarea[@class="note"],textarea,find_element_by_xpath,send_keys,You been LOCKED OUT Home Skillet
LOCK,button.primary,[button] lost-mode,find_element_by_css_selector,click,
LOCK,passcode-1,[input] passcode-1,find_element_by_name,send_keys,1234
LOCK,passcode-2,[input] passcode-2,find_element_by_name,send_keys,1234
LOCK,//button[@class="activate primary"],[button] Lock,find_element_by_xpath,click,
ERASE,//span//a,Erase,find_elements_by_xpath,click,
ERASE,//button,button: Erase,find_element_by_xpath,click,
DEVICE_FIND,leaflet-map-pane,leaflet-map-pane,find_element_by_class_name,,
DEVICE_FIND,leaflet-marker-icon,[icon] Device,find_element_by_class_name,,"""

    @property
    def proc_selenium_pid(self):
        return self._proc_selenium_pid

    @proc_selenium_pid.setter
    def proc_selenium_pid(self, value):
        self.proc_selenium_pid = value

    @property
    def test_reporter(self):
        return self._test_reporter

    @test_reporter.setter
    def test_reporter(self, value):
        self._test_reporter = value

    def parse_csv(self, category):

        steps = []
        for line in self.selenium_actions_csv.split('\n'):
            holding=[]
            for var in line.split(','):
                holding.append(var)
            steps.append(holding)
        steps_final = []
        for step in steps:
            if step[0] == category:
                steps_final.append(step)
        return steps_final

    def selenium_start(self):

        cmd = 'java -jar ' + self.selenium_server
        proc_selenium = Popen(cmd, shell=True, stdout=PIPE, stdin=PIPE, stderr=STDOUT)
        self.test_reporter.print_log('Starting Selenium server'.format(proc_selenium.pid))
        print cmd
        self._proc_selenium_pid = proc_selenium.pid
        print proc_selenium.pid

    def wait_leave_page(self, current_url):

        while(self.driver.current_url == current_url):
            time.sleep(self.wait_time) #3
        return True

    """Get a Selenium locator object, given all necessary locator params

    Args:
        method_name ~= 'find_element_by_link_text'
        locator ~= '//span//a'
        locator_desc ~= 'Found the xyz link'
    Returns:
        * if true: return locator_obj
        * else: tear_down

    """
    def get_locator_obj(self, method_name, locator, locator_desc):

        try:
            locator_obj = getattr(self.driver, method_name)(locator)

            # if locator object is iterable, lets grab the object
            if hasattr(locator_obj, '__iter__'):
                for item in locator_obj:
                    # match on item.text == locator_desc
                    # Example <a href=somelink.com>locator_desc</a>
                    if item.text == locator_desc:
                        locator_obj = item
        except NoSuchElementException:
            if locator == 'leaflet-marker-icon':
                return 'FAIL', 'Device NOT found!'
            else:
                self.tear_down('FAIL', 'NOT FOUND: {}'.format(locator_desc))
                return False

        # !!! vulnerable to changes in CSV
        # We are determining True if we are able to activate
        # these controls, but a true validation would be if
        # we could check on the B2G client side that the action
        # was received:
        #
        if locator_desc == '[icon] Device':
            self.test_results['device_found'] = True
        if locator_desc == '[button] Ring':
            self.test_results['ringer_activated'] = True
        elif locator_desc == '[button] Lock':
            self.test_results['device_locked'] = True
        elif locator_desc == '[button] Erase':
            self.test_results['device_erased'] = True

        print 'FOUND: {}'.format(locator_desc)
        return locator_obj

    """Performs a single Selenium action, given all necessary input params
    (Used with get_locator_obj method)

    Args:
        method ~= 'find_elements_by_xpath'
        locator ~= '//input[class="email"]'
        locator_desc ~= '[input] email'
        locator_obj_method ~= 'send_keys'
        keys_text ~= 'johnny@restmail.net'

    Note:
        Could be used to exec all Selenium actions from a list (i.e. csv file)

    """
    def do_selenium_action(self, locator, locator_desc, method, locator_obj_method, keys_text=''):

        if self.tear_down_time:
            return
        locator_obj = self.get_locator_obj(method, locator, locator_desc)
        if locator_obj:
            if locator_obj_method:
                if keys_text:
                    getattr(locator_obj, locator_obj_method)(keys_text)
                else:
                    getattr(locator_obj, locator_obj_method)()
        else:
            return

    def run_steps(self, category, wait_time=0):

        if self.tear_down_time:
            return True

        actions = self.parse_csv(category=category)
        for action in actions:
            action = action[1:]
            self.do_selenium_action(*action)
            # we want to hear the ringer
            time.sleep(wait_time)

        if self.tear_down_time == True:
            return True
        else:
            return False

    def test_fmd_setup(self):

        self.test_reporter.print_log('Starting FMD Test')
        des_caps = {'browserName':self.browser_name}
        des_caps['loggingPrefs'] = { 'browser':'ALL' }

        try:
            self.driver = webdriver.Remote(desired_capabilities=des_caps)
        except urllib2.URLError:
            self.tear_down('FAIL', 'Connection refused!')
            return

        self.driver.implicitly_wait(self.test_timeout)
        self.driver.get(self.fmd_server)

        print 'TITLE: {}'.format(self.driver.title)
        print 'USERNAME: {}'.format(self.user_name)

    '''
    PURPOSE:
    1. device icon found = test PASS
    2. ringer started and verified (on device)
    3. lock initiated and verified (on device)
    4. erase initiated and verified (on device)

    NOTE:
    Should we make steps 2-4 part of test PASS criteria?
    '''
    def test_fmd(self):

        self.test_fmd_setup()
        if self.run_steps('SIGNIN')  == TEAR_DOWN_TIME: return

        # timer_start: once signed in
        self.test_reporter.timer_start()
        if self.run_steps('HEADER') == TEAR_DOWN_TIME: return
        if self.run_steps('DEVICE_FIND') == TEAR_DOWN_TIME: return

        # timer_end: when device icon appears
        self.test_reporter.timer_end()
        print 'TEST_DURATION: {}'.format(self.test_reporter.test_duration)
        print 'TEST_DURATION_AVG: {}'.format(self.test_reporter.test_duration_avg)

        if self.run_steps('RINGER', self.wait_time) == TEAR_DOWN_TIME: return
        if self.run_steps('LOCK') == TEAR_DOWN_TIME: return
        if self.run_steps('ERASE') == TEAR_DOWN_TIME: return

        # sleep time here for erase to complete and b2g to have time to react
        time.sleep(self.wait_time)

        print self.test_results
        if self.test_results['device_found']:
            self.tear_down('PASS', 'Device Found')
        else:
            self.tear_down('FAIL', 'Device NOT Found')

    def tear_down(self, result='FAIL', message='N/A'):

        self.tear_down_time = True
        self.test_reporter.timer_end()


        self.test_reporter.print_log('Teardown time!')
        print 'duration: {2}s | result: {0} | {1}'.format(
            result,
            message,
            self.test_reporter.test_duration
        )
        if self.test_results['device_found']:
            result = 'PASS'
            message = 'device found'
        if self.test_results['ringer_activated']:
            message += ', ringer activated'
        if self.test_results['device_locked']:
            message += ', device locked'
        if self.test_results['device_erased']:
            message += ', device erased'

        self.test_reporter.test_end(result, message)
        if(result is 'EXCEPTION'):
            print '{}: {}'.format(result, message)

        print 'KILLING Selenium'
        self.driver.quit()
        self.proc_mgr.tear_down()


if __name__ == '__main__':
    selenium_server = 'selenium-server-standalone-2.42.2.jar'
    fmd_server = 'https://find.firefox.com'
    fxa_user = '<your email here>'
    fxa_password = '<your password here>'
    fmd = FMDWebHandler(
        selenium_server,
        fmd_server,
        fxa_user,
        fxa_password
    )


