import os
import psutil
import signal

"""Manage system processes (and subprocesses) for cleanup"""
class ProcessManager(object):
    '''
    Description:
    * register individual processes by PID
    * store each process in a dictionary with a label
    * allows for cleanup of all parent/child processes at termination time
      (whether planned or upon throwing an exception)
    '''

    def __init__(self):
        # dictionary for registring process PIDs = { label: PID }
        self._procs = {}

    @property
    def procs(self):
        return self._procs

    @procs.setter
    def procs(self, value):
        self._procs = value

    def register_pid(self, label, pid):
        proc = {}
        proc[label] = pid
        self._procs.update(proc)

    def terminate_procs(self, proc_name, parent_pid, sig=signal.SIGTERM):

        try:
            p = psutil.Process(parent_pid)
        except Exception as e: #psutil.error.NoSuchProcess:
            print 'KILLING {} - NO SUCH PROCESS '.format(proc_name)
            return
        child_pid = p.get_children(recursive=True)
        for pid in child_pid:
            print 'KILLING {} - PID:{} '.format(proc_name, pid.pid)
            os.kill(pid.pid, sig)

        print 'KILLING {} - Parent PID:{} '.format(proc_name, parent_pid)
        os.kill(parent_pid, sig)

    def tear_down(self):

        for label,pid in self.procs.iteritems():
            self.terminate_procs(label, pid)
