/*
 @preserve Leaflet Data Visualization Framework, a JavaScript library for creating thematic maps using Leaflet
 (c) 2013, Scott Fairgrieve, HumanGeo
*/
L.LinearFunction=L.Class.extend({initialize:function(t,e,i){this.setOptions(i),this.setRange(t,e)},_calculateParameters:function(t,e){0===this._xRange?(this._slope=0,this._b=t.y):(this._slope=(e.y-t.y)/this._xRange,this._b=t.y-this._slope*t.x)},_arrayToPoint:function(t){return{x:t[0],y:t[1]}},setOptions:function(t){L.Util.setOptions(this,t),this._preProcess=this.options.preProcess,this._postProcess=this.options.postProcess},getBounds:function(){var t=Math.min(this._minPoint.x,this._maxPoint.x),e=Math.max(this._minPoint.x,this._maxPoint.x),i=Math.min(this._minPoint.y,this._maxPoint.y),n=Math.max(this._minPoint.y,this._maxPoint.y);return[new L.Point(t,i),new L.Point(e,n)]},setRange:function(t,e){return t=t instanceof Array?this._arrayToPoint(t):t,e=e instanceof Array?this._arrayToPoint(e):e,this._minPoint=t,this._maxPoint=e,this._xRange=e.x-t.x,this._calculateParameters(t,e),this},setMin:function(t){return this.setRange(t,this._maxPoint),this},setMax:function(t){return this.setRange(this._minPoint,t),this},setPreProcess:function(t){return this._preProcess=t,this},setPostProcess:function(t){return this._postProcess=t,this},evaluate:function(t){var e;return this._preProcess&&(t=this._preProcess(t)),e=Number((this._slope*t).toFixed(6))+Number(this._b.toFixed(6)),this._postProcess&&(e=this._postProcess(e)),e},random:function(){var t=Math.random()*this._xRange+this._minPoint.x;return this.evaluate(t)},sample:function(t){t=Math.max(t,2);for(var e=t-1,i=this._xRange/e,n=this._minPoint.x,a=[];n<=this._maxPoint.x;)a.push(this.evaluate(n)),n+=i;return a},samplePoints:function(t){t=Math.max(t,2);for(var e=t-1,i=this._xRange/e,n=this._minPoint.x,a=[];n<=this._maxPoint.x;)a.push(new L.Point(n,this.evaluate(n))),n+=i;return a},getIntersectionPoint:function(t){var e=null;if(this._slope!==t._slope){var i=(this._b-t._b)/(t._slope-this._slope),n=this.evaluate(i);e=new L.Point(i,n)}return e}}),L.ColorFunction=L.LinearFunction.extend({options:{alpha:1,includeAlpha:!1},initialize:function(t,e,i){L.Util.setOptions(this,i),this._parts=[],this._dynamicPart=null,this._outputPrecision=0,this._prefix=null,this._formatOutput=function(t){return t.toFixed(this._outputPrecision)},this._mapOutput=function(t){for(var e=[],i=0;i<this._parts.length;++i){var n=this._parts[i];e.push(t[n])}return this.options.includeAlpha&&e.push(this.options.alpha),e},this._getColorString=function(t){t=this._formatOutput(t),this.options[this._dynamicPart]=t;var e=this._mapOutput(this.options);return this._writeColor(this._prefix,e)},this._writeColor=function(t,e){return this.options.includeAlpha&&(t+="a"),t+"("+e.join(",")+")"};var n=function(t){i&&i.postProcess&&(t=i.postProcess.call(this,t));var e=this._getColorString(t);return L.Browser.ie&&e.indexOf("hsl")>-1&&(e=L.hslColor(e).toRGBString()),e};L.LinearFunction.prototype.initialize.call(this,t,e,{preProcess:this.options.preProcess,postProcess:n})}}),L.HSLColorFunction=L.ColorFunction.extend({initialize:function(t,e,i){L.ColorFunction.prototype.initialize.call(this,t,e,i),this._parts=["outputHue","outputSaturation","outputLuminosity"],this._prefix="hsl",this._outputPrecision=2}}),L.RGBColorFunction=L.ColorFunction.extend({initialize:function(t,e,i){L.ColorFunction.prototype.initialize.call(this,t,e,i),this._parts=["outputRed","outputBlue","outputGreen"],this._prefix="rgb",this._outputPrecision=0}}),L.RGBRedFunction=L.LinearFunction.extend({options:{outputGreen:0,outputBlue:0},initialize:function(t,e,i){L.RGBColorFunction.prototype.initialize.call(this,t,e,i),this._dynamicPart="outputRed"}}),L.RGBBlueFunction=L.LinearFunction.extend({options:{outputRed:0,outputGreen:0},initialize:function(t,e,i){L.RGBColorFunction.prototype.initialize.call(this,t,e,i),this._dynamicPart="outputBlue"}}),L.RGBGreenFunction=L.LinearFunction.extend({options:{outputRed:0,outputBlue:0},initialize:function(t,e,i){L.RGBColorFunction.prototype.initialize.call(this,t,e,i),this._dynamicPart="outputGreen"}}),L.RGBColorBlendFunction=L.LinearFunction.extend({initialize:function(t,e,i,n){i=new L.RGBColor(i),n=new L.RGBColor(n);var a=i.r(),o=n.r(),r=i.g(),s=n.g(),f=i.b(),d=n.b();this._minX=t,this._maxX=e,this._redFunction=new L.LinearFunction(new L.Point(t,a),new L.Point(e,o)),this._greenFunction=new L.LinearFunction(new L.Point(t,r),new L.Point(e,s)),this._blueFunction=new L.LinearFunction(new L.Point(t,f),new L.Point(e,d))},getBounds:function(){var t=this._redFunction.getBounds(),e=this._greenFunction.getBounds(),i=this._blueFunction.getBounds(),n=Math.min(t[0].y,e[0].y,i[0].y),a=Math.max(t[0].y,e[0].y,i[0].y);return[new L.Point(t[0].x,n),new L.Point(t[1].x,a)]},evaluate:function(t){return new L.RGBColor([this._redFunction.evaluate(t),this._greenFunction.evaluate(t),this._blueFunction.evaluate(t)]).toRGBString()}}),L.HSLHueFunction=L.HSLColorFunction.extend({options:{outputSaturation:"100%",outputLuminosity:"50%"},initialize:function(t,e,i){L.HSLColorFunction.prototype.initialize.call(this,t,e,i),this._dynamicPart="outputHue"}}),L.HSLSaturationFunction=L.LinearFunction.extend({options:{outputHue:0,outputLuminosity:"50%"},initialize:function(t,e,i){L.HSLColorFunction.prototype.initialize.call(this,t,e,i),this._formatOutput=function(t){return(100*t).toFixed(this._outputPrecision)+"%"},this._dynamicPart="outputSaturation"}}),L.HSLLuminosityFunction=L.LinearFunction.extend({options:{outputHue:0,outputSaturation:"100%"},initialize:function(t,e,i){L.HSLColorFunction.prototype.initialize.call(this,t,e,i),this._formatOutput=function(t){return(100*t).toFixed(this._outputPrecision)+"%"},this._dynamicPart="outputLuminosity"}}),L.HSLColorBlendFunction=L.LinearFunction.extend({initialize:function(t,e,i,n){i=new L.HSLColor(i),n=new L.HSLColor(n);var a=i.h(),o=n.h(),r=i.s(),s=n.s(),f=i.l(),d=n.l();this._minX=t,this._maxX=e,this._hueFunction=new L.LinearFunction(new L.Point(t,a),new L.Point(e,o)),this._saturationFunction=new L.LinearFunction(new L.Point(t,r),new L.Point(e,s)),this._luminosityFunction=new L.LinearFunction(new L.Point(t,f),new L.Point(e,d))},getBounds:function(){var t=this._hueFunction.getBounds(),e=this._saturationFunction.getBounds(),i=this._luminosityFunction.getBounds(),n=Math.min(t[0].y,e[0].y,i[0].y),a=Math.max(t[0].y,e[0].y,i[0].y);return[new L.Point(t[0].x,n),new L.Point(t[1].x,a)]},evaluate:function(t){return new L.HSLColor([this._hueFunction.evaluate(t),this._saturationFunction.evaluate(t),this._luminosityFunction.evaluate(t)]).toHSLString()}}),L.PiecewiseFunction=L.LinearFunction.extend({initialize:function(t,e){L.Util.setOptions(this,e),this._functions=t;var i,n;i=t[0].getBounds()[0],n=t[t.length-1].getBounds()[1],L.LinearFunction.prototype.initialize.call(this,i,n,{preProcess:this.options.preProcess,postProcess:this.options.postProcess})},_getFunction:function(t){for(var e,i,n,a,o=!1,r=0;r<this._functions.length;++r)if(a=this._functions[r],e=a.getBounds(),i=e[0],n=e[1],t>=i.x&&t<n.x){o=!0;break}return o?a:this._functions[this._functions.length-1]},evaluate:function(t){var e,i=null;return this._preProcess&&(t=this._preProcess(t)),e=this._getFunction(t),e&&(i=e.evaluate(t),this._postProcess&&(i=this._postProcess(i))),i}}),L.CustomColorFunction=L.PiecewiseFunction.extend({options:{interpolate:!0},initialize:function(t,e,i,n){var a,o=e-t,r=o/(i.length-1),s=[];L.Util.setOptions(this,n);for(var f=0;f<i.length;++f){var d=Math.min(f+1,i.length-1);a=this.options.interpolate?new L.RGBColorBlendFunction(t+r*f,t+r*d,i[f],i[d]):new L.RGBColorBlendFunction(t+r*f,t+r*d,i[f],i[f]),s.push(a)}L.PiecewiseFunction.prototype.initialize.call(this,s)}}),L.CategoryFunction=L.Class.extend({initialize:function(t,e){L.Util.setOptions(this,e),this._categoryKeys=Object.keys(t),this._categoryMap=t,this._preProcess=this.options.preProcess,this._postProcess=this.options.postProcess},evaluate:function(t){var e;return this._preProcess&&(t=this._preProcess(t)),e=this._categoryMap[t],this._postProcess&&(e=this._postProcess(e)),e},getCategories:function(){return this._categoryKeys}}),Array.prototype.indexOf||(Array.prototype.indexOf=function(t,e){for(var i=e||0,n=this.length;n>i;i++)if(this[i]===t)return i;return-1}),Object.keys||(Object.keys=function(){var t=Object.prototype.hasOwnProperty,e=!{toString:null}.propertyIsEnumerable("toString"),i=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],n=i.length;return function(a){var o,r,s;if("object"!=typeof a&&"function"!=typeof a||null===a)throw new TypeError("Object.keys called on non-object");o=[];for(r in a)t.call(a,r)&&o.push(r);if(e)for(s=0;n>s;s++)t.call(a,i[s])&&o.push(i[s]);return o}}()),L.Util.guid=function(){var t=function(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)};return t()+t()+"-"+t()+"-"+t()+"-"+t()+"-"+t()+t()+t()},L.Util.getProperty=function(t,e,i){return e in t?t[e]:i},L.Util.setFieldValue=function(t,e,i){for(var n,a=e.split("."),o=t,r=0;r<a.length-1;++r)n=a[r],o[n]=o[n]||{},o=o[n];o[a[a.length-1]]=i},L.Util.getFieldValue=function(t,e){var i=null;if(e){for(var n,a,o,r,s,f,d,c=e.split("."),l=t,u=-1,h=0;h<c.length;++h)if(n=c[h],u=n.indexOf("["),u>-1){f=n.substring(u),n=n.substring(0,u),f=f.replace("[","").replace("]",""),a=f.split("="),o=a[0],r=a[1],l=l[n];for(var b=0;b<l.length;++b)s=l[b],d=s[o],d&&d===r&&(l=s)}else{if(!l||!l.hasOwnProperty(n)){l=null;break}l=l[n]}i=l}else i=t;return i},L.Util.getNumericRange=function(t,e){var i=Number.MAX_VALUE,n=Number.MIN_VALUE;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a],r=L.Util.getFieldValue(o,e);i=Math.min(i,r),n=Math.max(n,r)}return[i,n]},L.CategoryLegend=L.Class.extend({initialize:function(t){L.Util.setOptions(this,t)},generate:function(t){t=t||{};var e=document.createElement("div"),i=L.DomUtil.create("div","legend",e),n=t.className,a=this.options;n&&L.DomUtil.addClass(i,n),t.title&&(L.DomUtil.create("div","legend-title",i).innerHTML=t.title);for(var o in a){categoryOptions=a[o];var r=categoryOptions.displayName||o,s=L.DomUtil.create("div","data-layer-legend",i),f=L.DomUtil.create("div","legend-box",s);L.DomUtil.create("div","key",s).innerHTML=r,L.StyleConverter.applySVGStyle(f,categoryOptions)}return e.innerHTML}}),L.LegendIcon=L.DivIcon.extend({initialize:function(t,e,i){var n,a=document.createElement("div"),o=L.DomUtil.create("div","legend",a),r=L.DomUtil.create("div","title",o),s=L.DomUtil.create("div","legend-box",o),f=L.DomUtil.create("div","legend-values",o),d=e.title||e.name;d&&(r.innerHTML=d);for(var c in t)n=t[c],L.DomUtil.create("div","key",f).innerHTML=n.name||c,L.DomUtil.create("div","value",f).innerHTML=n.value;L.StyleConverter.applySVGStyle(s,e),s.style.height="5px",i.html=a.innerHTML,i.className=i.className||"legend-icon",L.DivIcon.prototype.initialize.call(this,i)}}),L.legendIcon=function(t,e,i){return new L.LegendIcon(t,e,i)},L.GeometryUtils={getName:function(t){var e=null;if(t&&t.features)for(var i=0;i<t.features.length;++i){var n=t.features[i];if(n.properties&&n.properties.name){e=n.properties.name;break}}return e},getGeoJSONLocation:function(t,e,i,n){var a=new L.GeoJSON(t,{pointToLayer:function(t,a){var o={location:a,text:i?L.Util.getFieldValue(e,i):[a.lat.toFixed(3),a.lng.toFixed(3)].join(", "),center:a};return n(o,e)}}),o=null;try{o=L.GeometryUtils.loadCentroid(t)}catch(r){console.log("Error loading centroid for "+JSON.stringify(t))}return{location:a,text:i?L.Util.getFieldValue(e,i):null,center:o}},mergeProperties:function(t,e,i){var n,a,o=e.features,r=L.GeometryUtils.indexFeatureCollection(o,i),s={type:"FeatureCollection",features:[]};for(var f in t)if(t.hasOwnProperty(f)&&(n=t[f],a=n[i])){var d=r[a];for(var c in n)d.properties[c]=n[c];s.features.push(d)}return s},indexFeatureCollection:function(t,e){for(var i,n,a,o=t.features,r={},s=0;s<o.length;++s)if(i=o[s],n=i.properties,a=n[e],a in r){var f=r[a];"GeometryCollection"!==f.geometry.type?r[a]={type:"Feature",geometry:{type:"GeometryCollection",geometries:[i.geometry,f.geometry]}}:f.geometry.geometries.push(i.geometry)}else r[a]=i;return r},arrayToMap:function(t,e,i){for(var n,a,o,r={},s=0;s<t.length;++s)n=t[s],a=n[e],o=i?n[i]:n,r[a]=o;return r},arrayToMaps:function(t,e){for(var i,n,a,o,r,s,f,d=[],c=0;c<e.length;++c)d.push({});for(var l=0;l<t.length;++l){n=t[l];for(var u=0;u<e.length;++u)i=d[u],r=e[u],s=r.from,f=r.to,a=n[s],o=f?n[f]:n,i[a]=o}return d},loadCentroid:function(t){var e,i,n,a=null;if(t.geometry&&"Point"===t.geometry.type)a=new L.LatLng(t.geometry.coordinates[1],t.geometry.coordinates[0]);else if("undefined"!=typeof jsts){var o=new jsts.io.GeoJSONParser,r=o.read(t);if(r.getCentroid)e=r.getCentroid(),i=e.coordinate.x,n=e.coordinate.y;else if(r.features){for(var s=0,f=0,d=0;d<r.features.length;++d)e=r.features[d].geometry.getCentroid(),s+=e.coordinate.x,f+=e.coordinate.y;i=s/r.features.length,n=f/r.features.length}else e=r.geometry.getCentroid(),i=e.coordinate.x,n=e.coordinate.y;a=new L.LatLng(n,i)}return a},loadCentroids:function(t){var e,i={};for(var n in t)e=t[n],i[n]=L.GeometryUtils.loadCentroid(e);return i}},L.SVGPathBuilder=L.Class.extend({initialize:function(t,e,i){this._points=t||[],this._innerPoints=e||[],L.Util.setOptions(this,i)},options:{closePath:!0},_getPathString:function(t,e){var i="";if(t.length>0){var n=t[0],e=null!==e?e:2,a="M",o="L",r="Z";L.Browser.vml&&(e=0,a="m",o="l",r="xe"),i=a+n.x.toFixed(e)+","+n.y.toFixed(e);for(var s=1;s<t.length;s++)n=t[s],i+=o+n.x.toFixed(e)+","+n.y.toFixed(e);this.options.closePath&&(i+=r)}return i},addPoint:function(t,e){e?this._innerPoints.push(t):this._points.push(t)},build:function(t){t=t||this.options.digits;var e=this._getPathString(this._points,t);return this._innerPoints&&(e+=this._getPathString(this._innerPoints,t)),e}}),L.StyleConverter={keyMap:{fillColor:{property:["background-color"],valueFunction:function(t){return t}},color:{property:["color","border-top-color","border-right-color","border-bottom-color","border-left-color"],valueFunction:function(t){return t}},weight:{property:["border-width"],valueFunction:function(t){return Math.ceil(t)+"px"}},stroke:{property:["border-style"],valueFunction:function(t){return t===!0?"solid":"none"}},dashArray:{property:["border-style"],valueFunction:function(t){var e="solid";return t&&(e="dashed"),e}},barThickness:{property:["height"],valueFunction:function(t){return t+"px"}},radius:{property:["height"],valueFunction:function(t){return 2*t+"px"}},fillOpacity:{property:["opacity"],valueFunction:function(t){return t}}},applySVGStyle:function(t,e,i){var n=L.StyleConverter.keyMap;i&&(n=L.Util.extend(n,i)),t.style.borderStyle="solid";for(var a in e)L.StyleConverter.setCSSProperty(t,a,e[a],n);return t},setCSSProperty:function(t,e,i,n){var n=n||L.StyleConverter.keyMap,a=n[e],o="";if(a)for(var r=a.property,s=0,f=r.length;f>s;++s)o+=r[s]+":"+a.valueFunction(i)+";";return t.style.cssText+=o,t}},L.StylesBuilder=L.Class.extend({initialize:function(t,e){this._categories=t,this._styleFunctionMap=e,this._buildStyles()},_buildStyles:function(){for(var t,e,i,n={},a=0;a<this._categories.length;++a){t=this._categories[a],n[t]={};for(var o in this._styleFunctionMap)e=this._styleFunctionMap[o],i=e.evaluate?e.evaluate(a):"function"==typeof e?e(a):e,n[t][o]=i}this._styleMap=n},getStyles:function(){return this._styleMap}}),L.PaletteBuilder=L.Class.extend({initialize:function(t){this._styleFunctionMap=t},generate:function(t){t=t||{};var e=document.createElement("div"),i=L.DomUtil.create("div","palette",e),n=t.count||10,a=function(t){for(var e=[],i=0;t>i;++i)e.push(i);return e}(n),o=new L.StylesBuilder(a,this._styleFunctionMap),r=o.getStyles();t.className&&L.DomUtil.addClass(i,t.className);for(var s in r){var f=L.DomUtil.create("i","palette-element",i),d=r[s];L.StyleConverter.applySVGStyle(f,d)}return e.innerHTML}}),L.HTMLUtils={buildTable:function(t,e,i){function n(t,e){for(var i=0,n=t.length;n>i;i++)if(t[i]===e)return!0;return!1}e=e||"table table-condensed table-striped table-bordered";var a=L.DomUtil.create("table",e),o=L.DomUtil.create("thead","",a),r=L.DomUtil.create("tbody","",a);o.innerHTML="<tr><th>Name</th><th>Value</th></tr>",i=i||[];for(var s in t)if(t.hasOwnProperty(s)&&!n(i,s)){var f=t[s];if("object"==typeof f){var d=document.createElement("div");d.appendChild(L.HTMLUtils.buildTable(f,i)),f=d.innerHTML}r.innerHTML+="<tr><td>"+s+"</td><td>"+f+"</td></tr>"}return a}},L.AnimationUtils={animate:function(t,e,i,n){var a=n.delay||0,o=n.frames||30,r=n.duration||500,s={},f=n.easeFunction||function(t){return t},d=n.complete,c=r/o;for(var l in e)"color"!=l&&"fillColor"!=l&&i[l]?s[l]=new L.LinearFunction([0,e[l]],[o-1,i[l]]):("color"==l||"fillColor"==l)&&(s[l]=new L.RGBColorBlendFunction(0,o-1,e[l],i[l]));var u={},h=0,b=function(){for(var e in s)u[e]=s[e].evaluate(h);t.options=L.extend({},t.options,u),t.setStyle(t.options).redraw(),h++,c=f(c),o>h?setTimeout(b,c):d()};setTimeout(b,a)}},L.Color=L.Class.extend({initialize:function(t){this._rgb=[0,0,0],this._hsl=[0,1,.5],this._a=1,t&&this.parseColorDef(t)},parseColorDef:function(){},rgbToHSL:function(t,e,i){t/=255,e/=255,i/=255;var n,a,o=Math.max(t,e,i),r=Math.min(t,e,i),s=(o+r)/2;if(o==r)n=a=0;else{var f=o-r;switch(a=s>.5?f/(2-o-r):f/(o+r),o){case t:n=(e-i)/f+(i>e?6:0);break;case e:n=(i-t)/f+2;break;case i:n=(t-e)/f+4}n/=6}return[n,a,s]},hslToRGB:function(t,e,i){function n(t,e,i){return 0>i&&(i+=1),i>1&&(i-=1),1/6>i?t+6*(e-t)*i:.5>i?e:2/3>i?t+(e-t)*(2/3-i)*6:t}var a,o,r;if(0==e)a=o=r=i;else{var s=.5>i?i*(1+e):i+e-i*e,f=2*i-s;a=n(f,s,t+1/3),o=n(f,s,t),r=n(f,s,t-1/3)}return[Math.floor(255*a),Math.floor(255*o),Math.floor(255*r)]},setRGB:function(t,e,i){return this._rgb=[t,e,i],this._hsl=this.rgbToHSL(t,e,i),this},setHSL:function(t,e,i){return this._hsl=[t,e,i],this._rgb=this.hslToRGB(t,e,i),this},toHSL:function(){return this._hsl},toHSLString:function(){var t="hsl";return this._a<1&&(t+="a"),t+"("+(360*this._hsl[0]).toFixed(1)+","+(100*this._hsl[1]).toFixed(0)+"%,"+(100*this._hsl[2]).toFixed(0)+"%)"},toRGB:function(){return this._rgb},toRGBString:function(){var t;if(this._a<1)t="rgba("+this._rgb[0].toFixed(0)+","+this._rgb[1].toFixed(0)+","+this._rgb[2].toFixed(0)+","+this._a.toFixed(1)+")";else{for(var e=[this._rgb[0].toString(16),this._rgb[1].toString(16),this._rgb[2].toString(16)],i=0;i<e.length;++i)1===e[i].length&&(e[i]="0"+e[i]);t="#"+e.join("")}return t},r:function(t){return arguments.length?this.setRGB(t,this._rgb[1],this._rgb[2]):this._rgb[0]},g:function(t){return arguments.length?this.setRGB(this._rgb[0],t,this._rgb[2]):this._rgb[1]},b:function(t){return arguments.length?this.setRGB(this._rgb[0],this._rgb[1],t):this._rgb[2]},h:function(t){return arguments.length?this.setHSL(t,this._hsl[1],this._hsl[2]):this._hsl[0]},s:function(t){return arguments.length?this.setHSL(this._hsl[0],t,this._hsl[2]):this._hsl[1]},l:function(t){return arguments.length?this.setHSL(this._hsl[0],this._hsl[1],t):this._hsl[2]},a:function(t){return arguments.length?(this._a=t,this):this._a}}),L.RGBColor=L.Color.extend({initialize:function(t){L.Color.prototype.initialize.call(this,t)},parseColorDef:function(t){var e,i,n,a,o=t instanceof Array,r=0===t.indexOf("#"),s=[];o?(e=Math.floor(t[0]),i=Math.floor(t[1]),n=Math.floor(t[2]),a=4===t.length?t[3]:1):r?(t=t.replace("#",""),e=parseInt(t.substring(0,2),16),i=parseInt(t.substring(2,4),16),n=parseInt(t.substring(4,6),16),a=8===t.length?parseInt(t.substring(6,8),16):1):(s=t.replace("rgb","").replace("a","").replace(/\s+/g,"").replace("(","").replace(")","").split(","),e=parseInt(s[0]),i=parseInt(s[1]),n=parseInt(s[2]),a=4===s.length?parseInt(s[3]):1),this.setRGB(e,i,n),this._a=a}}),L.rgbColor=function(t){return new L.RGBColor(t)},L.HSLColor=L.Color.extend({initialize:function(t){L.Color.prototype.initialize.call(this,t)},parseColorDef:function(t){var e,i,n,a,o=t instanceof Array;if(o)e=t[0],i=t[1],n=t[2],a=4===t.length?t[3]:1;else{var r=t.replace("hsl","").replace("a","").replace("(","").replace(/\s+/g,"").replace(/%/g,"").replace(")","").split(",");e=Number(r[0])/360,i=Number(r[1])/100,n=Number(r[2])/100,a=4===r.length?parseInt(r[3]):1}this.setHSL(e,i,n),this._a=a}}),L.hslColor=function(t){return new L.HSLColor(t)},L.Animation=L.Class.extend({initialize:function(t,e){this._easeFunction=t,this._animateFrame=e},run:function(t,e){this.stop(),this._el=t,this._inProgress=!0,this._duration=e.duration||.25,this._animationOptions=e,this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(),this._complete())},_animate:function(){this._animId=L.Util.requestAnimFrame(this._animate,this),this._step()},_step:function(){var t=+new Date-this._startTime,e=1e3*this._duration;e>t?this._runFrame(this._easeFunction(t/e)):(this._runFrame(1),this._complete())},_runFrame:function(t){this._animateFrame(t),this.fire("step")},_complete:function(){L.Util.cancelAnimFrame(this._animId),this._inProgress=!1,this.fire("end")}}),L.ColorBrewer={Sequential:{YlGn:{3:["#f7fcb9","#addd8e","#31a354"],4:["#ffffcc","#c2e699","#78c679","#238443"],5:["#ffffcc","#c2e699","#78c679","#31a354","#006837"],6:["#ffffcc","#d9f0a3","#addd8e","#78c679","#31a354","#006837"],7:["#ffffcc","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],8:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],9:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"]},YlGnBu:{3:["#edf8b1","#7fcdbb","#2c7fb8"],4:["#ffffcc","#a1dab4","#41b6c4","#225ea8"],5:["#ffffcc","#a1dab4","#41b6c4","#2c7fb8","#253494"],6:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#2c7fb8","#253494"],7:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],8:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],9:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"]},GnBu:{3:["#e0f3db","#a8ddb5","#43a2ca"],4:["#f0f9e8","#bae4bc","#7bccc4","#2b8cbe"],5:["#f0f9e8","#bae4bc","#7bccc4","#43a2ca","#0868ac"],6:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#43a2ca","#0868ac"],7:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],8:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],9:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"]},BuGn:{3:["#e5f5f9","#99d8c9","#2ca25f"],4:["#edf8fb","#b2e2e2","#66c2a4","#238b45"],5:["#edf8fb","#b2e2e2","#66c2a4","#2ca25f","#006d2c"],6:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#2ca25f","#006d2c"],7:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],8:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],9:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"]},PuBuGn:{3:["#ece2f0","#a6bddb","#1c9099"],4:["#f6eff7","#bdc9e1","#67a9cf","#02818a"],5:["#f6eff7","#bdc9e1","#67a9cf","#1c9099","#016c59"],6:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#1c9099","#016c59"],7:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],8:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],9:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"]},PuBu:{3:["#ece7f2","#a6bddb","#2b8cbe"],4:["#f1eef6","#bdc9e1","#74a9cf","#0570b0"],5:["#f1eef6","#bdc9e1","#74a9cf","#2b8cbe","#045a8d"],6:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#2b8cbe","#045a8d"],7:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],8:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],9:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"]},BuPu:{3:["#e0ecf4","#9ebcda","#8856a7"],4:["#edf8fb","#b3cde3","#8c96c6","#88419d"],5:["#edf8fb","#b3cde3","#8c96c6","#8856a7","#810f7c"],6:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8856a7","#810f7c"],7:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],8:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],9:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"]},RdPu:{3:["#fde0dd","#fa9fb5","#c51b8a"],4:["#feebe2","#fbb4b9","#f768a1","#ae017e"],5:["#feebe2","#fbb4b9","#f768a1","#c51b8a","#7a0177"],6:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#c51b8a","#7a0177"],7:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],8:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],9:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"]},PuRd:{3:["#e7e1ef","#c994c7","#dd1c77"],4:["#f1eef6","#d7b5d8","#df65b0","#ce1256"],5:["#f1eef6","#d7b5d8","#df65b0","#dd1c77","#980043"],6:["#f1eef6","#d4b9da","#c994c7","#df65b0","#dd1c77","#980043"],7:["#f1eef6","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],8:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],9:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"]},OrRd:{3:["#fee8c8","#fdbb84","#e34a33"],4:["#fef0d9","#fdcc8a","#fc8d59","#d7301f"],5:["#fef0d9","#fdcc8a","#fc8d59","#e34a33","#b30000"],6:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#e34a33","#b30000"],7:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],8:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],9:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"]},YlOrRd:{3:["#ffeda0","#feb24c","#f03b20"],4:["#ffffb2","#fecc5c","#fd8d3c","#e31a1c"],5:["#ffffb2","#fecc5c","#fd8d3c","#f03b20","#bd0026"],6:["#ffffb2","#fed976","#feb24c","#fd8d3c","#f03b20","#bd0026"],7:["#ffffb2","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],8:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],9:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"]},YlOrBr:{3:["#fff7bc","#fec44f","#d95f0e"],4:["#ffffd4","#fed98e","#fe9929","#cc4c02"],5:["#ffffd4","#fed98e","#fe9929","#d95f0e","#993404"],6:["#ffffd4","#fee391","#fec44f","#fe9929","#d95f0e","#993404"],7:["#ffffd4","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],8:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],9:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"]},Purples:{3:["#efedf5","#bcbddc","#756bb1"],4:["#f2f0f7","#cbc9e2","#9e9ac8","#6a51a3"],5:["#f2f0f7","#cbc9e2","#9e9ac8","#756bb1","#54278f"],6:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#756bb1","#54278f"],7:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],8:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],9:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"]},Blues:{3:["#deebf7","#9ecae1","#3182bd"],4:["#eff3ff","#bdd7e7","#6baed6","#2171b5"],5:["#eff3ff","#bdd7e7","#6baed6","#3182bd","#08519c"],6:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#3182bd","#08519c"],7:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],8:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],9:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"]},Greens:{3:["#e5f5e0","#a1d99b","#31a354"],4:["#edf8e9","#bae4b3","#74c476","#238b45"],5:["#edf8e9","#bae4b3","#74c476","#31a354","#006d2c"],6:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#31a354","#006d2c"],7:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],8:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],9:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"]},Oranges:{3:["#fee6ce","#fdae6b","#e6550d"],4:["#feedde","#fdbe85","#fd8d3c","#d94701"],5:["#feedde","#fdbe85","#fd8d3c","#e6550d","#a63603"],6:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#e6550d","#a63603"],7:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],8:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],9:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"]},Reds:{3:["#fee0d2","#fc9272","#de2d26"],4:["#fee5d9","#fcae91","#fb6a4a","#cb181d"],5:["#fee5d9","#fcae91","#fb6a4a","#de2d26","#a50f15"],6:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#de2d26","#a50f15"],7:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],8:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],9:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"]},Greys:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]}},Diverging:{PuOr:{3:["#f1a340","#f7f7f7","#998ec3"],4:["#e66101","#fdb863","#b2abd2","#5e3c99"],5:["#e66101","#fdb863","#f7f7f7","#b2abd2","#5e3c99"],6:["#b35806","#f1a340","#fee0b6","#d8daeb","#998ec3","#542788"],7:["#b35806","#f1a340","#fee0b6","#f7f7f7","#d8daeb","#998ec3","#542788"],8:["#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788"],9:["#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788"],10:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],11:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"]},BrBG:{3:["#d8b365","#f5f5f5","#5ab4ac"],4:["#a6611a","#dfc27d","#80cdc1","#018571"],5:["#a6611a","#dfc27d","#f5f5f5","#80cdc1","#018571"],6:["#8c510a","#d8b365","#f6e8c3","#c7eae5","#5ab4ac","#01665e"],7:["#8c510a","#d8b365","#f6e8c3","#f5f5f5","#c7eae5","#5ab4ac","#01665e"],8:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e"],9:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e"],10:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],11:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"]},PRGn:{3:["#af8dc3","#f7f7f7","#7fbf7b"],4:["#7b3294","#c2a5cf","#a6dba0","#008837"],5:["#7b3294","#c2a5cf","#f7f7f7","#a6dba0","#008837"],6:["#762a83","#af8dc3","#e7d4e8","#d9f0d3","#7fbf7b","#1b7837"],7:["#762a83","#af8dc3","#e7d4e8","#f7f7f7","#d9f0d3","#7fbf7b","#1b7837"],8:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837"],9:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837"],10:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],11:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"]},PiYG:{3:["#e9a3c9","#f7f7f7","#a1d76a"],4:["#d01c8b","#f1b6da","#b8e186","#4dac26"],5:["#d01c8b","#f1b6da","#f7f7f7","#b8e186","#4dac26"],6:["#c51b7d","#e9a3c9","#fde0ef","#e6f5d0","#a1d76a","#4d9221"],7:["#c51b7d","#e9a3c9","#fde0ef","#f7f7f7","#e6f5d0","#a1d76a","#4d9221"],8:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221"],9:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221"],10:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],11:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"]},RdBu:{3:["#ef8a62","#f7f7f7","#67a9cf"],4:["#ca0020","#f4a582","#92c5de","#0571b0"],5:["#ca0020","#f4a582","#f7f7f7","#92c5de","#0571b0"],6:["#b2182b","#ef8a62","#fddbc7","#d1e5f0","#67a9cf","#2166ac"],7:["#b2182b","#ef8a62","#fddbc7","#f7f7f7","#d1e5f0","#67a9cf","#2166ac"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"]},RdGy:{3:["#ef8a62","#ffffff","#999999"],4:["#ca0020","#f4a582","#bababa","#404040"],5:["#ca0020","#f4a582","#ffffff","#bababa","#404040"],6:["#b2182b","#ef8a62","#fddbc7","#e0e0e0","#999999","#4d4d4d"],7:["#b2182b","#ef8a62","#fddbc7","#ffffff","#e0e0e0","#999999","#4d4d4d"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"]},RdYlBu:{3:["#fc8d59","#ffffbf","#91bfdb"],4:["#d7191c","#fdae61","#abd9e9","#2c7bb6"],5:["#d7191c","#fdae61","#ffffbf","#abd9e9","#2c7bb6"],6:["#d73027","#fc8d59","#fee090","#e0f3f8","#91bfdb","#4575b4"],7:["#d73027","#fc8d59","#fee090","#ffffbf","#e0f3f8","#91bfdb","#4575b4"],8:["#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4"],9:["#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"]},Spectral:{3:["#fc8d59","#ffffbf","#99d594"],4:["#d7191c","#fdae61","#abdda4","#2b83ba"],5:["#d7191c","#fdae61","#ffffbf","#abdda4","#2b83ba"],6:["#d53e4f","#fc8d59","#fee08b","#e6f598","#99d594","#3288bd"],7:["#d53e4f","#fc8d59","#fee08b","#ffffbf","#e6f598","#99d594","#3288bd"],8:["#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd"],9:["#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd"],10:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],11:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"]},RdYlGn:{3:["#fc8d59","#ffffbf","#91cf60"],4:["#d7191c","#fdae61","#a6d96a","#1a9641"],5:["#d7191c","#fdae61","#ffffbf","#a6d96a","#1a9641"],6:["#d73027","#fc8d59","#fee08b","#d9ef8b","#91cf60","#1a9850"],7:["#d73027","#fc8d59","#fee08b","#ffffbf","#d9ef8b","#91cf60","#1a9850"],8:["#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850"],9:["#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"]}},Qualitative:{Accent:{3:["#7fc97f","#beaed4","#fdc086"],4:["#7fc97f","#beaed4","#fdc086","#ffff99"],5:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0"],6:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f"],7:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17"],8:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"]},Dark2:{3:["#1b9e77","#d95f02","#7570b3"],4:["#1b9e77","#d95f02","#7570b3","#e7298a"],5:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e"],6:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02"],7:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d"],8:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"]},Paired:{3:["#a6cee3","#1f78b4","#b2df8a"],4:["#a6cee3","#1f78b4","#b2df8a","#33a02c"],5:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99"],6:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c"],7:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f"],8:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00"],9:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6"],10:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a"],11:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99"],12:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"]},Pastel1:{3:["#fbb4ae","#b3cde3","#ccebc5"],4:["#fbb4ae","#b3cde3","#ccebc5","#decbe4"],5:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6"],6:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc"],7:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd"],8:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec"],9:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},Pastel2:{3:["#b3e2cd","#fdcdac","#cbd5e8"],4:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4"],5:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9"],6:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae"],7:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc"],8:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"]},Set1:{3:["#e41a1c","#377eb8","#4daf4a"],4:["#e41a1c","#377eb8","#4daf4a","#984ea3"],5:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00"],6:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33"],7:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628"],8:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf"],9:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"]},Set2:{3:["#66c2a5","#fc8d62","#8da0cb"],4:["#66c2a5","#fc8d62","#8da0cb","#e78ac3"],5:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854"],6:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f"],7:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494"],8:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"]},Set3:{3:["#8dd3c7","#ffffb3","#bebada"],4:["#8dd3c7","#ffffb3","#bebada","#fb8072"],5:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3"],6:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462"],7:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69"],8:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5"],9:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9"],10:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd"],11:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5"],12:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"]}}},L.Palettes={huePalette:function(t,e,i,n,a){return new L.HSLHueFunction(new L.Point(t,i),new L.Point(e,n),a)
},luminosityPalette:function(t,e,i,n,a){return new L.HSLLuminosityFunction(new L.Point(t,i),new L.Point(e,n),a)},saturationPalette:function(t,e,i,n,a){return new L.HSLSaturationFunction(new L.Point(t,i),new L.Point(e,n),a)},rgbBlendPalette:function(t,e,i,n,a){return new L.RGBColorBlendFunction(t,e,i,n,a)},hslBlendPalette:function(t,e,i,n,a){return new L.HSLColorBlendFunction(t,e,i,n,a)},customColorPalette:function(t,e,i,n){return new L.CustomColorFunction(t,e,i,n)}},L.DynamicColorPalettes={rainbow:{text:"Rainbow",getPalette:function(t,e){return L.Palettes.huePalette(t,e,0,300)}},greentored:{text:"Green - Red",getPalette:function(t,e){return L.Palettes.huePalette(t,e,120,0)}},yellowtored:{text:"Yellow - Red",getPalette:function(t,e){return L.Palettes.huePalette(t,e,60,0)}},orangetored:{text:"Orange - Red",getPalette:function(t,e){return L.Palettes.huePalette(t,e,30,0)}},redtopurple:{text:"Red - Purple",getPalette:function(t,e){return L.Palettes.huePalette(t,e,360,270)}},bluetored:{text:"Blue - Red",getPalette:function(t,e){return L.Palettes.huePalette(t,e,210,360)}},bluetored2:{text:"Blue - Red 2",getPalette:function(t,e){return L.Palettes.huePalette(t,e,180,0)}},whitetored:{text:"White - Red",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:0})}},whitetoorange:{text:"White - Orange",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:30})}},whitetoyellow:{text:"White - Yellow",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:60})}},whitetogreen:{text:"White - Green",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:120})}},whitetoltblue:{text:"White - Lt. Blue",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:180})}},whitetoblue:{text:"White - Blue",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:240})}},whitetopurple:{text:"White - Purple",getPalette:function(t,e){return L.Palettes.luminosityPalette(t,e,1,.5,{outputHue:270})}},graytored:{text:"Gray - Red",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:0})}},graytoorange:{text:"Gray - Orange",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:30})}},graytoyellow:{text:"Gray - Yellow",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:60})}},graytogreen:{text:"Gray - Green",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:120})}},graytoltblue:{text:"Gray - Lt. Blue",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:180})}},graytoblue:{text:"Gray - Blue",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:240})}},graytopurple:{text:"Gray - Purple",getPalette:function(t,e){return L.Palettes.saturationPalette(t,e,0,1,{outputHue:270})}}},L.DynamicPaletteElement=L.Class.extend({initialize:function(t,e){this._key=t,this._dynamicPalette=e},generate:function(t){var e=L.DomUtil.create("div","palette"),i=t.count,n=this._dynamicPalette.getPalette(0,i-1),a=t.width,o=!0;void 0!=t.showText&&(o=t.showText),e.setAttribute("data-palette-key",this._key),this._dynamicPalette.text&&o&&(L.DomUtil.create("div","palette-text",e).innerHTML='<i class="icon-ok hidden"></i>'+this._dynamicPalette.text);var r=a/i;t.className&&L.DomUtil.addClass(e,t.className);for(var s=0;i>s;++s){var s=L.DomUtil.create("i","palette-element");for(var f in n){var d=n[f],c=d.evaluate?d.evaluate(s):d;L.StyleConverter.setCSSProperty(s,f,c)}s.style.width=r+"px",e.appendChild(s)}return e}}),L.Path.XLINK_NS="http://www.w3.org/1999/xlink";var TextFunctions=TextFunctions||{__updatePath:L.Path.prototype._updatePath,_updatePath:function(){this.__updatePath.call(this),this.options.text&&this._createText(this.options.text)},_initText:function(){this.options.text&&this._createText(this.options.text)},getTextAnchor:function(){return this._point?this._point:void 0},setTextAnchor:function(t){this._text&&(this._text.setAttribute("x",t.x),this._text.setAttribute("y",t.y))},_createText:function(t){this._text&&this._container.removeChild(this._text),this._pathDef&&this._defs.removeChild(this._pathDef);var e=function(t,e){var i="";for(var n in e)i+=n+": "+e[n]+";";return t.setAttribute("style",i),t},i=function(t,e){for(var i in e)t.setAttribute(i,e[i]);return t};this._text=this._createElement("text");var n=document.createTextNode(t.text);if(t.path){var a=t.path,o=L.Util.guid(),r=this._createElement("path");r.setAttribute("d",this._path.getAttribute("d")),r.setAttribute("id",o),this._defs||(this._defs=this._createElement("defs"),this._container.appendChild(this._defs)),this._defs.appendChild(r),this._pathDef=r;var s=this._createElement("textPath");a.startOffset&&s.setAttribute("startOffset",a.startOffset),a.attr&&i(s,a.attr),a.style&&e(s,a.style),s.setAttributeNS(L.Path.XLINK_NS,"xlink:href","#"+o),s.appendChild(n),this._text.appendChild(s)}else{this._text.appendChild(n);var f=this.getTextAnchor();this.setTextAnchor(f)}t.className?this._text.setAttribute("class",t.className):this._text.setAttribute("class","leaflet-svg-text"),t.attr&&i(this._text,t.attr),t.style&&e(this._text,t.style),this._container.appendChild(this._text)}},PathFunctions=PathFunctions||{__updateStyle:L.Path.prototype._updateStyle,_createDefs:function(){this._defs=this._createElement("defs"),this._container.appendChild(this._defs)},_createGradient:function(t){this._defs||this._createDefs(),this._gradient&&this._defs.removeChild(this._gradient);var e=this._createElement("linearGradient"),i=L.Util.guid();this._gradientGuid=i,t=t!==!0?L.extend({},t):{};var n=t.vector||[["0%","0%"],["100%","100%"]],a={x1:n[0][0],x2:n[1][0],y1:n[0][1],y2:n[1][1]};a.id="grad"+i;var o=t.stops||[{offset:"0%",style:{color:"rgb(255, 255, 255)",opacity:1}},{offset:"60%",style:{color:this.options.fillColor||this.options.color,opacity:1}}];for(var r in a)e.setAttribute(r,a[r]);for(var s=0;s<o.length;++s){var f=o[s],d=this._createElement("stop");f.style=f.style||{};for(var r in f){var c=f[r];if("style"===r){var l="";c.color=c.color||this.options.fillColor||this.options.color,c.opacity="undefined"==typeof c.opacity?1:c.opacity;for(var u in c)l+="stop-"+u+":"+c[u]+";";c=l}d.setAttribute(r,c)}e.appendChild(d)}this._gradient=e,this._defs.appendChild(e)},_createDropShadow:function(t){this._defs||this._createDefs(),this._dropShadow&&this._defs.removeChild(this._dropShadow);var e=L.Util.guid(),i=this._createElement("filter"),n=this._createElement("feOffset"),a=this._createElement("feGaussianBlur"),o=this._createElement("feBlend");t=t||{width:"200%",height:"200%"},t.id="filter"+e;for(var r in t)i.setAttribute(r,t[r]);var s={result:"offOut","in":"SourceAlpha",dx:"2",dy:"2"},f={result:"blurOut","in":"offOut",stdDeviation:"2"},d={"in":"SourceGraphic",in2:"blurOut",mode:"lighten"};for(var r in s)n.setAttribute(r,s[r]);for(var r in f)a.setAttribute(r,f[r]);for(var r in d)o.setAttribute(r,d[r]);i.appendChild(n),i.appendChild(a),i.appendChild(o),this._dropShadow=i,this._defs.appendChild(i)},_createCustomElement:function(t,e){var i=this._createElement(t);for(var n in e)e.hasOwnProperty(n)&&i.setAttribute(n,e[n]);return i},_createImage:function(t){var e=this._createElement("image");return e.setAttribute("width",t.width),e.setAttribute("height",t.height),e.setAttribute("x",t.x||0),e.setAttribute("y",t.y||0),e.setAttributeNS(L.Path.XLINK_NS,"xlink:href",t.url),e},_createPattern:function(t){var e=this._createCustomElement("pattern",t);return e},_createShape:function(t,e){var i=this._createCustomElement(t,e);return i},_applyCustomStyles:function(){},_createFillPattern:function(t){var e=L.Util.guid(),i=t.pattern;i.id=e,i.patternUnits=i.patternUnits||"objectBoundingBox";var n=this._createPattern(i),a=this._createImage(t.image);a.setAttributeNS(L.Path.XLINK_NS,"xlink:href",t.url),n.appendChild(a),this._defs||this._createDefs(),this._defs.appendChild(n),this._path.setAttribute("fill","url(#"+e+")")},_getDefaultDiameter:function(t){return 1.75*t},_createShapeImage:function(t){t=t||{};var e=L.Util.guid(),i=this.options.radius||Math.max(this.options.radiusX,this.options.radiusY),n=this._getDefaultDiameter(i),a=t.imageSize||new L.Point(n,n),o=t.radius||n/2,r=t.shape||{circle:{r:o,cx:0,cy:0}},s=t.pattern||{width:a.x,height:a.y,x:0,y:0},f=Object.keys(r),d=f.length>0?f[0]:"circle";r[d].fill="url(#"+e+")";var c=this._createShape(d,r[d]);this.options.clickable&&c.setAttribute("class","leaflet-clickable"),s.id=e,s.patternUnits=s.patternUnits||"objectBoundingBox";var l=this._createPattern(s),t=t.image||{width:a.x,height:a.y,x:0,y:0,url:this.options.imageCircleUrl},u=this._createImage(t);u.setAttributeNS(L.Path.XLINK_NS,"xlink:href",t.url),l.appendChild(u),this._defs.appendChild(l),this._container.insertBefore(c,this._defs),this._shape=c},_updateStyle:function(){this.__updateStyle.call(this),this.options.stroke&&(this.options.lineCap&&this._path.setAttribute("stroke-linecap",this.options.lineCap),this.options.lineJoin&&this._path.setAttribute("stroke-linejoin",this.options.lineJoin)),this.options.gradient?(this._createGradient(this.options.gradient),this._path.setAttribute("fill","url(#"+this._gradient.getAttribute("id")+")")):this.options.fill||this._path.setAttribute("fill","none"),this.options.dropShadow?(this._createDropShadow(),this._path.setAttribute("filter","url(#"+this._dropShadow.getAttribute("id")+")")):this._path.removeAttribute("filter"),this.options.fillPattern&&this._createFillPattern(this.options.fillPattern),this._applyCustomStyles()}},LineTextFunctions=L.extend({},TextFunctions);LineTextFunctions.__updatePath=L.Polyline.prototype._updatePath,LineTextFunctions.getCenter=function(){var t,e,i,n,a,o,r=this._latlngs,s=r.length;for(t=0,e=s-1,area=0,lat=0,lng=0;s>t;e=t++)i=r[t],n=r[e],a=i.lat*n.lng-n.lat*i.lng,lat+=(i.lat+n.lat)*a,lng+=(i.lng+n.lng)*a,area+=a/2;return o=area?new L.LatLng(lat/(6*area),lng/(6*area)):r[0],o.area=area,o},LineTextFunctions.getTextAnchor=function(){var t=this.getCenter();return this._map.latLngToLayerPoint(t)},L.Polyline.include(LineTextFunctions),L.CircleMarker.include(TextFunctions),L.Path.include(PathFunctions),L.Polygon.include(PathFunctions),L.Polyline.include(PathFunctions),L.CircleMarker.include(PathFunctions),L.CircleMarker=L.CircleMarker.extend({_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)}}),L.Point.prototype.rotate=function(t,e){var i=this.distanceTo(e),n=t*L.LatLng.DEG_TO_RAD+Math.atan2(this.y-e.y,this.x-e.x);this.x=e.x+i*Math.cos(n),this.y=e.y+i*Math.sin(n)},L.MapMarker=L.Path.extend({includes:TextFunctions,initialize:function(t,e){L.Path.prototype.initialize.call(this,e),this._latlng=t},options:{fill:!0,fillOpacity:1,opacity:1,radius:15,innerRadius:5,position:{x:0,y:0},rotation:0,numberOfSides:50,color:"#000000",fillColor:"#0000FF",weight:1,gradient:!0,dropShadow:!0,clickable:!0},setLatLng:function(t){return this._latlng=t,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints(),this.options.innerRadius>0&&(this._innerPoints=this._getPoints(!0).reverse())},getBounds:function(){var t=this._map,e=3*this.options.radius,i=t.project(this._latlng),n=new L.Point(i.x-this.options.radius,i.y),a=new L.Point(i.x+this.options.radius,i.y-e),o=t.unproject(n),r=t.unproject(a);return new L.LatLngBounds(o,r)},getLatLng:function(){return this._latlng},getPathString:function(){var t=this.getTextAnchor();return this._shape&&("circle"===this._shape.tagName?(this._shape.setAttribute("cx",t.x),this._shape.setAttribute("cy",t.y)):(this._shape.setAttribute("x",t.x),this._shape.setAttribute("y",t.y))),this._path.setAttribute("shape-rendering","geometricPrecision"),new L.SVGPathBuilder(this._points,this._innerPoints).build(6)},getTextAnchor:function(){return new L.Point(this._point.x,this._point.y-2*this.options.radius)},_getPoints:function(t){var e,i,n=t?360:210,a=t?n/Math.max(this.options.numberOfSides,3):n/50,o=t?n+this.options.rotation:n,r=t?this.options.rotation:-30,s=[],f=this.options.radius,d=Math.sqrt(.75),c=function(t){return t*L.LatLng.DEG_TO_RAD},l=this._point;for(t||(s.push(l),s.push(new L.Point(l.x+d*f,l.y-1.5*f)));o>r;)i=c(r),e=this._getPoint(i,f,t),s.push(e),r+=a;return t||s.push(new L.Point(l.x-d*f,l.y-1.5*f)),s},_getPoint:function(t,e,i){var n=e;return e=i?this.options.innerRadius:e,new L.Point(this._point.x+this.options.position.x+e*Math.cos(t),this._point.y-2*n+this.options.position.y-e*Math.sin(t))},_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)}}),L.mapMarker=function(t,e){return new L.MapMarker(t,e)},L.RegularPolygonMarker=L.Path.extend({includes:TextFunctions,initialize:function(t,e){L.Path.prototype.initialize.call(this,e),this._latlng=t,this.options.numberOfSides=Math.max(this.options.numberOfSides,3)},options:{fill:!0,radiusX:10,radiusY:10,rotation:0,numberOfSides:3,position:{x:0,y:0},maxDegrees:360,gradient:!0,dropShadow:!1,clickable:!0},setLatLng:function(t){return this._latlng=t,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints(),(this.options.innerRadius||this.options.innerRadiusX&&this.options.innerRadiusY)&&(this._innerPoints=this._getPoints(!0).reverse())},getBounds:function(){var t=this._map,e=this.options.radius||this.options.radiusX,i=this.options.radius||this.options.radiusY,n=e*Math.cos(Math.PI/4),a=i*Math.sin(Math.PI/4),o=t.project(this._latlng),r=new L.Point(o.x-n,o.y+a),s=new L.Point(o.x+n,o.y-a),f=t.unproject(r),d=t.unproject(s);return new L.LatLngBounds(f,d)},getLatLng:function(){return this._latlng},getPathString:function(){this._path.setAttribute("shape-rendering","geometricPrecision");var t=this.getTextAnchor();return this._shape&&("circle"===this._shape.tagName?(this._shape.setAttribute("cx",t.x),this._shape.setAttribute("cy",t.y)):(this._shape.setAttribute("x",t.x),this._shape.setAttribute("y",t.y))),new L.SVGPathBuilder(this._points,this._innerPoints).build(6)},_getPoints:function(t){for(var e,i,n=this.options.maxDegrees||360,a=n/Math.max(this.options.numberOfSides,3),o=n,r=0,s=[],f=t?this.options.innerRadius||this.options.innerRadiusX:this.options.radius||this.options.radiusX,d=t?this.options.innerRadius||this.options.innerRadiusY:this.options.radius||this.options.radiusY,c=function(t){return t*L.LatLng.DEG_TO_RAD};o>r;)i=c(r),e=this._getPoint(i,f,d),s.push(e),r+=a;return s},_getPoint:function(t,e,i){var n=this.options.position?this._point.add(new L.Point(this.options.position.x,this.options.position.y)):this._point,a=new L.Point(n.x+e*Math.cos(t),n.y+i*Math.sin(t));return a.rotate(this.options.rotation,n),a},_getDefaultDiameter:function(t){var e=Math.PI/this.options.numberOfSides,i=t*Math.cos(e);return 1.75*i},_applyCustomStyles:function(){(this.options.shapeImage||this.options.imageCircleUrl)&&this._createShapeImage(this.options.shapeImage)}}),L.regularPolygonMarker=function(t,e){return new L.RegularPolygonMarker(t,e)},L.StarMarker=L.RegularPolygonMarker.extend({options:{numberOfPoints:5,rotation:-15,maxDegrees:360,gradient:!0,dropShadow:!0},_getPoints:function(t){for(var e,i,n,a=this.options.maxDegrees||360,o=a/this.options.numberOfPoints,r=a,s=0,f=[],d=t?this.options.innerRadius||this.options.innerRadiusX:this.options.radius||this.options.radiusX,c=t?this.options.innerRadius||this.options.innerRadiusY:this.options.radius||this.options.radiusY,l=function(t){return t*L.LatLng.DEG_TO_RAD};r>s;)n=l(s),e=this._getPoint(n,d,c),i=this._getPoint(n+l(o)/2,d/2,c/2),f.push(e),f.push(i),s+=o;return f}}),L.starMarker=function(t,e){return new L.StarMarker(t,e)},L.TriangleMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:3,rotation:30,radius:5}}),L.triangleMarker=function(t,e){return new L.TriangleMarker(t,e)},L.DiamondMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:4,radiusX:5,radiusY:10}}),L.diamondMarker=function(t,e){return new L.DiamondMarker(t,e)},L.SquareMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:4,rotation:45,radius:5}}),L.squareMarker=function(t,e){return new L.SquareMarker(t,e)},L.PentagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:5,rotation:-18,radius:5}}),L.pentagonMarker=function(t,e){return new L.PentagonMarker(t,e)},L.HexagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:6,rotation:30,radius:5}}),L.hexagonMarker=function(t,e){return new L.HexagonMarker(t,e)},L.OctagonMarker=L.RegularPolygonMarker.extend({options:{numberOfSides:8,rotation:22.5,radius:5}}),L.octagonMarker=function(t,e){return new L.OctagonMarker(t,e)},L.SVGMarker=L.Path.extend({initialize:function(t,e){L.Path.prototype.initialize.call(this,e),this._svg=e.svg,0===this._svg.indexOf("<")&&(this._data=this._svg),this._latlng=t},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng)},setLatLng:function(t){this._latlng=t,this.redraw()},getLatLng:function(){return this._latlng},getPathString:function(){var t=this,e=function(){for(var e=t._path.parentNode;"g"!==e.nodeName.toLowerCase();)e=e.parentNode;t.options.clickable&&e.setAttribute("class","leaflet-clickable");var i=t._data,n="svg"===i.nodeName.toLowerCase()?i.cloneNode(!0):i.querySelector("svg").cloneNode(!0);t.options.setStyle&&t.options.setStyle.call(t,n);var a=n.getAttribute("width"),o=n.getAttribute("height"),r=a?a.replace("px",""):"100%",s=o?o.replace("px",""):"100%";"100%"===r&&(r=t.options.size.x,s=t.options.size.y,n.setAttribute("width",r+(-1!==String(r).indexOf("%")?"":"px")),n.setAttribute("height",s+(-1!==String(s).indexOf("%")?"":"px")));var f=t.options.size||new L.Point(r,s),d=new L.Point(f.x/r,f.y/s),c=e.getElementsByTagName("svg");c.length>0&&c[0].parentNode.removeChild(c[0]),e.appendChild(n);var l=[],u=t.options.anchor||new L.Point(-f.x/2,-f.y/2),h=t._point.x+u.x,b=t._point.y+u.y;l.push("translate("+h+" "+b+")"),l.push("scale("+d.x+" "+d.y+")"),t.options.rotation&&l.push("rotate("+t.options.rotation+" "+r/2+" "+s/2+")"),e.setAttribute("transform",l.join(" "))};if(this._data)e();else{var i=new XMLHttpRequest;i.onreadystatechange=function(){4==this.readyState&&200==this.status&&(t._data=this.responseXML,e())},i.open("GET",this._svg,!0),i.send(null)}}}),L.MarkerGroup=L.FeatureGroup.extend({initialize:function(t,e){L.FeatureGroup.prototype.initialize.call(this,e),this.setLatLng(t)},setLatLng:function(t){return this._latlng=t,this.eachLayer(function(e){e.setLatLng&&e.setLatLng(t)}),this},getLatLng:function(){return this._latlng}}),L.BarMarker=L.Path.extend({initialize:function(t,e){L.Path.prototype.initialize.call(this,e),this._latlng=t},options:{fill:!0,width:2,maxHeight:10,position:{x:0,y:0},weight:1,color:"#000",opacity:1,gradient:!0,dropShadow:!1,lineCap:"square",lineJoin:"miter"},setLatLng:function(t){return this._latlng=t,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getBounds:function(){var t=this._map,e=t.project(this._latlng),i=this.options.width/2,n=new L.Point(e.x-i,e.y),a=new L.Point(e.x+i,e.y-this.options.maxHeight),o=t.unproject(n),r=t.unproject(a);return new L.LatLngBounds(o,r)},getLatLng:function(){return this._latlng},getPathString:function(){return this._path.setAttribute("shape-rendering","crispEdges"),new L.SVGPathBuilder(this._points).build()},_getPoints:function(){var t,e,i,n,a=[],o=this._point.x+this.options.position.x,r=this._point.y+this.options.position.y,s=this.options.width/2,f=this.options.value/this.options.maxValue*this.options.maxHeight;return t=new L.Point(o+s,r),e=new L.Point(o+s,r-f),i=new L.Point(o-s,r-f),n=new L.Point(o-s,r),a=[t,e,i,n]}}),L.barMarker=function(t,e){return new L.BarMarker(t,e)},L.ChartMarker=L.FeatureGroup.extend({initialize:function(t,e){L.Util.setOptions(this,e),this._layers={},this._latlng=t,this._loadComponents()},setLatLng:function(t){return this._latlng=t,this.redraw()},getLatLng:function(){return this._latlng},_loadComponents:function(){},_highlight:function(t){return t.weight&&(t.weight*=2),t},_unhighlight:function(t){return t.weight&&(t.weight/=2),t},_bindMouseEvents:function(t){var e=this,i=this.options.tooltipOptions;t.on("mouseover",function(t){var n,a=this.options,o=a.key,r=a.value,s=t.layerPoint,f=s.x-this._point.x,d=s.y-this._point.y,c=a.iconSize,l=f,u=d,h=5;l=0>f?c.x-f+h:-f-h,u=0>d?c.y-d+h:-d-h,n=new L.Point(l,u);var b={},p=a.displayText?a.displayText(r):r;b[o]={name:a.displayName,value:p};var g=new L.LegendIcon(b,a,{className:"leaflet-div-icon",iconSize:i?i.iconSize:c,iconAnchor:n});a.marker=new L.Marker(e._latlng,{icon:g}),a=e._highlight(a),this.initialize(e._latlng,a),this.redraw(),this.setStyle(a),e.addLayer(a.marker)}),t.on("mouseout",function(){var t=this.options;t=e._unhighlight(t),this.initialize(e._latlng,t),this.redraw(),this.setStyle(t),e.removeLayer(t.marker)})},bindPopup:function(t,e){this.eachLayer(function(i){i.bindPopup(t,e)})},openPopup:function(t){for(var e in this._layers){var i=this._layers[e];t=t||this._latlng,i.openPopup(t);break}},closePopup:function(){for(var t in this._layers){var e=this._layers[t];latlng=latlng||this._latlng,e.closePopup();break}},redraw:function(){this.clearLayers(),this._loadComponents()}}),L.BarChartMarker=L.ChartMarker.extend({initialize:function(t,e){L.Util.setOptions(this,e),L.ChartMarker.prototype.initialize.call(this,t,e)},options:{weight:1,opacity:1,color:"#000",fill:!0,position:{x:0,y:0},width:10,offset:0,iconSize:new L.Point(50,40)},_loadComponents:function(){var t,e,i,n,a,o,r,s=this.options,f=Object.keys(this.options.data),d=f.length,c=this.options.width,l=this.options.offset||0,u=this.options.data,h=this.options.chartOptions;a=-(c*d+l*(d-1))/2+c/2,o=0;for(var b in u)t=u[b],r=h[b],e=r.minValue||0,i=r.maxValue||100,s.fillColor=r.fillColor||this.options.fillColor,s.value=t,s.minValue=e,s.maxValue=i,s.position={x:a,y:o},s.width=c,s.maxHeight=r.maxHeight||10,s.key=b,s.value=t,s.displayName=r.displayName,s.opacity=this.options.opacity||1,s.fillOpacity=this.options.fillOpacity||.7,s.weight=this.options.weight||1,s.color=r.color||this.options.color,s.displayText=r.displayText,n=new L.BarMarker(this._latlng,s),this._bindMouseEvents(n),this.addLayer(n),a+=c+l}}),L.RadialBarMarker=L.Path.extend({initialize:function(t,e){L.Path.prototype.initialize.call(this,e),this._latlng=t},options:{fill:!0,radius:10,rotation:0,numberOfSides:30,position:{x:0,y:0},gradient:!0,dropShadow:!1},setLatLng:function(t){return this._latlng=t,this.redraw()},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._points=this._getPoints()},getBounds:function(){var t=this._map,e=this.options.radiusX||this.options.radius,i=this.options.radiusY||this.options.radius,n=e*Math.cos(Math.PI/4),a=i*Math.sin(Math.PI/4),o=t.project(this._latlng),r=new L.Point(o.x-n,o.y+a),s=new L.Point(o.x+n,o.y-a),f=t.unproject(r),d=t.unproject(s);return new L.LatLngBounds(f,d)},getLatLng:function(){return this._latlng},getPathString:function(){var t=this.options.endAngle-this.options.startAngle,e=t>=180?"1":"0",i=this.options.radiusX||this.options.radius,n=this.options.radiusY||this.options.radius,a="M"+this._points[0].x.toFixed(2)+","+this._points[0].y.toFixed(2)+"A"+i.toFixed(2)+","+n.toFixed(2)+" 0 "+e+",1 "+this._points[1].x.toFixed(2)+","+this._points[1].y.toFixed(2)+"L";return this._innerPoints?(a=a+this._innerPoints[0].x.toFixed(2)+","+this._innerPoints[0].y.toFixed(2),a=a+"A"+(i-this.options.barThickness).toFixed(2)+","+(n-this.options.barThickness).toFixed(2)+" 0 "+e+",0 "+this._innerPoints[1].x.toFixed(2)+","+this._innerPoints[1].y.toFixed(2)+"z"):a=a+this._point.x.toFixed(2)+","+this._point.y.toFixed(2)+"z",L.Browser.vml&&(a=Core.SVG.path(a)),this._path.setAttribute("shape-rendering","geometricPrecision"),a},_getPoints:function(){var t=this.options.endAngle-this.options.startAngle,e=this.options.endAngle+this.options.rotation,i=this.options.startAngle+this.options.rotation,n=[],a="radiusX"in this.options?this.options.radiusX:this.options.radius,o="radiusY"in this.options?this.options.radiusY:this.options.radius,r=function(t){return t*L.LatLng.DEG_TO_RAD};360===t&&(e-=.1);var s=r(i),f=r(e);return n.push(this._getPoint(s,a,o)),n.push(this._getPoint(f,a,o)),this.options.barThickness&&(this._innerPoints=[],this._innerPoints.push(this._getPoint(f,a-this.options.barThickness,o-this.options.barThickness)),this._innerPoints.push(this._getPoint(s,a-this.options.barThickness,o-this.options.barThickness))),n},_getPoint:function(t,e,i){return new L.Point(this._point.x+this.options.position.x+e*Math.cos(t),this._point.y+this.options.position.y+i*Math.sin(t))}}),L.radialBarMarker=function(t,e){return new L.RadialBarMarker(t,e)},L.PieChartMarker=L.ChartMarker.extend({initialize:function(t,e){L.Util.setOptions(this,e),L.ChartMarker.prototype.initialize.call(this,t,e)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:50,mouseOverExaggeration:1.2,maxDegrees:360,iconSize:new L.Point(50,40)},_highlight:function(t){var e=t.radiusX,i=t.radiusY,n=t.barThickness;return t.oldBarThickness=n,t.oldRadiusX=e,t.oldRadiusY=i,t.radiusX*=t.mouseOverExaggeration,t.radiusY*=t.mouseOverExaggeration,t.barThickness=t.radiusX-e+n,t},_unhighlight:function(t){return t.radiusX=t.oldRadiusX,t.radiusY=t.oldRadiusY,t.barThickness=t.oldBarThickness,t},_loadComponents:function(){var t,e,i,n,a=0,o=0,r=0,s=this.options.maxDegrees||360,f=this.options.rotation,d=this.options,c=this.options.data,l=this.options.chartOptions,u=function(t,e){var i=0;return t[e]&&(i=parseFloat(t[e])),i};for(n in c)t=u(c,n),a+=t;if(a>0)for(n in c)t=parseFloat(c[n]),i=l[n],r=t/a,o=r*s,d.startAngle=f,d.endAngle=f+o,d.fillColor=i.fillColor,d.color=i.color||"#000",d.radiusX=this.options.radiusX||this.options.radius,d.radiusY=this.options.radiusY||this.options.radius,d.rotation=0,d.key=n,d.value=t,d.displayName=i.displayName,d.displayText=i.displayText,e=new L.RadialBarMarker(this._latlng,d),this._bindMouseEvents(e),f=d.endAngle,this.addLayer(e)}}),L.pieChartMarker=function(t,e){return new L.PieChartMarker(t,e)},L.CoxcombChartMarker=L.PieChartMarker.extend({statics:{SIZE_MODE_RADIUS:"radius",SIZE_MODE_AREA:"area"}}),L.CoxcombChartMarker=L.CoxcombChartMarker.extend({initialize:function(t,e){L.Util.setOptions(this,e),L.PieChartMarker.prototype.initialize.call(this,t,e)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:50,mouseOverExaggeration:1.2,maxDegrees:360,iconSize:new L.Point(50,40),sizeMode:L.CoxcombChartMarker.SIZE_MODE_AREA},_loadComponents:function(){var t,e,i,n,a,o=0,r=this.options.maxDegrees||360,s=this.options.rotation,f=this.options,d="radiusX"in this.options?this.options.radiusX:this.options.radius,c="radiusY"in this.options?this.options.radiusY:this.options.radius,l=Object.keys(this.options.data),u=l.length,h=this.options.data,b=this.options.chartOptions;o=r/u;for(var p in h){t=parseFloat(h[p]),a=b[p];var e=a.minValue||0,i=a.maxValue;if(this.options.sizeMode===L.CoxcombChartMarker.SIZE_MODE_RADIUS){var g=new L.LinearFunction(new L.Point(e,0),new L.Point(i,d)),_=new L.LinearFunction(new L.Point(e,0),new L.Point(i,c));f.radiusX=g.evaluate(t),f.radiusY=_.evaluate(t)}else{var y=Math.max(d,c),m=Math.PI*Math.pow(y,2)/u,P=new L.LinearFunction(new L.Point(e,0),new L.Point(i,m),{postProcess:function(t){return Math.sqrt(u*t/Math.PI)}});f.radiusX=P.evaluate(t),f.radiusY=f.radiusX}f.startAngle=s,f.endAngle=s+o,f.fillColor=a.fillColor,f.color=a.color||"#000",f.rotation=0,f.key=p,f.value=t,f.displayName=a.displayName,f.displayText=a.displayText,n=new L.RadialBarMarker(this._latlng,f),this._bindMouseEvents(n),s=f.endAngle,this.addLayer(n)}}}),L.coxcombChartMarker=function(t,e){return new L.CoxcombChartMarker(t,e)},L.RadialBarChartMarker=L.ChartMarker.extend({initialize:function(t,e){L.Util.setOptions(this,e),L.ChartMarker.prototype.initialize.call(this,t,e)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:0,numberOfSides:30,offset:2,barThickness:5,maxDegrees:360,iconSize:new L.Point(50,40)},_loadComponents:function(){var t,e,i,n,a,o=this.options.rotation,r=this.options.maxDegrees||360,s=this.options,f=this.options.radiusX||this.options.radius,d=this.options.radiusY||this.options.radius,c=this.options.data,l=this.options.chartOptions,u=this.options.barThickness||4,h=this.options.offset||2;for(var b in c){t=parseFloat(c[b]),a=l[b],e=a.minValue||0,i=a.maxValue||100;var p=new L.LinearFunction(new L.Point(e,0),new L.Point(i,r));o=p.evaluate(t),s.startAngle=this.options.rotation,s.endAngle=this.options.rotation+o,s.fillColor=a.fillColor,s.radiusX=f,s.radiusY=d,s.barThickness=u,s.rotation=0,s.key=b,s.value=t,s.displayName=a.displayName,s.displayText=a.displayText,s.weight=this.options.weight||1,n=new L.RadialBarMarker(this._latlng,s),this._bindMouseEvents(n),this.addLayer(n),f+=u+h,d+=u+h}}}),L.radialBarChartMarker=function(t,e){return new L.RadialBarChartMarker(t,e)},L.StackedRegularPolygonMarker=L.ChartMarker.extend({options:{iconSize:new L.Point(50,40)},initialize:function(t,e){L.Util.setOptions(this,e),L.ChartMarker.prototype.initialize.call(this,t,e)},_loadComponents:function(){var t,e,i,n,a=0,o=0,r=this.options,s=this.options.data,f=this.options.chartOptions;for(n in s){t=parseFloat(s[n]),i=f[n],minValue=i.minValue||0,maxValue=i.maxValue||100,minRadius=i.minRadius||0,maxRadius=i.maxRadius||10,r.fillColor=i.fillColor||this.options.fillColor,r.value=t,r.minValue=minValue,r.maxValue=maxValue;var d=new L.LinearFunction(new L.Point(minValue,minRadius),new L.Point(maxValue,maxRadius)),c=d.evaluate(t);r.radiusX=a+c,r.radiusY=o+c,r.innerRadiusX=a,r.innerRadiusY=o,r.key=n,r.displayName=i.displayName,r.opacity=this.options.opacity||1,r.fillOpacity=this.options.fillOpacity||.7,r.weight=this.options.weight||1,r.color=i.color||this.options.color,r.displayText=i.displayText,e=new L.RegularPolygonMarker(this._latlng,r),this._bindMouseEvents(e),a=r.radiusX,o=r.radiusY,this.addLayer(e)}}}),L.RadialMeterMarker=L.ChartMarker.extend({initialize:function(t,e){L.Util.setOptions(this,e),L.ChartMarker.prototype.initialize.call(this,t,e)},options:{weight:1,opacity:1,color:"#000",fill:!0,radius:10,rotation:180,numberOfSides:30,offset:2,barThickness:5,maxDegrees:180,iconSize:new L.Point(50,40),backgroundStyle:{fill:!0,fillColor:"#707070",fillOpacity:.2,opacity:.8,color:"#505050"}},_loadComponents:function(){var t,e,i,n,a,o,r=this.options.rotation,s=this.options.maxDegrees||360,f=this.options,d=this.options.radiusX||this.options.radius,c=this.options.radiusY||this.options.radius,l=this.options.data,u=this.options.chartOptions,h=this.options.barThickness||4,b=r,p=this.options.numSegments||10,g=s/p;for(var _ in l){t=parseFloat(l[_]),a=u[_],o=this.options.displayOptions?this.options.displayOptions[_]:{},e=a.minValue||0,i=a.maxValue||100;for(var y=i-e,m=s/y*(t-e),P=r+m,x=r+s,v=new L.LinearFunction(new L.Point(r,e),new L.Point(x,i));P>b;){f.startAngle=b;var w=Math.min(g,P-b);f.endAngle=b+w,f.fillColor=a.fillColor,f.radiusX=d,f.radiusY=c,f.barThickness=h,f.rotation=0,f.key=_,f.value=t,f.displayName=a.displayName,f.displayText=a.displayText;var C=v.evaluate(b+w);for(var S in o)f[S]=o[S].evaluate?o[S].evaluate(C):o[S];n=new L.RadialBarMarker(this._latlng,f),this._bindMouseEvents(n),this.addLayer(n),b+=w}if(this.options.backgroundStyle&&x>b){var w=x-b;f.endAngle=b+w,f.radiusX=d,f.radiusY=c,f.barThickness=h,f.rotation=0,f.key=_,f.value=t,f.displayName=a.displayName,f.displayText=a.displayText,f.fillColor=null,f.fill=!1,f.gradient=!1;for(var M in this.options.backgroundStyle)f[M]=this.options.backgroundStyle[M];var C=v.evaluate(b+w);n=new L.RadialBarMarker(this._latlng,f),this.addLayer(n)}}}});