# -*- coding: utf-8 -*-
from fontaine.cmap import library

class Charmap:
    common_name = u'Adobe Latin 5'
    native_name = u''

    def glyphs(self):
        # from http://blogs.adobe.com/typblography/2008/08/extended_latin.html
        glyphs  = [0x0020] # SPACE
        glyphs += [0x0021] # EXCLAMATION MARK
        glyphs += [0x0022] # QUOTATION MARK
        glyphs += [0x0023] # NUMBER SIGN
        glyphs += [0x0024] # DOLLAR SIGN
        glyphs += [0x0025] # PERCENT SIGN
        glyphs += [0x0026] # AMPERSAND
        glyphs += [0x0027] # APOSTROPHE
        glyphs += [0x0028] # LEFT PARENTHESIS
        glyphs += [0x0029] # RIGHT PARENTHESIS
        glyphs += [0x002A] # ASTERISK
        glyphs += [0x002B] # PLUS SIGN
        glyphs += [0x002C] # COMMA
        glyphs += [0x002D] # HYPHEN-MINUS
        glyphs += [0x002E] # FULL STOP
        glyphs += [0x002F] # SOLIDUS
        glyphs += [0x0030] # DIGIT ZERO
        glyphs += [0x0031] # DIGIT ONE
        glyphs += [0x0032] # DIGIT TWO
        glyphs += [0x0033] # DIGIT THREE
        glyphs += [0x0034] # DIGIT FOUR
        glyphs += [0x0035] # DIGIT FIVE
        glyphs += [0x0036] # DIGIT SIX
        glyphs += [0x0037] # DIGIT SEVEN
        glyphs += [0x0038] # DIGIT EIGHT
        glyphs += [0x0039] # DIGIT NINE
        glyphs += [0x003A] # COLON
        glyphs += [0x003B] # SEMICOLON
        glyphs += [0x003C] # LESS-THAN SIGN
        glyphs += [0x003D] # EQUALS SIGN
        glyphs += [0x003E] # GREATER-THAN SIGN
        glyphs += [0x003F] # QUESTION MARK
        glyphs += [0x0040] # COMMERCIAL AT
        glyphs += [0x0041] # LATIN CAPITAL LETTER A
        glyphs += [0x0042] # LATIN CAPITAL LETTER B
        glyphs += [0x0043] # LATIN CAPITAL LETTER C
        glyphs += [0x0044] # LATIN CAPITAL LETTER D
        glyphs += [0x0045] # LATIN CAPITAL LETTER E
        glyphs += [0x0046] # LATIN CAPITAL LETTER F
        glyphs += [0x0047] # LATIN CAPITAL LETTER G
        glyphs += [0x0048] # LATIN CAPITAL LETTER H
        glyphs += [0x0049] # LATIN CAPITAL LETTER I
        glyphs += [0x004A] # LATIN CAPITAL LETTER J
        glyphs += [0x004B] # LATIN CAPITAL LETTER K
        glyphs += [0x004C] # LATIN CAPITAL LETTER L
        glyphs += [0x004D] # LATIN CAPITAL LETTER M
        glyphs += [0x004E] # LATIN CAPITAL LETTER N
        glyphs += [0x004F] # LATIN CAPITAL LETTER O
        glyphs += [0x0050] # LATIN CAPITAL LETTER P
        glyphs += [0x0051] # LATIN CAPITAL LETTER Q
        glyphs += [0x0052] # LATIN CAPITAL LETTER R
        glyphs += [0x0053] # LATIN CAPITAL LETTER S
        glyphs += [0x0054] # LATIN CAPITAL LETTER T
        glyphs += [0x0055] # LATIN CAPITAL LETTER U
        glyphs += [0x0056] # LATIN CAPITAL LETTER V
        glyphs += [0x0057] # LATIN CAPITAL LETTER W
        glyphs += [0x0058] # LATIN CAPITAL LETTER X
        glyphs += [0x0059] # LATIN CAPITAL LETTER Y
        glyphs += [0x005A] # LATIN CAPITAL LETTER Z
        glyphs += [0x005B] # LEFT SQUARE BRACKET
        glyphs += [0x005C] # REVERSE SOLIDUS
        glyphs += [0x005D] # RIGHT SQUARE BRACKET
        glyphs += [0x005E] # CIRCUMFLEX ACCENT
        glyphs += [0x005F] # LOW LINE
        glyphs += [0x0060] # GRAVE ACCENT
        glyphs += [0x0061] # LATIN SMALL LETTER A
        glyphs += [0x0062] # LATIN SMALL LETTER B
        glyphs += [0x0063] # LATIN SMALL LETTER C
        glyphs += [0x0064] # LATIN SMALL LETTER D
        glyphs += [0x0065] # LATIN SMALL LETTER E
        glyphs += [0x0066] # LATIN SMALL LETTER F
        glyphs += [0x0067] # LATIN SMALL LETTER G
        glyphs += [0x0068] # LATIN SMALL LETTER H
        glyphs += [0x0069] # LATIN SMALL LETTER I
        glyphs += [0x006A] # LATIN SMALL LETTER J
        glyphs += [0x006B] # LATIN SMALL LETTER K
        glyphs += [0x006C] # LATIN SMALL LETTER L
        glyphs += [0x006D] # LATIN SMALL LETTER M
        glyphs += [0x006E] # LATIN SMALL LETTER N
        glyphs += [0x006F] # LATIN SMALL LETTER O
        glyphs += [0x0070] # LATIN SMALL LETTER P
        glyphs += [0x0071] # LATIN SMALL LETTER Q
        glyphs += [0x0072] # LATIN SMALL LETTER R
        glyphs += [0x0073] # LATIN SMALL LETTER S
        glyphs += [0x0074] # LATIN SMALL LETTER T
        glyphs += [0x0075] # LATIN SMALL LETTER U
        glyphs += [0x0076] # LATIN SMALL LETTER V
        glyphs += [0x0077] # LATIN SMALL LETTER W
        glyphs += [0x0078] # LATIN SMALL LETTER X
        glyphs += [0x0079] # LATIN SMALL LETTER Y
        glyphs += [0x007A] # LATIN SMALL LETTER Z
        glyphs += [0x007B] # LEFT CURLY BRACKET
        glyphs += [0x007C] # VERTICAL LINE
        glyphs += [0x007D] # RIGHT CURLY BRACKET
        glyphs += [0x007E] # TILDE
        glyphs += [0x00A0] # NO-BREAK SPACE
        glyphs += [0x00A1] # INVERTED EXCLAMATION MARK
        glyphs += [0x00A2] # CENT SIGN
        glyphs += [0x00A3] # POUND SIGN
        glyphs += [0x00A4] # CURRENCY SIGN
        glyphs += [0x00A5] # YEN SIGN
        glyphs += [0x00A6] # BROKEN BAR
        glyphs += [0x00A7] # SECTION SIGN
        glyphs += [0x00A8] # DIAERESIS
        glyphs += [0x00A9] # COPYRIGHT SIGN
        glyphs += [0x00AA] # FEMININE ORDINAL INDICATOR
        glyphs += [0x00AB] # LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        glyphs += [0x00AC] # NOT SIGN
        glyphs += [0x00AD] # SOFT HYPHEN
        glyphs += [0x00AE] # REGISTERED SIGN
        glyphs += [0x00AF] # MACRON
        glyphs += [0x00B0] # DEGREE SIGN
        glyphs += [0x00B1] # PLUS-MINUS SIGN
        glyphs += [0x00B2] # SUPERSCRIPT TWO
        glyphs += [0x00B3] # SUPERSCRIPT THREE
        glyphs += [0x00B4] # ACUTE ACCENT
        glyphs += [0x00B5] # MICRO SIGN
        glyphs += [0x00B6] # PILCROW SIGN
        glyphs += [0x00B7] # MIDDLE DOT
        glyphs += [0x00B8] # CEDILLA
        glyphs += [0x00B9] # SUPERSCRIPT ONE
        glyphs += [0x00BA] # MASCULINE ORDINAL INDICATOR
        glyphs += [0x00BB] # RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        glyphs += [0x00BC] # VULGAR FRACTION ONE QUARTER
        glyphs += [0x00BD] # VULGAR FRACTION ONE HALF
        glyphs += [0x00BE] # VULGAR FRACTION THREE QUARTERS
        glyphs += [0x00BF] # INVERTED QUESTION MARK
        glyphs += [0x00C0] # LATIN CAPITAL LETTER A WITH GRAVE
        glyphs += [0x00C1] # LATIN CAPITAL LETTER A WITH ACUTE
        glyphs += [0x00C2] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX
        glyphs += [0x00C3] # LATIN CAPITAL LETTER A WITH TILDE
        glyphs += [0x00C4] # LATIN CAPITAL LETTER A WITH DIAERESIS
        glyphs += [0x00C5] # LATIN CAPITAL LETTER A WITH RING ABOVE
        glyphs += [0x00C6] # LATIN CAPITAL LETTER AE
        glyphs += [0x00C7] # LATIN CAPITAL LETTER C WITH CEDILLA
        glyphs += [0x00C8] # LATIN CAPITAL LETTER E WITH GRAVE
        glyphs += [0x00C9] # LATIN CAPITAL LETTER E WITH ACUTE
        glyphs += [0x00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
        glyphs += [0x00CB] # LATIN CAPITAL LETTER E WITH DIAERESIS
        glyphs += [0x00CC] # LATIN CAPITAL LETTER I WITH GRAVE
        glyphs += [0x00CD] # LATIN CAPITAL LETTER I WITH ACUTE
        glyphs += [0x00CE] # LATIN CAPITAL LETTER I WITH CIRCUMFLEX
        glyphs += [0x00CF] # LATIN CAPITAL LETTER I WITH DIAERESIS
        glyphs += [0x00D0] # LATIN CAPITAL LETTER ETH
        glyphs += [0x00D1] # LATIN CAPITAL LETTER N WITH TILDE
        glyphs += [0x00D2] # LATIN CAPITAL LETTER O WITH GRAVE
        glyphs += [0x00D3] # LATIN CAPITAL LETTER O WITH ACUTE
        glyphs += [0x00D4] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX
        glyphs += [0x00D5] # LATIN CAPITAL LETTER O WITH TILDE
        glyphs += [0x00D6] # LATIN CAPITAL LETTER O WITH DIAERESIS
        glyphs += [0x00D7] # MULTIPLICATION SIGN
        glyphs += [0x00D8] # LATIN CAPITAL LETTER O WITH STROKE
        glyphs += [0x00D9] # LATIN CAPITAL LETTER U WITH GRAVE
        glyphs += [0x00DA] # LATIN CAPITAL LETTER U WITH ACUTE
        glyphs += [0x00DB] # LATIN CAPITAL LETTER U WITH CIRCUMFLEX
        glyphs += [0x00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
        glyphs += [0x00DD] # LATIN CAPITAL LETTER Y WITH ACUTE
        glyphs += [0x00DE] # LATIN CAPITAL LETTER THORN
        glyphs += [0x00DF] # LATIN SMALL LETTER SHARP S
        glyphs += [0x00E0] # LATIN SMALL LETTER A WITH GRAVE
        glyphs += [0x00E1] # LATIN SMALL LETTER A WITH ACUTE
        glyphs += [0x00E2] # LATIN SMALL LETTER A WITH CIRCUMFLEX
        glyphs += [0x00E3] # LATIN SMALL LETTER A WITH TILDE
        glyphs += [0x00E4] # LATIN SMALL LETTER A WITH DIAERESIS
        glyphs += [0x00E5] # LATIN SMALL LETTER A WITH RING ABOVE
        glyphs += [0x00E6] # LATIN SMALL LETTER AE
        glyphs += [0x00E7] # LATIN SMALL LETTER C WITH CEDILLA
        glyphs += [0x00E8] # LATIN SMALL LETTER E WITH GRAVE
        glyphs += [0x00E9] # LATIN SMALL LETTER E WITH ACUTE
        glyphs += [0x00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
        glyphs += [0x00EB] # LATIN SMALL LETTER E WITH DIAERESIS
        glyphs += [0x00EC] # LATIN SMALL LETTER I WITH GRAVE
        glyphs += [0x00ED] # LATIN SMALL LETTER I WITH ACUTE
        glyphs += [0x00EE] # LATIN SMALL LETTER I WITH CIRCUMFLEX
        glyphs += [0x00EF] # LATIN SMALL LETTER I WITH DIAERESIS
        glyphs += [0x00F0] # LATIN SMALL LETTER ETH
        glyphs += [0x00F1] # LATIN SMALL LETTER N WITH TILDE
        glyphs += [0x00F2] # LATIN SMALL LETTER O WITH GRAVE
        glyphs += [0x00F3] # LATIN SMALL LETTER O WITH ACUTE
        glyphs += [0x00F4] # LATIN SMALL LETTER O WITH CIRCUMFLEX
        glyphs += [0x00F5] # LATIN SMALL LETTER O WITH TILDE
        glyphs += [0x00F6] # LATIN SMALL LETTER O WITH DIAERESIS
        glyphs += [0x00F7] # DIVISION SIGN
        glyphs += [0x00F8] # LATIN SMALL LETTER O WITH STROKE
        glyphs += [0x00F9] # LATIN SMALL LETTER U WITH GRAVE
        glyphs += [0x00FA] # LATIN SMALL LETTER U WITH ACUTE
        glyphs += [0x00FB] # LATIN SMALL LETTER U WITH CIRCUMFLEX
        glyphs += [0x00FC] # LATIN SMALL LETTER U WITH DIAERESIS
        glyphs += [0x00FD] # LATIN SMALL LETTER Y WITH ACUTE
        glyphs += [0x00FE] # LATIN SMALL LETTER THORN
        glyphs += [0x00FF] # LATIN SMALL LETTER Y WITH DIAERESIS
        glyphs += [0x0100] # LATIN CAPITAL LETTER A WITH MACRON
        glyphs += [0x0101] # LATIN SMALL LETTER A WITH MACRON
        glyphs += [0x0102] # LATIN CAPITAL LETTER A WITH BREVE
        glyphs += [0x0103] # LATIN SMALL LETTER A WITH BREVE
        glyphs += [0x0104] # LATIN CAPITAL LETTER A WITH OGONEK
        glyphs += [0x0105] # LATIN SMALL LETTER A WITH OGONEK
        glyphs += [0x0106] # LATIN CAPITAL LETTER C WITH ACUTE
        glyphs += [0x0107] # LATIN SMALL LETTER C WITH ACUTE
        glyphs += [0x0108] # LATIN CAPITAL LETTER C WITH CIRCUMFLEX
        glyphs += [0x0109] # LATIN SMALL LETTER C WITH CIRCUMFLEX
        glyphs += [0x010A] # LATIN CAPITAL LETTER C WITH DOT ABOVE
        glyphs += [0x010B] # LATIN SMALL LETTER C WITH DOT ABOVE
        glyphs += [0x010C] # LATIN CAPITAL LETTER C WITH CARON
        glyphs += [0x010D] # LATIN SMALL LETTER C WITH CARON
        glyphs += [0x010E] # LATIN CAPITAL LETTER D WITH CARON
        glyphs += [0x010F] # LATIN SMALL LETTER D WITH CARON
        glyphs += [0x0110] # LATIN CAPITAL LETTER D WITH STROKE
        glyphs += [0x0111] # LATIN SMALL LETTER D WITH STROKE
        glyphs += [0x0112] # LATIN CAPITAL LETTER E WITH MACRON
        glyphs += [0x0113] # LATIN SMALL LETTER E WITH MACRON
        glyphs += [0x0114] # LATIN CAPITAL LETTER E WITH BREVE
        glyphs += [0x0115] # LATIN SMALL LETTER E WITH BREVE
        glyphs += [0x0116] # LATIN CAPITAL LETTER E WITH DOT ABOVE
        glyphs += [0x0117] # LATIN SMALL LETTER E WITH DOT ABOVE
        glyphs += [0x0118] # LATIN CAPITAL LETTER E WITH OGONEK
        glyphs += [0x0119] # LATIN SMALL LETTER E WITH OGONEK
        glyphs += [0x011A] # LATIN CAPITAL LETTER E WITH CARON
        glyphs += [0x011B] # LATIN SMALL LETTER E WITH CARON
        glyphs += [0x011C] # LATIN CAPITAL LETTER G WITH CIRCUMFLEX
        glyphs += [0x011D] # LATIN SMALL LETTER G WITH CIRCUMFLEX
        glyphs += [0x011E] # LATIN CAPITAL LETTER G WITH BREVE
        glyphs += [0x011F] # LATIN SMALL LETTER G WITH BREVE
        glyphs += [0x0120] # LATIN CAPITAL LETTER G WITH DOT ABOVE
        glyphs += [0x0121] # LATIN SMALL LETTER G WITH DOT ABOVE
        glyphs += [0x0122] # LATIN CAPITAL LETTER G WITH CEDILLA
        glyphs += [0x0123] # LATIN SMALL LETTER G WITH CEDILLA
        glyphs += [0x0124] # LATIN CAPITAL LETTER H WITH CIRCUMFLEX
        glyphs += [0x0125] # LATIN SMALL LETTER H WITH CIRCUMFLEX
        glyphs += [0x0126] # LATIN CAPITAL LETTER H WITH STROKE
        glyphs += [0x0127] # LATIN SMALL LETTER H WITH STROKE
        glyphs += [0x0128] # LATIN CAPITAL LETTER I WITH TILDE
        glyphs += [0x0129] # LATIN SMALL LETTER I WITH TILDE
        glyphs += [0x012A] # LATIN CAPITAL LETTER I WITH MACRON
        glyphs += [0x012B] # LATIN SMALL LETTER I WITH MACRON
        glyphs += [0x012C] # LATIN CAPITAL LETTER I WITH BREVE
        glyphs += [0x012D] # LATIN SMALL LETTER I WITH BREVE
        glyphs += [0x012E] # LATIN CAPITAL LETTER I WITH OGONEK
        glyphs += [0x012F] # LATIN SMALL LETTER I WITH OGONEK
        glyphs += [0x0130] # LATIN CAPITAL LETTER I WITH DOT ABOVE
        glyphs += [0x0131] # LATIN SMALL LETTER DOTLESS I
        glyphs += [0x0132] # LATIN CAPITAL LIGATURE IJ
        glyphs += [0x0133] # LATIN SMALL LIGATURE IJ
        glyphs += [0x0134] # LATIN CAPITAL LETTER J WITH CIRCUMFLEX
        glyphs += [0x0135] # LATIN SMALL LETTER J WITH CIRCUMFLEX
        glyphs += [0x0136] # LATIN CAPITAL LETTER K WITH CEDILLA
        glyphs += [0x0137] # LATIN SMALL LETTER K WITH CEDILLA
        glyphs += [0x0138] # LATIN SMALL LETTER KRA
        glyphs += [0x0139] # LATIN CAPITAL LETTER L WITH ACUTE
        glyphs += [0x013A] # LATIN SMALL LETTER L WITH ACUTE
        glyphs += [0x013B] # LATIN CAPITAL LETTER L WITH CEDILLA
        glyphs += [0x013C] # LATIN SMALL LETTER L WITH CEDILLA
        glyphs += [0x013D] # LATIN CAPITAL LETTER L WITH CARON
        glyphs += [0x013E] # LATIN SMALL LETTER L WITH CARON
        glyphs += [0x013F] # LATIN CAPITAL LETTER L WITH MIDDLE DOT
        glyphs += [0x0140] # LATIN SMALL LETTER L WITH MIDDLE DOT
        glyphs += [0x0141] # LATIN CAPITAL LETTER L WITH STROKE
        glyphs += [0x0142] # LATIN SMALL LETTER L WITH STROKE
        glyphs += [0x0143] # LATIN CAPITAL LETTER N WITH ACUTE
        glyphs += [0x0144] # LATIN SMALL LETTER N WITH ACUTE
        glyphs += [0x0145] # LATIN CAPITAL LETTER N WITH CEDILLA
        glyphs += [0x0146] # LATIN SMALL LETTER N WITH CEDILLA
        glyphs += [0x0147] # LATIN CAPITAL LETTER N WITH CARON
        glyphs += [0x0148] # LATIN SMALL LETTER N WITH CARON
        glyphs += [0x0149] # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
        glyphs += [0x014A] # LATIN CAPITAL LETTER ENG
        glyphs += [0x014B] # LATIN SMALL LETTER ENG
        glyphs += [0x014C] # LATIN CAPITAL LETTER O WITH MACRON
        glyphs += [0x014D] # LATIN SMALL LETTER O WITH MACRON
        glyphs += [0x014E] # LATIN CAPITAL LETTER O WITH BREVE
        glyphs += [0x014F] # LATIN SMALL LETTER O WITH BREVE
        glyphs += [0x0150] # LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
        glyphs += [0x0151] # LATIN SMALL LETTER O WITH DOUBLE ACUTE
        glyphs += [0x0152] # LATIN CAPITAL LIGATURE OE
        glyphs += [0x0153] # LATIN SMALL LIGATURE OE
        glyphs += [0x0154] # LATIN CAPITAL LETTER R WITH ACUTE
        glyphs += [0x0155] # LATIN SMALL LETTER R WITH ACUTE
        glyphs += [0x0156] # LATIN CAPITAL LETTER R WITH CEDILLA
        glyphs += [0x0157] # LATIN SMALL LETTER R WITH CEDILLA
        glyphs += [0x0158] # LATIN CAPITAL LETTER R WITH CARON
        glyphs += [0x0159] # LATIN SMALL LETTER R WITH CARON
        glyphs += [0x015A] # LATIN CAPITAL LETTER S WITH ACUTE
        glyphs += [0x015B] # LATIN SMALL LETTER S WITH ACUTE
        glyphs += [0x015C] # LATIN CAPITAL LETTER S WITH CIRCUMFLEX
        glyphs += [0x015D] # LATIN SMALL LETTER S WITH CIRCUMFLEX
        glyphs += [0x015E] # LATIN CAPITAL LETTER S WITH CEDILLA
        glyphs += [0x015F] # LATIN SMALL LETTER S WITH CEDILLA
        glyphs += [0x0160] # LATIN CAPITAL LETTER S WITH CARON
        glyphs += [0x0161] # LATIN SMALL LETTER S WITH CARON
        glyphs += [0x0162] # LATIN CAPITAL LETTER T WITH CEDILLA
        glyphs += [0x0163] # LATIN SMALL LETTER T WITH CEDILLA
        glyphs += [0x0164] # LATIN CAPITAL LETTER T WITH CARON
        glyphs += [0x0165] # LATIN SMALL LETTER T WITH CARON
        glyphs += [0x0166] # LATIN CAPITAL LETTER T WITH STROKE
        glyphs += [0x0167] # LATIN SMALL LETTER T WITH STROKE
        glyphs += [0x0168] # LATIN CAPITAL LETTER U WITH TILDE
        glyphs += [0x0169] # LATIN SMALL LETTER U WITH TILDE
        glyphs += [0x016A] # LATIN CAPITAL LETTER U WITH MACRON
        glyphs += [0x016B] # LATIN SMALL LETTER U WITH MACRON
        glyphs += [0x016C] # LATIN CAPITAL LETTER U WITH BREVE
        glyphs += [0x016D] # LATIN SMALL LETTER U WITH BREVE
        glyphs += [0x016E] # LATIN CAPITAL LETTER U WITH RING ABOVE
        glyphs += [0x016F] # LATIN SMALL LETTER U WITH RING ABOVE
        glyphs += [0x0170] # LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
        glyphs += [0x0171] # LATIN SMALL LETTER U WITH DOUBLE ACUTE
        glyphs += [0x0172] # LATIN CAPITAL LETTER U WITH OGONEK
        glyphs += [0x0173] # LATIN SMALL LETTER U WITH OGONEK
        glyphs += [0x0174] # LATIN CAPITAL LETTER W WITH CIRCUMFLEX
        glyphs += [0x0175] # LATIN SMALL LETTER W WITH CIRCUMFLEX
        glyphs += [0x0176] # LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
        glyphs += [0x0177] # LATIN SMALL LETTER Y WITH CIRCUMFLEX
        glyphs += [0x0178] # LATIN CAPITAL LETTER Y WITH DIAERESIS
        glyphs += [0x0179] # LATIN CAPITAL LETTER Z WITH ACUTE
        glyphs += [0x017A] # LATIN SMALL LETTER Z WITH ACUTE
        glyphs += [0x017B] # LATIN CAPITAL LETTER Z WITH DOT ABOVE
        glyphs += [0x017C] # LATIN SMALL LETTER Z WITH DOT ABOVE
        glyphs += [0x017D] # LATIN CAPITAL LETTER Z WITH CARON
        glyphs += [0x017E] # LATIN SMALL LETTER Z WITH CARON
        glyphs += [0x017F] # LATIN SMALL LETTER LONG S
        glyphs += [0x0181] # LATIN CAPITAL LETTER B WITH HOOK
        glyphs += [0x0186] # LATIN CAPITAL LETTER OPEN O
        glyphs += [0x018A] # LATIN CAPITAL LETTER D WITH HOOK
        glyphs += [0x018F] # LATIN CAPITAL LETTER SCHWA
        glyphs += [0x0190] # LATIN CAPITAL LETTER OPEN E
        glyphs += [0x0191] # LATIN CAPITAL LETTER F WITH HOOK
        glyphs += [0x0192] # LATIN SMALL LETTER F WITH HOOK
        glyphs += [0x0194] # LATIN CAPITAL LETTER GAMMA
        glyphs += [0x0198] # LATIN CAPITAL LETTER K WITH HOOK
        glyphs += [0x0199] # LATIN SMALL LETTER K WITH HOOK
        glyphs += [0x019A] # LATIN SMALL LETTER L WITH BAR
        glyphs += [0x019B] # LATIN SMALL LETTER LAMBDA WITH STROKE
        glyphs += [0x019D] # LATIN CAPITAL LETTER N WITH LEFT HOOK
        glyphs += [0x019F] # LATIN CAPITAL LETTER O WITH MIDDLE TILDE
        glyphs += [0x01A0] # LATIN CAPITAL LETTER O WITH HORN
        glyphs += [0x01A1] # LATIN SMALL LETTER O WITH HORN
        glyphs += [0x01AF] # LATIN CAPITAL LETTER U WITH HORN
        glyphs += [0x01B0] # LATIN SMALL LETTER U WITH HORN
        glyphs += [0x01B3] # LATIN CAPITAL LETTER Y WITH HOOK
        glyphs += [0x01B4] # LATIN SMALL LETTER Y WITH HOOK
        glyphs += [0x01B5] # LATIN CAPITAL LETTER Z WITH STROKE
        glyphs += [0x01B6] # LATIN SMALL LETTER Z WITH STROKE
        glyphs += [0x01C1] # LATIN LETTER LATERAL CLICK
        glyphs += [0x01C2] # LATIN LETTER ALVEOLAR CLICK
        glyphs += [0x01C3] # LATIN LETTER RETROFLEX CLICK
        glyphs += [0x01C4] # LATIN CAPITAL LETTER DZ WITH CARON
        glyphs += [0x01C5] # LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
        glyphs += [0x01C6] # LATIN SMALL LETTER DZ WITH CARON
        glyphs += [0x01C7] # LATIN CAPITAL LETTER LJ
        glyphs += [0x01C8] # LATIN CAPITAL LETTER L WITH SMALL LETTER J
        glyphs += [0x01C9] # LATIN SMALL LETTER LJ
        glyphs += [0x01CA] # LATIN CAPITAL LETTER NJ
        glyphs += [0x01CB] # LATIN CAPITAL LETTER N WITH SMALL LETTER J
        glyphs += [0x01CC] # LATIN SMALL LETTER NJ
        glyphs += [0x01CD] # LATIN CAPITAL LETTER A WITH CARON
        glyphs += [0x01CE] # LATIN SMALL LETTER A WITH CARON
        glyphs += [0x01CF] # LATIN CAPITAL LETTER I WITH CARON
        glyphs += [0x01D0] # LATIN SMALL LETTER I WITH CARON
        glyphs += [0x01D1] # LATIN CAPITAL LETTER O WITH CARON
        glyphs += [0x01D2] # LATIN SMALL LETTER O WITH CARON
        glyphs += [0x01D3] # LATIN CAPITAL LETTER U WITH CARON
        glyphs += [0x01D4] # LATIN SMALL LETTER U WITH CARON
        glyphs += [0x01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
        glyphs += [0x01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
        glyphs += [0x01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
        glyphs += [0x01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
        glyphs += [0x01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
        glyphs += [0x01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
        glyphs += [0x01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
        glyphs += [0x01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
        glyphs += [0x01E6] # LATIN CAPITAL LETTER G WITH CARON
        glyphs += [0x01E7] # LATIN SMALL LETTER G WITH CARON
        glyphs += [0x01EA] # LATIN CAPITAL LETTER O WITH OGONEK
        glyphs += [0x01EB] # LATIN SMALL LETTER O WITH OGONEK
        glyphs += [0x01EF] # LATIN SMALL LETTER EZH WITH CARON
        glyphs += [0x01F0] # LATIN SMALL LETTER J WITH CARON
        glyphs += [0x01F1] # LATIN CAPITAL LETTER DZ
        glyphs += [0x01F2] # LATIN CAPITAL LETTER D WITH SMALL LETTER Z
        glyphs += [0x01F3] # LATIN SMALL LETTER DZ
        glyphs += [0x01F4] # LATIN CAPITAL LETTER G WITH ACUTE
        glyphs += [0x01F5] # LATIN SMALL LETTER G WITH ACUTE
        glyphs += [0x01F8] # LATIN CAPITAL LETTER N WITH GRAVE
        glyphs += [0x01F9] # LATIN SMALL LETTER N WITH GRAVE
        glyphs += [0x01FA] # LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
        glyphs += [0x01FB] # LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
        glyphs += [0x01FC] # LATIN CAPITAL LETTER AE WITH ACUTE
        glyphs += [0x01FD] # LATIN SMALL LETTER AE WITH ACUTE
        glyphs += [0x01FE] # LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
        glyphs += [0x01FF] # LATIN SMALL LETTER O WITH STROKE AND ACUTE
        glyphs += [0x0218] # LATIN CAPITAL LETTER S WITH COMMA BELOW
        glyphs += [0x0219] # LATIN SMALL LETTER S WITH COMMA BELOW
        glyphs += [0x021A] # LATIN CAPITAL LETTER T WITH COMMA BELOW
        glyphs += [0x021B] # LATIN SMALL LETTER T WITH COMMA BELOW
        glyphs += [0x021C] # LATIN CAPITAL LETTER YOGH
        glyphs += [0x021D] # LATIN SMALL LETTER YOGH
        glyphs += [0x0232] # LATIN CAPITAL LETTER Y WITH MACRON
        glyphs += [0x0233] # LATIN SMALL LETTER Y WITH MACRON
        glyphs += [0x0237] # LATIN SMALL LETTER DOTLESS J
        glyphs += [0x023D] # LATIN CAPITAL LETTER L WITH BAR
        glyphs += [0x0250] # LATIN SMALL LETTER TURNED A
        glyphs += [0x0251] # LATIN SMALL LETTER ALPHA
        glyphs += [0x0252] # LATIN SMALL LETTER TURNED ALPHA
        glyphs += [0x0253] # LATIN SMALL LETTER B WITH HOOK
        glyphs += [0x0254] # LATIN SMALL LETTER OPEN O
        glyphs += [0x0255] # LATIN SMALL LETTER C WITH CURL
        glyphs += [0x0256] # LATIN SMALL LETTER D WITH TAIL
        glyphs += [0x0257] # LATIN SMALL LETTER D WITH HOOK
        glyphs += [0x0258] # LATIN SMALL LETTER REVERSED E
        glyphs += [0x0259] # LATIN SMALL LETTER SCHWA
        glyphs += [0x025A] # LATIN SMALL LETTER SCHWA WITH HOOK
        glyphs += [0x025B] # LATIN SMALL LETTER OPEN E
        glyphs += [0x025C] # LATIN SMALL LETTER REVERSED OPEN E
        glyphs += [0x025D] # LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
        glyphs += [0x025E] # LATIN SMALL LETTER CLOSED REVERSED OPEN E
        glyphs += [0x025F] # LATIN SMALL LETTER DOTLESS J WITH STROKE
        glyphs += [0x0260] # LATIN SMALL LETTER G WITH HOOK
        glyphs += [0x0261] # LATIN SMALL LETTER SCRIPT G
        glyphs += [0x0262] # LATIN LETTER SMALL CAPITAL G
        glyphs += [0x0263] # LATIN SMALL LETTER GAMMA
        glyphs += [0x0264] # LATIN SMALL LETTER RAMS HORN
        glyphs += [0x0265] # LATIN SMALL LETTER TURNED H
        glyphs += [0x0266] # LATIN SMALL LETTER H WITH HOOK
        glyphs += [0x0267] # LATIN SMALL LETTER HENG WITH HOOK
        glyphs += [0x0268] # LATIN SMALL LETTER I WITH STROKE
        glyphs += [0x0269] # LATIN SMALL LETTER IOTA
        glyphs += [0x026A] # LATIN LETTER SMALL CAPITAL I
        glyphs += [0x026B] # LATIN SMALL LETTER L WITH MIDDLE TILDE
        glyphs += [0x026C] # LATIN SMALL LETTER L WITH BELT
        glyphs += [0x026D] # LATIN SMALL LETTER L WITH RETROFLEX HOOK
        glyphs += [0x026E] # LATIN SMALL LETTER LEZH
        glyphs += [0x026F] # LATIN SMALL LETTER TURNED M
        glyphs += [0x0270] # LATIN SMALL LETTER TURNED M WITH LONG LEG
        glyphs += [0x0271] # LATIN SMALL LETTER M WITH HOOK
        glyphs += [0x0272] # LATIN SMALL LETTER N WITH LEFT HOOK
        glyphs += [0x0273] # LATIN SMALL LETTER N WITH RETROFLEX HOOK
        glyphs += [0x0274] # LATIN LETTER SMALL CAPITAL N
        glyphs += [0x0275] # LATIN SMALL LETTER BARRED O
        glyphs += [0x0276] # LATIN LETTER SMALL CAPITAL OE
        glyphs += [0x0277] # LATIN SMALL LETTER CLOSED OMEGA
        glyphs += [0x0278] # LATIN SMALL LETTER PHI
        glyphs += [0x0279] # LATIN SMALL LETTER TURNED R
        glyphs += [0x027A] # LATIN SMALL LETTER TURNED R WITH LONG LEG
        glyphs += [0x027B] # LATIN SMALL LETTER TURNED R WITH HOOK
        glyphs += [0x027C] # LATIN SMALL LETTER R WITH LONG LEG
        glyphs += [0x027D] # LATIN SMALL LETTER R WITH TAIL
        glyphs += [0x027E] # LATIN SMALL LETTER R WITH FISHHOOK
        glyphs += [0x027F] # LATIN SMALL LETTER REVERSED R WITH FISHHOOK
        glyphs += [0x0280] # LATIN LETTER SMALL CAPITAL R
        glyphs += [0x0281] # LATIN LETTER SMALL CAPITAL INVERTED R
        glyphs += [0x0282] # LATIN SMALL LETTER S WITH HOOK
        glyphs += [0x0283] # LATIN SMALL LETTER ESH
        glyphs += [0x0284] # LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
        glyphs += [0x0285] # LATIN SMALL LETTER SQUAT REVERSED ESH
        glyphs += [0x0286] # LATIN SMALL LETTER ESH WITH CURL
        glyphs += [0x0287] # LATIN SMALL LETTER TURNED T
        glyphs += [0x0288] # LATIN SMALL LETTER T WITH RETROFLEX HOOK
        glyphs += [0x0289] # LATIN SMALL LETTER U BAR
        glyphs += [0x028A] # LATIN SMALL LETTER UPSILON
        glyphs += [0x028B] # LATIN SMALL LETTER V WITH HOOK
        glyphs += [0x028C] # LATIN SMALL LETTER TURNED V
        glyphs += [0x028D] # LATIN SMALL LETTER TURNED W
        glyphs += [0x028E] # LATIN SMALL LETTER TURNED Y
        glyphs += [0x028F] # LATIN LETTER SMALL CAPITAL Y
        glyphs += [0x0290] # LATIN SMALL LETTER Z WITH RETROFLEX HOOK
        glyphs += [0x0291] # LATIN SMALL LETTER Z WITH CURL
        glyphs += [0x0292] # LATIN SMALL LETTER EZH
        glyphs += [0x0293] # LATIN SMALL LETTER EZH WITH CURL
        glyphs += [0x0294] # LATIN LETTER GLOTTAL STOP
        glyphs += [0x0295] # LATIN LETTER PHARYNGEAL VOICED FRICATIVE
        glyphs += [0x0296] # LATIN LETTER INVERTED GLOTTAL STOP
        glyphs += [0x0297] # LATIN LETTER STRETCHED C
        glyphs += [0x0298] # LATIN LETTER BILABIAL CLICK
        glyphs += [0x0299] # LATIN LETTER SMALL CAPITAL B
        glyphs += [0x029A] # LATIN SMALL LETTER CLOSED OPEN E
        glyphs += [0x029B] # LATIN LETTER SMALL CAPITAL G WITH HOOK
        glyphs += [0x029C] # LATIN LETTER SMALL CAPITAL H
        glyphs += [0x029D] # LATIN SMALL LETTER J WITH CROSSED-TAIL
        glyphs += [0x029E] # LATIN SMALL LETTER TURNED K
        glyphs += [0x029F] # LATIN LETTER SMALL CAPITAL L
        glyphs += [0x02A0] # LATIN SMALL LETTER Q WITH HOOK
        glyphs += [0x02A1] # LATIN LETTER GLOTTAL STOP WITH STROKE
        glyphs += [0x02A2] # LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE
        glyphs += [0x02A3] # LATIN SMALL LETTER DZ DIGRAPH
        glyphs += [0x02A4] # LATIN SMALL LETTER DEZH DIGRAPH
        glyphs += [0x02A5] # LATIN SMALL LETTER DZ DIGRAPH WITH CURL
        glyphs += [0x02A6] # LATIN SMALL LETTER TS DIGRAPH
        glyphs += [0x02A7] # LATIN SMALL LETTER TESH DIGRAPH
        glyphs += [0x02A8] # LATIN SMALL LETTER TC DIGRAPH WITH CURL
        glyphs += [0x02A9] # LATIN SMALL LETTER FENG DIGRAPH
        glyphs += [0x02AA] # LATIN SMALL LETTER LS DIGRAPH
        glyphs += [0x02AB] # LATIN SMALL LETTER LZ DIGRAPH
        glyphs += [0x02AC] # LATIN LETTER BILABIAL PERCUSSIVE
        glyphs += [0x02AD] # LATIN LETTER BIDENTAL PERCUSSIVE
        glyphs += [0x02AE] # LATIN SMALL LETTER TURNED H WITH FISHHOOK
        glyphs += [0x02AF] # LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
        glyphs += [0x02B0] # MODIFIER LETTER SMALL H
        glyphs += [0x02B1] # MODIFIER LETTER SMALL H WITH HOOK
        glyphs += [0x02B2] # MODIFIER LETTER SMALL J
        glyphs += [0x02B3] # MODIFIER LETTER SMALL R
        glyphs += [0x02B4] # MODIFIER LETTER SMALL TURNED R
        glyphs += [0x02B5] # MODIFIER LETTER SMALL TURNED R WITH HOOK
        glyphs += [0x02B6] # MODIFIER LETTER SMALL CAPITAL INVERTED R
        glyphs += [0x02B7] # MODIFIER LETTER SMALL W
        glyphs += [0x02B8] # MODIFIER LETTER SMALL Y
        glyphs += [0x02B9] # MODIFIER LETTER PRIME
        glyphs += [0x02BA] # MODIFIER LETTER DOUBLE PRIME
        glyphs += [0x02BB] # MODIFIER LETTER TURNED COMMA
        glyphs += [0x02BC] # MODIFIER LETTER APOSTROPHE
        glyphs += [0x02BD] # MODIFIER LETTER REVERSED COMMA
        glyphs += [0x02BE] # MODIFIER LETTER RIGHT HALF RING
        glyphs += [0x02BF] # MODIFIER LETTER LEFT HALF RING
        glyphs += [0x02C0] # MODIFIER LETTER GLOTTAL STOP
        glyphs += [0x02C1] # MODIFIER LETTER REVERSED GLOTTAL STOP
        glyphs += [0x02C2] # MODIFIER LETTER LEFT ARROWHEAD
        glyphs += [0x02C3] # MODIFIER LETTER RIGHT ARROWHEAD
        glyphs += [0x02C4] # MODIFIER LETTER UP ARROWHEAD
        glyphs += [0x02C5] # MODIFIER LETTER DOWN ARROWHEAD
        glyphs += [0x02C6] # MODIFIER LETTER CIRCUMFLEX ACCENT
        glyphs += [0x02C7] # CARON
        glyphs += [0x02C8] # MODIFIER LETTER VERTICAL LINE
        glyphs += [0x02C9] # MODIFIER LETTER MACRON
        glyphs += [0x02CA] # MODIFIER LETTER ACUTE ACCENT
        glyphs += [0x02CB] # MODIFIER LETTER GRAVE ACCENT
        glyphs += [0x02CC] # MODIFIER LETTER LOW VERTICAL LINE
        glyphs += [0x02CD] # MODIFIER LETTER LOW MACRON
        glyphs += [0x02CE] # MODIFIER LETTER LOW GRAVE ACCENT
        glyphs += [0x02CF] # MODIFIER LETTER LOW ACUTE ACCENT
        glyphs += [0x02D0] # MODIFIER LETTER TRIANGULAR COLON
        glyphs += [0x02D1] # MODIFIER LETTER HALF TRIANGULAR COLON
        glyphs += [0x02D2] # MODIFIER LETTER CENTRED RIGHT HALF RING
        glyphs += [0x02D3] # MODIFIER LETTER CENTRED LEFT HALF RING
        glyphs += [0x02D4] # MODIFIER LETTER UP TACK
        glyphs += [0x02D5] # MODIFIER LETTER DOWN TACK
        glyphs += [0x02D6] # MODIFIER LETTER PLUS SIGN
        glyphs += [0x02D7] # MODIFIER LETTER MINUS SIGN
        glyphs += [0x02D8] # BREVE
        glyphs += [0x02D9] # DOT ABOVE
        glyphs += [0x02DA] # RING ABOVE
        glyphs += [0x02DB] # OGONEK
        glyphs += [0x02DC] # SMALL TILDE
        glyphs += [0x02DD] # DOUBLE ACUTE ACCENT
        glyphs += [0x02DE] # MODIFIER LETTER RHOTIC HOOK
        glyphs += [0x02DF] # MODIFIER LETTER CROSS ACCENT
        glyphs += [0x02E0] # MODIFIER LETTER SMALL GAMMA
        glyphs += [0x02E1] # MODIFIER LETTER SMALL L
        glyphs += [0x02E2] # MODIFIER LETTER SMALL S
        glyphs += [0x02E3] # MODIFIER LETTER SMALL X
        glyphs += [0x02E4] # MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
        glyphs += [0x02E5] # MODIFIER LETTER EXTRA-HIGH TONE BAR
        glyphs += [0x02E6] # MODIFIER LETTER HIGH TONE BAR
        glyphs += [0x02E7] # MODIFIER LETTER MID TONE BAR
        glyphs += [0x02E8] # MODIFIER LETTER LOW TONE BAR
        glyphs += [0x02E9] # MODIFIER LETTER EXTRA-LOW TONE BAR
        glyphs += [0x02EA] # MODIFIER LETTER YIN DEPARTING TONE MARK
        glyphs += [0x02EB] # MODIFIER LETTER YANG DEPARTING TONE MARK
        glyphs += [0x02EC] # MODIFIER LETTER VOICING
        glyphs += [0x02ED] # MODIFIER LETTER UNASPIRATED
        glyphs += [0x02EE] # MODIFIER LETTER DOUBLE APOSTROPHE
        glyphs += [0x02EF] # MODIFIER LETTER LOW DOWN ARROWHEAD
        glyphs += [0x02F0] # MODIFIER LETTER LOW UP ARROWHEAD
        glyphs += [0x02F1] # MODIFIER LETTER LOW LEFT ARROWHEAD
        glyphs += [0x02F2] # MODIFIER LETTER LOW RIGHT ARROWHEAD
        glyphs += [0x02F3] # MODIFIER LETTER LOW RING
        glyphs += [0x02F4] # MODIFIER LETTER MIDDLE GRAVE ACCENT
        glyphs += [0x02F5] # MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT
        glyphs += [0x02F6] # MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT
        glyphs += [0x02F7] # MODIFIER LETTER LOW TILDE
        glyphs += [0x02F8] # MODIFIER LETTER RAISED COLON
        glyphs += [0x02F9] # MODIFIER LETTER BEGIN HIGH TONE
        glyphs += [0x02FA] # MODIFIER LETTER END HIGH TONE
        glyphs += [0x02FB] # MODIFIER LETTER BEGIN LOW TONE
        glyphs += [0x02FC] # MODIFIER LETTER END LOW TONE
        glyphs += [0x02FD] # MODIFIER LETTER SHELF
        glyphs += [0x02FE] # MODIFIER LETTER OPEN SHELF
        glyphs += [0x02FF] # MODIFIER LETTER LOW LEFT ARROW
        glyphs += [0x0300] # COMBINING GRAVE ACCENT
        glyphs += [0x0301] # COMBINING ACUTE ACCENT
        glyphs += [0x0302] # COMBINING CIRCUMFLEX ACCENT
        glyphs += [0x0303] # COMBINING TILDE
        glyphs += [0x0304] # COMBINING MACRON
        glyphs += [0x0305] # COMBINING OVERLINE
        glyphs += [0x0306] # COMBINING BREVE
        glyphs += [0x0307] # COMBINING DOT ABOVE
        glyphs += [0x0308] # COMBINING DIAERESIS
        glyphs += [0x0309] # COMBINING HOOK ABOVE
        glyphs += [0x030A] # COMBINING RING ABOVE
        glyphs += [0x030B] # COMBINING DOUBLE ACUTE ACCENT
        glyphs += [0x030C] # COMBINING CARON
        glyphs += [0x030D] # COMBINING VERTICAL LINE ABOVE
        glyphs += [0x030E] # COMBINING DOUBLE VERTICAL LINE ABOVE
        glyphs += [0x030F] # COMBINING DOUBLE GRAVE ACCENT
        glyphs += [0x0311] # COMBINING INVERTED BREVE
        glyphs += [0x0312] # COMBINING TURNED COMMA ABOVE
        glyphs += [0x0313] # COMBINING COMMA ABOVE
        glyphs += [0x0314] # COMBINING REVERSED COMMA ABOVE
        glyphs += [0x0315] # COMBINING COMMA ABOVE RIGHT
        glyphs += [0x0316] # COMBINING GRAVE ACCENT BELOW
        glyphs += [0x0317] # COMBINING ACUTE ACCENT BELOW
        glyphs += [0x0318] # COMBINING LEFT TACK BELOW
        glyphs += [0x0319] # COMBINING RIGHT TACK BELOW
        glyphs += [0x031A] # COMBINING LEFT ANGLE ABOVE
        glyphs += [0x031B] # COMBINING HORN
        glyphs += [0x031C] # COMBINING LEFT HALF RING BELOW
        glyphs += [0x031D] # COMBINING UP TACK BELOW
        glyphs += [0x031E] # COMBINING DOWN TACK BELOW
        glyphs += [0x031F] # COMBINING PLUS SIGN BELOW
        glyphs += [0x0320] # COMBINING MINUS SIGN BELOW
        glyphs += [0x0321] # COMBINING PALATALIZED HOOK BELOW
        glyphs += [0x0322] # COMBINING RETROFLEX HOOK BELOW
        glyphs += [0x0323] # COMBINING DOT BELOW
        glyphs += [0x0324] # COMBINING DIAERESIS BELOW
        glyphs += [0x0325] # COMBINING RING BELOW
        glyphs += [0x0326] # COMBINING COMMA BELOW
        glyphs += [0x0327] # COMBINING CEDILLA
        glyphs += [0x0328] # COMBINING OGONEK
        glyphs += [0x0329] # COMBINING VERTICAL LINE BELOW
        glyphs += [0x032A] # COMBINING BRIDGE BELOW
        glyphs += [0x032B] # COMBINING INVERTED DOUBLE ARCH BELOW
        glyphs += [0x032C] # COMBINING CARON BELOW
        glyphs += [0x032D] # COMBINING CIRCUMFLEX ACCENT BELOW
        glyphs += [0x032E] # COMBINING BREVE BELOW
        glyphs += [0x032F] # COMBINING INVERTED BREVE BELOW
        glyphs += [0x0330] # COMBINING TILDE BELOW
        glyphs += [0x0331] # COMBINING MACRON BELOW
        glyphs += [0x0332] # COMBINING LOW LINE
        glyphs += [0x0333] # COMBINING DOUBLE LOW LINE
        glyphs += [0x0334] # COMBINING TILDE OVERLAY
        glyphs += [0x0335] # COMBINING SHORT STROKE OVERLAY
        glyphs += [0x0336] # COMBINING LONG STROKE OVERLAY
        glyphs += [0x0337] # COMBINING SHORT SOLIDUS OVERLAY
        glyphs += [0x0338] # COMBINING LONG SOLIDUS OVERLAY
        glyphs += [0x0339] # COMBINING RIGHT HALF RING BELOW
        glyphs += [0x033A] # COMBINING INVERTED BRIDGE BELOW
        glyphs += [0x033B] # COMBINING SQUARE BELOW
        glyphs += [0x033C] # COMBINING SEAGULL BELOW
        glyphs += [0x033D] # COMBINING X ABOVE
        glyphs += [0x033E] # COMBINING VERTICAL TILDE
        glyphs += [0x033F] # COMBINING DOUBLE OVERLINE
        glyphs += [0x0340] # COMBINING GRAVE TONE MARK
        glyphs += [0x0341] # COMBINING ACUTE TONE MARK
        glyphs += [0x0342] # COMBINING GREEK PERISPOMENI
        glyphs += [0x0343] # COMBINING GREEK KORONIS
        glyphs += [0x0344] # COMBINING GREEK DIALYTIKA TONOS
        glyphs += [0x0345] # COMBINING GREEK YPOGEGRAMMENI
        glyphs += [0x0346] # COMBINING BRIDGE ABOVE
        glyphs += [0x0347] # COMBINING EQUALS SIGN BELOW
        glyphs += [0x0348] # COMBINING DOUBLE VERTICAL LINE BELOW
        glyphs += [0x0349] # COMBINING LEFT ANGLE BELOW
        glyphs += [0x034A] # COMBINING NOT TILDE ABOVE
        glyphs += [0x034B] # COMBINING HOMOTHETIC ABOVE
        glyphs += [0x034C] # COMBINING ALMOST EQUAL TO ABOVE
        glyphs += [0x034D] # COMBINING LEFT RIGHT ARROW BELOW
        glyphs += [0x034E] # COMBINING UPWARDS ARROW BELOW
        glyphs += [0x0350] # COMBINING RIGHT ARROWHEAD ABOVE
        glyphs += [0x0351] # COMBINING LEFT HALF RING ABOVE
        glyphs += [0x0352] # COMBINING FERMATA
        glyphs += [0x0353] # COMBINING X BELOW
        glyphs += [0x0354] # COMBINING LEFT ARROWHEAD BELOW
        glyphs += [0x0355] # COMBINING RIGHT ARROWHEAD BELOW
        glyphs += [0x0356] # COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW
        glyphs += [0x0357] # COMBINING RIGHT HALF RING ABOVE
        glyphs += [0x0358] # COMBINING DOT ABOVE RIGHT
        glyphs += [0x0359] # COMBINING ASTERISK BELOW
        glyphs += [0x035A] # COMBINING DOUBLE RING BELOW
        glyphs += [0x035B] # COMBINING ZIGZAG ABOVE
        glyphs += [0x035C] # COMBINING DOUBLE BREVE BELOW
        glyphs += [0x035D] # COMBINING DOUBLE BREVE
        glyphs += [0x035E] # COMBINING DOUBLE MACRON
        glyphs += [0x035F] # COMBINING DOUBLE MACRON BELOW
        glyphs += [0x0360] # COMBINING DOUBLE TILDE
        glyphs += [0x0361] # COMBINING DOUBLE INVERTED BREVE
        glyphs += [0x0362] # COMBINING DOUBLE RIGHTWARDS ARROW BELOW
        glyphs += [0x0363] # COMBINING LATIN SMALL LETTER A
        glyphs += [0x0364] # COMBINING LATIN SMALL LETTER E
        glyphs += [0x0365] # COMBINING LATIN SMALL LETTER I
        glyphs += [0x0366] # COMBINING LATIN SMALL LETTER O
        glyphs += [0x0367] # COMBINING LATIN SMALL LETTER U
        glyphs += [0x0368] # COMBINING LATIN SMALL LETTER C
        glyphs += [0x0369] # COMBINING LATIN SMALL LETTER D
        glyphs += [0x036A] # COMBINING LATIN SMALL LETTER H
        glyphs += [0x036B] # COMBINING LATIN SMALL LETTER M
        glyphs += [0x036C] # COMBINING LATIN SMALL LETTER R
        glyphs += [0x036D] # COMBINING LATIN SMALL LETTER T
        glyphs += [0x036E] # COMBINING LATIN SMALL LETTER V
        glyphs += [0x036F] # COMBINING LATIN SMALL LETTER X
        glyphs += [0x03A9] # GREEK CAPITAL LETTER OMEGA
        glyphs += [0x03B2] # GREEK SMALL LETTER BETA
        glyphs += [0x03B3] # GREEK SMALL LETTER GAMMA
        glyphs += [0x03B8] # GREEK SMALL LETTER THETA
        glyphs += [0x03BB] # GREEK SMALL LETTER LAMDA
        glyphs += [0x03C0] # GREEK SMALL LETTER PI
        glyphs += [0x03C6] # GREEK SMALL LETTER PHI
        glyphs += [0x03C7] # GREEK SMALL LETTER CHI
        glyphs += [0x1D05] # LATIN LETTER SMALL CAPITAL D
        glyphs += [0x1D5A] # MODIFIER LETTER SMALL TURNED M
        glyphs += [0x1D5B] # MODIFIER LETTER SMALL V
        glyphs += [0x1D5D] # MODIFIER LETTER SMALL BETA
        glyphs += [0x1D5E] # MODIFIER LETTER SMALL GREEK GAMMA
        glyphs += [0x1D60] # MODIFIER LETTER SMALL GREEK PHI
        glyphs += [0x1D61] # MODIFIER LETTER SMALL CHI
        glyphs += [0x1D9C] # MODIFIER LETTER SMALL C
        glyphs += [0x1D9E] # MODIFIER LETTER SMALL ETH
        glyphs += [0x1DA0] # MODIFIER LETTER SMALL F
        glyphs += [0x1DA8] # MODIFIER LETTER SMALL J WITH CROSSED-TAIL
        glyphs += [0x1DBB] # MODIFIER LETTER SMALL Z
        glyphs += [0x1DBF] # MODIFIER LETTER SMALL THETA
        glyphs += [0x1E04] # LATIN CAPITAL LETTER B WITH DOT BELOW
        glyphs += [0x1E05] # LATIN SMALL LETTER B WITH DOT BELOW
        glyphs += [0x1E0C] # LATIN CAPITAL LETTER D WITH DOT BELOW
        glyphs += [0x1E0D] # LATIN SMALL LETTER D WITH DOT BELOW
        glyphs += [0x1E0E] # LATIN CAPITAL LETTER D WITH LINE BELOW
        glyphs += [0x1E0F] # LATIN SMALL LETTER D WITH LINE BELOW
        glyphs += [0x1E12] # LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
        glyphs += [0x1E13] # LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
        glyphs += [0x1E20] # LATIN CAPITAL LETTER G WITH MACRON
        glyphs += [0x1E21] # LATIN SMALL LETTER G WITH MACRON
        glyphs += [0x1E24] # LATIN CAPITAL LETTER H WITH DOT BELOW
        glyphs += [0x1E25] # LATIN SMALL LETTER H WITH DOT BELOW
        glyphs += [0x1E2A] # LATIN CAPITAL LETTER H WITH BREVE BELOW
        glyphs += [0x1E2B] # LATIN SMALL LETTER H WITH BREVE BELOW
        glyphs += [0x1E32] # LATIN CAPITAL LETTER K WITH DOT BELOW
        glyphs += [0x1E33] # LATIN SMALL LETTER K WITH DOT BELOW
        glyphs += [0x1E34] # LATIN CAPITAL LETTER K WITH LINE BELOW
        glyphs += [0x1E35] # LATIN SMALL LETTER K WITH LINE BELOW
        glyphs += [0x1E36] # LATIN CAPITAL LETTER L WITH DOT BELOW
        glyphs += [0x1E37] # LATIN SMALL LETTER L WITH DOT BELOW
        glyphs += [0x1E38] # LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
        glyphs += [0x1E39] # LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
        glyphs += [0x1E3A] # LATIN CAPITAL LETTER L WITH LINE BELOW
        glyphs += [0x1E3B] # LATIN SMALL LETTER L WITH LINE BELOW
        glyphs += [0x1E3C] # LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
        glyphs += [0x1E3D] # LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
        glyphs += [0x1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
        glyphs += [0x1E3F] # LATIN SMALL LETTER M WITH ACUTE
        glyphs += [0x1E40] # LATIN CAPITAL LETTER M WITH DOT ABOVE
        glyphs += [0x1E41] # LATIN SMALL LETTER M WITH DOT ABOVE
        glyphs += [0x1E42] # LATIN CAPITAL LETTER M WITH DOT BELOW
        glyphs += [0x1E43] # LATIN SMALL LETTER M WITH DOT BELOW
        glyphs += [0x1E44] # LATIN CAPITAL LETTER N WITH DOT ABOVE
        glyphs += [0x1E45] # LATIN SMALL LETTER N WITH DOT ABOVE
        glyphs += [0x1E46] # LATIN CAPITAL LETTER N WITH DOT BELOW
        glyphs += [0x1E47] # LATIN SMALL LETTER N WITH DOT BELOW
        glyphs += [0x1E48] # LATIN CAPITAL LETTER N WITH LINE BELOW
        glyphs += [0x1E49] # LATIN SMALL LETTER N WITH LINE BELOW
        glyphs += [0x1E4A] # LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
        glyphs += [0x1E4B] # LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
        glyphs += [0x1E58] # LATIN CAPITAL LETTER R WITH DOT ABOVE
        glyphs += [0x1E59] # LATIN SMALL LETTER R WITH DOT ABOVE
        glyphs += [0x1E5A] # LATIN CAPITAL LETTER R WITH DOT BELOW
        glyphs += [0x1E5B] # LATIN SMALL LETTER R WITH DOT BELOW
        glyphs += [0x1E5C] # LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
        glyphs += [0x1E5D] # LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
        glyphs += [0x1E5E] # LATIN CAPITAL LETTER R WITH LINE BELOW
        glyphs += [0x1E5F] # LATIN SMALL LETTER R WITH LINE BELOW
        glyphs += [0x1E60] # LATIN CAPITAL LETTER S WITH DOT ABOVE
        glyphs += [0x1E61] # LATIN SMALL LETTER S WITH DOT ABOVE
        glyphs += [0x1E62] # LATIN CAPITAL LETTER S WITH DOT BELOW
        glyphs += [0x1E63] # LATIN SMALL LETTER S WITH DOT BELOW
        glyphs += [0x1E6C] # LATIN CAPITAL LETTER T WITH DOT BELOW
        glyphs += [0x1E6D] # LATIN SMALL LETTER T WITH DOT BELOW
        glyphs += [0x1E6E] # LATIN CAPITAL LETTER T WITH LINE BELOW
        glyphs += [0x1E6F] # LATIN SMALL LETTER T WITH LINE BELOW
        glyphs += [0x1E70] # LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
        glyphs += [0x1E71] # LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
        glyphs += [0x1E80] # LATIN CAPITAL LETTER W WITH GRAVE
        glyphs += [0x1E81] # LATIN SMALL LETTER W WITH GRAVE
        glyphs += [0x1E82] # LATIN CAPITAL LETTER W WITH ACUTE
        glyphs += [0x1E83] # LATIN SMALL LETTER W WITH ACUTE
        glyphs += [0x1E84] # LATIN CAPITAL LETTER W WITH DIAERESIS
        glyphs += [0x1E85] # LATIN SMALL LETTER W WITH DIAERESIS
        glyphs += [0x1E8E] # LATIN CAPITAL LETTER Y WITH DOT ABOVE
        glyphs += [0x1E8F] # LATIN SMALL LETTER Y WITH DOT ABOVE
        glyphs += [0x1E92] # LATIN CAPITAL LETTER Z WITH DOT BELOW
        glyphs += [0x1E93] # LATIN SMALL LETTER Z WITH DOT BELOW
        glyphs += [0x1E94] # LATIN CAPITAL LETTER Z WITH LINE BELOW
        glyphs += [0x1E95] # LATIN SMALL LETTER Z WITH LINE BELOW
        glyphs += [0x1E96] # LATIN SMALL LETTER H WITH LINE BELOW
        glyphs += [0x1E97] # LATIN SMALL LETTER T WITH DIAERESIS
        glyphs += [0x1E9E] # LATIN CAPITAL LETTER SHARP S
        glyphs += [0x1EA0] # LATIN CAPITAL LETTER A WITH DOT BELOW
        glyphs += [0x1EA1] # LATIN SMALL LETTER A WITH DOT BELOW
        glyphs += [0x1EA2] # LATIN CAPITAL LETTER A WITH HOOK ABOVE
        glyphs += [0x1EA3] # LATIN SMALL LETTER A WITH HOOK ABOVE
        glyphs += [0x1EA4] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1EA5] # LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1EA6] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1EA7] # LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1EA8] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1EA9] # LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1EAA] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1EAB] # LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1EAC] # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1EAD] # LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1EAE] # LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
        glyphs += [0x1EAF] # LATIN SMALL LETTER A WITH BREVE AND ACUTE
        glyphs += [0x1EB0] # LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
        glyphs += [0x1EB1] # LATIN SMALL LETTER A WITH BREVE AND GRAVE
        glyphs += [0x1EB2] # LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
        glyphs += [0x1EB3] # LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
        glyphs += [0x1EB4] # LATIN CAPITAL LETTER A WITH BREVE AND TILDE
        glyphs += [0x1EB5] # LATIN SMALL LETTER A WITH BREVE AND TILDE
        glyphs += [0x1EB6] # LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
        glyphs += [0x1EB7] # LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
        glyphs += [0x1EB8] # LATIN CAPITAL LETTER E WITH DOT BELOW
        glyphs += [0x1EB9] # LATIN SMALL LETTER E WITH DOT BELOW
        glyphs += [0x1EBA] # LATIN CAPITAL LETTER E WITH HOOK ABOVE
        glyphs += [0x1EBB] # LATIN SMALL LETTER E WITH HOOK ABOVE
        glyphs += [0x1EBC] # LATIN CAPITAL LETTER E WITH TILDE
        glyphs += [0x1EBD] # LATIN SMALL LETTER E WITH TILDE
        glyphs += [0x1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1EC2] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1EC3] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1EC4] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1EC5] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1EC6] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1EC7] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1EC8] # LATIN CAPITAL LETTER I WITH HOOK ABOVE
        glyphs += [0x1EC9] # LATIN SMALL LETTER I WITH HOOK ABOVE
        glyphs += [0x1ECA] # LATIN CAPITAL LETTER I WITH DOT BELOW
        glyphs += [0x1ECB] # LATIN SMALL LETTER I WITH DOT BELOW
        glyphs += [0x1ECC] # LATIN CAPITAL LETTER O WITH DOT BELOW
        glyphs += [0x1ECD] # LATIN SMALL LETTER O WITH DOT BELOW
        glyphs += [0x1ECE] # LATIN CAPITAL LETTER O WITH HOOK ABOVE
        glyphs += [0x1ECF] # LATIN SMALL LETTER O WITH HOOK ABOVE
        glyphs += [0x1ED0] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1ED1] # LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
        glyphs += [0x1ED2] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1ED3] # LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
        glyphs += [0x1ED4] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1ED5] # LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
        glyphs += [0x1ED6] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1ED7] # LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
        glyphs += [0x1ED8] # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1ED9] # LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
        glyphs += [0x1EDA] # LATIN CAPITAL LETTER O WITH HORN AND ACUTE
        glyphs += [0x1EDB] # LATIN SMALL LETTER O WITH HORN AND ACUTE
        glyphs += [0x1EDC] # LATIN CAPITAL LETTER O WITH HORN AND GRAVE
        glyphs += [0x1EDD] # LATIN SMALL LETTER O WITH HORN AND GRAVE
        glyphs += [0x1EDE] # LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
        glyphs += [0x1EDF] # LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
        glyphs += [0x1EE0] # LATIN CAPITAL LETTER O WITH HORN AND TILDE
        glyphs += [0x1EE1] # LATIN SMALL LETTER O WITH HORN AND TILDE
        glyphs += [0x1EE2] # LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
        glyphs += [0x1EE3] # LATIN SMALL LETTER O WITH HORN AND DOT BELOW
        glyphs += [0x1EE4] # LATIN CAPITAL LETTER U WITH DOT BELOW
        glyphs += [0x1EE5] # LATIN SMALL LETTER U WITH DOT BELOW
        glyphs += [0x1EE6] # LATIN CAPITAL LETTER U WITH HOOK ABOVE
        glyphs += [0x1EE7] # LATIN SMALL LETTER U WITH HOOK ABOVE
        glyphs += [0x1EE8] # LATIN CAPITAL LETTER U WITH HORN AND ACUTE
        glyphs += [0x1EE9] # LATIN SMALL LETTER U WITH HORN AND ACUTE
        glyphs += [0x1EEA] # LATIN CAPITAL LETTER U WITH HORN AND GRAVE
        glyphs += [0x1EEB] # LATIN SMALL LETTER U WITH HORN AND GRAVE
        glyphs += [0x1EEC] # LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
        glyphs += [0x1EED] # LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
        glyphs += [0x1EEE] # LATIN CAPITAL LETTER U WITH HORN AND TILDE
        glyphs += [0x1EEF] # LATIN SMALL LETTER U WITH HORN AND TILDE
        glyphs += [0x1EF0] # LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
        glyphs += [0x1EF1] # LATIN SMALL LETTER U WITH HORN AND DOT BELOW
        glyphs += [0x1EF2] # LATIN CAPITAL LETTER Y WITH GRAVE
        glyphs += [0x1EF3] # LATIN SMALL LETTER Y WITH GRAVE
        glyphs += [0x1EF4] # LATIN CAPITAL LETTER Y WITH DOT BELOW
        glyphs += [0x1EF5] # LATIN SMALL LETTER Y WITH DOT BELOW
        glyphs += [0x1EF6] # LATIN CAPITAL LETTER Y WITH HOOK ABOVE
        glyphs += [0x1EF7] # LATIN SMALL LETTER Y WITH HOOK ABOVE
        glyphs += [0x1EF8] # LATIN CAPITAL LETTER Y WITH TILDE
        glyphs += [0x1EF9] # LATIN SMALL LETTER Y WITH TILDE
        glyphs += [0x2007] # FIGURE SPACE
        glyphs += [0x2010] # HYPHEN
        glyphs += [0x2012] # FIGURE DASH
        glyphs += [0x2013] # EN DASH
        glyphs += [0x2014] # EM DASH
        glyphs += [0x2015] # HORIZONTAL BAR
        glyphs += [0x2017] # DOUBLE LOW LINE
        glyphs += [0x2018] # LEFT SINGLE QUOTATION MARK
        glyphs += [0x2019] # RIGHT SINGLE QUOTATION MARK
        glyphs += [0x201A] # SINGLE LOW-9 QUOTATION MARK
        glyphs += [0x201C] # LEFT DOUBLE QUOTATION MARK
        glyphs += [0x201D] # RIGHT DOUBLE QUOTATION MARK
        glyphs += [0x201E] # DOUBLE LOW-9 QUOTATION MARK
        glyphs += [0x2020] # DAGGER
        glyphs += [0x2021] # DOUBLE DAGGER
        glyphs += [0x2022] # BULLET
        glyphs += [0x2026] # HORIZONTAL ELLIPSIS
        glyphs += [0x2030] # PER MILLE SIGN
        glyphs += [0x2032] # PRIME
        glyphs += [0x2033] # DOUBLE PRIME
        glyphs += [0x2039] # SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        glyphs += [0x203A] # SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        glyphs += [0x203C] # DOUBLE EXCLAMATION MARK
        glyphs += [0x203E] # OVERLINE
        glyphs += [0x2044] # FRACTION SLASH
        glyphs += [0x2070] # SUPERSCRIPT ZERO
        glyphs += [0x2074] # SUPERSCRIPT FOUR
        glyphs += [0x2075] # SUPERSCRIPT FIVE
        glyphs += [0x2076] # SUPERSCRIPT SIX
        glyphs += [0x2077] # SUPERSCRIPT SEVEN
        glyphs += [0x2078] # SUPERSCRIPT EIGHT
        glyphs += [0x2079] # SUPERSCRIPT NINE
        glyphs += [0x207D] # SUPERSCRIPT LEFT PARENTHESIS
        glyphs += [0x207E] # SUPERSCRIPT RIGHT PARENTHESIS
        glyphs += [0x207F] # SUPERSCRIPT LATIN SMALL LETTER N
        glyphs += [0x2080] # SUBSCRIPT ZERO
        glyphs += [0x2081] # SUBSCRIPT ONE
        glyphs += [0x2082] # SUBSCRIPT TWO
        glyphs += [0x2083] # SUBSCRIPT THREE
        glyphs += [0x2084] # SUBSCRIPT FOUR
        glyphs += [0x2085] # SUBSCRIPT FIVE
        glyphs += [0x2086] # SUBSCRIPT SIX
        glyphs += [0x2087] # SUBSCRIPT SEVEN
        glyphs += [0x2088] # SUBSCRIPT EIGHT
        glyphs += [0x2089] # SUBSCRIPT NINE
        glyphs += [0x208D] # SUBSCRIPT LEFT PARENTHESIS
        glyphs += [0x208E] # SUBSCRIPT RIGHT PARENTHESIS
        glyphs += [0x20A1] # COLON SIGN
        glyphs += [0x20A3] # FRENCH FRANC SIGN
        glyphs += [0x20A4] # LIRA SIGN
        glyphs += [0x20A6] # NAIRA SIGN
        glyphs += [0x20A7] # PESETA SIGN
        glyphs += [0x20A8] # RUPEE SIGN
        glyphs += [0x20A9] # WON SIGN
        glyphs += [0x20AA] # NEW SHEQEL SIGN
        glyphs += [0x20AB] # DONG SIGN
        glyphs += [0x20AC] # EURO SIGN
        glyphs += [0x20AD] # KIP SIGN
        glyphs += [0x20B0] # GERMAN PENNY SIGN
        glyphs += [0x20B1] # PESO SIGN
        glyphs += [0x20B2] # GUARANI SIGN
        glyphs += [0x20B3] # AUSTRAL SIGN
        glyphs += [0x20B5] # CEDI SIGN
        glyphs += [0x2105] # CARE OF
        glyphs += [0x2113] # SCRIPT SMALL L
        glyphs += [0x2117] # SOUND RECORDING COPYRIGHT
        glyphs += [0x211E] # PRESCRIPTION TAKE
        glyphs += [0x2120] # SERVICE MARK
        glyphs += [0x2122] # TRADE MARK SIGN
        glyphs += [0x2126] # OHM SIGN
        glyphs += [0x212E] # ESTIMATED SYMBOL
        glyphs += [0x2153] # VULGAR FRACTION ONE THIRD
        glyphs += [0x2154] # VULGAR FRACTION TWO THIRDS
        glyphs += [0x215B] # VULGAR FRACTION ONE EIGHTH
        glyphs += [0x215C] # VULGAR FRACTION THREE EIGHTHS
        glyphs += [0x215D] # VULGAR FRACTION FIVE EIGHTHS
        glyphs += [0x215E] # VULGAR FRACTION SEVEN EIGHTHS
        glyphs += [0x2190] # LEFTWARDS ARROW
        glyphs += [0x2191] # UPWARDS ARROW
        glyphs += [0x2192] # RIGHTWARDS ARROW
        glyphs += [0x2193] # DOWNWARDS ARROW
        glyphs += [0x2194] # LEFT RIGHT ARROW
        glyphs += [0x2195] # UP DOWN ARROW
        glyphs += [0x21A8] # UP DOWN ARROW WITH BASE
        glyphs += [0x2202] # PARTIAL DIFFERENTIAL
        glyphs += [0x2206] # INCREMENT
        glyphs += [0x220F] # N-ARY PRODUCT
        glyphs += [0x2211] # N-ARY SUMMATION
        glyphs += [0x2212] # MINUS SIGN
        glyphs += [0x2215] # DIVISION SLASH
        glyphs += [0x2219] # BULLET OPERATOR
        glyphs += [0x221A] # SQUARE ROOT
        glyphs += [0x221E] # INFINITY
        glyphs += [0x221F] # RIGHT ANGLE
        glyphs += [0x2229] # INTERSECTION
        glyphs += [0x222B] # INTEGRAL
        glyphs += [0x2248] # ALMOST EQUAL TO
        glyphs += [0x2260] # NOT EQUAL TO
        glyphs += [0x2261] # IDENTICAL TO
        glyphs += [0x2264] # LESS-THAN OR EQUAL TO
        glyphs += [0x2265] # GREATER-THAN OR EQUAL TO
        glyphs += [0x2302] # HOUSE
        glyphs += [0x2310] # REVERSED NOT SIGN
        glyphs += [0x25A0] # BLACK SQUARE
        glyphs += [0x25B2] # BLACK UP-POINTING TRIANGLE
        glyphs += [0x25B3] # WHITE UP-POINTING TRIANGLE
        glyphs += [0x25B6] # BLACK RIGHT-POINTING TRIANGLE
        glyphs += [0x25B7] # WHITE RIGHT-POINTING TRIANGLE
        glyphs += [0x25BC] # BLACK DOWN-POINTING TRIANGLE
        glyphs += [0x25BD] # WHITE DOWN-POINTING TRIANGLE
        glyphs += [0x25C0] # BLACK LEFT-POINTING TRIANGLE
        glyphs += [0x25C1] # WHITE LEFT-POINTING TRIANGLE
        glyphs += [0x25C6] # BLACK DIAMOND
        glyphs += [0x25C9] # FISHEYE
        glyphs += [0x25CA] # LOZENGE
        glyphs += [0x2610] # BALLOT BOX
        glyphs += [0x2611] # BALLOT BOX WITH CHECK
        glyphs += [0x263A] # WHITE SMILING FACE
        glyphs += [0x263B] # BLACK SMILING FACE
        glyphs += [0x263C] # WHITE SUN WITH RAYS
        glyphs += [0x2640] # FEMALE SIGN
        glyphs += [0x2642] # MALE SIGN
        glyphs += [0x2660] # BLACK SPADE SUIT
        glyphs += [0x2663] # BLACK CLUB SUIT
        glyphs += [0x2665] # BLACK HEART SUIT
        glyphs += [0x2666] # BLACK DIAMOND SUIT
        glyphs += [0x266A] # EIGHTH NOTE
        glyphs += [0x266B] # BEAMED EIGHTH NOTES
        glyphs += [0x266C] # BEAMED SIXTEENTH NOTES
        glyphs += [0x267E] # PERMANENT PAPER SIGN
        glyphs += [0x2713] # CHECK MARK
        glyphs += [0x2752] # UPPER RIGHT SHADOWED WHITE SQUARE
        glyphs += [0xFB01] # LATIN SMALL LIGATURE FI
        glyphs += [0xFB02] # LATIN SMALL LIGATURE FL
        return glyphs

library.register(Charmap)
