# coding: utf-8
# Copyright 2013 The Font Bakery Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# See AUTHORS.txt for the list of Authors and LICENSE.txt for the License.
from __future__ import print_function

import os
import sys

from fontTools.ttLib import TTLibError

from bakery_cli.ttfont import Font
from bakery_cli.utils import normalizestr


def fix_name_table(fontfile):
    try:
        font = Font(fontfile)
    except TTLibError:
        print("Unable to open {}".format(os.path.basename(fontfile)),
              file=sys.stderr)
        return

    for name in font['name'].names:
        title = Font.bin2unistring(name)
        title = normalizestr(title)
        if name.platformID == 3:
            name.string = title.encode('utf-16-be')
        else:
            name.string = title

    font.save(fontfile + '.fix')
