from functools import update_wrapper
import re
from foundationdb_sql import compat


def fails(description):
    def decorate(fn):
        def go(*arg, **kw):
            try:
                fn(*arg, **kw)
                assert False, "Test did not fail as expected"
            except AssertionError:
                assert True
        return update_wrapper(go, fn)
    return decorate

def assert_raises_message(except_cls, msg, callable_, *args, **kwargs):
    try:
        callable_(*args, **kwargs)
        assert False, "Callable did not raise an exception"
    except except_cls as e:
        assert re.search(msg, compat.text_type(e), re.UNICODE), "%r !~ %s" % (msg, e)
        print(compat.text_type(e).encode('utf-8'))
