import unittest
from foundationdb_sql import api


NUMBER = object()
STRING = object()

class NestedCursorTest(unittest.TestCase):
    def _fixture(self):
        from foundationdb_sql.api import NestedCursor
        cursor = NestedCursor(
            None,
            12,
            [
                {"name": "id", "type": NUMBER},
                {"name": "value", "type": STRING}
            ],
            lambda fields: [
                    (field["name"], field["type"], None, None, None, None, None)
                    for field in fields
                ]

        )
        cursor._rows.extend(
            [
                (i, "row%d" % i) for i in range(20)
            ]
        )
        return cursor

    def test_typecode_hashable(self):
        s = set([5001, api.NESTED_CURSOR, api.NestedCursorType()])
        self.assertEquals(len(s), 1)

    def test_close(self):
        cursor = self._fixture()
        # doesn't actually do anything right now, just needed
        # by the API
        cursor.close()

    def test_fetchone(self):
        cursor = self._fixture()
        self.assertEquals(
            [cursor.fetchone() for i in range(22)],
            [
                (i, "row%d" % i) for i in range(20)
            ] + [None, None]
        )

    def test_fetchall(self):
        cursor = self._fixture()
        self.assertEquals(
            cursor.fetchall(),
            [
                (i, "row%d" % i) for i in range(20)
            ]
        )

    def test_fetchmany(self):
        cursor = self._fixture()
        self.assertEquals(
            cursor.fetchmany(5),
            [
                (i, "row%d" % i) for i in range(5)
            ]
        )
        self.assertEquals(
            cursor.fetchmany(),
            [
                (i, "row%d" % i) for i in range(5, 17)
            ]
        )
        self.assertEquals(
            cursor.fetchmany(10),
            [
                (i, "row%d" % i) for i in range(17, 20)
            ]
        )


    def test_description(self):
        cursor = self._fixture()
        self.assertEquals(
            cursor.description,
            [
                ("id", NUMBER, None, None, None, None, None),
                ("value", STRING, None, None, None, None, None),
            ]
        )