import os
import re


try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

v = open(os.path.join(os.path.dirname(__file__), 'foundationdb_sql', '__init__.py'))
VERSION = re.compile(r".*__version__ = '(.*?)'", re.S).match(v.read()).group(1)
v.close()

readme = os.path.join(os.path.dirname(__file__), 'README.rst')


setup(name='foundationdb-sql',
      version=VERSION,
      description="FoundationDB SQL Layer DBAPI Integration",
      long_description=open(readme).read(),
      url="https://github.com/FoundationDB/sql-layer-adapter-dbapi",
      classifiers=[
      'Development Status :: 4 - Beta',
      'Environment :: Console',
      'Intended Audience :: Developers',
      'Programming Language :: Python',
      'Programming Language :: Python :: 3',
      'Programming Language :: Python :: Implementation :: CPython',
      'Programming Language :: Python :: Implementation :: PyPy',
      'Topic :: Database :: Front-Ends',
      ],
      keywords='foundationdb',
      author='Mike Bayer',
      author_email='mike@zzzcomputing.com',
      license='MIT',
      packages=['foundationdb_sql'],
      include_package_data=True,
      install_requires=['psycopg2'],
      tests_require=['nose >= 0.11'],
      test_suite="nose.collector",
      zip_safe=False
)
