from setuptools import setup, find_packages
from pkg_resources import resource_string

VERSION_STR = __import__('foundationdb_sql').__version__
README_STR = resource_string(__name__, 'README.rst')

setup(name='foundationdb-sql',
      version=VERSION_STR,
      description="FoundationDB SQL Layer DBAPI Integration",
      long_description=README_STR,
      url="https://github.com/FoundationDB/sql-layer-adapter-dbapi",
      classifiers=[
      'Development Status :: 4 - Beta',
      'Environment :: Console',
      'Intended Audience :: Developers',
      'License :: OSI Approved :: MIT License',
      'Programming Language :: Python',
      'Programming Language :: Python :: 3',
      'Programming Language :: Python :: Implementation :: CPython',
      'Programming Language :: Python :: Implementation :: PyPy',
      'Topic :: Database :: Front-Ends',
      ],
      keywords='foundationdb',
      author='Mike Bayer',
      author_email='mike@zzzcomputing.com',
      maintainer='FoundationDB',
      maintainer_email='distribution@foundationdb.com',
      license='MIT',
      packages=find_packages(exclude=['tests']),
      include_package_data=True,
      install_requires=['psycopg2'],
      tests_require=['nose >= 0.11'],
      test_suite="nose.collector",
      zip_safe=True
)
