# FoundationDB Python API
# Copyright (c) 2012 FoundationDB, LLC

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import types

NetworkOption = {
    "local_address" : (10, "Deprecated", type(''), "IP:PORT"),
    "cluster_file" : (20, "Deprecated", type(''), "path to cluster file"),
    "trace_enable" : (30, "Enables trace output to a file in a directory of the clients choosing", type(''), "path to output directory (or NULL for current working directory)"),
    "knob" : (40, "Set internal tuning or debugging knobs", type(''), "knob_name=knob_value"),
    "TLS_plugin" : (41, "Set the TLS plugin to load. This option, if used, must be set before any other TLS options", type(''), "file path or linker-resolved name"),
    "TLS_cert_bytes" : (42, "Set the certificate chain", type(b''), "certificates"),
    "TLS_cert_path" : (43, "Set the file from which to load the certificate chain", type(''), "file path"),
    "TLS_key_bytes" : (45, "Set the private key corresponding to your own certificate", type(b''), "key"),
    "TLS_key_path" : (46, "Set the file from which to load the private key corresponding to your own certificate", type(''), "file path"),
    "TLS_verify_peers" : (47, "Set the peer certificate field verification criteria", type(b''), "verification pattern"),
}

ClusterOption = {

}

DatabaseOption = {
    "location_cache_size" : (10, "Set the size of the client location cache. Raising this value can boost performance in very large databases where clients access data in a near-random pattern. Defaults to 100000.", type(0), "Max location cache entries"),
    "max_watches" : (20, "Set the maximum number of watches allowed to be outstanding on a database connection. Increasing this number could result in increased resource usage. Reducing this number will not cancel any outstanding watches. Defaults to 10000 and cannot be larger than 1000000.", type(0), "Max outstanding watches"),
    "machine_id" : (21, "Specify the machine ID that was passed to fdbserver processes running on the same machine as this client, for better location-aware load balancing.", type(''), "Hexadecimal ID"),
    "datacenter_id" : (22, "Specify the datacenter ID that was passed to fdbserver processes running in the same datacenter as this client, for better location-aware load balancing.", type(''), "Hexadecimal ID"),
}

TransactionOption = {
    "causal_write_risky" : (10, "The transaction, if not self-conflicting, may be committed a second time after commit succeeds, in the event of a fault", type(None), None),
    "causal_read_risky" : (20, "The read version will be committed, and usually will be the latest committed, but might not be the latest committed in the event of a fault or partition", type(None), None),
    "causal_read_disable" : (21, "", type(None), None),
    "next_write_no_write_conflict_range" : (30, "The next write performed on this transaction will not generate a write conflict range. As a result, other transactions which read the key(s) being modified by the next write will not conflict with this transaction. Care needs to be taken when using this option on a transaction that is shared between multiple threads. When setting this option, write conflict ranges will be disabled on the next write operation, regardless of what thread it is on.", type(None), None),
    "check_writes_enable" : (50, "", type(None), None),
    "read_your_writes_disable" : (51, "Reads performed by a transaction will not see any prior mutations that occured in that transaction, instead seeing the value which was in the database at the transaction's read version. This option may provide a small performance benefit for the client, but also disables a number of client-side optimizations which are beneficial for transactions which tend to read and write the same keys within a single transaction.", type(None), None),
    "read_ahead_disable" : (52, "Disables read-ahead caching for range reads. Under normal operation, a transaction will read extra rows from the database into cache if range reads are used to page through a series of data one row at a time (i.e. if a range read with a one row limit is followed by another one row range read starting immediately after the result of the first).", type(None), None),
    "durability_datacenter" : (110, "", type(None), None),
    "durability_risky" : (120, "", type(None), None),
    "durability_dev_null_is_web_scale" : (130, "", type(None), None),
    "priority_system_immediate" : (200, "Specifies that this transaction should be treated as highest priority and that lower priority transactions should block behind this one. Use is discouraged outside of low-level tools", type(None), None),
    "priority_batch" : (201, "Specifies that this transaction should be treated as low priority and that default priority transactions should be processed first. Useful for doing batch work simultaneously with latency-sensitive work", type(None), None),
    "initialize_new_database" : (300, "This is a write-only transaction which sets the initial configuration", type(None), None),
    "access_system_keys" : (301, "Allows this transaction to read and modify system keys (those that start with the byte 0xFF)", type(None), None),
    "debug_dump" : (400, "", type(None), None),
    "timeout" : (500, "Set a timeout in milliseconds which, when elapsed, will cause the transaction automatically to be cancelled. Valid parameter values are ``[0, INT_MAX]``. If set to 0, will disable all timeouts. All pending and any future uses of the transaction will throw an exception. The transaction can be used again after it is reset. Like all transaction options, a timeout must be reset after a call to onError. This behavior allows the user to make the timeout dynamic.", type(0), "value in milliseconds of timeout"),
    "retry_limit" : (501, "Set a maximum number of retries after which additional calls to onError will throw the most recently seen error code. Valid parameter values are ``[-1, INT_MAX]``. If set to -1, will disable the retry limit. Like all transaction options, the retry limit must be reset after a call to onError. This behavior allows the user to make the retry limit dynamic.", type(0), "number of times to retry"),
}

StreamingMode = {
    "want_all" : (-2, "Client intends to consume the entire range and would like it all transferred as early as possible.", type(None), None),
    "iterator" : (-1, "The default. The client doesn't know how much of the range it is likely to used and wants different performance concerns to be balanced. Only a small portion of data is transferred to the client initially (in order to minimize costs if the client doesn't read the entire range), and as the caller iterates over more items in the range larger batches will be transferred in order to minimize latency.", type(None), None),
    "exact" : (0, "Infrequently used. The client has passed a specific row limit and wants that many rows delivered in a single batch. Because of iterator operation in client drivers make request batches transparent to the user, consider ``WANT_ALL`` StreamingMode instead. A row limit must be specified if this mode is used.", type(None), None),
    "small" : (1, "Infrequently used. Transfer data in batches small enough to not be much more expensive than reading individual rows, to minimize cost if iteration stops early.", type(None), None),
    "medium" : (2, "Infrequently used. Transfer data in batches sized in between small and large.", type(None), None),
    "large" : (3, "Infrequently used. Transfer data in batches large enough to be, in a high-concurrency environment, nearly as efficient as possible. If the client stops iteration early, some disk and network bandwidth may be wasted. The batch size may still be too small to allow a single client to get high throughput from the database, so if that is what you need consider the SERIAL StreamingMode.", type(None), None),
    "serial" : (4, "Transfer data in batches large enough that an individual client can get reasonable read bandwidth from the database. If the client stops iteration early, considerable disk and network bandwidth may be wasted.", type(None), None),
}

MutationType = {
    "add" : (2, "Performs an addition of little-endian integers. If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The integers to be added must be stored in a little-endian representation.  They can be signed in two's complement representation or unsigned. You can add to an integer at a known offset in the value by prepending the appropriate number of zero bytes to ``param`` and padding with zero bytes to match the length of the value. However, this offset technique requires that you know the addition will not cause the integer field within the value to overflow.", type(b''), "addend"),
    "and" : (6, "Deprecated", type(b''), "value with which to perform bitwise and"),
    "bit_and" : (6, "Performs a bitwise ``and`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", type(b''), "value with which to perform bitwise and"),
    "or" : (7, "Deprecated", type(b''), "value with which to perform bitwise or"),
    "bit_or" : (7, "Performs a bitwise ``or`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", type(b''), "value with which to perform bitwise or"),
    "xor" : (8, "Deprecated", type(b''), "value with which to perform bitwise xor"),
    "bit_xor" : (8, "Performs a bitwise ``xor`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``.", type(b''), "value with which to perform bitwise xor"),
}

ConflictRangeType = {
    "read" : (0, "Used to add a read conflict range", type(None), None),
    "write" : (1, "Used to add a write conflict range", type(None), None),
}

