'''
Created on 1.12.2011

@author: xaralis
'''
class DictDifference(object):
    """
    @see: http://stackoverflow.com/questions/1165352/fast-comparison-between-two-python-dictionary/1165552#1165552
    Calculate the difference between two dictionaries as:
    (1) items added
    (2) items removed
    (3) keys same in both but changed values
    (4) keys same in both and unchanged values
    """
    def __init__(self, current_dict, past_dict):
        self.current_dict, self.past_dict = current_dict, past_dict
        self.set_current, self.set_past = set(current_dict.keys()), set(past_dict.keys())
        self.intersect = self.set_current.intersection(self.set_past)
        
    def added(self):
        return self.set_current - self.intersect 
    
    def removed(self):
        return self.set_past - self.intersect 
    
    def changed(self):
        return set(o for o in self.intersect if self.past_dict[o] != self.current_dict[o])
    
    def unchanged(self):
        return set(o for o in self.intersect if self.past_dict[o] == self.current_dict[o])