# -*- coding: utf-8
from __future__ import unicode_literals

import os
import sys

GREY    = 30
RED     = 31
GREEN   = 32
YELLOW  = 33
BLUE    = 34
MAGENTA = 35
CYAN    = 36
WHITE   = 37
BRIGHT_WHITE = 57
NORMAL = 0
BOLD = 1


class ColoredString(type('')):
    color = WHITE
    weight = NORMAL

    def colorize(self):
        if sys.stdout.isatty():
            return '\033[%sm\033[%sm%s\033[0m' % (self.weight, self.color, self)
        else:
            return self


class Added(ColoredString):
    @property
    def color(self):
        if os.getenv('COLORBLIND', '').lower() in ['protan', 'deutan']:
            return BLUE
        return GREEN

class Deleted(ColoredString):
    color = RED

class Modified(ColoredString):
    color = YELLOW

class LineNumber(ColoredString):
    color = MAGENTA

class Unknown(ColoredString):
    color = MAGENTA

class Error(ColoredString):
    color = GREY

class DeletedHeader(Deleted):
    weight = BOLD

class AddedHeader(Added):
    weight = BOLD

class Header(ColoredString):
    color = BRIGHT_WHITE
    weight = BOLD

class Prompt(ColoredString):
    color = YELLOW
    weight = BOLD

    def __new__(cls, s):
        return super(Prompt, cls).__new__(cls, s+' ')
