#!/usr/bin/env python
#
# Copyright 2013 Wantoto Inc http://www.wantoto.com/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from fss.flaskr import app as flask_app
from fss.freeze import freezer


#noinspection PyUnusedLocal
def build(args):
    freezer.freeze()


#noinspection PyUnusedLocal
def dev_server(args):
    flask_app.run()


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser()
    subparsers = parser.add_subparsers(title='Commands')

    parser_build = subparsers.add_parser('build', help='Compile Jinja2 templates into static html pages')
    parser_build.set_defaults(func=build)

    parser_dev_server = subparsers.add_parser('dev_server', help='Start a local dev-server via Flask')
    parser_dev_server.set_defaults(func=dev_server)

    arguments = parser.parse_args()
    arguments.func(arguments)
